(* Finite maps *)

(*
$File: Common/FinMap.sml $
$Date: 1992/01/29 15:00:49 $
$Revision: 1.17 $
$Locker: birkedal $
*)

(*$FinMap: REPORT PRETTYPRINT FINMAP*)

functor FinMap(structure Report: REPORT
	       structure PP: PRETTYPRINT
	      ): FINMAP =
  struct
    type (''a, 'b) map = (''a *  'b) list

    val empty = []

    fun singleton p = [p]

    fun isEmpty nil = true | isEmpty _ = false

    fun lookup [] x  = None
      | lookup ((x,y)::rest) x' =
	if x=x' then Some(y) else lookup rest x'

    fun add (x, y, nil) = [(x, y)]
      | add (x', y', (x, y) :: rest) = 
	  if x=x' then (x', y') :: rest
	  else (x, y) :: add(x', y', rest)

    fun plus (l, []) = l
      | plus (l, (x, y) :: tl) = plus(add(x, y, l), tl)

    fun mergeMap folder map1 map2 =
      let
	fun insert(x', y', nil) = [(x', y')]
	  | insert(x', y', (x, y) :: rest) =
	      if x = x' then (x, folder(y, y')) :: rest
	      else (x, y) :: insert(x', y', rest)
      in
	List.foldL (fn (x, y) => fn m => insert(x, y, m)) map1 map2
      end

    fun dom(m: (''a, 'b) map) = EqSet.fromList(map #1 m)
    val range : (''a, 'b) map -> 'b list  = map #2

    fun composemap (f: 'b -> 'c) (m: (''a, 'b) map): (''a, 'c) map = 
	map (fn (a, b) => (a, f b)) m

    fun ComposeMap (f: ''a * 'b -> 'c) (m: (''a, 'b) map): (''a, 'c) map =
        map (fn (a, b) => (a, f(a, b))) m

    fun fold (f : ('a * 'b) -> 'b) (x : 'b) (m : (''d,'a) map) : 'b = 
	List.foldL (fn (a, b) => fn c => f(b, c)) x m

    fun Fold (f : ((''a * 'b) * 'c) -> 'c) (x : 'c) (m : (''a,'b) map) : 'c =
	List.foldL (fn (a, b) => fn c => f((a, b), c)) x m

    val filter = List.all


    type Report = Report.Report

    fun reportMap f m = Report.flatten(map f m)

    fun reportMapSORTED lt f m =
      reportMap f (ListSort.sort (fn (a, _) => fn (b, _) => lt(a, b)) m)

    type StringTree = PP.StringTree

    fun layoutMap {start, eq, sep, finish} layoutDom layoutRan m =
      let
	fun doit(x, y) = PP.NODE{start="", finish="", indent=0,
				 childsep=PP.RIGHT eq,
				 children=[layoutDom x, layoutRan y]
				}
      in
	PP.NODE{start=start, finish=finish, indent=0,
		childsep=PP.RIGHT sep, children=map doit m
	       }
      end
  end;
