/*
 *	Aes rectangle utils
 *		rc_copy		copy grects
 * 		rc_equal	compare two grects
 *              rc_intersect    check if two grects intersect, ret intersec
 *              rc_union        union of two grects
 *		grect_to_aray	convert GRECT to a vdi pxy style coordinate
 *				array
 *
 *	    ++jrb	bammi@cadence.com
 *	    modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include <macros.h>
#include <gemfast.h>

#ifdef __DEF_ALL__

#define L_rc_copy
#define L_rc_equal
/***
#define L_max
#define L_min
***/
#define L_rc_inter
#define L_grect_to

#endif /* __DEF_ALL__ */


#ifdef L_rc_copy

/* rc_copy	copy grects
 * always returns success
 */
int rc_copy(GRECT *src, GRECT *dst)
{
    *dst = *src;
    return 1;
}
#endif /* L_rc_copy */

#ifdef L_rc_equal

/* rc_equal	compare two rectangles
 * returns 0 is not same
 */
int rc_equal(GRECT *p1, GRECT *p2) {
    return ((p1->g_x == p2->g_x) &&
	    (p1->g_y == p2->g_y) &&
	    (p1->g_w == p2->g_w) &&
	    (p1->g_h == p2->g_h));
}
#endif /* L_rc_equal */


#if 0
#ifdef L_max
static int max(int x, int y)
{
	return (x > y)? x : y;
}
#endif /* L_max */

#ifdef L_min

static int min(int x, int y)
{
	return (x > y)? y : x;
}
#endif /* L_min */
#endif

#ifdef L_rc_inter

/*
 * rc_intersect       check if two rects intersect
 * returns 0 if they do not intersect,
 * otherwise returns 1 and rect2 is set to common area
 */
int rc_intersect(GRECT *r1, GRECT *r2)
{
      int     tx, ty, tw, th, ret;
	
      tx = max (r2->g_x, r1->g_x);
      tw = min (r2->g_x + r2->g_w, r1->g_x + r1->g_w) - tx;
      if ((ret = (0 < tw))) {
          ty = max (r2->g_y, r1->g_y);
          th = min (r2->g_y + r2->g_h, r1->g_y + r1->g_h) - ty;
          if ((ret = (0 < th))) {
              r2->g_x = tx;
              r2->g_y = ty;
              r2->g_w = tw;
              r2->g_h = th;
          }
      }
      return (ret);
}
#endif /* L_rc_inter */

#ifdef L_grect_to

/*
 * convert a GRECT to a pxy array
 * returns &pxy_array[0]
 */
int *grect_to_array(GRECT *area, int *array)
{
    int *ip = array;

    *ip = area->g_x;
    ip[2] = *ip;
    ip++;
    *ip = area->g_y;
    ip[2] = *ip;
    ip++;
    *ip++ += area->g_w - 1;
    *ip   += area->g_h - 1;
    return (array);
}
#endif /* L_grect_to */

/* rc_union todo */

/* -eof- */
