DEFINITION MODULE ResCtrl;

FROM SYSTEM IMPORT BYTE, WORD;

FROM MOSGlobals IMPORT MemArea;

(*
 * Dies Modul bietet Funktionen fr Systemmodule, die Ressourcen verwalten
 * und sich dazu Sys-Funktionen bedienen (und mit $Y+ bersetzt werden).
 *
 * Problemerluterung:
 *   Ein Systemmodul, das 'Sys'-Funktionen bietet oder globale bzw. externe
 * Variablen oder Ressourcen kontrolliert (z.B. Interrupts) sollte sich selbst
 * auch der Sys-Funktionen bedienen.
 *   Beispielsweise kann ein Modul im Modulkrper Speicher mit SysAlloc
 * anfordern oder einen Systemvektor des TOS verndern. Wird das Modul
 * nicht mehr gebraucht und aus dem Speicher entfernt, mu natrlich der
 * Speicher zurckgegeben bzw. der Vektor restauriert werden. Wrde man
 * das mit Hilfe der Funktion 'PrgCtrl.CatchProcessTerm' tun, wrde es
 * normalerweise funktionieren.
 *  Das Problem entsteht erst, wenn das Modul, das dieses Systemmodul im-
 * portiert, sich resident macht. Wenn der Proze dann endet, wird ja
 * der vom Systemmodul geforderte 'CatchProcessTerm' aktiv und das
 * Systemmodul wrde seine Ressourcen schlieen. Das darf es dann aber
 * noch gar nicht, weil es ja noch resident bleibt und weiterhin von
 * anderen Modulen bentigt wird.
 *   Aus diesem Grund gibt es hier die Funktion 'CatchRemoval', die,
 * entgegen 'CatchProcessTerm', das Modul erst dann informiert, wenn
 * es nicht mehr bentigt, sprich importiert, wird.
 *
 *   Deshalb ist immer dann, wenn man daran denkt, 'CatchProcessTerm' zu
 * verwenden, zu prfen, ob nicht der oben beschriebene Fall eintreten
 * kann und dann stattdessen 'CatchRemoval' einzusetzen ist.
 *   Als Faustregel gilt:
 *    - 'CatchRemoval' fr Freigabe von Sys-Ressourcen bei Ressource-
 *      verwaltenden Modulen.
 *    - 'CatchProcessTerm' bei Hauptmodulen (denn hier hat das Modul
 *      ja selbst die Kontrolle darber, wann es sich resident macht
 *      und wieder freigibt) und Freigabe von Ressourcen des untersten
 *      Levels bei Ressource-verwaltenden Modulen (ergnzend zu den
 *      "Envelopes").
 *)

TYPE  RemovalCarrier = ARRAY [0..15] OF WORD;

PROCEDURE CatchRemoval ( VAR hdl: RemovalCarrier; info: PROC; wsp: MemArea );
  (*
   * Meldet eine Prozedur an, die aufgerufen wird, wenn das Modul,
   * das die Prozedur enthlt, nicht mehr bentigt wird und aus dem
   * Speicher entfernt werden kann.
   *
   * 'wsp' ist der Stack, der 'info' beim Aufruf zugeteilt wird. 'wsp.bottom'
   * darf NIL sein, dann wird der normale Programm-Stack verwendet.
   *
   * Diese Funktion (und nicht etwa 'CatchProcessTerm') ist deshalb
   * das exakte Gegenstck zum Aufruf des Modulkrpers.
   *
   * Dies ist der Fall, wenn
   *  a) das Modul in einem Programm eingelinkt ist und das Programm
   *     normal beendet;
   *  b) das Modul durch einen Import vom Loader (also durch Load-Time
   *     Link) dazugeladen und gestartet wurde und nun wieder freigegeben
   *     werden kann, da der Proze wieder endet;
   *  c) das Modul von einem Modul importiert wird, das sich mit
   *     'ModCtrl.InstallModule' resident gemacht hatte und nach
   *     einem Aufruf von 'ReleaseModule', wie unter b), entfert wird.
   *
   * Wird ein Modul lediglich vom Loader (mittels 'LoadModule') geladen,
   * aber nicht aufgerufen, zhlt das entsprechende Ausladen des Moduls
   * nicht zu den obigen Fllen. Vielmehr wird bei geladenen Modulen
   * so verfahren, als wenn das Modul jedesmal neu geladen und wieder
   * entladen wird.
   *
   * Somit ist diese Funktion dann zu verwenden, wenn ein Modul Ressourcen
   * dynamisch bei seiner Initialisierung ffnet, die genau dann wieder
   * geschlossen werden drfen, wenn das Modul nicht mehr bentigt wird.
   * Normalerweise knnte man das dann mit 'PrgCtrl.CatchProcessTerm'
   * bewerkstelligen. Nur ist es dann nicht mglich, das Modul in Pro-
   * grammen zu verwenden, die sich mit 'InstallModule' resident machen.
   *
   * Wird also z.B. in einem Modul im Krper Speicher angefordert, sollte
   * dieser mit der Sys-Funktion (SysAlloc) angefordert werden und ber
   * 'CatchRemoval' der Speicher wieder freigegeben werden.
   *
   * WICHTIG: Das benutzende Modul mu mit der Directive "$Y+" bersetzt
   *          werden!
   *)

PROCEDURE Resident (): BOOLEAN;
  (*
   * Liefert TRUE, wenn der akt. Proze z.Zt. resident ist.
   * Es ist zu beachten, da dieser Zustand nicht im Modulkrper schon
   * ermittelt werden soll, da das Hauptmodul, das sich evtl. resident
   * macht, dies erst spter durchfhren kann.
   *)


PROCEDURE Private ( n: CARDINAL; VAR d: ARRAY OF BYTE );
  (*
   * interne Systemfunktion
   *)

END ResCtrl.
