 IMPLEMENTATION MODULE InOut; (* V#039 *)
 (*$Y+,R-,F-*)
 
 (*
"18.7.87:  Read... setzen termCH richtig (? nicht getestet!);
,Wenn bei Write EOL ausgegeben wird, wird automatisch LF mit
,ausgegeben, leider geht's nicht bei WriteString.
"1.4.88:   Done wird bei allen exportierten Procs gesetzt. Bei EOF
,wird Done FALSE, aber es kommt keine Fehlermeldung mehr.
,Bei Ausgaben wird bei Fehlern Done FALSE, Fehlermeldung kommt
,weiterhin.
"5.6.88:   InOutBase/InOutFile neu. Dadurch wird erreicht, da die File-
,Funktionen nicht eingebunden werden, wenn keine Redirection
,verwendet wird.
,Wenn bei der Ausgabe auf ein File abgebrochen wird, wird nicht
,mehr die Ausgabe auf das Window wiederholt.
"27.6.88:  skipLF wird bei Write wieder (?) richtig ausgewertet.
"17.9.88:  ReadReal/Card/usw, korrigiert (rdWLR zerstrte A0 -> Endlosschleife
,und Zeiger auf Funktionen mit LEA statt MOVE.L geladen)
,ReadNum/ReadLNum korrigiert - auch Korrektur in InOutFile !
"08.8.89:  Termination-Stack entfernt (nun wird Default-Stack verwendet)
"20.7.89:  ReadLReal neu, ReadLine heit nun ReadFromLine
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER;
 FROM SYSTEM IMPORT WORD, LONGWORD, ADR;
 
 IMPORT StrConv, Convert;
 
 FROM PrgCtrl IMPORT SetEnvelope, EnvlpCarrier, CatchProcessTerm, TermCarrier,
(TermProcess;
 
 FROM MOSGlobals IMPORT MemArea, OutOfMemory;
 
 FROM Strings IMPORT Append, Length, Empty, MaxChars;
 
 FROM InOutBase IMPORT consIn, consOut, eop, level, inLev, outLev;
 
 IMPORT InOutBase, InOutFile;
 
 
 VAR     ok, skiplf: BOOLEAN;
 
 PROCEDURE ReadFromLine     (VAR s: ARRAY OF CHAR);  (* Liest eine ganze Zeile *)
"BEGIN HALT END ReadFromLine;
 PROCEDURE ReadToken    (VAR s: ARRAY OF CHAR);  (* Liest ein Wort *)
"BEGIN HALT END ReadToken;
 PROCEDURE ReadLn;
"BEGIN HALT END ReadLn;
 PROCEDURE EndOfLine (skip: BOOLEAN): BOOLEAN;
"BEGIN HALT; RETURN TRUE END EndOfLine;
 
 
 PROCEDURE Read (VAR c: CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST     consIn
(BEQ     d1
(MOVE    #1,Done
(MOVE.L  InOutBase.Read,A0
(JMP     (A0)
%d1 MOVE.L  InOutBase.fRead,A0
(JSR     (A0)
(MOVE    InOutBase.done,Done
$END
"END Read;
"(*$L=*)
 
 
 PROCEDURE KeyPressed   (): BOOLEAN;
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST     consIn
(BEQ     t0
(MOVE    #1,Done
(MOVE.L  InOutBase.KeyPressed,A0
(JMP     (A0)
%t0 MOVE.L  InOutBase.fKeyPressed,A0
(JSR     (A0)
(MOVE    InOutBase.done,Done
$END
"END KeyPressed;
"(*$L=*)
 
 PROCEDURE CondRead     (VAR c: CHAR; VAR valid: BOOLEAN);
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST     consIn
(BEQ     d1
(MOVE    #1,Done
(MOVE.L  InOutBase.CondRead,A0
(JMP     (A0)
%d1 MOVE.L  InOutBase.fCondRead,A0
(JSR     (A0)
(MOVE    InOutBase.done,Done
$END
"END CondRead;
"(*$L=*)
 
 PROCEDURE BusyRead (VAR c: CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     CondRead
(ADDQ.L  #2,A7
(UNLK    A5
$END
"END BusyRead;
"(*$L=*)
 
 PROCEDURE FlushKbd;
"(*$L-*)
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(TST.W   consIn
(BEQ     ende
&c JSR     KeyPressed
(TST     -(A3)
(BEQ     ende
(CLR.W   -(A7)
(MOVE.L  A7,(A3)+
(JSR     Read
(ADDQ.L  #2,A7
(BRA     c
&ende
(UNLK    A5
$END
"END FlushKbd;
"(*$L=*)
 
 PROCEDURE inp (VAR s:ARRAY OF CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #1,Done
(MOVE.B  #EOL,termCH
(LINK    A5,#0
(MOVE.L  InOutBase.ReadString,A0
(JSR     (A0)
(UNLK    A5
$END
"END inp;
"(*$L=*)
 
 PROCEDURE ReadString (VAR s: ARRAY OF CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST     consIn
(BEQ     d1
(MOVE    #1,Done
(MOVE.B  #EOL,termCH
(MOVE.L  InOutBase.ReadString,A0
(JMP     (A0)
%d1 MOVE.L  InOutBase.fReadString,A0
(JSR     (A0)
(MOVE    InOutBase.done,Done
(MOVE.W  InOutBase.termCh,termCH
$END
"END ReadString;
"(*$L=*)
 
 PROCEDURE rdWLR;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  InOutBase.fRdWLR,A2
(JSR     (A2)
(MOVE.W  InOutBase.done,Done
(MOVE.W  InOutBase.termCh,termCH
$END
"END rdWLR;
"(*$L=*)
 
 PROCEDURE rdWord;
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST     consIn
(BEQ     d1
(LINK    A5,#-18
(MOVE.L  A7,(A3)+
(MOVE    #17,(A3)+
(MOVE.L  A1,-(A7)
(JSR     inp
(MOVE.L  (A7)+,A1
(MOVE.L  A7,(A3)+
(MOVE    #17,(A3)+
(CLR     -(A7)
(MOVE.L  A7,(A3)+
(MOVE.L  #Done,(A3)+
(JSR     (A1)
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.W  D0,(A0)
(UNLK    A5
(RTS
%d1 JMP     rdWLR
$END
"END rdWord;
"(*$L=*)
 
 PROCEDURE rdLong;
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST     consIn
(BEQ     d1
(LINK    A5,#-34
(MOVE.L  A7,(A3)+
(MOVE    #33,(A3)+
(MOVE.L  A1,-(A7)
(JSR     inp
(MOVE.L  (A7)+,A1
(MOVE.L  A7,(A3)+
(MOVE    #33,(A3)+
(CLR     -(A7)
(MOVE.L  A7,(A3)+
(MOVE.L  #Done,(A3)+
(JSR     (A1)
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A0)
(UNLK    A5
(RTS
%d1 JMP     rdWLR
$END
"END rdLong;
"(*$L=*)
 
 PROCEDURE ReadCard     (VAR v: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(LEA     StrConv.StrToCard,A1
(MOVE.L  InOutBase.fReadCard,A0
(JMP     rdWord
$END
"END ReadCard;
"(*$L=*)
 
 PROCEDURE ReadInt      (VAR v: INTEGER);
"(*$L-*)
"BEGIN
$ASSEMBLER
(LEA     StrConv.StrToInt,A1
(MOVE.L  InOutBase.fReadInt,A0
(JMP     rdWord
$END
"END ReadInt;
"(*$L=*)
 
 PROCEDURE ReadLCard    (VAR v: LONGCARD);
"(*$L-*)
"BEGIN
$ASSEMBLER
(LEA     StrConv.StrToLCard,A1
(MOVE.L  InOutBase.fReadLCard,A0
(JMP     rdLong
$END
"END ReadLCard;
"(*$L=*)
 
 PROCEDURE ReadLInt     (VAR v: LONGINT);
"(*$L-*)
"BEGIN
$ASSEMBLER
(LEA     StrConv.StrToLInt,A1
(MOVE.L  InOutBase.fReadLInt,A0
(JMP     rdLong
$END
"END ReadLInt;
"(*$L=*)
 
 PROCEDURE ReadNum      (VAR v: WORD;     base: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(LINK    A5,#-18
(TST     consIn
(BEQ     d1
(MOVE.L  A7,(A3)+
(MOVE    #17,(A3)+
(JSR     inp             ; ReadString
(MOVE.W  -(A3),D0
(MOVE.L  A7,(A3)+        ; str
(MOVE    #17,(A3)+
(MOVE.W  D0,(A3)+        ; base
(CLR     -(A7)
(MOVE.L  A7,(A3)+        ; pos
(MOVE.L  #Done,(A3)+     ; valid
(JSR     StrConv.StrToNum
(MOVE.W  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.W  D0,(A0)
(UNLK    A5
(RTS
%d1 MOVE.L  InOutBase.fReadNum,A0
(JSR     (A0)
(UNLK    A5
(MOVE.W  InOutBase.done,Done
(MOVE.W  InOutBase.termCh,termCH
$END
"END ReadNum;
"(*$L=*)
 
 PROCEDURE ReadLNum     (VAR v: LONGWORD; base: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(LINK    A5,#-34
(TST     consIn
(BEQ     d1
(MOVE.L  A7,(A3)+
(MOVE    #33,(A3)+
(JSR     inp             ; ReadString
(MOVE.W  -(A3),D0
(MOVE.L  A7,(A3)+        ; str
(MOVE    #33,(A3)+
(MOVE.W  D0,(A3)+        ; base
(CLR     -(A7)
(MOVE.L  A7,(A3)+        ; pos
(MOVE.L  #Done,(A3)+     ; valid
(JSR     StrConv.StrToLNum
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A0)
(UNLK    A5
(RTS
%d1 MOVE.L  InOutBase.fReadLNum,A0
(JSR     (A0)
(UNLK    A5
(MOVE.W  InOutBase.done,Done
(MOVE.W  InOutBase.termCh,termCH
$END
"END ReadLNum;
"(*$L=*)
 
 PROCEDURE ReadLReal     (VAR v: LONGREAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(TST     consIn
(BEQ     d1
(LINK    A5,#-26
(MOVE.L  A7,(A3)+
(MOVE    #25,(A3)+
(MOVE.L  A1,-(A7)
(JSR     inp
(MOVE.L  (A7)+,A1
(MOVE.L  A7,(A3)+
(MOVE    #25,(A3)+
(CLR     -(A7)
(MOVE.L  A7,(A3)+
(MOVE.L  #Done,(A3)+
(JSR     StrConv.StrToReal
(MOVE.L  -(A3),D1
(MOVE.L  -(A3),D0
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A0)+
(MOVE.L  D1,(A0)
(UNLK    A5
(RTS
%d1 MOVE.L  InOutBase.fReadReal,A0
(JMP     rdWLR
$END
"END ReadLReal;
"(*$L=*)
 
 PROCEDURE ReadReal     (VAR r: REAL);
"VAR r2: LONGREAL;
"BEGIN
$r:= REAL (0);
$ReadLReal (r2);
$IF Done THEN
&IF ABS (r2) > MAX (REAL) THEN
(Done:= FALSE;
&ELSE
(r:= r2
&END
$END
"END ReadReal;
"
 
 (* ********************************************************************** *)
 (* ************************    A u s g a b e    ************************* *)
 (* ********************************************************************** *)
 
 PROCEDURE chkOut;
"BEGIN
$ASSEMBLER
(MOVE    consOut,D0
(EORI    #1,D0
(MOVE    D0,Done
$END
"END chkOut;
"
 PROCEDURE Write (c: CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #1,Done
(MOVE.B  -2(A3),D0
(TST     skiplf
(BEQ     d1
(CMPI.B  #$0A,D0
(BEQ     d4
%d1 CMPI.B  #$0D,D0
(BNE     d2
(JSR     WriteLn
(MOVE    #1,skiplf
(RTS
%d2 CLR     skiplf
(TST     consOut
(BNE     d3
(MOVE.L  InOutBase.fWrite,A0
(JSR     (A0)
(JMP     chkOut
%d3 MOVE.L  InOutBase.Write,A0
(JMP     (A0)
%d4 CLR     skiplf
$END;
"END Write;
"(*$L=*)
 
 
 PROCEDURE WriteLn;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #1,Done
(CLR     skiplf
(TST     consOut
(BNE     d1
(MOVE.L  InOutBase.fWriteLn,A0
(JSR     (A0)
(JMP     chkOut
%d1 MOVE.L  InOutBase.WriteLn,A0
(JMP     (A0)
%d2
$END
"END WriteLn;
"(*$L=*)
 
 PROCEDURE WritePg;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #1,Done
(CLR     skiplf
(TST     consOut
(BNE     d1
(MOVE.L  InOutBase.fWritePg,A0
(JSR     (A0)
(JMP     chkOut
%d1 MOVE.L  InOutBase.WritePg,A0
(JMP     (A0)
%d2
$END
"END WritePg;
"(*$L=*)
 
 
 PROCEDURE GotoXY (x, y: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(CLR     skiplf
(MOVE    #1,Done
(TST     consOut
(BNE     d1
(MOVE.L  InOutBase.fGotoXY,A0
(JSR     (A0)
(JMP     chkOut
%d1 MOVE.L  InOutBase.GotoXY,A0
(JMP     (A0)
%d2
$END
"END GotoXY;
"(*$L=*)
 
 
 PROCEDURE WriteString (REF s: ARRAY OF CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(CLR     skiplf
(MOVE    #1,Done
(TST     consOut
(BNE     c0
(MOVE.L  InOutBase.fWriteString,A0
(JSR     (A0)
(JMP     chkOut
%c0 MOVE.L  InOutBase.WriteString,A0
(JMP     (A0)
%e0
$END;
"END WriteString;
"(*$L=*)
 
 
 PROCEDURE prpPrt;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE    #1,Done
(MOVE.L  A7,(A3)+
(MOVE    #MaxChars,(A3)+
(TST     consOut
(BNE     c0
(MOVE.L  InOutBase.fWriteString,A0
(JSR     (A0)
(UNLK    A5
(JMP     chkOut
%c0 MOVE.L  InOutBase.WriteString,A0
(JSR     (A0)
(UNLK    A5
$END
"END prpPrt;
"(*$L=*)
 
 PROCEDURE prpOut;
"(*$L-*)
"BEGIN
$ASSEMBLER
(MOVE.L  (A7)+,A1                ; Rcksprungadr. v. Stack
(CLR     skiplf
(LINK    A5,#-MaxChars-1
(MOVE.L  A7,(A3)+
(MOVE    #MaxChars,(A3)+
(JMP     (A1)
$END
"END prpOut;
"(*$L=*)
 
 
 PROCEDURE WriteCard    (v:LONGCARD; width: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvCard
(JMP     prpPrt
$END;
"END WriteCard;
"(*$L=*)
 
 PROCEDURE WriteInt     (v: LONGINT;  width: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvInt
(JMP     prpPrt
$END;
"END WriteInt;
"(*$L=*)
 
 PROCEDURE WriteHex     (v: WORD;     width: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvHex
(JMP     prpPrt
$END;
"END WriteHex;
"(*$L=*)
 
 PROCEDURE WriteLHex    (v: LONGWORD; width: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvLHex
(JMP     prpPrt
$END;
"END WriteLHex;
"(*$L=*)
 
 PROCEDURE WriteNum     (v: WORD;     base, width: CARDINAL; filler: CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvNum
(JMP     prpPrt
$END;
"END WriteNum;
"(*$L=*)
 
 PROCEDURE WriteLNum    (v: LONGWORD; base, width: CARDINAL; filler: CHAR);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvLNum
(JMP     prpPrt
$END;
"END WriteLNum;
"(*$L=*)
 
 PROCEDURE WriteFix     (v: LONGREAL; width, frac: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvFix
(JMP     prpPrt
$END;
"END WriteFix;
"(*$L=*)
 
 PROCEDURE WriteFloat   (v: LONGREAL; width, frac: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvFloat
(JMP     prpPrt
$END;
"END WriteFloat;
"(*$L=*)
 
 PROCEDURE WriteEng     (v: LONGREAL; width, frac: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvEng
(JMP     prpPrt
$END;
"END WriteEng;
"(*$L=*)
 
 PROCEDURE WriteReal    (v: LONGREAL; width, frac: CARDINAL);
"(*$L-*)
"BEGIN
$ASSEMBLER
(JSR     prpOut
(JSR     Convert.ConvReal
(JMP     prpPrt
$END;
"END WriteReal;
"(*$L=*)
 
 
 
 PROCEDURE RedirectInput (REF fileName: ARRAY OF CHAR);
"BEGIN
$InOutFile.redirectInput (fileName);
$Done:= InOutBase.done
"END RedirectInput;
 
 PROCEDURE RedirectOutput (REF fileName: ARRAY OF CHAR; append: BOOLEAN);
"BEGIN
$InOutFile.redirectOutput (fileName, append);
$Done:= InOutBase.done
"END RedirectOutput;
 
 PROCEDURE OpenInput ( REF defExt: ARRAY OF CHAR );
"BEGIN
$InOutFile.openInput (defExt);
$Done:= InOutBase.done
"END OpenInput;
 
 PROCEDURE OpenOutput ( REF defExt: ARRAY OF CHAR );
"BEGIN
$InOutFile.openOutput (defExt);
$Done:= InOutBase.done
"END OpenOutput;
 
 
 PROCEDURE CloseInput;
"BEGIN
$InOutBase.fCloseInput;
$Done:= TRUE
"END CloseInput;
 
 PROCEDURE CloseOutput;
"BEGIN
$InOutBase.fCloseOutput;
$Done:= TRUE
"END CloseOutput;
 
 
 PROCEDURE Terminate;
"BEGIN
$IF consIn OR consOut THEN InOutBase.CloseWdw END;
$eop:= TRUE;
$InOutBase.fCloseOutput;
$InOutBase.fCloseInput
"END Terminate;
 
 PROCEDURE ChgLevel (start:BOOLEAN; inChild:BOOLEAN; VAR exitCode:INTEGER);
"(*$L-*)
"BEGIN
$ASSEMBLER
(SUBQ.L  #4,A3
(MOVE.L  -(A3),D0
(TST     D0
(BEQ     d4
(SWAP    D0
(TST     D0
(BEQ     d1
(ADDQ    #1,level
%d4 RTS
%d1 MOVE    level,D0
(TST     consIn
(BNE     d2
(CMP     inLev,D0
(BNE     d2
(MOVE.L  InOutBase.fCloseInput,A0
(JSR     (A0)
%d2 TST     consOut
(BNE     d3
(CMP     outLev,D0
(BNE     d3
(MOVE.L  InOutBase.fCloseOutput,A0
(JSR     (A0)
%d3 SUBQ    #1,level
$END
"END ChgLevel;
"(*$L=*)
 
 VAR env: EnvlpCarrier;
$term: TermCarrier;
$wsp: MemArea;
 
 BEGIN
"(* Das ffnen des Fensters mu VOR 'CatchProcessTerm' erfolgen, weil
#* TextWindows ggf. auch 'CatchProcessTerm' aufruft! *)
"InOutBase.OpenWdw (0,0);
"eop:= FALSE;
"SetEnvelope (env,ChgLevel,wsp);
"CatchProcessTerm (term,Terminate,wsp);
"consIn:= TRUE;
"consOut:= TRUE;
"skiplf:=FALSE;
 END InOut.
  
(* $000016D8$FFF6A76E$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$000004A7$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$00000A58$FFFC497A$FFFC497A$FFFC497A$FFFC497A$FFFC497A$00003627T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$00000696$00001DA3$00000603$00000038$000036D3$00003645$00003627$00003676$00003627$000035CD$00003627$0000041E$00000456$00000437$0000044A$0000063E*)
