 (* (C) 1989, 1990 by Johannes Leckebusch *)
 (* Portiert fr MM2: 7. 6. 89 *)
 
 (* 12.12.90  TT  Puffer werden hier statt in GMEBase angelegt,
1um zirkul. Import zw. GMEBase & GMEConfig zu lsen;
1FastLen wieder in Assembler;
1Ctrl-Z wird in FastLen als Ende erkannt;
1Meldung "Config laden" nur, wenn's wirklich geladen wird;
1Wenn ungltiger Text gelesen wird, kommt entspr.
1Fehlermeldung und TextLesen bricht ab - allerdings
1wird Puffer noch nicht dann wieder gelscht!
#13.12.90  TT  Konstante 'DefaultConfigName' definiert, die Datei heit
1wieder "GME.GME", weil's so im Handbuch steht.
1Meldung, da .GME nicht gefunden, erscheint nun mit vollst.
1Dateinamen (also z.B. "GME.GME" statt nur ".GME") und
1dahinter wird ein CR/LF ausgegeben, damit das evtl. folgende
1"Text laden" nicht direkt dahinter steht.
#17.12.90  TT  Fix vom 16.12. von JL wg. Absturz bei ^QE in TextSchreiben
1eingesetzt.
#18.12.90  TT  Letzte Zeile wird von TextLesen nun korrekt geladen;
1Fehlerabfrage beim Anlegen ALLER Puffer -> OutOfMemory-Meldg.;
1TextSchreiben: Handles werden auf neg. Werte und nicht mehr
1"<6" verglichen; TextSchreiben: Letzte Zeile wird nicht mit
1CR/LF versehen.
#09.03.91  TT  TextSchreiben: liefert Erfolgswert; GME.GME wird nur geladen,
1wenn "KonfigSpeichern" aktiv ist.
 *)
 
 (*$R-*)
 (*$Y+*)
 (*$Z+*)
 
 IMPLEMENTATION MODULE GMEFile;
 
 
 (* The Little Golem Editor. Begonnen 13. 06. 86
#(C) 1986, 1990 by Johannes Leckebusch
#Version: Siehe ceditor
#Stand: 28. 02. 88
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, ADR, CAST;
 (* FROM Storage IMPORT ALLOCATE, DEALLOCATE; *)
 FROM Granule IMPORT ALLOCATE, DEALLOCATE;
 
 FROM GEMDOS IMPORT IOMode, Open, Create, Close, Delete, Read, Write, Rename,
"DaTime, TimeAccessMode;
 
 FROM EasyGEM1 IMPORT MakeScrapName;
 FROM PrgCtrl IMPORT ActiveProcess;
 FROM SystemError IMPORT OutOfMemory;
 
 FROM Strings IMPORT Append, Assign, Copy;
 FROM FastStrings IMPORT Pos;
 IMPORT FastStrings, Paths, Lists, Directory, ShellMsg, PathCtrl, FileNames;
 FROM ShellMsg IMPORT ShellPath;
 
 (* FROM MyConversions IMPORT ConvCard; *)
 FROM Convert IMPORT ConvCard;
 
 FROM GMEConfig IMPORT ConfigInit, InitConfig;
 
 FROM GMEBase IMPORT WriteConst, WriteLn, WriteChar, Trace,
(bel, cr, eot, lf, tab, nul, LinesOnScreen,
(
(PuffRecSize, cRevision,
(InitBuffer,
(LoescheBild, LoescheZeile,
(WriteLine, HighLight, Normal, GotoXY, CursorEin, CursorAus,
(Nachricht, FrageJaNein, Ja, Nein, MausEin, MausAus, MausBusy,
(GetVersion,
(PuffInit,
(UndoPuffer, ClipBoard, HilfsPuffer, ConfigPuffer,
(EditPuffer, AlternEdit, DruckPuff, MailPuffer,
(Tausch, GolemPuffer, PSCPuffer, FehlerPuffer;
 
 FROM GMEBase IMPORT DeleteTail, GetDirectory, GetPfad;
 
 FROM GMEBase IMPORT cZeile, cTabWeite, cKopfVorlauf, cKopfNachlauf,
(cZeilenAbstand, cSpiegel, cOffset;
 
 FROM GMEBase IMPORT Mode, CharSet,
(einPufferPointer, eineInfo, eineZeile,
(einLinePointer, Moden, MerkIndex,
(einMerkPunkt, einMerkPointer, einStringPointer, einMerkSet;
 
 FROM GMEBase IMPORT Loeschen, Init, AllocLine, PutLine,
(AutoCount, InsertPuffer;
 
 (* FROM EditCommand IMPORT SplitFileName; *)
 
 FROM GMEKernel IMPORT SchirmSchreiben;
 
 FROM GMEKernel IMPORT LineUp, InsertLine, StelleZeileEin, SucheZeilenPointer;
 
 (* Bemerkung: StringZeilen werden als >>Zeile<<, Pointer-Objekte
#als >>Line<< bezeichnet *)
 
 CONST   cpuffer =       32767;
(cgrain =        16; (* Hm - das war natrlich Granule... *)
(
(DefaultConfigName = 'GME.GME';
 
 TYPE    einPuffer =     ARRAY [0..cpuffer] OF CHAR;
(PufferPointer = POINTER TO einPuffer;
 
 VAR     version:        eineInfo;
(puffer:         PufferPointer;
 
 
 (************************* aus GMEBase *******************************)
 
 PROCEDURE LoadConfig (Puff: einPufferPointer; frage, message: BOOLEAN);
 VAR     Info:           eineInfo;
(filehandle:     INTEGER;
(ok:             BOOLEAN;
(button:         INTEGER;
 VAR     PName:          eineInfo;
(LSIZE:          LONGCARD;
(mind:           MerkIndex;
(dot, star:      ARRAY [0..0] OF CHAR; (* Compilerfehler! *)
(i:              CARDINAL;
(ch:             CHAR;
(chp:            POINTER TO CHAR;
 
$PROCEDURE ReadZeile (VAR lp: einLinePointer);
$VAR       LSIZE:          LONGCARD;
.l:              eineZeile;
.ind:            CARDINAL;
$BEGIN
&LSIZE := 1; ind := 0;
&WHILE (ch # cr) & (ch # eot) & (ind < cZeile) & (LSIZE = 1L) DO
&(* Achtung: Falls tatsaechlich zuviele Zeichen im String,
)werden nicht alle gelesen! (ind < cZeile) *)
(l [ind] := ch; INC (ind);
(Read (filehandle, LSIZE, chp);
&END (* WHILE *);
&l [ind] := nul;
&(* merkinfo ist nicht alloziiert! *)
&AllocLine (lp, 0);
&IF lp = NIL THEN
(Nachricht ('Kein Platz fr|Zeileninfo.113');
&ELSE
(PutLine (lp, l);
&END;
$END ReadZeile;
 
 (*
$PROCEDURE LoadMerkpunktListe (VAR mp: einMerkPunkt);
$VAR     mpp, hp:    einMerkPointer;
,Ende:       BOOLEAN;
"
&PROCEDURE LoadMerkpunkt (VAR p: einMerkPointer);
&VAR       LSIZE:          LONGCARD;
(VAR     lp:             einLinePointer;
(
&BEGIN (* LoadMerkpunkt *)
((* Merkpunkt-Record lesen: *)
(NEW (p);
(IF p = NIL THEN
*Nachricht ('Kein Platz fr|Merkpunkt.114');
*Ende := TRUE; RETURN;
(END;
(LSIZE := LONG (SIZE (p^));
(Read (filehandle, LSIZE, p);
((* p^.nextMerk enthaelt alten Pointerwert, dieser darf
+jedoch nur auf NIL verglichen werden! *)
(WITH p^ DO
*merkline := Puff^.Puffer^.naechste; (* erste effektive Textzeile *)
 
*(* Infostring lesen: *)
 
*IF merkinfo # NIL THEN
,lp := merkinfo;
,chp := ADR (ch); LSIZE := 1;
,Read (filehandle, LSIZE, chp);
,WHILE (ch # eot) & (LSIZE = 1) DO
.ReadZeile (merkinfo);
.Read (filehandle, LSIZE, chp);
.IF ch # eot THEN
0AllocLine (merkinfo^.naechste, 0);
0IF merkinfo^.naechste = NIL THEN
2Nachricht ('Kein Platz fr|Zeileninfo.115');
2Ende := TRUE; RETURN;
0END;
0merkinfo^.naechste^.vorige := merkinfo;
0merkinfo := merkinfo^.naechste;
.END (* IF *);
,END (* WHILE NOT ^Z *);
*END (* IF Infostring lesen *);
*
(END (* WITH *);
&END LoadMerkpunkt;
&
$BEGIN (* LoadMerkpunktListe *)
&IF mp.nextMerk # NIL THEN
((* WriteLn; WriteConst (' Lade Merkpunktliste'); *)
(LoadMerkpunkt (mp.nextMerk);
(mpp := mp.nextMerk; Ende := FALSE;
(WHILE (mpp^.nextMerk # NIL) & ~Ende DO
*LoadMerkpunkt (mpp^.nextMerk);
*mpp := mpp^.nextMerk;
(END (* WHILE *);
&END (* IF *);
$END LoadMerkpunktListe;
 *)
 BEGIN (* LoadConfig *)
"(* IF ~FrageJaNein (1, 'Texteinstellungen laden') THEN RETURN; END; *)
 
"dot [0] := '.'; (* Compilerfehler - keine Char-Konstante erlaubt! *)
"star [0] := '*';
"(* REPEAT *)
"IF frage THEN CursorAus;
%LoescheBild;
%HighLight; WriteLine (version);
%Normal; WriteLn; WriteLn;
"END (* IF frage *);
"
$WITH Puff^ DO
&FileNames.ConcatName (Pfad, 'GME', Pfad);
&FileNames.ConcatName (Name, 'GME', Name);
$END;
$
$Info := Puff^.Pfad; DeleteTail (Info);
$FastStrings.Append (Puff^.Name, Info);
$IF frage THEN
&(* WriteConst (' Text-Konfiguration lesen: '); *)
&HighLight; WriteConst (Info); Normal;
&GetDirectory (Puff^.Pfad, Puff^.Name, 'GME lesen', button, FALSE);
&IF (button # 1) THEN
((*IF expand THEN RETURN; END;*)
(InitConfig (Puff);
(CursorEin; RETURN;
&END;
&Info := Puff^.Pfad; DeleteTail (Info);
&FastStrings.Append (Puff^.Name, Info);
$END (* IF frage *);
 
$Open (Info, ORD (read), filehandle);
$(* frage := TRUE; *)
 
"IF ~(filehandle >= 0) THEN
$(* Nachricht ('.GME-Datei nicht gefunden!'); *)
 
$HighLight; WriteLine (Puff^.Name);
$WriteConst (' nicht gefunden!'); Normal;
$WriteLn;
 
$InitConfig (Puff);
$EXCL (Puff^.Modus, KonfigSpeichern);
$RETURN;
"END (* IF *);
"IF message THEN
$WriteConst ('Config laden');
$WriteLn;
"END;
"MausBusy;
"LSIZE := 4;
"Read (filehandle, LSIZE, Puff);
"IF Puff^.MagicRevision # cRevision THEN
$ok := Close (filehandle);
$Nachricht ('GME-Datei inkompatibel');
$InitConfig (Puff);(* Puff^.MagicRevision := 0;*)
$CursorEin;
$RETURN;
"END (* IF *);
"LSIZE := PuffRecSize - 4L;
"Read (filehandle, LSIZE, ADDRESS (Puff) + 4L);
"EXCL (Puff^.Modus, Editiert);
"(* EXCL (Puff^.Modus, ScanText); (* Flag steuert PSC-Interpreter! *) *)
"
"(* Merkinfo der festen Merkpunkte laden: *)
"
"FOR mind := ErsteZeile TO LetztePosition DO
$(* Trace (' Merkpunkt laden...'); *)
$WITH Puff^.MerkPunkte [mind] DO
&IF merkinfo # NIL (* alter String war vorhanden *)
(THEN chp := ADR (ch); LSIZE := 1;
-Read (filehandle, LSIZE, chp);
-ReadZeile (merkinfo);
&END (* IF merkinfo *);
$END (* WITH *);
"END (* FOR *);
 
 (*
"(* Merklisten laden: *)
"
"IF expand THEN
$FOR mind := ErsteZeile TO LetztePosition DO
&WITH Puff^ DO
(LoadMerkpunktListe (MerkPunkte [mind]);
&END (* WITH *);
$END (* FOR *);
"END (* IF *);
 *)
 
"(* File schliessen *)
"ok := Close (filehandle);
"MausEin; CursorEin;
 END LoadConfig;
 
 PROCEDURE SaveConfig (Puff: einPufferPointer; frage: BOOLEAN);
 (* Speichere die in listen genannten Merkpunktlisten, sonst nur den
#Kopfrecord des Textpufferdescriptors *)
 
 VAR     Name, BakName, Pfad:  eineInfo;
(filehandle:           INTEGER;
(ok:                   BOOLEAN;
(dot, star:            ARRAY [0..0] OF CHAR; (* Compilerfehler! *)
(PName:                eineInfo;
(i:                    CARDINAL;
(button:               INTEGER;
(LSIZE:                LONGCARD;
(mind:                 MerkIndex;
 
"PROCEDURE WriteInfo (lp: einLinePointer);
"VAR   ch:             CHAR;
"BEGIN
$LSIZE := LONG (LENGTH (lp^.ZeilPointer^)); (* ERROR *)
$Write (filehandle, LSIZE, lp^.ZeilPointer);
$ch := cr; LSIZE := 1;
$Write (filehandle, LSIZE, ADR (ch));
"END WriteInfo;
 
 (*
"PROCEDURE SaveMerkpunktListe (mp: einMerkPunkt);
"VAR     mpp:    einMerkPointer;
 
$PROCEDURE SaveMerkpunkt (p: einMerkPointer);
$VAR         LSIZE:          LONGCARD;
0lp:             einLinePointer;
0ch:             CHAR;
$BEGIN
&(* Merkpunkt-Record schreiben: *)
&LSIZE := LONG (SIZE (p^));
&Write (filehandle, LSIZE, p);
&WITH p^ DO
&
((* Infostring schreiben: *)
&
(IF merkinfo # NIL THEN
*lp := merkinfo;
*WHILE lp # NIL DO
,WriteInfo (lp);
,lp := lp^.naechste;
*END (* WHILE *);
(END (* IF Infostring schreiben *);
(ch := eot; (* ^Z *)
(LSIZE := 1;
(Write (filehandle, LSIZE, ADR (ch));
&END (* WITH p^ *);
$END SaveMerkpunkt;
$
"BEGIN (* SaveMerkpunktListe *)
$mpp := mp.nextMerk;
$WHILE mpp # NIL DO
&SaveMerkpunkt (mpp);
&mpp := mpp^.nextMerk;
$END (* WHILE *);
"END SaveMerkpunktListe;
 *)
 
 BEGIN (* SaveConfig *)
 (*
"IF ~FrageJaNein (1, 'Texteinstellungen speichern') THEN RETURN; END;
 *)
"dot [0] := '.'; (* Compilerfehler - keine Char-Konstante erlaubt! *)
"star [0] := '*';
"IF frage THEN
$Name := DefaultConfigName;
"ELSE
$(*
$Name := Puff^.Name;
$IF Pos (dot, Name) >= 0 THEN
&(* Suffix entfernen: *)
&i := LENGTH (Name); DEC (i);
&WHILE Name [i] # '.' DO
(DEC (i);
&END (* WHILE *);
&Name [i] := nul;
$END (* IF Punkt *);
$IF Name [0] = nul THEN FastStrings.Assign (star, Name); END;
$FastStrings.Append ('.GME', Name);
$*)
$FileNames.ConcatName (Puff^.Name, 'GME', Name);
"END (* IF frage *);
"
"(* Meldung in die obersten Bildschirmzeilen schreiben: *)
"
"(* LoescheBild; *)
"GotoXY (0, 0); CursorAus;
"HighLight; WriteLine (version); Normal; LoescheZeile;
"WriteLn; LoescheZeile; WriteLn; LoescheZeile;
"HighLight; WriteConst (' Text-Konfiguration schreiben: ');
"Pfad := Puff^.Pfad; DeleteTail (Pfad);
"WriteConst (Pfad); WriteConst (Name); Normal; LoescheZeile;
"WriteLn; LoescheZeile;
"
"IF frage THEN
$FileNames.ConcatPath (ShellPath, DefaultConfigName, PName);
"ELSE
$(*
$PName := Puff^.Pfad;
$IF Pos (dot, PName) >= 0 THEN
&i := LENGTH (PName); DEC (i);
&WHILE PName [i] # '.' DO
(DEC (i);
&END (* WHILE *);
&PName [i] := nul;
$END (* IF Punkt *);
$IF PName [0] = nul THEN FastStrings.Assign (star, PName); END;
$FastStrings.Append ('.GME', PName);
$*)
$FileNames.ConcatName (Puff^.Pfad, 'GME', PName);
"END (* IF frage *);
"
"IF (* frage OR *) (Name [0] = nul) THEN
$(* Filename vom Benutzer holen: *)
$GetDirectory (PName, Name, '*.GME speichern', button, FALSE);
$IF button # 1 THEN (* Abbruch-Knopf gedrueckt *)
&RETURN;
$END;
"END (* IF frage *);
"
"IF Name [0] = nul THEN
$Nachricht('Sie mssen einen Dateinamen angeben!');
$RETURN;
"END (* IF kein Name *);
"BakName := Name;
"Pfad := PName; DeleteTail (Pfad);
"FastStrings.Append (BakName, Pfad);
 
"(* Alte Datei in .OLD umbenennen *)
"IF (MakeBAK IN Puff^.Modus) THEN
$FileNames.ConcatName (Pfad, 'OLD', BakName);
$ok := Delete (BakName);
$Rename (Pfad, BakName);
"END (* IF ~MakeBAK *);
"
"(* Neue Datei anlegen: *)
"
"MausBusy;
"
"Create (Pfad, 0, filehandle);
"IF filehandle < 0 THEN
$Nachricht ('Fehler beim Erzeugen der .GME-Datei');
$RETURN;
"END (* IF Handle ungueltig *);
"
"(* Deskriptor-Record schreiben: *)
"
"LSIZE := PuffRecSize;
"Write (filehandle, LSIZE, Puff);
"
"(* Merkinfo der festen Merkpunkte speichern: *)
"
"FOR mind := ErsteZeile TO LetztePosition DO
$WITH Puff^.MerkPunkte [mind] DO
&IF merkinfo # NIL THEN
(WriteInfo (merkinfo);
&END (* IF *);
$END (* WITH *);
"END (* FOR *);
 
 (*
"(* Merkpunktlisten speichern: *)
"
"FOR mind := ErsteZeile TO LetztePosition DO
$IF mind IN listen THEN
&WITH Puff^ DO
(SaveMerkpunktListe (MerkPunkte [mind]);
&END (* WITH *);
$END (* IF mind IN listen *);
"END (* FOR *);
 *)
"
"(* Datei schliessen: *)
"
"ok := Close (filehandle);
"MausEin; CursorEin;
 END SaveConfig;
 
 
 PROCEDURE TextVorhanden (Name: ARRAY OF CHAR): BOOLEAN;
 VAR     h:              INTEGER;
(ok:             BOOLEAN;
 BEGIN
"Open (Name, ORD (read), h);
"IF h >= 0 THEN
$ok := Close (h); RETURN TRUE;
"ELSE RETURN FALSE;
"END (* IF *);
 END TextVorhanden;
 
 PROCEDURE TextLoeschen (Name: ARRAY OF CHAR);
 VAR     ok:             BOOLEAN;
 BEGIN
"ok := Delete (Name);
 END TextLoeschen;
 
 PROCEDURE ReInit (Puff: einPufferPointer);
 (* Initialisiere Puffer nach LoadConfig, ohne ??? *)
 VAR     merkindex:      MerkIndex;
 BEGIN
"WITH Puff^ DO
$ZeilenAnzahl := 1; (* da sie durch Laden inkrementiert wird! *)
$MerkPunkte [LaufendeZeile].zeilpos := 1;
$AllocLine (Puffer, 0);
$IF Puffer = NIL THEN RETURN; END;
$WITH Puffer^ DO
&AllocLine (naechste, 0);
&naechste^.vorige := Puffer;
$END (* WITH *);
"END (* WITH *);
"FOR merkindex := ErsteZeile TO LaufendeZeile DO
$WITH Puff^.MerkPunkte [merkindex] DO
&merkline := Puff^.Puffer^.naechste;
$END (* WITH *);
"END (* FOR *);
 END ReInit;
 
 VAR     expandBlankCompr:       BOOLEAN;
 
 CONST DLE = 20C;
&ctrlZ = CHR (26);
 
(
"PROCEDURE LiesPuffer (VAR index, ende: LONGCARD; texthandle: INTEGER);
"(* Diese Routine liest mglichst schnell einen Textblock aus der Datei
%"texthandle" in den internen Puffer (puffer). Dabei wird festgehalten,
%wo das Ende des gltigen Textinhaltes steht (globaler Parameter ende).
%"index" wird wieder auf Null gesetzt, auer es war vorher schon Null,
%dann auf 1. Dann ist nmlich index > ende, was das Ende des Textes
%bedeutet.
#*)
%
"BEGIN
$(*Trace ('LiesPuffer');*)
$index := VAL (LONGCARD, cpuffer) + 1L; (* versuche, ganzen Block zu les. *)
$Read (texthandle, index, ADDRESS (puffer)); (* wird i. d. R. cpuffer + 1 *)
$(*Trace ('Read fertig');*)
$ende := index;
$(* Anzahl gelesener Zeichen, im Fehlerfall eigentlich negative LONGINT *)
$IF (ende > (*VAL (LONGCARD, 0)*) 0L) THEN
&(*Trace ('ende > 0');*)
&index := (*VAL (LONGCARD, 0)*) 0L; DEC (ende); (* Da 0-based, ist der gueltige Index
Adie Anzahl Zeichen - 1 *)
>(* Index auf 0, um Puffer vom Anfang aus-
Azulesen *)
$ELSE index := 1; (* index > ende! *)
$END (* IF *);
$(*Trace ('LiesPuffer fertig');*)
"END LiesPuffer;
 
 PROCEDURE FastLen (    texthandle: INTEGER;
3VAR index, ende: LONGCARD; TabWeite: CARDINAL;
3VAR blanks, len, endindex: CARDINAL;
3VAR zeilenende, dateiende: BOOLEAN): BOOLEAN;
 (* Diese Funktion ermittelt die effektive Lnge einer Zeile im Puffer.
#Sie startet ab der globalen Variablen index und liefert den endindex
#in Puffer. "len" ist die expandierte Lnge, dh. die Lnge der zu
#kopierenden Zeile, wenn Tabs und DLE expandiert werden. Die Funktion
#liefert TRUE, wenn Zeile ungltige Daten enthlt
!*)
 VAR   end: CARDINAL;
&error, first, fertig: BOOLEAN;
 BEGIN
"(*
$endindex := VAL (CARDINAL, index); end := VAL (CARDINAL, ende);
$len := 0; blanks := 0;
$zeilenende := FALSE; fertig := FALSE;
$IF dateiende OR (endindex > end) THEN RETURN FALSE; END;
$error:= FALSE;
$first:= TRUE;
$REPEAT
&CASE puffer^ [endindex] OF
((* DLE darf nur am Zeilenanfang stehen... *)
(DLE:    IF NOT first THEN
2error:= TRUE;
2fertig := TRUE;
2zeilenende := TRUE;
0INC (endindex); (* Skip DLE *) INC (index);
0IF (endindex > end) THEN
2LiesPuffer (index, ende, texthandle);
2endindex := VAL (CARDINAL, index);
2end := VAL (CARDINAL, ende);
0END (* IF *);
0IF (ORD (puffer^[endindex]) >= ORD (' ')) THEN
2blanks := ORD (puffer^[endindex]) - ORD (' ');
0ELSE
2error:= TRUE;
0END (* IF *);
0INC (index);
(|
(lf:     INC (index); (* Skip Linefeed *);
(|
(tab:    INC (len,
2TabWeite * ((len + blanks) DIV TabWeite + 1)
3- len);
(|
(cr:     fertig := TRUE;
0zeilenende := TRUE;
(|
(ctrlZ:  dateiende:= TRUE; fertig:= TRUE
(|
(ELSE    INC (len);
&END (* CASE *);
&first:= FALSE;
&INC (endindex); IF endindex > end THEN fertig := TRUE; END;
$UNTIL fertig;
 *)
"ASSEMBLER
&; endindex := VAL (CARDINAL, index); end := VAL (CARDINAL, ende);
&MOVE.L  index(A6),A0
&MOVE.L  endindex(A6),A1
&MOVE.L  (A0),D1
&MOVE    D1,(A1)
&MOVE.L  ende(A6),A0
&MOVE.L  (A0),D2
&MOVE    D2,end(A6)
&; len := 0; blanks := 0;
&MOVE.L  len(A6),A0
&CLR     (A0)
&MOVE.L  blanks(A6),A0
&CLR     (A0)
&; zeilenende := FALSE; fertig := FALSE; first:= TRUE; error:= FALSE;
&MOVE.L  zeilenende(A6),A0
&CLR     (A0)
&CLR     first(A6)
&CLR     error(A6)
&; IF dateiende OR (endindex > end) THEN RETURN FALSE; END;
&MOVE.L  dateiende(A6),A0
&TST     (A0)
&BNE.W   endRepeat
&CMP.L   D2,D1
&BLS     repeat
&BRA.W   endRepeat
 
&; REPEAT
$repeat:
&; CASE puffer^ [endindex] OF
&MOVE.L  endindex(A6),A1
&MOVE    (A1),D1
&MOVE.L  puffer,A0
&MOVE.B  0(A0,D1.W),D0
 
&CMPI.B  #DLE,D0
&BNE     noDLE
 
&; IF ~first THEN <ende> END;
&; INC (endindex); INC (index);
&; IF (endindex > end) THEN
&;   LiesPuffer (index, ende, texthandle);
&;   endindex := VAL (CARDINAL, index); end := VAL (CARDINAL, ende);
&; END (* IF *);
&; blanks:= ORD (puffer^[endindex]) - ORD (' ');
&; INC (index);
&TAS     first(A6)
&BPL     isfirst
$isnotext:
&; Garbage im File!
&MOVE    #1,error(A6)
&BRA.W   endOfLine
$isfirst:
&ADDQ    #1,D1             ; endindex
&MOVE    D1,(A1)
&MOVE.L  index(A6),A0
&ADDQ.L  #1,(A0)
&MOVE    end(A6),D0
&CMP     D0,D1
&BLS     not1
&END;
(LiesPuffer (index, ende, texthandle);
&ASSEMBLER
&MOVE.L  index(A6),A0
&MOVE.L  endindex(A6),A1
&MOVE.L  (A0),D1
&MOVE    D1,(A1)
&MOVE.L  ende(A6),A0
&MOVE.L  (A0),D2
&MOVE    D2,end(A6)
$not1:
&MOVE.L  puffer,A0
&MOVE.L  endindex(A6),A1
&MOVE    (A1),D1
&MOVEQ   #0,D0
&MOVE.B  0(A0,D1.W),D0
&SUBI.B  #' ',D0
&BCS     isnotext
&MOVE.L  blanks(A6),A0
&MOVE    D0,(A0)
&MOVE.L  index(A6),A0
&ADDQ.L  #1,(A0)
&BRA.W   endCase
 
$noDLE:
&; lf:     INC (index); (* Skip Linefeed *);
&CMPI.B  #lf,D0
&BNE     noLF
&MOVE.L  index(A6),A0
&ADDQ.L  #1,(A0)
&BRA.W   endCase
 
$noLF:
&; tab:  INC (len, TabWeite * ((len + blanks) DIV TabWeite + 1) - len);
&CMPI.B  #tab,D0
&BNE     noTAB
&MOVE    TabWeite(A6),D1
&MOVE    D1,D2
&ADDQ    #1,D2
&MOVE.L  len(A6),A0
&MOVE.W  (A0),D0
&MOVE.L  blanks(A6),A0
&ADD     (A0),D0
&MULU    D1,D0
&DIVU    D2,D0
&MOVE.L  len(A6),A0
&SUB     (A0),D0
&ADD     D0,(A0)
&BRA     endCase
 
$noTAB:
&; cr:     fertig := TRUE; zeilenende := TRUE;
&CMPI.B  #cr,D0
&BNE     noCR
 
$endOfLine
&MOVE.L  zeilenende(A6),A0
&MOVE    #1,(A0)
&MOVE.L  endindex(A6),A0
&ADDQ    #1,(A0)
&BRA     endRepeat
 
$noCR:
&CMPI.B  #ctrlZ,D0
&BNE     noEOF
&
&MOVE.L  dateiende(A6),A0
&MOVE    #1,(A0)
&BRA     endRepeat
&
$noEOF:
&MOVE.L  len(A6),A0
&ADDQ    #1,(A0)
 
$endCase:
&; INC (endindex); IF endindex > end THEN fertig := TRUE; END;
&MOVE.L  endindex(A6),A0
&ADDQ    #1,(A0)
&MOVE    (A0),D0
&MOVE    end(A6),D1
&CMP     D1,D0
&BHI     endRepeat
 
&; UNTIL fertig;
&BRA     repeat
 
$endRepeat:
"END;
"RETURN error
 END FastLen;
 
 PROCEDURE FastCopyExpand (VAR index, ende: LONGCARD; texthandle: INTEGER;
:TabWeite: CARDINAL;
:blanks, laenge, end: CARDINAL; VAR z: ARRAY OF CHAR);
 (* Kopiert Zeile oder Zeilenteil von
#start..end aus puffer^ in Zielstring. Expandiert Tab-Codes.
 *)
 VAR   ztab:           CARDINAL;
&start, zindex:  CARDINAL;
 BEGIN
 (*
$zindex := 0;
$start := VAL (CARDINAL, index); laenge := laenge + blanks;
 
$(* !JL 11. 12. 90 *)
$IF laenge > HIGH (z) THEN
&Nachricht ('Sourcezeile ist zu lang!');
&laenge := HIGH (z);
$END (* IF *);
$
$WHILE blanks > zindex DO
&z [zindex] := ' '; INC (zindex);
$END (* WHILE *);
$WHILE zindex < laenge DO
&CASE puffer^[start] OF
(tab:    ztab := TabWeite * (zindex DIV TabWeite + 1);
0WHILE (zindex < ztab) DO
2z [zindex] := ' '; INC (zindex);
0END (* WHILE *);
(|
(ELSE    z [zindex] := puffer^[start]; INC (zindex);
&END (* CASE *);
&INC (start);
$END (* WHILE *);
$z [zindex] := nul;
$index := VAL (LONGCARD, end);
$IF index > ende THEN
&LiesPuffer (index, ende, texthandle);
$END;
 *)
"ASSEMBLER
&; zindex := 0;
&; start := VAL (CARDINAL, index); laenge := laenge + blanks;
&MOVE.L  index(A6),A0
&MOVE.L  (A0),D0
&MOVE    D0,start(A6)
&MOVE    blanks(A6),D0
&ADD     D0,laenge(A6)
&
&; IF laenge > HIGH (z) THEN
&;   Nachricht ('Sourcezeile ist zu lang!');
&;   laenge := HIGH (z);
&; END;
&MOVE.W  laenge(A6),D1
&CMP.W   z+4(A6),D1
&BLS     nope
&MOVE.W  z+4(A6),laenge(A6)
&END;
(Nachricht ('Sourcezeile ist zu lang!');
&ASSEMBLER
$nope:
&
&; WHILE blanks > zindex DO z [zindex] := ' '; INC (zindex); END
&MOVE    blanks(A6),D0
&MOVEQ   #0,D1
&MOVE.L  z(A6),A2
$while1:
&CMP     D1,D0
&BLS     endWhile1
&MOVE.B  #' ',(A2)+
&ADDQ    #1,D1
&BRA     while1
$endWhile1:
 
$while2:
&; WHILE zindex < laenge DO
&MOVE    laenge(A6),D0
&CMP     D1,D0
&BLS.W   endWhile2
&; CASE puffer^[start] OF
&MOVE.L  puffer,A0
&MOVE    start(A6),D0
&MOVE.B  0(A0,D0.W),D0
&; tab:  ztab := TabWeite * (zindex DIV TabWeite + 1);
&;       WHILE (zindex < ztab) DO z [zindex] := ' '; INC (zindex); END
&CMPI.B  #tab,D0
&BNE     noTAB
&MOVE    TabWeite(A6),D0
&ADDQ    #1,D0
&MOVEQ   #0,D2
&MOVE    D1,D2
&DIVU    D0,D2
&MULU    TabWeite(A6),D2
$while3:
&CMP     D1,D2
&BLS     endWhile3
&MOVE.B  #' ',(A2)+
&ADDQ    #1,D1
&BRA     while3
$endWhile3:
&BRA     endCase
 
$noTAB:
&; ELSE    z [zindex] := puffer^[start]; INC (zindex);
&MOVE.B  D0,(A2)+
&ADDQ    #1,D1
 
$endCase:
&; END (* CASE *);
&; INC (start);
&ADDQ    #1,start(A6)
&BRA     while2
 
$endWhile2:
&; z [zindex] := nul;
&CLR.B   (A2)+
>; MOVE.L  zindex(A6),A0
>; MOVE    D1,(A0)
&; index := VAL (LONGCARD, end);
&MOVEQ   #0,D0
&MOVE    end(A6),D0
&MOVE.L  index(A6),A0
&MOVE.L  D0,(A0)
&; IF index > ende THEN
&;   LiesPuffer (index, ende, texthandle);
&; END;
&MOVE.L  ende(A6),A0
&CMP.L   (A0),D0
&BLS     noLies
&END;
(LiesPuffer (index, ende, texthandle);
&ASSEMBLER
$noLies:
"END (* Assembler *)
 END FastCopyExpand;
!
 PROCEDURE TextLesen (Puff: einPufferPointer; initialisiere: BOOLEAN;
5frage, loadconfig, message: BOOLEAN);
 (* Stellt yoffset auf 0 *)
 
 VAR     z, z2:          eineZeile;
(indent:         Moden;  (* Menge der Zustaende von Puff *)
(Info:           eineInfo;
(pf, na:         eineInfo;
(dummys:         eineInfo;
!
(index, ende:    LONGCARD;
(zindex:      CARDINAL;
(ok:             BOOLEAN;
(texthandle:     INTEGER;
(dummy, dum:     CHAR;
(button:         INTEGER;
(nulldeleted:    BOOLEAN;
(tabsgefiltert:  BOOLEAN;
(tabsfiltern:    BOOLEAN;
(dot:            ARRAY [0..0] OF CHAR; (* Compilerfehler! *)
(
(zlaenge, endindex,
(blanks:         CARDINAL;
(dateiende:      BOOLEAN;
(zeilenende:     BOOLEAN; (* Zeilenende steht im Puffer *)
 
 VAR     PName:                                  eineInfo;
(AlteZeilenNummer:                       CARDINAL;
(erstezeilpos, erstecharpos, laufendezeilpos,
(laufendecharpos:                        CARDINAL;
(nextpuff:                               einPufferPointer;
(helpline:                               einLinePointer;
(OldPfad:                                eineInfo;
(Message:                                ARRAY [0..60] OF CHAR;
(dname:                                  eineInfo;
(suff:                                   ARRAY [0..3] OF CHAR;
(h:                                      CARDINAL;
(timeptr:                                ADDRESS;
 
 PROCEDURE keinTextNachricht;
"BEGIN
$Nachricht ('Dies ist kein Text!');
"END keinTextNachricht;
 
 BEGIN (* TextLesen *)
"nulldeleted := FALSE; tabsgefiltert := FALSE;
"tabsfiltern := (* TabFiltern IN Puff^.Modus; *) TRUE;
"expandBlankCompr := TRUE; (*DLECompr IN Puff^.Modus; *)
"IF message THEN CursorAus; END;
"REPEAT
$IF message THEN
&LoescheBild;
&SchirmSchreiben (Puff, Puff^.MerkPunkte [LaufendeZeile].merkline, 0, 0);
&GotoXY (0, 0);
$END (* IF message *);
$IF (Editiert IN Puff^.Modus) & initialisiere THEN
&IF ~FrageJaNein (Ja, 'Puffer wurde editiert|berschreiben?')
&THEN RETURN END;
&LoescheBild;
$END (* IF Puffer nicht leer *);
$IF Puff^.Pfad [0] = nul THEN
&SplitFileName (GlobalPfad, Puff^.Pfad, dname, suff);
&IF suff [0] = nul THEN Append ('*.*', Puff^.Pfad, ok);
&ELSE Append ('*.', Puff^.Pfad, ok); FastStrings.Append (suff, Puff^.Pfad);
&END (* IF suff *);
$END (* IF *);
$Info := Puff^.Pfad; DeleteTail (Info);
$FastStrings.Append (Puff^.Name, Info);
$IF message THEN
&HighLight; WriteConst (version); Normal; WriteLn; WriteLn;
&IF initialisiere THEN Message := 'File lesen';
&ELSE Message := 'Block lesen';
&END;
&HighLight; WriteConst (Info); Normal;
&WriteLn;
&WriteLn;
$END (* IF message *);
$IF frage THEN
&PName := Puff^.Name;
&GetDirectory (Puff^.Pfad, Puff^.Name, Message, button, FALSE);
&IF button # 1 THEN
(IF ~initialisiere THEN
*Puff^.Name := PName;
(ELSE Puff^.Name [0] := nul;
(END;
(RETURN;
&END;
&GlobalPfad := Puff^.Pfad;
&MausEin;
&Info := Puff^.Pfad; DeleteTail (Info);
&FastStrings.Append (Puff^.Name, Info);
$ELSE MausEin;
$END (* IF frage *);
$Paths.SearchFile (Info, ShellMsg.SrcPaths, Paths.fromStart, ok, Info);
$IF ok THEN FileNames.SplitPath (Info, Puff^.Pfad, Puff^.Name); END;
$Open (Info, ORD (read), texthandle);
$frage := TRUE;
"UNTIL (texthandle >= 0);
"IF texthandle >= 0  THEN
$WITH Puff^ DO
'pf := Pfad; na := Name;
'IF initialisiere THEN
)Loeschen (Puff);
)Pfad := pf; Name := na;
'END (* IF *);
'indent := Modus;
'EXCL (Modus, AutoIndent);
'dateiende:= FALSE;
'index := 0; ende := 0;
 
 (****************************** Abspeichern von *.GME ***********************)
'IF loadconfig THEN
)nextpuff := NaechsterPuffer;
)LoadConfig (Puff, FALSE, message);
)(* nderung 10. 6. 89: *)
)loadconfig := KonfigSpeichern IN Modus;
)(* ******************* *)
)indent := Modus;
)Pfad := pf; Name := na;
)erstezeilpos := MerkPunkte [ErsteZeile].zeilpos;
)erstecharpos := MerkPunkte [ErsteZeile].charpos;
)laufendezeilpos := MerkPunkte  [LaufendeZeile].zeilpos;
)laufendecharpos := MerkPunkte  [LaufendeZeile].charpos;
)ReInit (Puff);
'END (* IF loadconfig *);
 
'IF message THEN
)WriteConst ('Text laden');
'END;
'IF puffer = NIL THEN
)Nachricht ('Speicher reicht|nicht fr Puffer');
)RETURN;
'END (* IF *);
'LiesPuffer (index, ende, texthandle);
'IF FastLen (texthandle, index, ende, TabWeite,
,blanks, zlaenge, endindex, zeilenende, dateiende) THEN
)keinTextNachricht; RETURN;
'END;
'FastCopyExpand (index, ende, texthandle, TabWeite, blanks, zlaenge, endindex, z);
'IF ~zeilenende THEN
)IF FastLen (texthandle, index, ende, TabWeite,
0blanks, zlaenge, endindex, zeilenende, dateiende) THEN
+keinTextNachricht; RETURN;
)END;
)FastCopyExpand (index, ende, texthandle, TabWeite,
9blanks, zlaenge, endindex, z2);
)FastStrings.Append (z2, z);
'END;
'(* *)
'IF initialisiere THEN
)PutLine (MerkPunkte [LaufendeZeile].merkline, z);
'ELSE
)LineUp (Puff);
)InsertLine (Puff, z, FALSE, FALSE, ~initialisiere);
'END (* IF *);
'IF message THEN
)GotoXY (38, 12); HighLight; (* CursorAus; *)
)WriteConst ('   0'); MausBusy;
'END;
'AlteZeilenNummer := 1;
'z:= '';
'LOOP
)IF index > ende THEN
+(*Nachricht ('EXIT 1');*)
+EXIT
)END;
)IF FastLen (texthandle, index, ende, TabWeite,
1blanks, zlaenge, endindex, zeilenende, dateiende) THEN
+keinTextNachricht; EXIT;
)END;
)(* *)
)WITH MerkPunkte [LaufendeZeile] DO
+WITH merkline^ DO
 
 (********** INLINE-Code fuer einen Sonderfall von InsertLine **********)
(
-IF initialisiere & zeilenende THEN
/NEW (helpline);
/IF helpline # NIL THEN
1helpline^.terminator [0] := nul;
1zindex := zlaenge + blanks;
1IF zindex > 0 THEN
3WITH helpline^ DO
5laenge := (zindex DIV cgrain + 1) * cgrain;
!
5ALLOCATE (ZeilPointer, VAL (LONGCARD, laenge));
5IF ZeilPointer = NIL THEN
7DISPOSE (helpline);
7Nachricht ('Speicher reicht nicht 1');
7EXIT;
5ELSE
7FastCopyExpand (index, ende, texthandle, TabWeite,
Gblanks, zlaenge, endindex, ZeilPointer^);
7(* *)
7INC (zeilpos); INC (ZeilenAnzahl);
5END (* IF noch Speicher *);
3END (* WITH *);
1ELSE
3WITH helpline^ DO
5ZeilPointer := ADR (terminator);
5laenge := 0;
3END (* WITH *);
3INC (zeilpos); INC (ZeilenAnzahl);
 
3(* Pufferindex weiterschalten!!! *)
3FastCopyExpand (index, ende, texthandle, TabWeite,
Cblanks, zlaenge, endindex, z2);
3(* Dummy-Aufruf zur Zeilenweiterschaltung *)
,
1END;
1IF zeilpos > AlteZeilenNummer THEN
3helpline^.vorige := merkline;
3helpline^.naechste := NIL;
3naechste := helpline;
3merkline := helpline;
1END (* IF *);
/ELSE Nachricht ('Speicher reicht nicht 2');
4EXIT;
/END (* IF # NIL *);
 
 (********** INLINE-Code fuer einen Sonderfall von InsertLine **********)
 
-ELSE
/(* *)
/FastCopyExpand (index, ende, texthandle, TabWeite,
?blanks, zlaenge, endindex, z);
/IF ~zeilenende THEN
1IF FastLen (texthandle, index, ende, TabWeite,
5blanks, zlaenge, endindex, zeilenende, dateiende) THEN
3keinTextNachricht; EXIT;
1END;
1FastCopyExpand (index, ende, texthandle, TabWeite,
Ablanks, zlaenge, endindex, z2);
1FastStrings.Append (z2, z);
/END;
 
/IF zeilenende OR dateiende OR (index > ende) THEN
1InsertLine (Puff, z, FALSE, FALSE, ~initialisiere);
/ELSE (* Textende *)
1(*Nachricht ('EXIT 2');*)
1EXIT;
/END (* IF *);
/IF dateiende THEN EXIT END;
-END (* IF initialisiere *);
-IF zeilpos > AlteZeilenNummer THEN
/AlteZeilenNummer := zeilpos
-ELSE
/Nachricht ('Speicher reicht nicht! 3');
/EXIT;
-END (* IF ZeilenNummer *);
+END (* WITH merkline^ *);
)END (* WITH *);
)IF message & (ZeilenAnzahl MOD 50 = 0) THEN
+CursorAus; MausAus; GotoXY (38, 12);
+ConvCard (MerkPunkte [LaufendeZeile].zeilpos, 4, dummys);
+WriteConst (dummys); MausBusy;
)END (* IF *);
'END (* LOOP *);
'IF message THEN Normal; END;
'(*GetDateTime (texthandle, fullDate, fullTime);
'datum:= Clock.PackDate (fullDate);
'tageszeit:= Clock.PackTime (fullTime)
'*)
'timeptr := ADR (tageszeit);
'DaTime (texthandle, timeptr, getTime);
'
'ok := Close (texthandle);
'Modus := indent;
$END (* WITH *);
$IF nulldeleted  & message THEN
&Nachricht ('Null-Characters ausgefiltert!');
$END (* IF *);
$IF tabsgefiltert & message THEN
&Nachricht ('Tab-Zeichen ausgefiltert!');
$END (* IF *);
"ELSE LoescheBild; HighLight;
'Assign ('Datei "', dummys, ok); FastStrings.Append (Info, dummys);
'Append ('"|nicht vorhanden!', dummys, ok);
'Nachricht (dummys);
'Info := "Neue Datei: ";
"END (* IF File *);
"IF initialisiere THEN
$WITH Puff^ DO (* Nach Lesen wieder auf Anfang einstellen *)
$
&IF loadconfig THEN (* wenn oben auskommentiert... *)
((* WriteConst ('restaurieren'); *)
(NaechsterPuffer := nextpuff;
(MerkPunkte [ErsteZeile].zeilpos := erstezeilpos;
(MerkPunkte [ErsteZeile].charpos := erstecharpos;
(MerkPunkte [LaufendeZeile].zeilpos := laufendezeilpos;
(MerkPunkte [LaufendeZeile].charpos := laufendecharpos;
((* ReAdjustMerkpointer (Puff); *)
 
(StelleZeileEin (Puff, laufendezeilpos, laufendezeilpos - erstezeilpos);
&ELSE
(MerkPunkte [ErsteZeile].zeilpos := 0;
(MerkPunkte [LaufendeZeile].charpos := 0;
(MerkPunkte [LaufendeZeile].zeilpos := 1;
(MerkPunkte [LaufendeZeile].merkline := Puffer^.naechste;
(MerkPunkte [ErsteZeile].merkline := Puffer^.naechste;
&END (* IF loadconfig *);
&
$END (* WITH *);
"ELSE StelleZeileEin (Puff, Puff^.MerkPunkte [LaufendeZeile].zeilpos,
7LinesOnScreen DIV 2);
"END (* IF *);
"WITH Puff^ DO
$EXCL (Modus, Exit); EXCL (Modus, Editiert); EXCL (Modus, BlockIstMarkiert);
$EXCL (Modus, Compiliert);
$MerkPunkte [CompilerInfo].charpos := 0;
$MerkPunkte [CompilerInfo].zeilpos := 1;
$MerkPunkte [CompilerInfo].merkline := Puffer^.naechste;
"END (* WITH *);
"Trace ('TextLesen fertig');
 END TextLesen;
 
 PROCEDURE TextSchreiben (Puff: einPufferPointer; backup, markiert,
9frage, saveconfig, controlfil: BOOLEAN;
9VAR erfolgreich: BOOLEAN);
 (* 'erfolgreich' ist auch TRUE, wenn "Abbruch" beim Selektor gewhlt wurde! *)
 VAR     Help:                   einLinePointer;
(i:                      CARDINAL;
(Info:                   eineInfo;
(BakName:                eineInfo;
(oldPfad, oldName:       eineInfo;
 
(index:                  LONGCARD;
(ok:                     BOOLEAN;
(texthandle:                      INTEGER;
(rest:                   eineZeile;
(ende:                   BOOLEAN;
(button:                 INTEGER;
 
"PROCEDURE SchreibPuffer (texthandle: INTEGER): BOOLEAN;
"VAR   count:  LONGCARD;
(ok:  BOOLEAN;
"BEGIN
$(* GEMDOS-Funktion 40H, D0 = Resultat (LONGINT) *)
$count := index;
$Write (texthandle, count, ADDRESS (puffer));
$ok := count = index;
$(* count sollte negative LONGINT sein, wenn Fehlermeldung,
'sonst Echo der geschriebenen Anzahl *)
$index := VAL (LONGCARD, 0); (* Puffer wieder vom Anfang her beschreiben *)
$RETURN ok;
"END SchreibPuffer;
!
"PROCEDURE SchreibZeile (texthandle: INTEGER; REF z: ARRAY OF CHAR;
:keinZeilenEndeAnfuegen: BOOLEAN; VAR ok: BOOLEAN);
"VAR   (*$Reg*)zindex: CARDINAL;
((*$Reg*)l:      CARDINAL;
((*$Reg*)ztab:   CARDINAL;
((*$Reg*)ind:    CARDINAL;
"BEGIN
"
$zindex := 0; (* Stringanfang *)
$(* Zeileninhalt in Puffer schreiben: *)
$l := LENGTH (z); (* Laenge des Strings - um 1 groesser als max. Index *)
$ok := TRUE;
$ind := VAL (CARDINAL, index);
$WHILE (ind <= cpuffer) & (zindex < l) & ok DO
&IF (z [zindex] < 40C) THEN
(IF (z [zindex] = tab) & (TabFiltern IN Puff^.Modus) THEN
*ztab := Puff^.TabWeite * ((zindex DIV Puff^.TabWeite) + 1);
*WHILE (ztab > 0) & ok DO
,puffer^ [ind] := ' '; INC (ind); DEC (ztab);
,IF (ind > cpuffer) & ok THEN
.index := VAL (LONGCARD, ind);
.ok := SchreibPuffer (texthandle);
.ind := 0;
,END;
*END (* WHILE *);
*INC (ind);
(ELSIF ~controlfil THEN
*puffer^ [ind] := z [zindex]; INC (ind);
(END (* IF Control-Code *);
&ELSE
(puffer^ [ind] := z [zindex]; INC (ind);
&END (* IF Tab *);
&INC (zindex);
&IF (ind > cpuffer) & ok THEN
(index := VAL (LONGCARD, ind);
(ok := SchreibPuffer (texthandle);
(ind := 0;
&END (* IF *);
$END (* WHILE *);
$IF ok & NOT keinZeilenEndeAnfuegen THEN
&(* cr schreiben: *)
&puffer^ [ind] := cr; INC (ind);
&IF (ind > cpuffer) & ok THEN
(index := VAL (LONGCARD, ind);
(ok := SchreibPuffer (texthandle);
(ind := 0;
&END (* IF *);
&(* lf schreiben: *)
&puffer^ [ind] := lf; INC (ind);
&IF (ind > cpuffer) & ok THEN
(index := VAL (LONGCARD, ind);
(ok := SchreibPuffer (texthandle);
(ind := 0;
&END (* IF *);
$END;
$index := VAL (LONGCARD, ind);
"END SchreibZeile;
 
 VAR     PName:          eineInfo;
(dummy:          CHAR;
(dummys:         eineInfo;
(dot:            ARRAY [0..0] OF CHAR; (* Compilerfehler! *)
(Message:        ARRAY [0..60] OF CHAR;
(timeptr:        ADDRESS;
 
 BEGIN (* TextSchreiben *)
"erfolgreich:= FALSE;
"WriteChar (bel);
"IF (Puff^.Puffer^.naechste^.naechste = NIL) &
%(Puff^.Puffer^.naechste^.ZeilPointer^[0] = nul) THEN
$erfolgreich:= TRUE;
$RETURN
"END (* IF Puffer leer *);
"CursorAus;
"REPEAT
$REPEAT
&Info := Puff^.Pfad; DeleteTail (Info);
&FastStrings.Append (Puff^.Name, Info);
&oldPfad := Puff^.Pfad; oldName := Puff^.Name;
&GotoXY (0, 0);
&HighLight; WriteConst (version); Normal; LoescheZeile;
&WriteLn; LoescheZeile; WriteLn; LoescheZeile;
&IF markiert THEN Message := 'Fileblock schreiben';
&ELSE Message := 'File schreiben';
&END;
&HighLight;
&WriteConst (Info); Normal;
&IF frage THEN
(PName := Puff^.Name;
(GetDirectory (Puff^.Pfad, Puff^.Name, Message, button, FALSE);
(IF button # 1 THEN
*Puff^.Name := PName;
*erfolgreich:= TRUE;
*RETURN;
(END;
(MausEin;
&ELSE MausEin;
&END (* IF frage *);
&(*
&IF Puff^.Name [0] = nul THEN
(Nachricht ('Noch kein Dateiname angegeben!');
&END (* IF kein Name *);
&*)
&frage := TRUE;
$UNTIL Puff^.Name [0] # nul;
$Info := Puff^.Pfad; DeleteTail (Info);
$FastStrings.Append (Puff^.Name, Info);
!
$IF ~markiert & (backup OR (MakeBAK IN Puff^.Modus)) THEN
&(*
(BakName := Info;
(dot [0] := '.'; (* Compilerfehler - keine Char-Konstante erlaubt! *)
(IF FastStrings.Pos (dot, BakName) > 0 THEN
*i := LENGTH (BakName); DEC (i);
*WHILE BakName [i] # '.' DO
,DEC (i);
*END (* WHILE *);
*BakName [i] := nul;
(END (* IF Punkt *);
(Append ('.BAK', BakName, ok);
&*)
&FileNames.ConcatName (Info, 'BAK', BakName);
&ok := Delete (BakName);
&Rename (Info, BakName);
$END (* IF nicht markiert *);
$Create (Info, 0, texthandle);
$IF texthandle < 0 THEN
&Nachricht ('Fehler beim Erzeugen der Text-Datei');
&RETURN;
$END (* IF Handle ungueltig *);
"UNTIL texthandle >= 0;
"WITH Puff^ DO
$IF markiert THEN
&StelleZeileEin (Puff, MerkPunkte [BlockMarke1].zeilpos, 0);
&Help := MerkPunkte [LaufendeZeile].merkline;
&i := MerkPunkte [LaufendeZeile].zeilpos;
$ELSE
&Help := Puffer^.naechste;
&i := 1;
$END (* IF *);
$index := VAL (LONGCARD, 0); ende := FALSE; ok := TRUE;
$HighLight;
 
$GotoXY (38, 12); HighLight;
$WriteConst ('   0'); MausBusy;
 
$IF puffer = NIL THEN
&Nachricht ('Speicher reicht|nicht fr Puffer');
&RETURN;
$END (* IF *);
$WHILE ~ende & ok DO
&ende := (Help^.naechste = NIL)
/OR (markiert & (i >= MerkPunkte [BlockMarke2].zeilpos));
&IF markiert & (i = MerkPunkte [LaufendeZeile].zeilpos) THEN
(FastStrings.Copy (Help^.ZeilPointer^, MerkPunkte [BlockMarke1].charpos,
.LENGTH (Help^.ZeilPointer^) - MerkPunkte [BlockMarke1].charpos,
.rest);
(SchreibZeile (texthandle, rest, ende, ok);
&ELSIF ende & markiert THEN
(FastStrings.Copy (Help^.ZeilPointer^, 0,
.MerkPunkte [BlockMarke2].charpos, rest);
(SchreibZeile (texthandle, rest, ende, ok);
&ELSE
(SchreibZeile (texthandle, Help^.ZeilPointer^, ende, ok);
&END (* IF *);
&Help := Help^.naechste;
&INC (i);
&IF i MOD 50 = 0 THEN
(CursorAus; MausAus; GotoXY (38, 12);
(ConvCard (i, 4, dummys);
(WriteConst (dummys); MausBusy;
&END (* IF *);
$END (* WHILE *);
$Normal;
$IF (index > VAL (LONGCARD, 0)) & ok THEN
&ok := SchreibPuffer (texthandle);
$END (* IF *);
$IF ~ok THEN
&Nachricht ('Fehler beim Abspeichern|Eventuell Diskette voll');
&LoescheBild;
&ok := Close (texthandle);
&RETURN
$END (* IF ~ok *);
$erfolgreich:= Close (texthandle);
$Open (Info, ORD (read), texthandle);
$timeptr := ADR (tageszeit);
$DaTime (texthandle, timeptr, CAST (TimeAccessMode, Compiliert IN Modus));
$ok := Close (texthandle);
"END (* WITH *);
"IF erfolgreich THEN
$IF markiert THEN Puff^.Pfad := oldPfad; Puff^.Name := oldName;
$ELSIF saveconfig THEN
&SaveConfig (Puff, FALSE);
$END (* IF *);
$AutoCount := 0;
$IF NOT markiert THEN
&EXCL (Puff^.Modus, Editiert);
$END
"END
 END TextSchreiben;
 
 (************************* EditCommand *************************************)
 
 CONST   cErrName =              'TLGE.ERR';
 
 VAR     FehlerMeldung:          eineInfo;
(ErrName:                eineInfo;
(FehlerText:             eineZeile;
(Start:                  CARDINAL;
(FehlerStart:            einLinePointer;
(ok:                     BOOLEAN;
(ErrZeil, ErrPos:        CARDINAL;
(ErrLine:                einLinePointer;
(FehlerAnzahl:           CARDINAL;
(LaufenderFehler:        CARDINAL;
(Backslash:              ARRAY [0..0] OF CHAR;
 
"(* Megamax-Modula: *)
"PROCEDURE SetCompilerInfo (Puff: einPufferPointer;
0VAR FehlerMeldung: ARRAY OF CHAR);
"VAR   mp, hp:                 einMerkPointer;
(ch:                     CHAR;
"BEGIN
%
%(* Einstellen der Fehlermeldung in Merkpunktliste Compilerinfo: *)
%(* Alte Compilerinfo-Liste lschen: *)
$
%WITH Puff^.MerkPunkte [CompilerInfo] DO
'zeilpos := Puff^.MerkPunkte [LaufendeZeile].zeilpos;
'merkline := Puff^.MerkPunkte [LaufendeZeile].merkline;
'charpos := Puff^.MerkPunkte [LaufendeZeile].charpos;
'PutLine (merkinfo, FehlerMeldung);
%END (* WITH *);
"END SetCompilerInfo;
"
"PROCEDURE SetPath;
"VAR   dummy:          eineInfo;
(Button:         INTEGER;
"BEGIN
$LoescheBild; (*WriteConst ('Pfad fr Dienstprogramme: ');*)
$dummy [0] := nul;
$GetDirectory (CompilerPfad, dummy, 'Pfad fr TDI-Programme', Button, FALSE);
$DeleteTail (CompilerPfad);
$IF CompilerPfad [0] = nul THEN
&CompilerPfad [0] := '\'; CompilerPfad [1] := nul;
$END;
"END SetPath;
 
 (*
"PROCEDURE DoRunProgram (Pfadname, Dateiname, Argument: ARRAY OF CHAR): INTEGER;
"(* korrigiert von Peter Hellinger *)
"
"VAR   (*Pfadname, Dateiname:    eineInfo;*)
(Programmname:           eineInfo;
(Button:                 INTEGER;
(laenge:                 ARRAY [0..0] OF CHAR;
(newDrive, oldDrive:     CARDINAL;
(map:                    LONGCARD;
(oldPfad:                eineInfo;
(Result:                 (*INTEGER*) LONGINT;
(key:                    einTasteneintrag;
(b:                      CHAR;
(ok:                     BOOLEAN;
"BEGIN
$GEMDOS.GetPath (oldPfad, 0);
$GEMDOS.GetDrv (oldDrive);
$IF Pfadname [0] = nul THEN
&Pfadname [0] := '\'; Pfadname [1] := nul;
$END (* IF *);
$GotoXY (0, 0);
$WriteLine (Pfadname);
$Assign (Pfadname, Programmname);
$DeleteTail (Programmname);
$Append (Dateiname, Programmname); (* Sehr richtig!! *)
$
$WriteConst ('--> '); WriteLine (Programmname);
$WriteConst (': '); WriteLine (Argument);
$
$laenge [0] := CHR (LENGTH (Argument));
$Insert (laenge, 0, Argument);
 
$(* Jetzt wirds interessant: *)
 
$IF (Programmname [0] >= 'A') & (Programmname [0] <= 'Z') THEN
&newDrive := ORD (Programmname [0]) - 65;
&IF (newDrive # oldDrive) THEN
(GEMDOS.SetDrv (newDrive, map);
&END (* IF *);
$END (* IF *);
$DeleteTail (Pfadname);
$IF GEMDOS.SetPath (Pfadname) THEN
'MausEin; (* Muss **hier** stehen! *)
 
'GEMDOS.Exec (GEMDOS.loadExecute, Programmname, Argument,
+Pfadname, Result);
 (*      WriteConst ('Programm-Resultat: ');
&WriteInt (output, Result, 5);
&LiesZeichen (b);
 *)
&TastInit;
&(*RestoreFont; (*-- Golem-Font wieder herstellen --*)*)
 
$ELSE (* Falscher Pfad! *)
&Nachricht ('Illegaler Zugriffspfad');
$END (* IF SetPath *);
$(* Altes Laufwerk und Pfad restaurieren *)
$GEMDOS.SetDrv (oldDrive, map);
$ok := GEMDOS.SetPath (oldPfad);
$(* Aechz - erstmal auf die Schnelle lokale Anpassung: *)
$RETURN VAL (INTEGER, Result);
"END DoRunProgram;
 *)
 
"PROCEDURE CommandLine (VAR FILENAME, FEHLERMELD: ARRAY OF CHAR): BOOLEAN;
"VAR   I, Z, s:        CARDINAL;
(CmdLine:        POINTER TO ARRAY [0..127] OF CHAR;
"BEGIN
$CmdLine:= ActiveProcess ();
$INC (CmdLine, 128);
$IF CmdLine^ [0] = nul THEN (* Ist eigentlich das Lngenbyte...*)
&(* Wenn Null, keine Commandline. *)
&RETURN FALSE
$ELSE
&(* Komandozeile wurde bergeben *)
&
&(* Trace ('CommandLine'); *)
&
&LoescheBild;
&(*
&GotoXY (2, 2);
&WriteConst ('CML: -->'); WriteLine (CmdLine^); WriteLn;
&*)
&Z := 0;
&s := ORD (CmdLine^ [0]);
&IF s >= 126 THEN s := 126; END;
&I := 1; CmdLine^ [s(*!TT:*)+1] := nul; (* Nullterminierung sicherstellen *)
&WHILE (I <= s) & (CmdLine^ [I] > ' ') & (CmdLine^ [I] # nul) DO
(FILENAME [Z] := CmdLine^ [I];
(INC (Z);
(INC (I);
&END (* WHILE *);
&FILENAME [Z] := nul;
 
&Z := 0;
&WHILE (I <= s) & (CmdLine^ [I] >= ' ') & (CmdLine^ [I] # nul) DO
(FEHLERMELD [Z] := CmdLine^ [I];
(INC (Z); INC (I);
&END (* WHILE *);
&FEHLERMELD [Z] := nul;
&
&RETURN TRUE
$END (* ELSE Kommandozeile vorhanden *);
"END CommandLine;
 
"PROCEDURE NextArgument (VAR n, arg: ARRAY OF CHAR): BOOLEAN;
"(* Kopiert aus n das erste Argument (bis zum Blank) in arg und lscht
%es in n. FALSE wenn n der leere String ist. *)
"VAR   quindex, zindex, laenge: CARDINAL;
(delimiter:              CHAR;
"BEGIN
$laenge := LENGTH (n); quindex := 0;
$IF laenge = 0 THEN RETURN FALSE; END;
$WHILE (n [quindex] = ' ') & (quindex < laenge) DO
&INC (quindex);
$END;
$FastStrings.Delete (n, 0, quindex); laenge := laenge (* + 1 *) - quindex;
$zindex := 0; quindex := 0;
$IF n [quindex] = '"' THEN
&delimiter := '"'; INC (quindex);
$ELSE delimiter := ' ';
$END;
$WHILE (n [quindex] # delimiter) & (quindex < laenge) DO
&arg [zindex] := n [quindex];
&INC (zindex); INC (quindex);
$END (* WHILE *);
$(* Skip '"'! *)
$IF (n [quindex] = '"') & (quindex < laenge) THEN INC (quindex); END;
$FastStrings.Delete (n, 0, quindex);
$arg [zindex] := nul;
$RETURN arg [0] # nul;
"END NextArgument;
"
"PROCEDURE SplitFileName (name: ARRAY OF CHAR;
;VAR path, file, suff: ARRAY OF CHAR);
"(* Kopiert den Pfad- und Dateinamensanteil aus name getrennt nach
%path und file *)
"VAR   i, index, laenge, pfadlaenge:   CARDINAL;
"VAR   dummy: ARRAY [0..7] OF CHAR;
"BEGIN
$FileNames.SplitPath (name, path, file);
$FileNames.SplitName (file, dummy, suff);
$(* Punkt nach Suff:
&Strings.Insert ('.',0,suff,BOOLEAN);
$*)
"END SplitFileName;
 
"PROCEDURE GetScrapPath (VAR ScrapPfad, ScrapName: ARRAY OF CHAR);
 (*
"CONST cClipVar =        'CLIPBRD';
"
"VAR     clipPath:       eineInfo;
*bootdev[0446H]: CARDINAL;
*bootfrom:       CARDINAL;
*stack:          ADDRESS;
*clipVar:        ARRAY [0..8] OF CHAR;
*ok:             BOOLEAN;
 *)
"VAR     dummySuff:      (*einSuffix*) ARRAY [0..3] OF CHAR;
"BEGIN
 (*
$AESMisc.ReadScrapDir (ScrapPfad);
$IF ScrapPfad [0] = nul THEN
&clipVar:= cClipVar;
&AESMisc.ShellEnvironment (clipVar, clipPath);
&IF clipPath [0] # nul THEN
((*Nachricht (clipPath);*)
(Assign (clipPath, ScrapPfad);
&ELSE
((*Nachricht ('warnix|');*)
(SysUtil1.SuperPeek (ADR (bootdev), bootfrom);
(Strings.Assign (':\CLIPBRD\SCRAP.TXT', ScrapPfad, ok);
(Strings.Insert (CHR (bootfrom + ORD ('A')), 0, ScrapPfad, ok);
&END (* IF clipPath *);
&AESMisc.WriteScrapDir (ScrapPfad);
$END (* IF ScrapPfad *);
 *)
$MakeScrapName ('TXT', ScrapPfad);
$SplitFileName (ScrapPfad, ScrapPfad, ScrapName, dummySuff);
$FastStrings.Assign (ScrapPfad, ClipBoard^.Pfad);
$FastStrings.Assign (ScrapName, ClipBoard^.Name);
"END GetScrapPath;
 
 (* ENDE EditCommand *)
 
 VAR     f: PathCtrl.PathEntry;
((*ok: BOOLEAN;*)
(result: INTEGER;
 
 BEGIN (* EditFile *)
 
 (* EditCommand *)
"BackPointer := NIL;
"
"InitBuffer;
 
 (* !JL 12. 12. 90 *)
"NEW (puffer);
"IF puffer = NIL THEN OutOfMemory END;
"expandBlankCompr := TRUE;
 
"NEW (ConfigPuffer);
"IF ConfigPuffer = NIL THEN OutOfMemory END;
"PuffInit (ConfigPuffer);
"IF ConfigPuffer = NIL THEN
$Nachricht ('Kann ConfigPuffer|nicht anlegen.109');
$RETURN;
"END;
"ConfigPuffer^.NaechsterPuffer := ConfigPuffer;
"ConfigInit := FALSE;
"InitConfig (ConfigPuffer);
"ConfigInit := TRUE;
"ConfigPuffer^.Name := DefaultConfigName;
"FileNames.ConcatPath (ShellPath, ConfigPuffer^.Name, ConfigPuffer^.Pfad);
"IF KonfigSpeichern IN ConfigPuffer^.Modus THEN
$LoadConfig (ConfigPuffer, FALSE, TRUE);
"END;
"
"NEW (HilfsPuffer);
"IF HilfsPuffer = NIL THEN OutOfMemory END;
"PuffInit (HilfsPuffer);
"IF HilfsPuffer = NIL THEN
$Nachricht ('Kann Hilfspuffer|nicht anlegen.110');
$RETURN;
"END;
"HilfsPuffer^.NaechsterPuffer := HilfsPuffer;
"EditPuffer := InsertPuffer (HilfsPuffer);
"Tausch := EditPuffer; MailPuffer := EditPuffer; GolemPuffer := EditPuffer;
"AlternEdit := EditPuffer;
"NEW (ClipBoard);
"IF ClipBoard = NIL THEN OutOfMemory END;
"PuffInit (ClipBoard);
"IF ClipBoard = NIL THEN
$Nachricht ('Kann ClipBoard|nicht anlegen.111');
$RETURN;
"END;
"ClipBoard^.NaechsterPuffer := ClipBoard;
"NEW (UndoPuffer);
"IF UndoPuffer = NIL THEN OutOfMemory END;
"PuffInit (UndoPuffer);
"IF UndoPuffer = NIL THEN
$Nachricht ('Kann UndoPuffer|nicht anlegen.112');
$RETURN;
"END;
"UndoPuffer^.NaechsterPuffer := UndoPuffer;
"
"NEW (FehlerPuffer);
"IF FehlerPuffer = NIL THEN OutOfMemory END;
"PuffInit (FehlerPuffer);
"IF UndoPuffer = NIL THEN
$Nachricht ('Kann FehlerPuffer|nicht anlegen.112');
$RETURN;
"END;
"FehlerPuffer^.NaechsterPuffer := FehlerPuffer;
"FastStrings.Assign (cErrName, ErrName);
"FehlerMeldung := '';
"GetPfad (CompilerPfad); DeleteTail (CompilerPfad);
"GetScrapPath (ScrapPfad, ScrapName);
"(* DoClipboard := FALSE; *) (* IN GMEBase!!! *)
 
 (* EditFile *)
 
"Trace ('EditFile');
"GetVersion (version); GlobalPfad [0] := nul; (*GetPfad (GlobalPfad);*)
"Lists.ResetList (ShellMsg.SrcPaths);
"f := Lists.NextEntry (ShellMsg.SrcPaths);
"
"IF f # NIL THEN
$FastStrings.Assign (f^, GlobalPfad);
$Paths.MakeFullName (GlobalPfad, FALSE, ok);
"END;
"
"Directory.MakeFullPath (GlobalPfad, result);
"IF result < 0 THEN
$GlobalPfad:= '';
$GetPfad (GlobalPfad);
"END;
"(*!TT 18.12.90 - steht oben schon einmal
$NEW (puffer);
"*)
"expandBlankCompr := TRUE;
 END GMEFile.
 
 
(* $FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$FFF0A82D$00008356T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$0000BC45$FFEB97DE$00001AD8$0000BB22$0000BC14$0000BBB3$0000BB6A$00001F53$0000BC76$0000BB9D$00000431$000082F2$00009C46$00008356$0000832C$00008356*)
