/* SET MAXIMUMS HERE!! ------------------------------ */
#define MAX_TOKENS 20000 /* max. number of tokens going through the system */
#define MAX_SERVERS 1000 /* max. number of servers for a facility */
#define MAX_FACILITIES 1000 /* max. number of facilities */
#define MAX_NUM_ATTR 5 /* max. number of attributes for an entity */
#define HEAP_SIZE 50000 /* max. heap size */
#define CALQSPACE 49153     /* calendar array size needed for maximum resize */
#define MAXNBUCKETS 32768     /* maximum number of buckets in calendar queue */
/* SET MAXIMUMS HERE!! ------------------------------ */


/* Set the type of system. Three are supported:
   (1) UNIX   -  UNIX System C (normal UNIX setting)
   (2) UNIXX  -  UNIX System C without Curses (used to generate
                 a smaller executable. You cannot access visual
                 trace facility with this option.
   (3) TURBOC -  Borland Turbo C (setting for IBM/PC and compatibles)

   NOTE: set one flag to the value '1' and the rest to '0'.
*/
#define UNIX    1
#define UNIXX   0
#define TURBOC  0

#define TRUE 1
#define FALSE 0
#define NIL 0 
#define FREE 0 
#define BUSY 1 
#define ON 1
#define OFF 0
#define FOUND 1
#define NOT_FOUND -1
#define TIME_KEY 0
#define AHEAD_PRIORITY_KEY 1
#define BEHIND_PRIORITY_KEY 2
#define INTERACTIVE 0
#define BATCH 1
#define LINKED 0
#define HEAP 1
#define CALENDAR 2
#define REMOVE_DUPLICATES 4


#include <stream.h> 
#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <strings.h>

#if UNIX
#include <curses.h>
#endif

class Token {
public:
 int id;
 float attr[MAX_NUM_ATTR];
 Token(void) { }
 Token(int ident) {id = ident;}
 ~Token(void) { }
 int getid(void) {return id;}
 void putid(int ident) {id = ident;}
};

class Item {
public:
  float time;
  int event;
  Token token;
  int priority;
};

class Node {
public:
 Item item;
 Node *next;
};

class LinkedList {
public:
 Node* front;
 int size;
 
 LinkedList(void) {front = NIL;}
 ~LinkedList(void) { }
 void insert(Item,int);
 void add_front(Item);
 void remove_front(Item&);
 void set_size(int new_size) {size = new_size;}
 int get_size(void) {return size;}
 int empty_list(void);
 friend void trace_update(void);
 friend void trace_visual(int);
};

class Facility : public LinkedList {
public:
  int id;
  int status;
  int total_servers;
  int busy_servers;
  float busy_time;
  float start_busy_time;
  int preemptions;
  int server_info[MAX_SERVERS][2];

  Facility(int,int);
  ~Facility(void) { }
  int get_status(void);
  int request(Token,int);
  int preempt(Token,int);
  void release(Token);
  void trace(void);
};

class Events : public LinkedList {
public:
  Events(void) { }
  ~Events(void) { }
  int cancel_event(int);
  int cancel_token(Token);
  void trace(void);
  void schedule(int,float,Token);
  void next_event(int&,Token&);
};

struct tokenstruct {
  int event;
  float time;
  float first_arg;
  float second_arg;
} token_list[MAX_TOKENS+1];

typedef struct calist *calptr;         /* type of a pointer to a calist node */
struct calist {          /* node type for a linked list of pointers to items */
  Item entry;               /* these are used in the calendar queue routines */
  calptr next;
};

extern int calfirstsub,
    nbuckets, calqsize, lastbucket, calresize_enable;   /* global variables- */
extern float caltop_threshold, calbot_threshold, lastprio;     /* for the calendar- */
extern double buckettop, calendar_width;                       /* queueing routines */


extern float current_time,time(),last_event_time;
extern float total_token_time;
extern int current_event,facilities,arrivals,completions;
extern int tokens_in_system,trace_flag,trace_type,heap_count;
extern int event_list_type,remove_duplicates,total_facilities;
extern char current_operation[50];
extern Facility* facility_list[MAX_FACILITIES];
extern Item heap[HEAP_SIZE],an_item,item1;
extern Events event_list;

extern double ranf(void),uniform(double,double),expntl(double);
extern double erlang(double,double),hyperx(double,double);
extern double triang(double,double,double),normal(double,double);
extern int random(int,int),trace_eventlist_size(void),stream(int);
extern long seed(long,int);
extern float time(void);

//
// Function Declarations
//
extern void init_simpack(int),update_arrivals(void),update_completions(void);
extern void trace_visual(int),trace_update(void);
extern void report_stats(void),heap_insert(Item),heap_remove(Item*);
extern void heap_delete(Token,Item*),heap_swap(Item*,Item*);
extern void print_heap(void);

extern void calendar_insert(Item*),calendar_remove(Item*);
extern void calendar_delete(int,Item*),calendar_localinit(int,int,double,double);
extern void calendar_init(void),calendar_resize(int);
extern void print_calendar(void);
extern double new_cal_width(void);
extern long seed(long,int);
