//---------------------------------------------
//               S I M P A C K + +
//            Simulation Tool Package
//        Copyright 1992, Paul A. Fishwick
//---------------------------------------------

#include <stream.h>
#include <math.h>

// Forced Vibration 
class vibration {
 private:
   float in[4],out[4],f[4],savevar[4],delta_time;
   int num_equations;
 public:
   vibration();
   void next_state();
   void integrate();
   void print_time();
 };

vibration v1;
float simtime;

main()
{
  simtime = 0.0;
  while (simtime < 60) {
   v1.next_state();
   v1.integrate(); 
   v1.print_time();
 }
} // end main 

vibration::vibration()
{
  out[1] = 1.0;
  out[2] = 1.0;
  out[3] = 1.0;
  num_equations = 3;
  delta_time = 0.05;
}

void vibration::next_state()
{ // parameters are chosen for demonstrating the formation
  //   of "wave packets". 
  float a=3.7,c=0.0,f=10.0,k=16.0,m=1.0; 
 // Calculate state:
 //   x1' = x2
 //   x2' = -c/m(x2)  - k/m(x1) + f/m(cos(ax3))
 //   x3' = 1.0
 
 in[1] = out[2];
 in[2] = -c*out[2]/m - k*out[1]/m + f*cos(a*out[3])/m;
 in[3] = 1.0;
}
 
void vibration::integrate()
{
  int i;

  for (i=1;i<=num_equations;i++) {
    f[i] = delta_time*in[i];
    savevar[i] = out[i];
    out[i] += f[i]/2;
  }
  simtime += delta_time/2;
  next_state();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i]/2;
  }
  next_state();

  for (i=1;i<=num_equations;i++) {
    f[i] += 2*delta_time*in[i];
    out[i] = savevar[i] + delta_time*in[i];
  }
  simtime += delta_time/2;
  next_state();

  for (i=1;i<=num_equations;i++) 
    out[i] = savevar[i] + (f[i] + delta_time*in[i])/6;
}

void vibration::print_time()
{
  cout<<simtime<<"  "<<out[1]<<"\n";
}

