//---------------------------------------------
//               S I M P A C K + +
//            Simulation Tool Package
//        Copyright 1992, Paul A. Fishwick
//--------------------------------------------- 

#include <stream.h>

class conte {
 private:
    float in[4], out[4], delta_time;
  public:
    conte();
    void next_state();
    void integrate();
    void print_time();
  };

float simtime;
conte con1;

main()
{
  simtime = 0.0;
  while (simtime < 5.0) {
   con1.next_state();
   con1.integrate(); 
   // output simtime,x   
   con1.print_time();
  } // end while  
} // end main  

conte::conte()
{
  out[1] = 1.0;
  out[2] = 1.0;
  out[3] = 1.0;
  delta_time = 0.01;
}

void conte::next_state()
{ 
// Calculate state: x''' + x' = 2  
 in[1] = out[2];
 in[2] = out[3];
 in[3] = 2 - out[2];
}
 
void conte::integrate()
{
 for(int i=1;i<=3;i++)
   out[i] += in[i]*delta_time;
 simtime += delta_time;
}

void conte::print_time()
{
 cout << simtime << "  " << out[1] << "\n"; 
} 

