/*---------------------------------------------
                 S I M P A C K
            Simulation Tool Package
        Copyright 1990, Paul A. Fishwick
---------------------------------------------*/

#include <stdlib.h>
#include <stream.h>
#include <string.h>
#include "pulse.h"

float adj[MAX_VERTICES][MAX_VERTICES];
float temp[MAX_VERTICES];
class vertex Vertex[MAX_VERTICES];
int end_time,num_vertices;

vertex::vertex()
{
	for( int i=0; i<MAX_STRING_LEN; i++)
		name[i] = '\0';
}


void vertex::name_vertex( char *node_name)

{
	strcpy(name, node_name);
}


void vertex::update_value(float new_value)
{
	value = new_value;
}


float vertex::get_value()
{
	return(value);
}


void vertex::update_pulse(float new_value)
{
	pulse = new_value;
}


float vertex::get_pulse()
{
	return(pulse);
}


Model::Model()
{
  int i,j;
  /* read in number of vertices, end time */
  cin >>num_vertices>>end_time;
  /* read in adjacency matrix */
  for ( i=0;i<num_vertices;i++) 
    for (j=0;j<num_vertices;j++)
       cin >> adj[i][j];
  /* read in vertex descriptors */
  char temp[MAX_STRING_LEN];
  for (i=0;i<num_vertices;i++) 
     {
      cin >>  temp;
      Vertex[i].name_vertex(temp);
     }

  /* read in values for each vertex */
  float temp_float;  for ( i=0;i<num_vertices;i++)
   {
      cin >> temp_float;
      Vertex[i].update_value(temp_float);
   }

  /* read in pulse for each vertex */
  for (i=0;i<num_vertices;i++)
    {
    	cin >> temp_float ;
    	Vertex[i].update_pulse(temp_float);
    }
} /* end Model */



void Model::simulate()
{
  int i,j;

  cout << "Pulse Process Results\n";
  cout << "------------------------\n\n";
  for (int time=0;time<end_time;time++) {
   /* output transient behavior */
   cout <<time << ": ";
   cout << " P ";
   
   for (j=0;j<num_vertices;j++)
    {
      cout << " " << (float) (Vertex[j].get_pulse());
    }

   cout << " V ";
   for (j=0;j<num_vertices;j++)
    cout <<  " " <<  Vertex[j].get_value();
   cout << "\n";
   /* for each vertex, determine new state value */
   for (j=0;j<num_vertices;j++) {
    temp[j] = 0.0;
    for (i=0;i<num_vertices;i++)
      temp[j] += adj[i][j]*(Vertex[i].get_pulse());
    Vertex[j].update_value(Vertex[j].get_value() + temp[j]);
   } /* end for */

   for (j=0;j<num_vertices;j++)
    Vertex[j].update_pulse(temp[j]);
  }
}/* end simulate */


main()
{
   class Model M;
   M.simulate();
} /* end main */

















