//---------------------------------------------
//               S I M P A C K++
//          Simulation Tool Package
//              Markov Simulator
//---------------------------------------------

#include <iostream.h>
#include "../queuing/queuing.h"

const MAX_STATES= 100;
const MAX_LINKS= MAX_STATES*MAX_STATES;
const MAX_STRING_LEN= 20;

extern "C" double uniform(float,float);

class Markov {
 public:

 Markov(){current_state = 0; current_time = 0.0;}
 void simulation_loop();
 void init();
 void display_link();
 void display_stat();


 private:
float adj[MAX_STATES][MAX_STATES];
char state[MAX_STATES][MAX_STRING_LEN];
int current_state,next_state,tr_index,row,col;
int count,num_states,state_freq[MAX_STATES],link_freq[MAX_LINKS],total;
float current_time ,end_time,branch_prob[MAX_STATES],state_time[MAX_STATES];
float total_state_time[MAX_STATES];
double prob;

 };


void Markov::simulation_loop()
{
 int i;

  for (i=0;i<num_states;i++) {
    state_freq[i] = 0;
    total_state_time[i] = 0.0;
   }
  for (i=0;i<MAX_LINKS;i++) link_freq[i] = 0;

 cout <<"Markov Simulator Output\n\n";

  while (current_time < end_time) {

   /* gather statistics */

   state_freq[current_state] += 1;

   /* initialize arrays */

   branch_prob[0] = adj[current_state][0];
   branch_prob[num_states-1] = 1.0;   
   for (i=1;i<num_states-1;i++)
     branch_prob[i] = branch_prob[i-1] + adj[current_state][i];

   /* decide which state to branch to */

   prob = uniform(0.0,1.0);
   count = 0;
   while (branch_prob[count] < (float) prob)
     count++;
   next_state = count;
   current_time += state_time[current_state];
   total_state_time[current_state] += state_time[current_state];
   tr_index = current_state*num_states+next_state;
   link_freq[tr_index] += 1;
   current_state = next_state;
  } /* end while */
 
}

void Markov::display_stat()
{
 int i;
  cout << "Markov Model Statistics\n\n";
  cout << "State Statistics\n";
  cout << "----------------\n";
  total = 0;
  for (i=0;i<num_states;i++)
      total += state_freq[i];
  cout << "State   " << "Name                ";
  cout << "  Freq  " << "Freq %%   " << "  Time  " << " Time %%\n";
  for (i=0;i<num_states;i++) {
     cout << form("%-3d     ",i);
     cout << form("%-20s",state[i]);
     cout << form("%6d  ",state_freq[i]);
     cout << form("%5.1f%%   ",(float) state_freq[i] * 100.0/ (float) total);
     cout << form("%6.1f  ",total_state_time[i]);
     cout << form(" %5.1f%%\n",(float) total_state_time[i]* 100.0/
                         (float) current_time);
  } /* end for */


}

void Markov::display_link()
{
   int i;

  cout << "\n\n";
  cout << "Link Statistics\n";
  cout << "----------------\n";
  total = 0;
  for (i=0;i<MAX_LINKS;i++)
    total += link_freq[i];
  cout << "Link     " << "Id      " << "  Freq  " << "Freq %%\n";
  for (i=0;i<MAX_LINKS;i++) {
    if(link_freq[i] > 0) {
      cout << form("%-3d     ",i);
      row = i/num_states;
      col = i%num_states;
      cout << form("%2d -> %2d ",row,col); 
      cout << form("%6d  ",link_freq[i]);
      cout << form("%5.1f%%\n",(float) link_freq[i] * 100.0/ (float) total);
    } /* end if */
  } /* end for */
} /* end main() */


void Markov::init()
{
  int i,j;
  /* read in number of states and end time */
  cin >> num_states >> end_time;
  /* read in the length of time for each state */
  for (i=0;i<num_states;i++)
   cin >> state_time[i];
  /* read in adjacency matrix */
  for (i=0;i<num_states;i++) 
    for (j=0;j<num_states;j++) 
      cin >> adj[i][j];
 
  /* read in state descriptors */
  for (i=0;i<num_states;i++) 
      cin >> state[i];
} /* end init() */



main()
{
  Markov markov;
  markov.init();
  markov.simulation_loop();
  markov.display_stat();
  markov.display_link();
}

