      subroutine dcffti (n,wsave)
c
c     Double precision version.  -tk
c
C***BEGIN PROLOGUE  CFFTI
C***REVISION DATE  811015   (YYMMDD)
C***CATEGORY NO.  D6
C***KEYWORDS FFT,FAST FOURIER TRANSFORM,FOURIER TRANSFORM,COMPLEX
C***DATE WRITTEN  FEBRUARY 1978
C***AUTHOR  SWARZTRAUBER P.N. (NCAR)
C***PURPOSE
C   INITIALIZE FOR CFFTF AND CFFTB
C***DESCRIPTION
C     *****************************************************************
C
C     SUBROUTINE CFFTI(N,WSAVE)
C
C     *****************************************************************
C
C     SUBROUTINE CFFTI INITIALIZES THE ARRAY WSAVE WHICH IS USED IN
C     BOTH CFFTF AND CFFTB. THE PRIME FACTORIZATION OF N TOGETHER WITH
C     A TABULATION OF THE TRIGONOMETRIC FUNCTIONS ARE COMPUTED AND
C     STORED IN WSAVE.
C
C     INPUT PARAMETER
C
C     N       THE LENGTH OF THE SEQUENCE TO BE TRANSFORMED
C
C     OUTPUT PARAMETER
C
C     WSAVE   A WORK ARRAY WHICH MUST BE DIMENSIONED AT LEAST 4*N+15
C             THE SAME WORK ARRAY CAN BE USED FOR BOTH CFFTF AND CFFTB
C             AS LONG AS N REMAINS UNCHANGED. DIFFERENT WSAVE ARRAYS
C             ARE REQUIRED FOR DIFFERENT VALUES OF N. THE CONTENTS OF
C             WSAVE MUST NOT BE CHANGED BETWEEN CALLS OF CFFTF OR CFFTB
C
C***REFERENCES
C***ROUTINES CALLED  CFFTI1
C***END PROLOGUE  CFFTI
      implicit double precision (a-h,o-z)
      dimension       wsave(1)
C***FIRST EXECUTABLE STATEMENT  CFFTI
      if (n .eq. 1) return
      iw1 = n+n+1
      iw2 = iw1+n+n
      call dcffti1 (n,wsave(iw1),wsave(iw2))
      return
      end
