/*
 *	Type specific routines for IntVec
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)ivecx.cc	2.2	9/18/89
 */

#define NO_VECTOR_MATHFUN
#include "rw/IntVec.h"
#include "rw/FloatVec.h"
#include "rw/DoubleVec.h"

static const char SCCSid[] = "@(#)ivecx.cc	2.2 9/18/89";

// Convert to a DoubleVec
// Should be a friend DoubleVec, but...
IntVec::operator DoubleVec()
{
  register int n = length();
  DoubleVec temp(n);
  register double* dp = temp.data();
  register int* tp = data();
  register int ts = stride();
  while(n--) {
    *dp++ = double(*tp); tp += ts;
  }
  return temp;
}

// Convert to a FloatVec
// Should be a friend of FloatVec, but...
IntVec::operator FloatVec()
{
  register int n = length();
  FloatVec temp(n);
  register float* dp = temp.data();
  register int* tp = data();
  register int ts = stride();
  while(n--) {
    *dp++ = float(*tp); tp += ts;
  }
  return temp;
}

IntVec
trunc(const DoubleVec& v)
{
  register int n = v.length();
  IntVec temp(n);
  register double* dp = v.data();
  register int* ip = temp.data();
  register int vs = v.stride();
  while(n--) {
    *ip++ = int(*dp); dp += vs;
  }
  return temp;
}
