/*
 *	Test of vector routines for type <T>
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)xvectest.cc	2.2	9/26/89
 */

/* 
Note that in what follows, explicit type conversions have been used.
For example,

    c(1) = <T>(-1.0);
    c[2] = <T>(-2.0);

This is for the benefit of type complex.  It is not necessary to do
this when using the GNU compiler and its class Complex (as declared in
Complex.h).  However, it is necessary when using the AT&T class
complex, as declared in complex.h.  I have not tried the GNU Complex.h
file with the AT&T compiler.  
*/

#include "rw/<T>Vec.h"
#include <stream.h>

#define TYPE <T>_TYPE
#include "vecdefs.h"

extern Cdecl void exit(int);

main()
{
  {
    cout << "\n**** Constructors / destructors ****\n";

    //  <T>Vec();
    <T>Vec a;
    cout << NL << "a:\n" << a <<NL;
    
    // <T>Vec(unsigned n);
    <T>Vec* b = new <T>Vec(10);
    cout << NL << "<T>Vec* b = new <T>Vec(10):\n"<< *b <<NL;
    
    // ~<T>Vec();
    delete b;
    
    // <T>Vec(unsigned n, <T> val, <T> by);
    <T>Vec c(15, <T>(5.0), <T>(1.0));
    cout << NL << "<T>Vec c(15, <T>(5.0), <T>(1.0)):\n" << c <<NL;

    // <T>Vec(const <T>Vec& a);
    <T>Vec d = c;
    cout << NL << "<T>Vec d = c:\n"<<d <<NL;

    //void <T>Vec::deepenShallowCopy()
    d.deepenShallowCopy();

    // <T>&		operator()(int i); // No bounds checking
    // <T>&		operator[](int i); // With bounds checking
    c(1) = <T>(-1.0);
    c[2] = <T>(-2.0);
    cout << NL << "c modified:\n" << c <<NL;
    
    cout << NL << "d.deepenShallowCopy():\n" << d <<NL;
    
    // <T>Vec		slice(int start, unsigned lgt, int strider=1);
    // <T>Vec(const <T>Vec& a);
    <T>Vec e = d.slice(0,5,1);
    cout << NL << "<T>Vec e = d.slice(0,5,1):\n" << e <<NL;
    
    // <T>Vec(register unsigned n, const <T>* dat);
    <T> some_data[8];
    for(int i = 0; i<8; i++) some_data[i] = <T>(i);
    <T>Vec f(some_data, 8);
    cout << NL <<"<T>Vec f(8, some_data):\n" << f <<NL;
    
    // unsigned		length()	{return npts;}
    cout << NL << "f.length(): " << f.length() << NL;

    // void <T>Vec::resize(unsigned)
    a.resize(8);
    cout << NL << "a.resize(8):\n" << a <<NL;

    // Assignment:
    // <T>Vec		operator=(const <T>Vec&);
    a = f;
    cout << NL << "a = f:\n" << a <<NL;
    
    // <T>Vec		operator=(const <T>Vec&);
    a.slice(1,3,2) = f.slice(0,3,2);
    cout << NL << "a.slice(1,3,2) = f.slice(0,3,2):\n" << a <<NL;
    
    // <T>Vec		operator=(<T>);
    a = <T>(1);
    cout << NL << "a = <T>(1):\n" << a <<NL;
    
    f.slice(0,3,2) = <T>(0);
    cout << NL << "f.slice(0,3,2) = <T>(0):\n" << f <<NL;
    
    //friend	<T>Vec	operator-(const <T>Vec&);
    cout << NL << "-f\n" << -f <<NL;
    
#if HAS_INCRDECR
    //friend	<T>Vec	operator++(<T>Vec&);
    //friend	<T>Vec	operator--(<T>Vec&);
    cout << NL << "f++\n" << f++ <<NL;
    cout << NL << "f--\n" << f-- <<NL;
#endif
  }    

  // Begin operator section:
  {
    cout <<"\n**** Operators ****\n";
#if TYPE==DComplex_TYPE
    <T>Vec a(10, DComplex(1,-1));
    <T>Vec b(10, DComplex(2,-2));
#else
    <T>Vec a(10, <T>(1));
    <T>Vec b(10, <T>(2));
#endif
    cout << NL << "a:\n"<<a<<NL;
    cout << NL << "b:\n"<<b<<NL;
//friend	<T>Vec	operator*(const <T>Vec&,const <T>Vec&);
    cout << NL << "a*b:\n" << a * b <<NL;

#if HAS_DIVIDE
//friend	<T>Vec	operator/(const <T>Vec&,const <T>Vec&);
    cout << NL << "a/b:\n" << a / b <<NL;
#endif

//friend	<T>Vec	operator+(const <T>Vec&,const <T>Vec&);
    cout << NL << "a+b:\n" << a + b <<NL;

//friend	<T>Vec	operator-(const <T>Vec&,const <T>Vec&);
    cout << NL << "a-b:\n" << a - b <<NL;

//friend	<T>Vec	operator*(const <T>Vec&,<T>);
//friend	<T>Vec	operator*(<T> s,const <T>Vec& V)
    cout << NL << "4 * a * 4:\n" << <T>(4) * a * <T>(4) <<NL;

#if HAS_DIVIDE
//friend	<T>Vec	operator/(const <T>Vec&,<T>);
    cout << NL << "a / 4:\n" << a / <T>(4) <<NL;

//friend	<T>Vec	operator/(<T>,const <T>Vec&);
    cout << NL << "4 / a:\n" << <T>(4) / a <<NL;
#endif

//friend	<T>Vec	operator+(const <T>Vec&,<T>);
//friend	<T>Vec	operator+(<T> s,const <T>Vec& V);
    cout << NL << "4 + a + 4:\n" << <T>(4) + a + <T>(4) <<NL;

//friend	<T>Vec	operator-(const <T>Vec&,<T>);
    cout << NL << "a - 4:\n" << a - <T>(4) <<NL;
//friend	<T>Vec	operator-(<T>,const <T>Vec&);
    cout << NL << "4 - a:\n" << <T>(4) - a <<NL;

//friend	void		operator+=(<T>Vec&,const <T>Vec&);
    a += b;
    cout << NL << "a += b:\n" << a <<NL;

//friend	void		operator+=(<T>Vec&,<T>);
    a += <T>(4);
    cout << NL << "a += 4:\n" << a <<NL;
//friend	void		operator-=(<T>Vec&,const <T>Vec&);
    a -= b;
    cout << NL << "a -= b:\n" << a <<NL;

//friend	void		operator-=(<T>Vec&, <T>);
    a -= <T>(4);
    cout << NL << "a -= 4:\n" << a <<NL;

//friend	void		operator*=(<T>Vec&,const <T>Vec&);
    a *= b;
    cout << NL << "a *= b:\n" << a <<NL;

//friend	void		operator*=(<T>Vec&,<T>);
    a *= <T>(2);
    cout << NL << "a *= 2:\n" << a <<NL;

#if HAS_DIVIDE
//friend	void		operator/=(<T>Vec&,const <T>Vec&);
    a /= b;
    cout << NL << "a /= b:\n" << a <<NL;
    
//friend	void		operator/=(<T>Vec&,<T>);
    a /= <T>(2);
    cout << NL << "a /= 2:\n" << a <<NL;
#endif
  }

  // math functions
  {
    cout << "\n**** Math functions ****\n";
#if TYPE==Int_TYPE
#define VALUE  1
#else
#define VALUE .5    
#endif

#if TYPE==DComplex_TYPE
    <T>Vec a(10, DComplex(-VALUE, 0));
    <T>Vec b(10, DComplex(2.0, 2.0));
    <T>Vec d(10, 0, DComplex(1,-1));
#else
    <T>Vec a(10, -VALUE);
    <T>Vec b(10, <T>(2));
    <T>Vec d(10, <T>(0), <T>(1));
#endif

    <T>Vec c = a;
    c.deepenShallowCopy();
    c.slice(1,5,2) = <T>(VALUE);	// Should result in -.5, .5, -.5, etc.

    cout << NL << "a:\n" << a <<NL;
    cout << NL << "b:\n" << b <<NL;
    cout << NL << "c:\n" << c <<NL;
    cout << NL << "d:\n" << d <<NL;

//friend	<T>Vec	abs(const <T>Vec& V);
    cout << NL << "abs(a):\n" << abs(a) <<NL;

#if HAS_APPLY && TYPE!=DComplex_TYPE
//friend	<T>Vec	acos(const <T>Vec& V)	{ return V.apply(acos); }
    cout << NL << "acos(a):\n" << acos(a) <<NL;

//friend	<T>Vec	asin(const <T>Vec& V)	{ return V.apply(asin); }
    cout << NL << "asin(a):\n" << asin(a) <<NL;

//friend	<T>Vec	atan(const <T>Vec& V)	{ return V.apply(atan); }
    cout << NL << "atan(a):\n" << atan(a) <<NL;

//friend	<T>Vec	atan2(const <T>Vec&,const <T>Vec&);
    cout << NL << "atan2(a,c):\n" << atan2(a,c) <<NL;

//friend	<T>Vec	ceil(const <T>Vec& V)	{ return V.apply(ceil); }
    cout << NL << "ceil(c):\n" << ceil(c) <<NL;
#endif

#if HAS_APPLY
//friend	<T>Vec	cos(const <T>Vec& V)	{ return V.apply(cos); }
    cout << NL << "cos(a):\n" << cos(a) <<NL;

//friend	<T>Vec	cosh(const <T>Vec& V)	{ return V.apply(cosh); }
    cout << NL << "cosh(a):\n" << cosh(a) <<NL;
#endif

//friend	<T>Vec	cumsum(const <T>Vec&);
    cout << NL << "cumsum(a):\n" << cumsum(a) <<NL;

//friend	<T>Vec	delta(const <T>Vec&);
    cout << NL << "delta(c):\n" << delta(c) << NL;
    
//friend	<T>		dot(const <T>Vec&,const <T>Vec&);
    cout << NL << "dot(a,c):\n" << dot(a,c) << NL;

#if HAS_APPLY
//friend	<T>Vec	floor(const <T>Vec& V)	{ return V.apply(floor); }
    cout << NL << "floor(c):\n" << floor(c) <<NL;
#endif

#if HAS_MINMAX
//friend	int		max(const <T>Vec&);
    cout << NL << "max(d):\n" << max(d) << NL;

//friend	int		min(const <T>Vec&);
    cout << NL << "min(d):\n" << min(d) << NL;
#endif

#if HAS_MEAN
//friend	<T>		mean(const <T>Vec&);
    cout << NL << "mean(c):\n" << mean(c) << NL;
#endif

//friend	<T>		prod(const <T>Vec&);
    cout << NL << "prod(b):\n" << prod(b) << NL;

//friend	<T>Vec	reverse(const <T>Vec&);
    cout << NL << "reverse(d):\n" << reverse(d) <<NL;

//friend	<T>		sum(const <T>Vec&);
    cout << NL << "sum(c):\n" << sum(c) <<NL;

#if HAS_VARIANCE
//friend		double		variance(const <T>Vec&);
    cout << NL << "variance(c):\n" << variance(c) <<NL;
#endif
    
  }
  exit(0);
}
