/*
 *	
 *	Written by
 *
 *	Bruce Eckel
 *	School of Oceanography; WB-10
 *	University of Washington
 *	Seattle, WA 98195
 *
 *	@(#)timer.cc	2.2	9/18/89
 */

#include "rw/Timer.h"

static const char SCCSid[] = "@(#)timer.cc	2.2 9/18/89";

int	strlen(const char*);
char*	strcpy(char*, const char*);

extern int getrusage(int, struct rusage*);

void
Timer::timer_(float *seconds)
{
  struct rusage use;
  double usertime, systime;

  getrusage(RUSAGE_SELF, &use);

  usertime = (double)use.ru_utime.tv_sec +
    ((double)use.ru_utime.tv_usec)/1.0e6;

  systime = (double)use.ru_stime.tv_sec +
    ((double)use.ru_stime.tv_usec)/1.0e6;

  *seconds = (float)(usertime + systime);

  return;
}


 Timer::Timer()
{
    current = head = new MarkPoint;
    head->next = 0;
}


/* 
-*++ Timer::~Timer(): 
** 
** (*++ history: 
** 	27 Apr 88	Bruce Eckel	Creation date
** ++*)
** 
** (*++ detailed: 
** ++*)
*/

Timer::~Timer()
{
    MarkPoint * ptr = head;
    MarkPoint * killptr;
    while (ptr) {
	killptr = ptr;
	if (ptr->next) 
	    ptr = ptr->next;
	else ptr = 0;
	delete killptr->msg;
	delete killptr;
    }
}
    

/* 
-*++ Timer::mark(): mark timing information at this point in the program
** 
** (*++ history: 
** 	27 Apr 88	Bruce Eckel	Creation date
** ++*)
** 
** (*++ detailed: 
** ++*)
*/

void Timer::mark()
{
    timer_(&(current->seconds));
    current->msg = new char[ strlen("Marker ") + 1 ];
    strcpy(current->msg,"Marker ");
    current->next = new MarkPoint;
    current = current->next;
    current->next = (MarkPoint *)0; /* denote end of list */
    current->seconds = 0;
}


/* 
-*++ Timer::mark(): place a marker with a message
** 
** (*++ history: 
** 	27 Apr 88	Bruce Eckel	Creation date
** ++*)
** 
** (*++ detailed: 
** ++*)
*/

void Timer::mark(char * message)
{
    timer_(&(current->seconds));
    current->msg = new char[ strlen(message) + 1 ];
    strcpy(current->msg,message);
    current->next = new MarkPoint;
    current = current->next;
    current->next = (MarkPoint *)0; /* denote end of list */
    current->seconds = 0;
}

/* 
-*++ operator<<(): how to output timing information via streams
** 
** (*++ history: 
** 	27 Apr 88	Bruce Eckel	Creation date
** ++*)
** 
** (*++ detailed: 
** ++*)
*/

ostream& operator<<(ostream & s, Timer & t)
{
    int i = 1;
    MarkPoint * ptr = t.head;
    while (ptr->next) {
	s << "Marker " << i << ": " << ptr->msg << ": time = ";
	s << ptr-> seconds << "\n";
	if (ptr->next) ptr = ptr->next;
	else break;
	i++;
    } 
    return s;
}

