c   imsl routine name   - vbla=idamax                                   vbib0010
c
c-----------------------------------------------------------------------
c
c   computer            - vax/double
c
c   latest revision     - january 1, 1978
c
c   purpose             - find the smallest index of the maximum
c                           magnitude of a double precision vector
c
c   usage               - function idamax (n,dx,incx)
c
c   arguments    idamax - the smallest index i such that dabs(x(i))
c                           is the maximum of dabs(x(j)) for j=1 to n.
c                           (output)
c                           x(i) refers to a specific element of dx.
c                           see incx argument description.
c                n      - length of vector x. (input)
c                dx     - double precision vector of length n*incx.
c                           (input)
c                incx   - displacement between elements of dx. (input)
c                           x(i) is defined to be dx(1+(i-1)*incx).
c                           incx must be greater than zero.
c
c   precision/hardware  - double/all
c
c   reqd. imsl routines - none required
c
c   notation            - information on special notation and
c                           conventions is available in the manual
c                           introduction or through imsl routine uhelp
c
c   copyright           - 1978 by imsl, inc. all rights reserved.
c
c   warranty            - imsl warrants only that imsl testing has been
c                           applied to this code. no other warranty,
c                           expressed or implied, is applicable.
c
c-----------------------------------------------------------------------
c
      integer function idamax (n,dx,incx)
c
c                                  specifications for arguments
      double precision   dx(1)
      integer            n,incx
c                                  specifications for local variables
      double precision   dmax,xmag
      integer            i,ii,ns
c                                  first executable statement
      idamax = 0
      if (n.le.0) return
      idamax = 1
      if (n.le.1) return
      if (incx.eq.1) go to 15
c                                  code for increments not equal to 1.
      dmax = dabs(dx(1))
      ns = n*incx
      ii = 1
      do 10 i=1,ns,incx
         xmag = dabs(dx(i))
         if (xmag.le.dmax) go to 5
         idamax = ii
         dmax = xmag
    5    ii = ii+1
   10 continue
      return
c                                  code for increments equal to 1.
   15 dmax = dabs(dx(1))
      do 20 i=2,n
         xmag = dabs(dx(i))
         if (xmag.le.dmax) go to 20
         idamax = i
         dmax = xmag
   20 continue
      return
      end
