#ifndef MATHPACK_H
#define MATHPACK_H
#pragma once

/*
 *	Declarations for Fortran math routines.
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)mathpack.h	2.2	9/18/89
 */

/* Splines under tension: */
extern Fdecl void curv1_(float* x,	// An array of N increasing abscissae to be interpolated.
		    float* y,	/* An array of N ordinates of the values X. */
		    int* n,	/* The number of points in X,Y. */
		    float* spl1,/* The desired value for the 1'st derivative at X(1).*/
		    float* spln,/* The desired value for the 1'st derivative at X(N).*/
		    float* temp,/* A working array of length at least N. */
		    float* sigma,/* The normalized spline tension. */
		    float* yp	/* The returned spline coefficients. */
		    );
extern Fdecl float curv2_(float* t,	/* X Value to be evaluated */
		     float* x,	/* From above */
		     float* y,	/* From above */
		     float* yp,	/* Spline coefficients evaluated by curv1 */
		     int* n,	/* Number of points in x, y, yp */
		     float* sigma,/* Spline tension. */
		     int* it	/* switch */
		     );

extern Fdecl void dcurv1_(double* x,	// An array of N increasing abscissae to be interpolated.
		    double* y,	/* An array of N ordinates of the values X. */
		    int* n,	/* The number of points in X,Y. */
		    double* spl1,/* The desired value for the 1'st derivative at X(1).*/
		    double* spln,/* The desired value for the 1'st derivative at X(N).*/
		    double* temp,/* A working array of length at least N. */
		    double* sigma,/* The normalized spline tension. */
		    double* yp	/* The returned spline coefficients. */
		    );
extern Fdecl double dcurv2_(double* t,/* X Value to be evaluated */
		     double* x,	/* From above */
		     double* y,	/* From above */
		     double* yp,/* Spline coefficients evaluated by curv1 */
		     int* n,	/* Number of points in x, y, yp */
		     double* sigma,/* Spline tension. */
		     int* it	/* switch */
		     );

/* Double the resolution of a matrix: */
extern Fdecl void double_(float*, int*, int*, int*, int*);

/* Increase the resolution of a curve: */
extern Fdecl void carc_(float*, float*, int*, float*, float*, float*, int*);

/***********************************************************/
/* Declarations for the NCAR FFT routines */

class		DComplex;
class		FComplex;

/* Double precision versions: */
extern Fdecl void dcfftb_(int*, DComplex*, double*);	/* Back transform */
extern Fdecl void dcfftf_(int*, DComplex*, double*);	/* Forward transform */
extern Fdecl void dcffti_(int*, double*);		/* Initialize weights */

/* Single precision versions: */
extern Fdecl void cfftb_(int*, FComplex*, float*);	/* Back transform */
extern Fdecl void cfftf_(int*, FComplex*, float*);	/* Forward transform */
extern Fdecl void cffti_(int*, float*);		/* Initialize weights */

/* define's so that the naming is consistent with other DAIMS software
 * (single precision complex should start with "FC", double with
 * "DC" ) */
#define DCfftb_		dcfftb_
#define DCfftf_		dcfftf_
#define DCffti_		dcffti_

#define FCfftb_		cfftb_
#define FCfftf_		cfftf_
#define FCffti_		cffti_

#endif MATHPACK_H
