#ifndef COMPLEXH
#define COMPLEXH

/* complex.h --- Declarations for type complex, for use with the AT&T
   "cfront" compiler.  Modified from the original code distributed with
   the compiler.

   Modified by 

	Tom Keffer
	School of Oceanography, WB-10
	Univ. of Washington
	Seattle, WA 98195
	(206) 543-6455

	Internet: keffer@sperm.ocean.washington.edu
	uucp:     uw-beaver!sperm.ocean.washington.edu!keffer
	BITNET:   keffer%sperm.ocean.washington.edu@UWAVM
	Telemail: T.KEFFER/OMNET	 

Changes from standard AT&T release:
	1) Addition of an unadorned constructor.
	2) Removal of the default value for the real argument of
	the existing constructor.
	3) Most inline functions changed to inline within
	declaration.
*/

#include <stream.h>
#include <errno.h>

overload cos;
overload cosh;
overload exp;
overload log;
overload pow;
overload sin;
overload sinh;
overload sqrt;
overload abs;

#include <math.h>
inline double abs(double d) { return fabs(d); }

class complex {
	double	re, im;
public:
	/* These constructors changed around by tk */
	complex()			{re=0; im=0;}
	complex(double r)		{re=r; im=0; }
	complex(double r, double i)	{re=r; im=i; }
	 	
	friend	double	real(const complex& a) {return a.re;}
	friend	double	imag(const complex& a) {return a.im;}

	friend	double	abs(complex);
	friend  double  norm(complex);
	friend  double	arg(complex);
	friend  complex conj(complex a){
	  return complex(a.re, -a.im);
	}
	friend  complex cos(complex);
	friend  complex cosh(complex);
	friend	complex exp(complex);
	friend  complex log(complex);
	friend  complex pow(double, complex);
	friend	complex pow(complex, int);
	friend	complex pow(complex, double);
	friend	complex pow(complex, complex);
	friend  complex	polar(double, double = 0);
	friend  complex sin(complex);
	friend  complex sinh(complex);
	friend	complex sqrt(complex);

	friend	complex	operator+(complex a1, complex a2)
	  { return complex(a1.re+a2.re, a1.im+a2.im); }
	friend	complex	operator-(complex a)
	  { return complex(-a.re, -a.im); }
	friend	complex operator-(complex a1, complex a2)
	  { return complex(a1.re-a2.re, a1.im-a2.im); }
	friend	complex operator*(complex, complex);
	friend 	complex operator/(complex, complex);
	friend 	int	operator==(complex a, complex b)
	  { return (a.re==b.re && a.im==b.im); }
	friend 	int	operator!=(complex a, complex b)
	  { return (a.re!=b.re || a.im!=b.im); }
	
        void operator+=(complex);
	void operator-=(complex);
	void operator*=(complex);
	void operator/=(complex);

};

ostream& operator<<(ostream&, complex);
istream& operator>>(istream&, complex&);

extern int errno;

inline void complex::operator+=(complex a)
{
	re += a.re;
	im += a.im;
}

inline void complex::operator-=(complex a)
{
	re -= a.re;
	im -= a.im;
}

static const complex complex_zero(0,0);

class c_exception
{
	int	type;
	char	*name;
	complex	arg1;
	complex	arg2;
	complex	retval;
public:

	c_exception( char *n, complex a1, complex a2 = complex_zero )
		{ name = n; arg1 = a1; arg2 = a2; type = 0; retval = 0; }

	friend int complex_error( c_exception& );

	friend complex exp( complex );
	friend complex sinh( complex );
	friend complex cosh( complex );
	friend complex log( complex );	
};


#endif
