#ifndef FLUDECOMP_H
#define FLUDECOMP_H
#pragma once 

/*
 *	Declarations for float precision LU Decomposition
 *
 *	Copyright (C) 1988, 1989.
 *
 *	Dr. Thomas Keffer
 *	Rogue Wave Associates
 *	P.O. Box 85341
 *	Seattle WA 98145-1341
 *
 *	Permission to use, copy, modify, and distribute this
 *	software and its documentation for any purpose and
 *	without fee is hereby granted, provided that the
 *	above copyright notice appear in all copies and that
 *	both that copyright notice and this permission notice
 *	appear in supporting documentation.
 *	
 *	This software is provided "as is" without any
 *	expressed or implied warranty.
 *
 *
 *	@(#)FLUDecomp.h	2.2	9/18/89
 */

#include "FGEMatrix.h"

class FLUDecomp : FGEMatrix {
  fortran_int*		ipvt;	// Pivot indices
  fortran_int		info;
  fortran_int		the_order;

  FGEMatrix		copy()	{return FGEMatrix::copy();}
  float*		data()	{return FGEMatrix::data();}
protected:
  void			assertDefined();
  void			assertPivots();
  void			assertOrder(const FloatVec& rhs);
public:
  FLUDecomp(const FGEMatrix&);
  ~FLUDecomp()	{delete ipvt;}

  unsigned			order() {return (unsigned)the_order;}

  // Matrix algebra declarations:
  friend float			determinant(const FLUDecomp&);
  friend FGEMatrix		inverse(const FLUDecomp&);
  friend FloatVec		solve(const FLUDecomp&, const FloatVec&);
};

#endif FLUDECOMP_H
