/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  _slist.c
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#include <LEDA/slist.h>

//------------------------------------------------------------------------------
// Members of class SLIST
//------------------------------------------------------------------------------

SLIST::SLIST()      
{ h=0; 
  t=0;
  count=0;
  iterator=0; 
}

SLIST::SLIST(GenPtr a) 
{ h=t=new slink(a,0);
  count=1; 
  iterator=0;  
}

SLIST::SLIST(const SLIST& x)
{ slink* p = x.h;
  h=0; 
  t=0; 
  count=0; 
  iterator=0;
  while (p) { append(p->e);     //copy new list
              p = p->succ;}
}

void SLIST::pop()    
{ if (iterator!=0) error_handler(1,"pop: deletion while iterator is active");
  if (h) 
  { if (t==h) t = 0;
    slink* x=h; 
    h=x->succ; 
    clear_el(x->e);
    delete x;
    count--;
   }
}

slink* SLIST::push(GenPtr a)   
{ if (iterator!=0) error_handler(2,"push: insertion while iterator is active");
  copy_el(a);
  count++;
  h = new slink(a,h); 
  if (t==0) t = h;
  return h;
}

slink* SLIST::append(GenPtr a)
{ if (iterator!=0) error_handler(2,"append: insertion while iterator is active");
  copy_el(a);
  count++;
  slink* p = new slink(a,0); 
  if (t) t->succ = p; 
  else   h = p;
  return t=p;
} 

slink* SLIST::append(SLIST& l)
{ if (iterator!=0) error_handler(2,"append: insertion while iterator is active");
  slink* p = l.h;
  while(p) { append(p->e);
             p = p->succ;  }
  return h;
} 

slink* SLIST::cyclic_succ(slink* loc) const
{ if (loc==0) return 0;
  return loc->succ? loc->succ : h;
}

SLIST& SLIST::operator=(const SLIST& x)
{ slink* p = x.h;
  iterator=0;
  while (h) pop();              //destroy old list
  while (p) { append(p->e);     //copy new list
              p = p->succ;}
  return *this;
}

SLIST SLIST::operator+(SLIST x)  // concatenation
{ append(x);
  return this;
}

void SLIST::clear()
{ while (h) pop(); 
  iterator=0;
}
