/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  stack.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/



#ifndef STACKH
#define STACKH

#include <LEDA/basic.h>
#include <LEDA/slist.h>

//------------------------------------------------------------------------------
// stacks                                                                
//------------------------------------------------------------------------------

#define stack(type) name2(type,stack)

#define stackdeclare(type)\
struct stack(type) : SLIST\
{\
  type name2(type,X);\
\
  void copy_el(GenPtr& x)  const { x=Copy(ACCESS(type,x)); }\
  void clear_el(GenPtr& x) const { Clear(ACCESS(type,x)); }\
\
  stack(type)() {}\
  stack(type)(const stack(type)& S) : SLIST((SLIST&) S) {}\
 ~stack(type)() { clear(); }\
\
  void push(type x)  { SLIST::push(Convert(x)); }\
  type top()   const { return ACCESS(type,SLIST::head());}\
  type pop()         { type x=top(); SLIST::pop(); return x; }\
  int  size()  const { return SLIST::length(); }\
  int  empty() const { return SLIST::empty(); }\
  void clear()       { SLIST::clear(); }\
\
  stack(type)& operator=(const stack(type)& S)\
  { return (stack(type)&)SLIST::operator=((SLIST&) S); }\
};

#endif
