/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  line.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef LINEH
#define LINEH

#include <LEDA/point.h>
#include <LEDA/segment.h>

//------------------------------------------------------------------------------
// straight lines
//------------------------------------------------------------------------------

struct line_rep {

  segment  seg; 
  int   count;
   
  line_rep(segment s);
  line_rep();
   
  LEDA_MEMORY(line_rep)
   
};
   

class line   : public LEDA_SIMPLE 
{


/* line_rep* ptr(); */

line_rep* ptr() const { return (line_rep*)PTR; }

public:

line();
line(const line&);
line(segment);
line(point, point);
line(point, double);
void clear();

~line()                { clear(); }



bool intersection(line l, point& inter);
bool intersection(segment s, point& inter);

bool vertical()        { return ptr()->seg.vertical();  }
bool horizontal()      { return ptr()->seg.horizontal();}

double distance()        { return ptr()->seg.distance();  }
double distance(point p) { return ptr()->seg.distance(p); }
double angle(line l)     { return ptr()->seg.angle(l.ptr()->seg); }
double angle()           { return ptr()->seg.angle();     }
double direction()       { return angle();}
double slope()           { return ptr()->seg.slope();     }

segment perpendicular(point q);

line    translate(double alpha, double d) { return ptr()->seg.translate(alpha,d); }
line    translate(const vector& v)        { return ptr()->seg.translate(v); }

line    rotate(point o, double alpha){ return ptr()->seg.rotate(o,alpha); }
line    rotate(double alpha)         { return rotate(point(0,0),alpha);}

double y_proj(double x)  { return ptr()->seg.y_proj(x); };
double x_proj(double y)  { return ptr()->seg.x_proj(y); };
double y_abs()           { return ptr()->seg.y_proj(0); }

bool contains(point);
bool contains(segment);

line& operator=(const line& l);

line operator+(const vector& v) { return translate(v); }

int operator==(const line& l) { return contains(l.ptr()->seg); }
int operator!=(const line& l) { return !contains(l.ptr()->seg); };

friend ostream& operator<<(ostream& out, const line& l);
friend istream& operator>>(istream& in, line& l);  


friend void Print(const line& l, ostream& out = cout) { out << l; } 
friend void Read(line& l,  istream& in = cin)   { in >> l; }

friend void   Clear(line& l)       { l.clear(); }
friend GenPtr Copy(line& l)  { l.ptr()->count++; return l.PTR; }
friend line& Access(const line&, const GenPtr& p) { return *(line*)&p; }

};

declare(list,line)


//------------------------------------------------------------------------------
// LINE(cmp): lines with user defined linear order cmp
//------------------------------------------------------------------------------

#define LINE(cmp) name2(line_,cmp)

#define LINEdeclare(cmp)\
struct LINE(cmp) : public line \
{  LINE(cmp)(line  p )           : line(p)   {}\
   LINE(cmp)(LINE(cmp)& p)       : line(p)   {}\
   LINE(cmp)() {}\
 ~ LINE(cmp)() {}\
};\
\
int compare(LINE(cmp)& x, LINE(cmp)& y) { return cmp(x,y); }

#endif
