/************************* MPEG-2 NBC Audio Decoder **************************
 *                                                                           *
"This software module was originally developed by 
AT&T, Dolby Laboratories, Fraunhofer Gesellschaft IIS in the course of 
development of the MPEG-2 NBC/MPEG-4 Audio standard ISO/IEC 13818-7, 
14496-1,2 and 3. This software module is an implementation of a part of one or more 
MPEG-2 NBC/MPEG-4 Audio tools as specified by the MPEG-2 NBC/MPEG-4 
Audio standard. ISO/IEC  gives users of the MPEG-2 NBC/MPEG-4 Audio 
standards free license to this software module or modifications thereof for use in 
hardware or software products claiming conformance to the MPEG-2 NBC/MPEG-4
Audio  standards. Those intending to use this software module in hardware or 
software products are advised that this use may infringe existing patents. 
The original developer of this software module and his/her company, the subsequent 
editors and their companies, and ISO/IEC have no liability for use of this software 
module or modifications thereof in an implementation. Copyright is not released for 
non MPEG-2 NBC/MPEG-4 Audio conforming products.The original developer
retains full right to use the code for his/her  own purpose, assign or donate the 
code to a third party and to inhibit third party from using the code for non 
MPEG-2 NBC/MPEG-4 Audio conforming products. This copyright notice must
be included in all copies or derivative works." 
Copyright(c)1996.
 *                                                                           *
 ****************************************************************************/

#include <stdlib.h>
#include "all.h"
#include "util.h"
#include "common.h"
#define DEBUG 0

#ifndef MAXINT
#undef MAXINT
#define MAXINT	32767.
#endif
enum _util_const {
  MAX_SR=16,
  MAX_BR=18
};

static long srindex2sr[MAX_SR] = { 96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000 };
static long brindex2br[MAX_BR] = { 8000L, 16000L, 24000L, 32000L, 40000L, 48000L, 56000L, 64000L, 80000L,\
                                 96000L, 112000L,  128000L, 160000L, 192000L, 256000L, 320000L };
long getSamplRate(int srIndex)
{
  return srindex2sr[srIndex];
}

int getSamplIdx(long samplRate)
{
  int x;
  for (x=0;x<MAX_SR;x++){
    if (samplRate == srindex2sr[x]) 
      return x;
  }
  CommonExit(-1,"\n no index for this Sampling Rate");  
  return 1 ;

}

long getBitRate(int brIndex)
{
  return brindex2br[brIndex];
}
int getBitrateIdx(long bitRate)
{
  int x;
  for (x=0;x<MAX_BR;x++){
    if (bitRate == brindex2br[x]) 
      return x;
  }
  CommonExit(-1,"\n no index for this bit Rate");
  return 1 ;
}

Float *NewFloat (int N) {
/* Allocate array of N Floats */

    Float *temp;

#if DEBUG
    printf ("Allocating a double array of %d data points\n", N);
#endif

    temp = (Float *) malloc (N * sizeof (Float));
    if (!temp) {
		printf ("\nERROR util.c 154: Could not allocate memory for array\nExiting program...\n");
		exit (1);
		}
    return temp;
}

typedef Float *pFloat;

Float **NewFloatMatrix (int N, int M) {
/* Allocate NxM matrix of Floats */

    Float **temp;
    int i;

#if DEBUG
    printf("Allocating %d x %d matrix of Floats\n", N, M);
#endif

/* allocate N pointers to Float arrays */
    temp = (pFloat *) malloc (N * sizeof (pFloat));
    if (!temp) {
		printf ("\nERROR: util.c 252: Could not allocate memory for array\nExiting program...\n");
		exit (1);
		}

/* Allocate a Float array M long for each of the N array pointers */

    for (i = 0; i < N; i++) {
		temp [i] = (Float *) malloc (M * sizeof (Float));
		if (! temp [i]) {
			printf ("\nERROR: Could not allocate memory for array\nExiting program...\n");
			exit (1);
			}
		}
    return temp;
}

void
specFilter (
	    double p_in[],
	    double p_out[],
	    int  samp_rate,
	    float lowpass_freq,
	    int    slope,
	    int    specLen
	    )
{  
  float lowpass;
  int    xlowpass,i;

   /* calculate the last line which is not zero */
   lowpass = (double)lowpass_freq * (double)specLen;
   lowpass /= (samp_rate>>1);
   lowpass += 1.0;             /* round up to ensure that the desired upper frequency limit is correct */
   xlowpass = ((int)lowpass < specLen) ? (int)lowpass : specLen ;

   if( p_out != p_in ) { 
      for (i = 0; i < specLen; i++ ) {
	p_out[i] = p_in[i];
      } 
   } 
   for (i = xlowpass; i <specLen ; i++ ) {
      p_out[i]  = 0;
   } 

   if( slope != 0 ) 
     CommonWarning("\nunsupported slope type in specFilter\n" );

}
