/*


This software module was originally developed by

Peter Kroon (Bell Laboratories, Lucent Technologies)

and edited by

Naoya Tanaka (Matsushita Communication Industrial Co., Ltd.)

in the course of development of the MPEG-2 NBC/MPEG-4 Audio standard
ISO/IEC 13818-7, 14496-1,2 and 3. This software module is an
implementation of a part of one or more MPEG-2 NBC/MPEG-4 Audio tools
as specified by the MPEG-2 NBC/MPEG-4 Audio standard. ISO/IEC gives
users of the MPEG-2 NBC/MPEG-4 Audio standards free license to this
software module or modifications thereof for use in hardware or
software products claiming conformance to the MPEG-2 NBC/ MPEG-4 Audio
standards. Those intending to use this software module in hardware or
software products are advised that this use may infringe existing
patents. The original developer of this software module and his/her
company, the subsequent editors and their companies, and ISO/IEC have
no liability for use of this software module or modifications thereof
in an implementation. Copyright is not released for non MPEG-2
NBC/MPEG-4 Audio conforming products. The original developer retains
full right to use the code for his/her own purpose, assign or donate
the code to a third party and to inhibit third party from using the
code for non MPEG-2 NBC/MPEG-4 Audio conforming products. This
copyright notice must be included in all copies or derivative works.

Copyright (c) 1996.


 * Last modified: May 1, 1996
 *
 */
/*
 * pitchpf - pitch postfilter  P(z) = g ( 1 + b z ^-M)
 *  parameters are derived from pitch predictor coefficients acb_delay
 *  and acb_gain
 *
 *  g = 1 ( 1 + b )
 *  b = GAMMA * beta
 *
 *  if acb_gain < GTH or acb_delay < 10 no pitch postfilter is applied
 *
 *  Revised 11/07/96 by N.Tanaka (Panasinic)
 *          - pitch gain is recalculated
 */
#include "att_proto.h"

/*#define GTH 0.4			/* threshold before pf is applied */
/*#define GAMMA 0.4		/* design parameter defines amount of pf*/
/*#define MTH 10			/* threshold on delay before pf is applied */
#define GTH .4			/* threshold before pf is applied */
#define GAMMA .40		/* design parameter defines amount of pf*/
#define MTH 10			/* threshold on delay before pf is applied */

void  pitchpf(
 float *output,			/* output: filtered signal */
 float *input,			/* input : unfiltered signal */
 long len,			/* input : size of input/output frame */
 long  acb_delay,		/* input : acb delay */
 float acb_gain,		/* input : acb gain  */
 float *pitchmem,		/* in/out: signal buffer  */
 long pitchmemsize		/* input : size of pitch buffer */
)
{
  float b;			/* postfilter gainfactor */
  float g;			/* postfilter scale factor */
  long i,k;

  float cr;
  float po;
  float p_gain;

 /* caluculation of pitch gain */
  for (i=0; i < pitchmemsize-len; i++)
    pitchmem[i] = pitchmem[i+len];
  for (k=0; i < pitchmemsize; i++,k++)
    pitchmem[i] = input[k];

  cr = 0.;
  po = 0.;
  for (i=0; i < len; i++,k++) {
    cr += pitchmem[pitchmemsize-len+i] *
		        pitchmem[pitchmemsize-len+i-acb_delay];
    po += pitchmem[pitchmemsize-len+i-acb_delay] *
                pitchmem[pitchmemsize-len+i-acb_delay];
  }
  if(po>1.) p_gain = cr/po;
  else      p_gain = 0.;

/* need some periodicity before we do postfiltering */
/*
  if ( acb_gain > GTH && acb_delay > MTH ) {
    b = GAMMA * acb_gain;	/* compute pf coefficient */

  if ((p_gain>GTH) && (acb_delay>MTH)) {
    b = GAMMA * p_gain;	/* compute pf coefficient */
    if (b > GAMMA) b = GAMMA;
    g = 1. / ( 1. + b);		/* compute scale factor */
/*
    for (i=0; i < pitchmemsize-len; i++)
      pitchmem[i] = pitchmem[i+len];
    for (k=0; i < pitchmemsize; i++,k++)
      pitchmem[i] = input[k];
*/
    for (i=0; i < len; i++,k++)
      output[i] = g * ( pitchmem[pitchmemsize-len+i] +
		       b* pitchmem[pitchmemsize-len+i-acb_delay]);
  }
}
