/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	slider.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_slider class header
 *
 *	RCSid = "$Id: slider.H,v 4.12.1.1 1993/06/01 22:56:51 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_slider_H
#define OI_slider_H

#ifndef OI_ctlr_1d_H
#include <OI/ctlr_1d.H>
#endif /* OI_ctlr_1d_H */

	// class forward reference declarations
	class OI_mdl_slider;
	class OI_entry_field;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

 /* ctl_bits private bits */
#define		OI_SLIDER_BOF_PAINTED		0x1	/* 1 => bof area painted */
#define		OI_SLIDER_TOP_ACT_PAINTED	0x2	/* 1 => top active area painted */
#define		OI_SLIDER_HDL_PAINTED		0x4	/* 1 => handle painted */
#define		OI_SLIDER_BOT_ACT_PAINTED	0x8	/* 1 => bottom active area painted */
#define		OI_SLIDER_EOF_PAINTED		0x10	/* 1 => eof area painted */
#define		OI_SLIDER_BOF_ACTIVE		0x20	/* 1 => bof button is down */
#define		OI_SLIDER_EOF_ACTIVE		0x40	/* 1 => eof button is down */
#define		OI_SLIDER_HDL_ACTIVE		0x80	/* 1 => handle is active */
#define		OI_SLIDER_BVL_PAINTED		0x100	/* 1 => 3D bevel has been painted */
#define		OI_SLIDER_DOWN_PAINTED		0x200	/* 1 => 3D down pixel has been painted */
#define		OI_SLIDER_BEG_SPACE_ACTIVE	0x400	/* 1 => btn down in space before handle */
#define		OI_SLIDER_END_SPACE_ACTIVE	0x800	/* 1 => btn down in space after handle */

#define		OI_SLIDER_LRTB_DIRECTION	1	/* handle moves left->right */
#define		OI_SLIDER_RLBT_DIRECTION	-1	/* handle moves right->left */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		


 /* upward compatible definitions for OI_ctlr_1d inheritance */

#define		OI_slider_ends			OI_ctlr_1d_ends
#define		OI_slider_ends_none		OI_ctlr_1d_ends_none
#define		OI_slider_ends_numeric		OI_ctlr_1d_ends_numeric
#define		OI_slider_ends_strings		OI_ctlr_1d_ends_strings
#define		OI_SLIDER_ENDS_NONE		OI_slider_ends_none
#define		OI_SLIDER_ENDS_NUMERIC		OI_slider_ends_numeric
#define		OI_SLIDER_ENDS_STRINGS		OI_slider_ends_strings

#define		OI_slider_current		OI_ctlr_1d_current
#define		OI_slider_current_none		OI_ctlr_1d_current_none
#define		OI_slider_current_ro		OI_ctlr_1d_current_ro
#define		OI_slider_current_rw		OI_ctlr_1d_current_rw
#define		OI_SLIDER_CURRENT_NONE		OI_slider_current_none
#define		OI_SLIDER_CURRENT_RO		OI_slider_current_ro
#define		OI_SLIDER_CURRENT_RW		OI_slider_current_rw

#define		OI_slider_ticks			OI_ctlr_1d_ticks
#define		OI_slider_ticks_none		OI_ctlr_1d_ticks_none
#define		OI_slider_ticks_ends		OI_ctlr_1d_ticks_ends
#define		OI_slider_ticks_ends_custom	OI_ctlr_1d_ticks_ends_custom
#define		OI_slider_ticks_all		OI_ctlr_1d_ticks_all
#define		OI_slider_ticks_all_custom	OI_ctlr_1d_ticks_all_custom
#define		OI_SLIDER_TICKS_NONE		OI_slider_ticks_none
#define		OI_SLIDER_TICKS_ENDS		OI_slider_ticks_ends
#define		OI_SLIDER_TICKS_ENDS_CUSTOM	OI_slider_ticks_ends_custom
#define		OI_SLIDER_TICKS_ALL		OI_slider_ticks_all
#define		OI_SLIDER_TICKS_ALL_CUSTOM	OI_slider_ticks_all_custom

#define		OI_SLIDER_KEY_UNIT		OI_CTLR_1D_KEY_UNIT
#define		OI_SLIDER_KEY_VIEW		OI_CTLR_1D_KEY_VIEW
#define		OI_SLIDER_KEY_EXTREME		OI_CTLR_1D_KEY_EXTREME
#define		OI_SLIDER_KEY_POSITION		OI_CTLR_1D_KEY_POSITION
#define		OI_SLIDER_KEY_UNIT_LEFT		OI_CTLR_1D_KEY_LEFT
#define		OI_SLIDER_KEY_UNIT_RIGHT	OI_CTLR_1D_KEY_RIGHT
#define		OI_SLIDER_KEY_UNIT_UP		OI_CTLR_1D_KEY_UP
#define		OI_SLIDER_KEY_UNIT_DOWN		OI_CTLR_1D_KEY_DOWN
//#define	OI_SLIDER_KEY_VIEW_LEFT		OI_CTLR_1D_KEY_LEFT
//#define	OI_SLIDER_KEY_VIEW_RIGHT	OI_CTLR_1D_KEY_RIGHT
//#define	OI_SLIDER_KEY_VIEW_UP		OI_CTLR_1D_KEY_UP
//#define	OI_SLIDER_KEY_VIEW_DOWN		OI_CTLR_1D_KEY_DOWN
#define		OI_SLIDER_KEY_MAX_LEFT		OI_CTLR_1D_KEY_LEFT
#define		OI_SLIDER_KEY_MAX_RIGHT		OI_CTLR_1D_KEY_RIGHT
#define		OI_SLIDER_KEY_MAX_UP		OI_CTLR_1D_KEY_UP
#define		OI_SLIDER_KEY_MAX_DOWN		OI_CTLR_1D_KEY_DOWN

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

	class OI_slider : public OI_ctlr_1d {
			OI_mdl_slider	*mdl_dep ;				/* ptr to model dependent aspects of OI_box object */
	 public:
		static	OI_class	*clsp ;					/* ptr to class record */

	 private:
			void		construct(OI_number, OI_orient, long, long) ;
			void		new_orientation(OI_orient) ;
	 protected:
					OI_slider(OI_class*, const char*, OI_number, OI_orient, long mx=0, long mn=1,
						OI_ctlr_1d_fnp fp=NULL, OI_callback *op=NULL, OI_ctlr_1d_memfnp mfp=NULL,
						void *ap=OI_DEF_ARG,
						const char *lp=NULL, OI_slider_ends et=OI_SLIDER_ENDS_NONE, const char *bl=NULL,
						const char *el=NULL, OI_slider_current cv=OI_SLIDER_CURRENT_NONE, OI_number nt=0,
						OI_slider_ticks tt=OI_SLIDER_TICKS_NONE, const char* const * tkl=NULL) ;
			OI_stat		create() ;
			int		in_beg_end_button(int x, int y) ;	/* check if in beginning of object button */
			int		in_beg_end_space(int x, int y) ;	/* check if in space between beg of obj btn & handle */
			OI_bool		in_handle(int x, int y) ;		/* check if anywhere in handle */
			void		paint_hdl() ;
			void		paint_tick(int,int,int,int)	{}	/* paint a tick mark */
			OI_bool		mov_hdl(long p) ;
		virtual	void		new_model(OI_model_type) ;
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

					OI_slider(const char*,OI_number,OI_orient, long=0, long=1,
						OI_ctlr_1d_fnp=NULL,OI_callback* =NULL,OI_ctlr_1d_memfnp=NULL,void* =OI_DEF_ARG,
						const char* =NULL, OI_slider_ends=OI_SLIDER_ENDS_NONE, const char* =NULL,
						const char* =NULL, OI_slider_current=OI_SLIDER_CURRENT_NONE, OI_number=0,
						OI_slider_ticks=OI_SLIDER_TICKS_NONE, const char* const * =NULL);
					~OI_slider();
			OI_number	bar_overhead() ;
		friend	void		dmpOI_slider(OI_slider*) ;				/* diagnostic dump procedure */
			OI_entry_field	*entry_field() ;
		virtual	void		focus_in(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
		virtual	void		focus_out(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
			void		font_resize() ;
		static	OI_bool		init(OI_connection*) ;
			OI_bool		is_write_resq(XrmQuark);
		static	OI_slider	*make_minimal(const char*,OI_minimal_type) ;
		virtual	void		min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
			void		new_active_pixel(PIXEL);
		virtual	OI_stat		new_size(OI_number,OI_number);
			void		new_inactive_pixel(PIXEL);
		virtual void		new_bvl_width(OI_number);
		virtual	void		new_tick_position(OI_position);
		virtual	void		nominal_outside_size(OI_number*,OI_number*);
			void		other_key(OI_d_tech *, const XEvent *, const char* const *, unsigned int *);
											/* Process key other than up,down,left,right. */
		virtual	void		paint(const XEvent*, void* =NULL);
		virtual	void		paint_current() ;
			void		paint_label() ;					/* paint label */
		virtual	void		re_layout() ;
			void		res_active_pixel(void *);
			void		res_inactive_pixel(void *);
 			void		res_bar_size(void *);
 			void		res_pixel_range(void *);
			void		res_orientation(void *);
		virtual	void		set_marker_orientation(OI_marker*);	/* Set orientation of the marker */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
			void		set_inactive_pixel(PIXEL);
			void		set_active_pixel(PIXEL);

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void		clone_adjust(OI_d_tech*) ;
		virtual	OI_number	num_props() ;
		virtual	OI_d_tech	*numbered_child(OI_number n) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			PIXEL		active_pixel() ;
			OI_number	bar_size() ;
			PIXEL		inactive_pixel() ;
			OI_number	major_space() ;
			OI_number	minimum_bar_size() ;
			OI_number	minimum_size_x() ;
			OI_number	minimum_size_y() ;
			OI_number	minor_space() ;
			OI_orient	orientation() ;
			OI_number	pixel_range() ;
			OI_stat		set_active_color(const char *clr);
			void		set_active_color(PIXEL);
			OI_stat		set_bar_size(OI_number s) ;
			OI_stat		set_inactive_color(const char *);
			void		set_inactive_color(PIXEL);
			OI_stat		set_major_size(OI_number) ;				/* set major axis size */
			OI_stat		set_pixel_range(OI_number) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED TRANSLATIONS FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under the
		//		translations available for this object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void		increment_down(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		increment_left(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		increment_right(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		increment_up(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		moved(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		release(OI_d_tech * =NULL, const XEvent * =NULL, const char* const * = NULL, unsigned int * =NULL) ;
			void		select(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
			void		top_or_bottom(OI_d_tech *, const XEvent *, const char* const *, unsigned int *) ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_slider	*oi_create_slider_cb(const char *name,OI_number len,OI_orient or, long mx, long mn,
					OI_ctlr_1d_fnp fp,OI_callback *objp,OI_ctlr_1d_memfnp mfp,void *argp,
					const char *label, OI_slider_ends end_typ, const char *min, const char *max, 
					OI_slider_current cur_typ, int ticks, OI_slider_ticks tick_typ, const char* const *labels);

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
		OI_slider	*oi_create_slider(const char *name,OI_number len,OI_orient or,long mx= -1,long mn=0,
					OI_ctlr_1d_fnp fp=NULL,void *argp=OI_DEF_ARG,
					const char *label=NULL, OI_slider_ends end_typ=OI_SLIDER_ENDS_NONE,
					const char *min=NULL, const char *max=NULL, 
					OI_slider_current cur_typ=OI_SLIDER_CURRENT_NONE, int ticks=0,
					OI_slider_ticks tick_typ=OI_SLIDER_TICKS_NONE, const char* const *labels=NULL) ;
		OI_slider	*oi_create_slider(const char *name,OI_number len,OI_orient or, long mx, long mn,
					OI_callback *objp,OI_ctlr_1d_memfnp mfp, void *argp=OI_DEF_ARG,
					const char *label=NULL, OI_slider_ends end_typ=OI_SLIDER_ENDS_NONE,
					const char *min=NULL, const char *max=NULL, 
					OI_slider_current cur_typ=OI_SLIDER_CURRENT_NONE, int ticks=0,
					OI_slider_ticks tick_typ=OI_SLIDER_TICKS_NONE, const char* const *labels=NULL) ;

#endif /* OI_slider_H */
