/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	dlgbox.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_dialog_box class header
 *
 *	RCSid = "$Id: dlgbox.H,v 4.11.1.1 1993/06/01 22:54:01 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_dlgbox_H
#define OI_dlgbox_H

#ifndef OI_box_H
#include <OI/box.H>
#endif /* OI_box_H */

#ifndef OI_mnucel_H
#include <OI/mnucel.H>
#endif /* OI_mnucel_H */

	// class forward reference declarations
	class OI_mdl_dialog_box;
	class OI_button_menu;
	class OI_menu;
	class OI_menu_cell;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Definitions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

		enum OI_dialog_box_type	{
			OI_dialog_box_unknown		= 0,
			OI_DIALOG_BOX_UNKNOWN		= OI_dialog_box_unknown,
			OI_dialog_box_ol_command	= 1,
			OI_DIALOG_BOX_OL_COMMAND	= OI_dialog_box_ol_command,
			OI_dialog_box_ol_help		= 2,
			OI_DIALOG_BOX_OL_HELP		= OI_dialog_box_ol_help,
			OI_dialog_box_ol_notice		= 3,
			OI_DIALOG_BOX_OL_NOTICE		= OI_dialog_box_ol_notice,
			OI_dialog_box_ol_other		= 4,
			OI_DIALOG_BOX_OL_OTHER		= OI_dialog_box_ol_other
		} ;

#define		OI_DIALOG_BOX_BTN_VERT_SP	2	/* # pixels to leave above and below button menu */
#define		OI_DIALOG_BOX_BTN_HORZ_SP	2	/* # pixels to leave to right and left of menus */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED DEFINITIONS, ENUMS, TYPEDEFS, ETC
		//		definitions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		

#ifdef TYPEDEF_MEMFN
	typedef	int	(OI_wait_fn)(OI_menu_cell *cellp, void *argp, OI_number btn) ;
	typedef	int	(OI_callback::OI_wait_memfn)(OI_menu_cell *cellp, void *argp, OI_number btn) ;
#endif /* TYPEDEF_MEMFN */
	typedef	int	(*OI_wait_fnp)(OI_menu_cell *cellp, void *argp, OI_number btn) ;
	typedef	int	(OI_callback::*OI_wait_memfnp)(OI_menu_cell *cellp, void *argp, OI_number btn) ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	END OF DOCUMENTED SECTION
		//
		//-------------------------------------------------------------------------------------------------		

 /* ctl_bits private bits */
#define		OI_DIALOG_BOX_PUSHPIN		0x1	/* 1 => title bar has pushpin */
#define		OI_DIALOG_BOX_WM_PUSHPIN	0x2	/* 1 => window manager title bar has pushpin */
#define		OI_DIALOG_BOX_PINNED		0x4	/* 1 => pushpin is in */
#define		OI_DIALOG_BOX_WAIT_BUTTON	0x8	/* 1 => in wait_button() or modeless popup */
#define		OI_DIALOG_BOX_BVL_PAINTED	0x10L	/* bevel has been painted */
#define		OI_DIALOG_BOX_AUTO_NOCLIP	0x20L	/* object is unclipped because toolkit unclipped it due to title/longterm/pushpin, not user */
#define		OI_DIALOG_BOX_SHOULD_BE_PINNED	0x40L	/* pushpin should be in when mapped */
#define		OI_DIALOG_BOX_LAST_FOCUS_DESTROYED	0x80L	/* Set if last_focus object was destroyed */
#define		OI_DIALOG_BOX_MODELESS		0x100L	/* dialog box is modeless, use popup() instead of wait_button() */
#define		OI_DIALOG_BOX_DEF_LOC		0x200L	/* 1 => should be at def_loc after taken down */
#define		OI_DIALOG_BOX_UNPIN_CB_MADE	0x400L	/* 1 => we've alread done the unpin callback */

	class OI_dialog_box : public OI_box {
			OI_mdl_dialog_box	*mdl_dep ;				/* ptr to model dep aspects of OI_dialog_box obj */
			unsigned long		ctl_bits ;				/* object specific control bits */
			OI_dialog_box_type	subtyp ;				/* type of dialog box */
			char			*ttlp ;					/* ptr to title string */
			char			*lngp ;					/* ptr to long term message string */
	 protected:
		static	XrmQuark		q_cbTermAction ;			/* quark for dialogbox verify callback */
		static	XrmQuark		q_cbPin ;				/* quark for dialogbox pin callback */
		static	XrmQuark		q_cbUnpin ;				/* quark for dialogbox unpin callback */
			OI_bool			process ;				/* process flag for wait_done() */
			OI_menu_cell		*btnp ;					/* ptr to button which was activated to terminate the dialog box */
			OI_number		btn ;					/* button # used to terminate the dialog box */
			OI_bool			wait_flg ;				/* wait_button flag when activated by cell as pop_up */
			OI_state		org_st ;				/* original state before being pinned up */
	 public:
		static	OI_class		*clsp ;					/* ptr to class record */
	 private:
			void			clear_auto_noclip()		{ ctl_bits &= ~OI_DIALOG_BOX_AUTO_NOCLIP; }
			void			clear_db_def_loc()		{ ctl_bits &= ~OI_DIALOG_BOX_DEF_LOC; }
			void			clear_in_wait_button()		{ ctl_bits &= ~OI_DIALOG_BOX_WAIT_BUTTON; }
			void			construct(OI_number, OI_menu_cell**) ;
			OI_bool			is_auto_noclip()		{ return(((ctl_bits&OI_DIALOG_BOX_AUTO_NOCLIP) != 0) ? OI_yes : OI_no); }
			OI_bool			is_db_def_loc()			{ return(((ctl_bits&OI_DIALOG_BOX_DEF_LOC) != 0) ? OI_yes : OI_no); }
			OI_bool			last_focus_destroyed()		{ return((ctl_bits&OI_DIALOG_BOX_LAST_FOCUS_DESTROYED)?OI_yes:OI_no); }
			void			object_destroyed_cb(OI_d_tech*,void*)	{ ctl_bits |= OI_DIALOG_BOX_LAST_FOCUS_DESTROYED; }
			void			res_is_pinned(void *);
			void			res_wait_flag(void *);
			void			res_is_pushpin(void *);
			void			res_modeless(void *);
			void			res_title(void *);
			void			res_longterm(void *);
			void			set_auto_noclip()		{ ctl_bits |= OI_DIALOG_BOX_AUTO_NOCLIP; }
			void			set_in_wait_button()		{ ctl_bits |= OI_DIALOG_BOX_WAIT_BUTTON; }
			void			set_wait_flag( OI_bool );
	 protected:
						OI_dialog_box(OI_class*, const char*, OI_number, OI_number, OI_number= -1,
							OI_menu_cell** =NULL) ;
						OI_dialog_box(OI_class*, const char*, OI_number, OI_number, OI_number, OI_cell_spec*) ;
		virtual	void			new_model(OI_model_type) ;
			OI_menu_cell		*wait_button_cb(OI_bool r, OI_wait_fnp fp, OI_callback *objp, OI_wait_memfnp mfp,
							void *argp) ;

		friend	void			dmpOI_dialog_box(OI_dialog_box*) ;	/* diagnostic dump procedure */
	 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		

						OI_dialog_box (const char*,OI_number,OI_number,OI_number=-1,OI_menu_cell** =NULL) ;
						OI_dialog_box (const char*,OI_number,OI_number,OI_number,OI_cell_spec*) ;
						~OI_dialog_box() ;
		virtual	void			abs_resume_layout(OI_bool=OI_yes) ;
//			void			*action_arg() ;
//			OI_wait_fn		*action_fn() ;
//			OI_wait_memfn		*action_memfn()	;
//			OI_callback		*action_obj() ;
			void			allow_should_be_pinned()	{ ctl_bits |= OI_DIALOG_BOX_SHOULD_BE_PINNED; }
			void			allow_unpin_cb_made()		{ ctl_bits |= OI_DIALOG_BOX_UNPIN_CB_MADE; }
			OI_menu_cell		*button_used()			{ return(btnp); }
												/* ptr to button pushed on last wait_button() call */
			void			clear_pinned();
			void			clear_pushpin_ok()		{ ctl_bits &= ~OI_DIALOG_BOX_PUSHPIN; }
		virtual	void			clone_adjust(OI_d_tech*) ;
			OI_stat			create() ;
			long			def_loc_x() ;
			long			def_loc_y() ;
			void			disallow_should_be_pinned()	{ ctl_bits &= ~OI_DIALOG_BOX_SHOULD_BE_PINNED; }
			void			disallow_unpin_cb_made()	{ ctl_bits &= ~OI_DIALOG_BOX_UNPIN_CB_MADE; }
			void			do_help(OI_menu_cell *, void *, OI_number);
		virtual	void			handle_delete_window();
			OI_bool			in_wait_button()		{ return(OI_bool)((ctl_bits&OI_DIALOG_BOX_WAIT_BUTTON)!=0 ? OI_yes : OI_no); }
		static	OI_bool			init(OI_connection*) ;
			OI_bool			is_should_be_pinned()		{ return ((ctl_bits&OI_DIALOG_BOX_SHOULD_BE_PINNED)?OI_yes:OI_no); }
			OI_bool			is_unpin_cb_made()		{ return ((ctl_bits&OI_DIALOG_BOX_UNPIN_CB_MADE)?OI_yes:OI_no); }
		static	OI_dialog_box		*make_minimal(const char*,OI_minimal_type) ;
			void			menu_resize(OI_d_tech*,void*) ;			/* resize callback for button menu */
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) ;
		virtual	void			new_layout(OI_layout, OI_number= -1, OI_number= -1) ;
		virtual	OI_stat			new_size(OI_number,OI_number);
		virtual	void			nominal_outside_size(OI_number*,OI_number*);
			OI_state		org_state()		{ return(org_st); }
			void			popup_cb(OI_wait_fnp,OI_callback*,OI_wait_memfnp,void*) ;	/* popup as modeless */
			OI_button_menu		*pushpin_menu() ;
			void			resize(OI_d_tech*,void*) ;			/* resize callback */
			void			set_db_def_loc()		{ ctl_bits |= OI_DIALOG_BOX_DEF_LOC; }
		virtual	void			set_model_info() ;
			void			set_pinned();
			void			set_pushpin_ok()	{ ctl_bits |= OI_DIALOG_BOX_PUSHPIN; }
			void			set_subtype(OI_dialog_box_type t)	{ subtyp=t; }
			void			strategy(const XEvent *ep) ;
			OI_dialog_box_type	subtype()		{ return(subtyp); }
		virtual	int			term_dlg(OI_menu_cell *, void *, OI_number);
			void			update_header() ;				/* update WM title bar info */
			void			update_prop();
			OI_bool			wait_flag()		{ return(wait_flg); }
	virtual	const	char			*wm_name() ;					/* name for window mgr WM_NAME property */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	void			allow_clip() ;
		virtual	OI_bool			auto_accelerators();
		virtual	void			disallow_clip(OI_bool=OI_no) ;
		virtual	OI_d_tech		*next_child(OI_d_tech*);
		virtual	OI_number		num_props() ;
		virtual	OI_d_tech		*numbered_child(OI_number n) ;
		virtual	OI_stat			set_state(OI_state) ;
		virtual	OI_number		size_y() ;

		//-------------------------------------------------------------------------------------------------		
		//		
		//	OBSOLETE MEMBER FUNCTIONS	
		//		Functions in this section were previously documented, but have been marked as
		//		obsolete.  These functions have been removed from the programmer's manual.
		//		These functions are subject to removal from the toolkit and should NEVER be
		//		used by toolkit users.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_number		first_column(OI_number = OI_undefined);
		virtual	OI_number		first_row(OI_number = OI_undefined);
		virtual	OI_number		last_column(OI_number = OI_undefined);
		virtual	OI_number		last_row(OI_number = OI_undefined);
		virtual	OI_number		next_column(OI_number, OI_number= OI_undefined) ;
		virtual	OI_number		next_row(OI_number, OI_number= OI_undefined) ;
			void			button_press(OI_menu_cell*, void*, OI_number btn) ;	/* process button press; use take_down instead */
			OI_number		useable_size_y() ;					/* size - space for buttons, use size_y() */

		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
			void			allow_modeless()		{ ctl_bits |= OI_DIALOG_BOX_MODELESS; }
			void			allow_pushpin() ;
			OI_button_menu		*buttons() ;
			void			disallow_modeless()		{ ctl_bits &= ~OI_DIALOG_BOX_MODELESS; }
			void			disallow_pushpin() ;
			void			fork(OI_menu_cell*,void*,OI_number) ;			/* fork cmd filled in from dialog box values */
			int			fork_nowait(OI_menu_cell*,void*,OI_number) ;		/* fork cmd filled in from dialog box values */
			OI_bool			is_modeless()			{ return(((ctl_bits&OI_DIALOG_BOX_MODELESS) != 0) ? OI_yes : OI_no); }
			OI_bool			is_pinned() ;
			OI_bool			is_pushpin() ;
			char			*longterm()		{ return(lngp); }
			void			pin();
			void			popup(OI_wait_fnp=NULL,void* =NULL) ;
			void			popup(OI_callback*,OI_wait_memfnp,void* =NULL) ;
			OI_stat			set_longterm(const char*) ;
			void			set_pin(OI_pin_fnp, void* =NULL) ;
			void			set_pin(OI_callback*, OI_pin_memfnp, void* =NULL) ;
			void			set_term_action(OI_bool wt=OI_no,OI_wait_fnp fp=NULL,void *argp=NULL) ;
			void			set_term_action(OI_bool wt, OI_callback *objp, OI_wait_memfnp mfp, void *argp=NULL) ;
			OI_stat			set_title(const char*) ;
			void			set_unpin(OI_pin_fnp, void* =NULL) ;
			void			set_unpin(OI_callback*, OI_pin_memfnp, void * =NULL) ;
			void			take_down(OI_menu* =NULL, OI_menu_cell* =NULL, void* =NULL, OI_number=0) ;
			char			*title()		{ return(ttlp); }
			void			unpin();
			OI_menu_cell		*wait_button(OI_bool restrict=OI_no,OI_wait_fnp fp=NULL,void *argp=NULL) ;
			OI_menu_cell		*wait_button(OI_bool restrict,OI_callback *objp,OI_wait_memfnp mfp,void *argp=NULL) ;
	} ;

//-------------------------------------------------------------------------------------------------		
//		
//	RESTRICTED FUNCTIONS
//		Functions in this section are not documented in the programmer's manual and are
//		restricted to internal use by the toolkit.
//		Functions not contained in user documentation are subject to change without notice
//		and should never be used by toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	OBSOLETED FUNCTIONS	
//		Functions below this point were once documented in the programmer's manual under
//		this object, but are now obsolete and will be removed in a future release.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		

//-------------------------------------------------------------------------------------------------		
//		
//	DOCUMENTED FUNCTIONS	
//		Functions below this point are documented in the programmer's manual under this
//		object and are available to the toolkit users.
//		Please maintain alphabetical order to facilitate releases and documentation.
//
//-------------------------------------------------------------------------------------------------		
	OI_dialog_box	*oi_create_dialog_box(const char*,OI_number,OI_number,OI_number= -1,OI_cell_spec* =NULL) ;
	OI_dialog_box	*oi_create_dialog_box(const char*,OI_number,OI_number,OI_number,OI_menu_cell**) ;

#endif /* OI_dlgbox_H */
