/*
 * @(#)system.c	1.1 91/09/06
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/ptrace.h>
#include <sys/reboot.h>
#define NFSCLIENT
#define LOFS
#define RFS
#define PCFS
#include <sys/mount.h>
#include <sys/socket.h>
#include <nfs/export.h>
#include <rpc/types.h>
#include <rpc/auth.h>

#include "defs.h"

int
sys_sync(tcp)
struct tcb *tcp;
{
	return 0;
}

static Xlat bootflags[] = {
	RB_AUTOBOOT,	"AUTOBOOT",	/* flags for system auto-booting itself */
	RB_ASKNAME,	"ASKNAME",	/* ask for file name to reboot from */
	RB_SINGLE,	"SINGLE",	/* reboot to single user only */
	RB_NOSYNC,	"NOSYNC",	/* dont sync before reboot */
	RB_HALT,	"HALT",		/* don't reboot, just halt */
	RB_INITNAME,	"INITNAME",	/* name given for /etc/init */
	RB_NOBOOTRC,	"NOBOOTRC",	/* don't run /etc/rc.boot */
	RB_DEBUG,	"DEBUG",	/* being run under debugger */
	RB_DUMP,	"DUMP",		/* dump system core */
	RB_WRITABLE,	"WRITABLE",	/* mount root read/write */
	RB_STRING,	"STRING",	/* pass boot args to prom monitor */
	0,		NULL,
};

int
sys_reboot(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		printflags(bootflags, tcp->u_args[0]);
		if (tcp->u_args[0] & RB_STRING) {
			printstr(tcp->pid, tcp->u_args[1], -1);
		}
	}
	return 0;
}

int
sys_sysacct(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		printstr(tcp->pid, tcp->u_args[0], -1);
	}
	return 0;
}

int
sys_swapon(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		printstr(tcp->pid, tcp->u_args[0], -1);
	}
	return 0;
}

static Xlat mountflags[] = {
	M_RDONLY,	"RDONLY",	/* mount fs read only */
	M_NOSUID,	"NOSUID",	/* mount fs with setuid not allowed */
	M_NEWTYPE,	"NEWTYPE",	/* use type string instead of int */
	M_GRPID,	"GRPID",	/* Old BSD group-id on create */
	M_REMOUNT,	"REMOUNT",	/* change options on an existing mount */
	M_NOSUB,	"NOSUB",	/* Disallow mounts beneath this mount */
	M_MULTI,	"MULTI",	/* Do multi-component lookup on files */
	M_SYS5,		"SYS5",		/* Mount with Sys 5-specific semantics */
	0,		NULL,
};
static Xlat nfsflags[] = {
	NFSMNT_SOFT,	"SOFT",		/* soft mount (hard is default) */
	NFSMNT_WSIZE,	"WSIZE",	/* set write size */
	NFSMNT_RSIZE,	"RSIZE",	/* set read size */
	NFSMNT_TIMEO,	"TIMEO",	/* set initial timeout */
	NFSMNT_RETRANS,	"RETRANS",	/* set number of request retrys */
	NFSMNT_HOSTNAME,"HOSTNAME",	/* set hostname for error printf */
	NFSMNT_INT,	"INT",		/* allow interrupts on hard mount */
	NFSMNT_NOAC,	"NOAC",		/* don't cache attributes */
	NFSMNT_ACREGMIN,"ACREGMIN",	/* set min secs for file attr cache */
	NFSMNT_ACREGMAX,"ACREGMAX",	/* set max secs for file attr cache */
	NFSMNT_ACDIRMIN,"ACDIRMIN",	/* set min secs for dir attr cache */
	NFSMNT_ACDIRMAX,"ACDIRMAX",	/* set max secs for dir attr cache */
	NFSMNT_SECURE,	"SECURE",	/* secure mount */
	NFSMNT_NOCTO,	"NOCTO",	/* no close-to-open consistency */
	NFSMNT_POSIX,	"POSIX",	/* static pathconf kludge info */
	0,		NULL,
};

int
sys_mount(tcp)
struct tcb *tcp;
{
	char type[4];

	if (entering(tcp)) {
		if (!(tcp->u_args[2] & M_NEWTYPE) || umovestr(tcp->pid,
				tcp->u_args[0],  sizeof type, type) < 0) {
			fprintf(outf, "OLDTYPE:#%x", tcp->u_args[0]);
		} else {
			fprintf(outf, "%s, ", type);
		}
		printstr(tcp->pid, tcp->u_args[1], -1);
		fprintf(outf, ", ");
		printflags(mountflags, tcp->u_args[2] & ~M_NEWTYPE);
		fprintf(outf, ", ");

		if (strcmp(type, "4.2") == 0) {
			struct ufs_args a;
			if (umove(tcp->pid, tcp->u_args[3], sizeof a, &a) < 0)
				return 0;
			printstr(tcp->pid, a.fspec, -1);
		} else if (strcmp(type, "lo") == 0) {
			struct lo_args a;
			if (umove(tcp->pid, tcp->u_args[3], sizeof a, &a) < 0)
				return 0;
			printstr(tcp->pid, a.fsdir, -1);
		} else if (strcmp(type, "nfs") == 0) {
			struct nfs_args a;
			if (umove(tcp->pid, tcp->u_args[3], sizeof a, &a) < 0)
				return 0;
			fprintf(outf, "[");
			printsock(tcp->pid, a.addr);
			fprintf(outf, ", ");
			printflags(nfsflags, a.flags);
			fprintf(outf, ", ws:%u,rs:%u,to:%u,re:%u,",
				a.wsize, a.rsize, a.timeo, a.retrans);
			if (a.flags & NFSMNT_HOSTNAME && a.hostname)
				printstr(tcp->pid, a.hostname, -1);
			else
				fprintf(outf, "%#x", a.hostname);
			fprintf(outf, ",reg-min:%u,max:%u,dir-min:%u,max:%u,",
				a.acregmin, a.acregmax, a.acdirmin, a.acdirmax);
			if (a.flags & NFSMNT_SECURE && a.netname)
				printstr(tcp->pid, a.netname, -1);
			else
				fprintf(outf, "%#x", a.netname);
			fprintf(outf, "]");
		} else if (strcmp(type, "rfs") == 0) {
			struct rfs_args a;
			struct token t;
			if (umove(tcp->pid, tcp->u_args[3], sizeof a, &a) < 0)
				return 0;
			fprintf(outf, "[");
			printstr(tcp->pid, a.rmtfs, -1);
			if (umove(tcp->pid, a.token, sizeof t, &t) < 0)
				return 0;
			fprintf(outf, ", %u, %s]", t.t_id, t.t_uname);
		} else if (strcmp(type, "pcfs") == 0) {
			struct pc_args a;
			if (umove(tcp->pid, tcp->u_args[3], sizeof a, &a) < 0)
				return 0;
			printstr(tcp->pid, a.fspec, -1);
		}
	}
	return 0;
}

int
sys_unmount(tcp)
struct tcb *tcp;
{
	if (entering(tcp)) {
		printstr(tcp->pid, tcp->u_args[0], -1);
	}
	return 0;
}

int
sys_umount(tcp)
struct tcb *tcp;
{
	return sys_unmount(tcp);
}

int
sys_auditsys(tcp)
struct tcb *tcp;
{
	/* XXX - no information available */
	return printargs(tcp);
}

static Xlat ex_auth_flags[] = {
	AUTH_UNIX, 	"AUTH_UNIX",
	AUTH_DES, 	"AUTH_DES",
	0,		NULL,
};

int
sys_exportfs(tcp)
struct tcb *tcp;
{
	struct export e;
	int i;

	if (entering(tcp)) {
		printstr(tcp->pid, tcp->u_args[0], -1);
		if (umove(tcp->pid, tcp->u_args[1], sizeof e, (char *)&e) < 0) {
			fprintf(outf, "%#x", tcp->u_args[1]);
			return 0;
		}
		fprintf(outf, "{fl:%u, anon:%u, ", e.ex_flags, e.ex_anon);
		printxval(ex_auth_flags, e.ex_auth, "AUTH_???");
		fprintf(outf, ", roots:[");
		if (e.ex_auth == AUTH_UNIX) {
			for (i=0; i<e.ex_u.exunix.rootaddrs.naddrs; i++) {
				printsock(tcp->pid,
					&e.ex_u.exunix.rootaddrs.addrvec[i]);
			}
			fprintf(outf, "], writers:[");
			for (i=0; i<e.ex_writeaddrs.naddrs; i++) {
				printsock(tcp->pid,
					&e.ex_writeaddrs.addrvec[i]);
			}
			fprintf(outf, "]");
		} else {
			for (i=0; i<e.ex_u.exdes.nnames; i++) {
				printsock(tcp->pid,
					&e.ex_u.exdes.rootnames[i]);
				fprintf(outf, ", ");
			}
			fprintf(outf, "], window:%u", e.ex_u.exdes.window);
		}
		fprintf(outf, "}");
	}
	return 0;
}
