/*
 * Copyright (C) 1995, 1996 Systemics Ltd (http://www.systemics.com/)
 * All rights reserved.
 */

package cryptix.pgp;

import java.io.*;

import cryptix.crypt.rsa.PublicKey;

public final class SignedData
{
	public byte[] data;
	public Signature signature;

	public ByteArrayInputStream
	dataAsByteArrayInputStream()
	{
		return new ByteArrayInputStream(data);
	}

	public String
	dataAsString()
	{
		return new String(data, 0);
	}

	public
	SignedData(byte[] data, Signature sig)
	{
		this.data = data;
		this.signature = sig;
	}

	public byte[]
	keyId()
	{
		return signature.getKeyId();
	}

	public boolean
	verify(PublicKey key)
	{
		return signature.verify(key, data);
	}
}
