/* */
/* 
 *     @(#)hotjava.os2.cmd	1.2 98/02/19
 *
 * Sample REXX script to launch HotJava under OS/2
 *
 * The following assumptions are made:
 * 
 *	o java.exe is present on the path
 *	o The directory layout of the JDK is consistent with the 
 *	  JavaSoft conventions
 *	o The directory layout of HotJava is consistent with the
 *	  standard distribution
 *	o classpath is already set to contain the standard JDK classes
 *
 * This script necessarily runs in a shell window.  However, the whole
 * function of the script is to dynamically determine characteristics
 * of the environment which are generally constant for a given machine.
 *
 * Creating a desktop ICON to launch HotJava is practical (and could
 * even be done using a REXX script) in that all that it needs to do is
 * to execute the java.exe with the right parameters.
 *
 * For additional information, see the hotjava shell script used for
 * unix platforms.
 */
n = setlocal();

/* pick up the REXX extensions to search the path */
call RxFuncAdd 'SysSearchPath', 'RexxUtil', 'SysSearchPath';

/* extract the command line */
parse source OS2 what program

/* manufacture a reasonable hotjava.home value */
hotjava_home = LEFT( program , LASTPOS( '\BIN\', program ) - 1 ) ;

/* construct a new classpath */
'@set classpath='hotjava_home'\lib;'hotjava_home'\lib\classes.zip;%classpath%'


/* construct a java.home value */
java=SysSearchPath('PATH', 'java.exe');
jhome=LEFT( java , LASTPOS( '\BIN\', java) - 1 ) ;

/* launch the browser using the JDK */
'@java -Dhotjava.home='hotjava_home '-Djava.home='jhome 'sunw.hotjava.Main'

/* restore the environment */
n = endlocal();
