/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.preview.filechooser;

import com.sun.java.swing.preview.filechooser.GenericFileSystemView;
import com.sun.java.swing.preview.filechooser.UnixFileSystemView;
import com.sun.java.swing.preview.filechooser.WindowsFileSystemView;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public abstract class FileSystemView {
    static FileSystemView windowsFileSystemView = null;
    static FileSystemView unixFileSystemView = null;
    static FileSystemView genericFileSystemView = null;

    public static FileSystemView getFileSystemView() {
        if (File.separatorChar == '\\') {
            if (windowsFileSystemView == null) {
                windowsFileSystemView = new WindowsFileSystemView();
            }
            return windowsFileSystemView;
        }
        if (File.separatorChar == '/') {
            if (unixFileSystemView == null) {
                unixFileSystemView = new UnixFileSystemView();
            }
            return unixFileSystemView;
        }
        if (genericFileSystemView == null) {
            genericFileSystemView = new GenericFileSystemView();
        }
        return genericFileSystemView;
    }

    public abstract boolean isRoot(File var1);

    public abstract File createNewFolder(File var1) throws IOException;

    public abstract boolean isHiddenFile(File var1);

    public abstract File[] getRoots();

    public File createFileObject(File file, String string) {
        if (file == null) {
            return new File(string);
        }
        return new File(file, string);
    }

    public File createFileObject(String string) {
        return new File(string);
    }

    public File[] getFiles(File file, boolean bl) {
        Vector<File> vector = new Vector<File>();
        String[] stringArray = file.list();
        int n = stringArray == null ? 0 : stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file2 = this.createFileObject(file, stringArray[n2]);
            if (bl) {
                if (!this.isHiddenFile(file2)) {
                    vector.addElement(file2);
                }
            } else {
                vector.addElement(file2);
            }
            ++n2;
        }
        Object[] objectArray = new File[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public File getParentDirectory(File file) {
        File file2;
        String string;
        if (file != null && (string = (file2 = this.createFileObject(file.getAbsolutePath())).getParent()) != null) {
            return new File(string);
        }
        return null;
    }
}

