/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.ColorChooserPanel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.basic.ColorPatch;
import com.sun.java.swing.plaf.basic.ColorWheel;
import com.sun.java.swing.plaf.basic.HueLightnessPatch;
import com.sun.java.swing.plaf.basic.Spinner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class BasicHSVChooserPanel
extends ColorChooserPanel
implements PropertyChangeListener,
Serializable {
    static int preferredWidth = 300;
    static int preferredHeight = 200;
    static Dimension preferredSize = new Dimension(preferredWidth, preferredHeight);
    static int butGap = 2;
    protected Spinner hue;
    protected Spinner saturation;
    protected Spinner brightness;
    protected ColorPatch resultColor;
    protected HueLightnessPatch hlp;
    protected ColorWheel wheel;
    Color color = Color.red;

    public BasicHSVChooserPanel() {
    }

    public BasicHSVChooserPanel(Color color) {
        this.color = color;
    }

    public int[] getHSBColor() {
        Color color = this.getColor();
        int[] nArray = new int[3];
        float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        nArray[0] = (int)((double)(fArray[0] * 100.0f) + 0.5);
        nArray[1] = (int)((double)(fArray[1] * 100.0f) + 0.5);
        nArray[2] = (int)((double)(fArray[2] * 100.0f) + 0.5);
        return nArray;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        float[] fArray = Color.RGBtoHSB(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), null);
        int n = Color.HSBtoRGB(fArray[0], fArray[1], fArray[2]);
        this.hlp.setColor(n);
        this.setSpinners(fArray);
        this.wheel.setTheta((double)(fArray[0] * 360.0f) + 0.5);
        this.resultColor.setColor(n);
    }

    public void installChooserPanel() {
        this.setLayout(new ColorChooserLayout());
        int[] nArray = this.getHSBColor();
        this.resultColor = new ColorPatch();
        this.resultColor.setBorder(UIManager.getBorder("ColorChooser.selectedColorBorder"));
        this.hue = new Spinner(nArray[0], "\u00b0 H");
        this.hue.setMinimum(0);
        this.hue.setMaximum(100);
        this.saturation = new Spinner(nArray[1], "% S");
        this.saturation.setMinimum(0);
        this.saturation.setMaximum(100);
        this.brightness = new Spinner(nArray[2], "% B");
        this.brightness.setMinimum(0);
        this.brightness.setMaximum(100);
        this.hlp = new HueLightnessPatch(this.resultColor, this.hue, this.saturation, this.brightness);
        this.add(this.hlp);
        this.saturation.addAdjustmentListener(this.hlp);
        this.brightness.addAdjustmentListener(this.hlp);
        this.wheel = new ColorWheel(this.hlp, this.hue);
        this.hue.setWrap(true);
        this.add(this.wheel);
        this.add(this.resultColor);
        this.add(this.hue);
        this.add(this.saturation);
        this.add(this.brightness);
        this.resultColor.addPropertyChangeListener(this);
    }

    public void uninstallChooserPanel() {
        this.resultColor.removePropertyChangeListener(this);
        this.setLayout(null);
        this.remove(this.hlp);
        this.remove(this.wheel);
        this.remove(this.resultColor);
        this.remove(this.hue);
        this.remove(this.saturation);
        this.remove(this.brightness);
        this.hlp = null;
        this.wheel = null;
        this.resultColor = null;
        this.brightness = null;
        this.saturation = null;
        this.hue = null;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.resultColor && propertyChangeEvent.getPropertyName().equals("color")) {
            Color color = (Color)propertyChangeEvent.getNewValue();
            Color color2 = this.getColor();
            this.fireColorPropertyChange(color2, color);
        }
    }

    protected void setSpinners(float[] fArray) {
        float f = this.hue.getValue();
        float f2 = this.saturation.getValue();
        float f3 = this.brightness.getValue();
        if (f != fArray[0]) {
            this.hue.setValue((int)((double)(fArray[0] * 360.0f) + 0.5));
        }
        if (f2 != fArray[1]) {
            this.saturation.setValue((int)((double)(fArray[1] * 100.0f) + 0.5));
        }
        if (f3 != fArray[2]) {
            this.brightness.setValue((int)((double)(fArray[2] * 100.0f) + 0.5));
        }
    }

    class ColorChooserLayout
    implements LayoutManager,
    Serializable {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return preferredSize;
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            int n2 = 16;
            Rectangle rectangle = container.getBounds();
            Insets insets = container.getInsets();
            int n3 = rectangle.height - insets.top - insets.bottom;
            int n4 = rectangle.width - insets.left - insets.right;
            int n5 = insets.left;
            int n6 = insets.top;
            int n7 = 3;
            while (n7 < n) {
                Dimension dimension = container.getComponent(n7).getMinimumSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                ++n7;
            }
            int n8 = n4 - n2 - butGap;
            int n9 = n3;
            if (n8 < n9) {
                n9 = n8;
            }
            n2 = n4 - n9 - butGap;
            Component component = container.getComponent(0);
            n8 = (int)((double)n9 * 0.5325);
            component.setBounds(n5 + (n9 - n8 >> 1), n6 + (n9 - n8 >> 1), n8, n8);
            component = container.getComponent(1);
            component.setBounds(n5, n6 + (n3 - n9 >> 1), n9, n9);
            int n10 = 0;
            int n11 = 3;
            while (n11 < n) {
                component = container.getComponent(n11);
                int n12 = component.getMinimumSize().height;
                component.setBounds(n5 + n4 - n2, n6 + n10, n2, n12);
                n10 += n12 + butGap;
                ++n11;
            }
            component = container.getComponent(2);
            component.setBounds(n5 + n4 - n2, n6 + n10, n2, n3 - n10);
        }

        ColorChooserLayout() {
            BasicHSVChooserPanel.this = BasicHSVChooserPanel.this;
        }
    }
}

