/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.tags;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import sunw.hotjava.doc.DocBusyException;
import sunw.hotjava.doc.DocPanel;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.DocumentCache;
import sunw.hotjava.doc.DocumentFormatter;
import sunw.hotjava.doc.DocumentPanel;
import sunw.hotjava.doc.Formatter;
import sunw.hotjava.doc.MasterDocumentPanel;
import sunw.hotjava.doc.TagItem;
import sunw.hotjava.tags.FRAME;
import sunw.hotjava.tags.FrameSetPanel;
import sunw.hotjava.tags.Resizable;
import sunw.hotjava.tags.ResizeRequestEvent;
import sunw.html.Attributes;

public class FramePanel
extends Panel
implements DocPanel,
MouseListener,
Resizable {
    private int BORDER_SLOP;
    private DocumentPanel docPanel;
    private boolean resizable;
    private int borderWidth = 4;
    private boolean borderEvaluated;
    private boolean shouldPaintBorder;
    private FrameSetPanel resizeListener;
    private Point gridLoc;
    private MasterDocumentPanel containingMaster;

    FramePanel(Formatter formatter, TagItem tagItem, int n, Container container) {
        this.setLayout(null);
        this.borderWidth = n;
        this.borderEvaluated = false;
        Attributes attributes = tagItem.getAttributes();
        URL uRL = ((FRAME)tagItem).src;
        String string = this.getAttribute("scrolling", attributes, "auto");
        int n2 = uRL != null ? 0 : 2;
        if ("yes".equalsIgnoreCase(string)) {
            n2 = 1;
        } else if ("no".equalsIgnoreCase(string)) {
            n2 = 2;
        } else if ("auto".equalsIgnoreCase(string)) {
            n2 = 0;
        }
        container.add(this);
        this.docPanel = new DocumentPanel(formatter.getDocFont(), n2);
        this.docPanel.addMouseListener(this);
        this.add(this.docPanel);
        this.containingMaster = MasterDocumentPanel.getContainingMasterDocumentPanel(formatter.getParent());
        this.containingMaster.addTopDocListenerToSource(this.docPanel);
        this.docPanel.setName(this.getAttribute("name", attributes, "_self"));
        if (uRL == null) {
            return;
        }
        URL uRL2 = formatter.getDocument().getURL();
        Document document = DocumentCache.getDocument(uRL, uRL2);
        this.docPanel.show(document);
        String string2 = this.getAttribute("noresize", attributes, null);
        this.resizable = !"noresize".equalsIgnoreCase(string2);
        int n3 = this.getMarginValue("marginwidth", attributes, 20);
        int n4 = this.getMarginValue("marginheight", attributes, 10);
        this.docPanel.setMargins(n3, n4);
        this.addMouseListener(this);
    }

    private DocumentFormatter getDocFormatter() {
        return this.docPanel.getFormatter();
    }

    public void setResizeListener(FrameSetPanel frameSetPanel, Point point) {
        this.resizeListener = frameSetPanel;
        this.gridLoc = point;
        if (!this.resizable && frameSetPanel != null) {
            frameSetPanel.setNotResizable(point);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl = false;
        int n = 0;
        int n2 = this.computeMouseEdge(mouseEvent);
        if (n2 < 0) {
            return;
        }
        if (n2 == 2 && this.resizeListener != null) {
            bl = true;
            n = this.gridLoc.y;
        } else if (n2 == 3 && this.resizeListener != null) {
            bl = true;
            n = this.gridLoc.y + 1;
        } else if (n2 == 0 && this.resizeListener != null) {
            n = this.gridLoc.x;
        } else if (n2 == 1 && this.resizeListener != null) {
            n = this.gridLoc.x + 1;
        } else {
            return;
        }
        ResizeRequestEvent resizeRequestEvent = new ResizeRequestEvent(this, mouseEvent.getPoint(), bl, n);
        if (this.resizeListener != null) {
            this.resizeListener.handleResizeEvent(resizeRequestEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private int computeMouseEdge(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        if (this.isCloseTo(n, 0)) {
            return 0;
        }
        int n2 = mouseEvent.getY();
        if (this.isCloseTo(n2, 0)) {
            return 2;
        }
        Dimension dimension = this.getSize();
        if (this.isCloseTo(n, dimension.width)) {
            return 1;
        }
        if (this.isCloseTo(n2, dimension.height)) {
            return 3;
        }
        return -1;
    }

    public boolean isCloseTo(int n, int n2) {
        return Math.abs(n - n2) <= this.BORDER_SLOP;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.shouldPaintBorder()) {
            this.paintBorder(graphics);
        }
        super.paint(graphics);
    }

    private void paintBorder(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.gray);
        int n = 0;
        while (n < this.borderWidth) {
            graphics.draw3DRect(n, n, dimension.width - (2 * n + 1), dimension.height - (2 * n + 1), false);
            ++n;
        }
    }

    private String getAttribute(String string, Attributes attributes, String string2) {
        String string3 = string2;
        if (attributes != null && (string3 = attributes.get(string)) == null) {
            string3 = string2;
        }
        return string3;
    }

    private int getMarginValue(String string, Attributes attributes, int n) {
        block3: {
            String string2 = this.getAttribute(string, attributes, null);
            if (string2 != null) {
                try {
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!"o".equalsIgnoreCase(string2)) break block3;
                    return 0;
                }
            }
        }
        return n;
    }

    private boolean shouldPaintBorder() {
        if (!this.borderEvaluated) {
            this.shouldPaintBorder = this.decideBorderPaintability();
            this.borderEvaluated = true;
        }
        return this.shouldPaintBorder;
    }

    private boolean decideBorderPaintability() {
        Insets insets = this.getInsets();
        this.BORDER_SLOP = this.borderWidth;
        this.borderWidth -= insets.left;
        return this.borderWidth > 0;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        Component component = this.getComponent(0);
        if (n3 != 0) {
            component.setBounds(this.borderWidth, this.borderWidth, n3 - 2 * this.borderWidth, n4 - 2 * this.borderWidth);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void activateSubItems() {
        DocumentFormatter documentFormatter = this.getDocFormatter();
        if (documentFormatter != null) {
            documentFormatter.activateSubItems();
        }
    }

    public void start() {
        DocumentFormatter documentFormatter = this.getDocFormatter();
        if (documentFormatter == null) {
            return;
        }
        Color color = documentFormatter.getFormatterBackgroundColor();
        if (color != null) {
            this.setBackground(color);
        }
        documentFormatter.start();
    }

    public void stop() {
        DocumentFormatter documentFormatter = this.getDocFormatter();
        if (documentFormatter != null) {
            documentFormatter.stop();
        }
    }

    public void destroy() {
        this.containingMaster.removeTopDocListenerFromSource(this.docPanel);
        if (this.docPanel != null) {
            this.docPanel.destroy();
        }
    }

    public void interruptLoading() {
        DocumentFormatter documentFormatter = this.getDocFormatter();
        if (documentFormatter != null) {
            documentFormatter.interruptLoading();
        }
    }

    public void notify(Document document, int n, int n2, int n3) {
        DocumentFormatter documentFormatter = this.getDocFormatter();
        if (documentFormatter != null) {
            documentFormatter.notify(document, n, n2, n3);
        }
    }

    public void reformat() {
        DocumentFormatter documentFormatter = this.getDocFormatter();
        if (documentFormatter != null) {
            documentFormatter.reformat();
        }
    }

    public int findYFor(int n) {
        DocumentFormatter documentFormatter = this.getDocFormatter();
        if (documentFormatter != null) {
            return documentFormatter.findYFor(n);
        }
        return 0;
    }

    public void reload() {
        this.docPanel.reload();
    }

    public DocumentFormatter getFormatter() {
        return this.docPanel.getFormatter();
    }

    public void print(PrintJob printJob, MasterDocumentPanel masterDocumentPanel) throws DocBusyException {
        this.docPanel.print(printJob, masterDocumentPanel);
    }

    public void removeNotify() {
        this.stop();
        this.docPanel.removeMouseListener(this);
        this.docPanel.removePanel(this.docPanel);
        super.removeNotify();
    }
}

