/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.doc;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.net.URL;
import sunw.hotjava.doc.Document;
import sunw.hotjava.doc.PageMargins;
import sunw.hotjava.doc.PageMarker;

class StdPageMarker
implements PageMarker {
    private Font labelFont;
    private FontMetrics fm;
    PageMargins margins;

    StdPageMarker() {
        String string = System.getProperty("hotjava.print.label.font");
        if (string == null) {
            string = "SansSerif-8";
        }
        this.labelFont = Font.decode(string);
    }

    public void adjustMargins(PageMargins pageMargins) {
        this.margins = pageMargins;
    }

    public void markBefore(Document document, Graphics graphics, PrintJob printJob, int n, int n2) {
    }

    public void markAfter(Document document, Graphics graphics, PrintJob printJob, int n, int n2) {
        Dimension dimension = printJob.getPageDimension();
        int n3 = printJob.getPageResolution();
        int n4 = Integer.getInteger("hotjava.print.header.spacing", 26) * n3 / 72;
        int n5 = Integer.getInteger("hotjava.print.footer.spacing", 26) * n3 / 72;
        int n6 = Integer.getInteger("hotjava.print.header.margin", 54) * n3 / 72;
        try {
            int n7;
            int n8;
            String string;
            URL uRL;
            graphics.setFont(this.labelFont);
            graphics.setColor(Color.black);
            if (this.fm == null) {
                this.fm = graphics.getFontMetrics();
            }
            String string2 = document.getTitle();
            int n9 = n6;
            int n10 = this.margins.getTopMargin() - (n4 + this.fm.getAscent());
            if (string2 != null) {
                graphics.drawString(string2, n9, n10);
                n9 += 20 + this.fm.stringWidth(string2);
            }
            if ((uRL = document.getURL()) != null) {
                string = uRL.toString();
                n8 = this.fm.stringWidth(string);
                n7 = dimension.width - n6 - n8;
                if (n7 < n9) {
                    n7 = n9;
                }
                graphics.drawString(string, n7, n10);
            }
            string = "- " + String.valueOf(n + 1) + " -";
            n8 = this.fm.stringWidth(string);
            n9 = (dimension.width - n8) / 2;
            n7 = dimension.height - this.fm.getDescent() - (this.margins.getBottomMargin() - n5);
            graphics.drawString(string, n9, n7);
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            graphics.dispose();
            throw throwable;
        }
        Object var12_18 = null;
        graphics.dispose();
    }
}

