/*************************************************************************
 *                                                                       *
 * Project Pandora Password Hash and Hack Functions                      *
 *************************************************************************/

#ifndef PAN_HASH_H
#define PAN_HASH_H

#include "pan_glob.h"

#ifdef __cplusplus
extern "C" {
#endif

/** API functions **/

 /* Password Hacking */

  /* Usage : err=Pan_Brute_Force(&pPassHack,PAN_ASCII,&retpw,"RESTORE.PAN");*/
  /* contains NULL if no error, -105 if not found, -106 if time to save */
 #define PAN_ASCII 25
 #define PAN_ALPHANUM 35
 #define PAN_KEYSPACE 66
 int Pan_Brute_Force(Pan_PassHack *pPassHack,
                     int maxtry,
                     char **retpw,
                     uint32 limit
                    );

  /*Usage : err=Pan_Dict_Attack(&pPassHack,&retpw,dict);*/
  /*->pwlen:lengh to try,return:password in retpw or error,readfile:dict*/
 int Pan_Dict_Attack(Pan_PassHack *pPassHack,char **retpw,char *readfile);

  /*Usage : err=Pan_Hash_Gen(&pPassHack);*/
  /*->pw_first:password to use,->pwlen:lengh,return ->hash or an error*/
 int Pan_Hash_Gen(Pan_PassHack *pPassHack);

  /*Usage : err=Pan_Challenge_Response(&pPassHack,TRUE,&logkey,&dst)*/
  /*Info must contain ObjectID and pw_first for hash_gen if hash_known=FALSE*/
  /*If hash_known=TRUE info must contain ObjectID and hash*/
 int Pan_Challenge_Response
  (Pan_PassHack *Info,int hash_known,uint8 *logkey, uint8 *dst);


  /*Usage : err=Pan_3hash_cipher(oldcipher,newcipher,newcipher)*/
  /*p1[8] : half of current password hash*/
  /*p2[8] : half of new password hash*/
  /*p3[8] : half-pattern such as H(p1,p2)=p3 and F(p1,p3)=p2, H() is Pan_*/
 int Pan_3hash_cipher(uint8 *oldcrpw,uint8 *newcrpw,uint8 *cipherpw);

#ifdef __cplusplus
}
#endif

#endif /* PAN_HASH_H */
