/* definitions for the dll.

Copyright (C) 1999 Politecnico di Torino

This file is part of the NDIS Packet capture driver.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.
*/
/* 
 This has been modified by the NMRC under the terms of the GNU
 licensing agreements.
*/

#ifndef __PACKET32
#define __PACKET32
#define        DOSNAMEPREFIX   TEXT("Packet_")
#define        MAX_LINK_NAME_LENGTH   64
#define        NMAX_PACKET 65535  

/** copied & paste for pandora **/
//
// Ndis Packet Filter Bits (OID_GEN_CURRENT_PACKET_FILTER).
//
#define NDIS_PACKET_TYPE_DIRECTED				0x0001
#define NDIS_PACKET_TYPE_MULTICAST				0x0002
#define NDIS_PACKET_TYPE_ALL_MULTICAST			0x0004
#define NDIS_PACKET_TYPE_BROADCAST				0x0008
#define NDIS_PACKET_TYPE_SOURCE_ROUTING			0x0010
#define NDIS_PACKET_TYPE_PROMISCUOUS			0x0020
#define NDIS_PACKET_TYPE_SMT					0x0040
#define NDIS_PACKET_TYPE_ALL_LOCAL				0x0080
#define NDIS_PACKET_TYPE_MAC_FRAME				0x8000
#define NDIS_PACKET_TYPE_FUNCTIONAL				0x4000
#define NDIS_PACKET_TYPE_ALL_FUNCTIONAL			0x2000
#define NDIS_PACKET_TYPE_GROUP					0x1000
//
// Ndis Token-Ring Ring Status Codes (OID_802_5_CURRENT_RING_STATUS).
//
#define NDIS_RING_SIGNAL_LOSS					0x00008000
#define NDIS_RING_HARD_ERROR					0x00004000
#define NDIS_RING_SOFT_ERROR					0x00002000
#define NDIS_RING_TRANSMIT_BEACON				0x00001000
#define NDIS_RING_LOBE_WIRE_FAULT				0x00000800
#define NDIS_RING_AUTO_REMOVAL_ERROR			0x00000400
#define NDIS_RING_REMOVE_RECEIVED				0x00000200
#define NDIS_RING_COUNTER_OVERFLOW				0x00000100
#define NDIS_RING_SINGLE_STATION				0x00000080
#define NDIS_RING_RING_RECOVERY					0x00000040
//
// Ndis protocol option bits (OID_GEN_PROTOCOL_OPTIONS).
//
#define NDIS_PROT_OPTION_ESTIMATED_LENGTH   	0x00000001
#define NDIS_PROT_OPTION_NO_LOOPBACK			0x00000002
#define NDIS_PROT_OPTION_NO_RSVD_ON_RCVPKT		0x00000004
//
// Ndis MAC option bits (OID_GEN_MAC_OPTIONS).
//
#define NDIS_MAC_OPTION_COPY_LOOKAHEAD_DATA 	0x00000001
#define NDIS_MAC_OPTION_RECEIVE_SERIALIZED  	0x00000002
#define NDIS_MAC_OPTION_TRANSFERS_NOT_PEND  	0x00000004
#define NDIS_MAC_OPTION_NO_LOOPBACK				0x00000008
#define NDIS_MAC_OPTION_FULL_DUPLEX				0x00000010
#define NDIS_MAC_OPTION_EOTX_INDICATION			0x00000020
#define NDIS_MAC_OPTION_RESERVED				0x80000000
//
//      NDIS MAC option bits for OID_GEN_CO_MAC_OPTIONS.
//
#define NDIS_CO_MAC_OPTION_DYNAMIC_LINK_SPEED	0x00000001

/* shity windows types, for packet driver */
#define BOOLEAN unsigned char 
#define VOID void
typedef void *PVOID;
typedef void *HANDLE;
typedef unsigned char	BYTE,UCHAR;
typedef unsigned int	UINT;
typedef unsigned long	ULONG,DWORD;
typedef unsigned short  USHORT;
typedef ULONG		*PULONG;
typedef char		*LPSTR,TCHAR,*PTSTR,*LPTSTR;
typedef struct {
  DWORD Internal;
  DWORD InternalHigh;
  DWORD Offset;
  DWORD OffsetHigh;
  HANDLE hEvent;
                } OVERLAPPED, *LPOVERLAPPED;

#define Packet_ALIGNMENT sizeof(int)
#define Packet_WORDALIGN(x) (((x)+(Packet_ALIGNMENT-1))&~(Packet_ALIGNMENT-1))
#define INVALID_HANDLE_VALUE (HANDLE)-1

//ioctls
#define  pBIOCSETBUFFERSIZE 9592
#define  pBIOCSETF 9030
#define  pBIOCGSTATS 9031
#define  pBIORELEASEREQUESTS 7412



struct _PACKET_OID_DATA {
    ULONG Oid;
    ULONG Length;
    UCHAR Data[1];
}; 
typedef struct _PACKET_OID_DATA PACKET_OID_DATA, *PPACKET_OID_DATA;

struct _ADAPTER
   {
    HANDLE hFile;
    TCHAR SymbolicLink[MAX_LINK_NAME_LENGTH];
   };
typedef struct _ADAPTER ADAPTER,*LPADAPTER;

struct _PACKET 
{
    HANDLE       hEvent;
    OVERLAPPED   OverLapped;
    PVOID        Buffer;
    UINT         Length;
    ULONG		 ulBytesReceived;
    BOOLEAN		 bIoComplete;
}; 
typedef struct _PACKET PACKET, *LPPACKET;

//Network type structure
typedef struct NetType
{
	UINT LinkType;
	UINT LinkSpeed;
}NetType;

//some definitions from libpcap
#ifndef BPF_MAJOR_VERSION

struct bpf_program {
	UINT bf_len;
	struct bpf_insn *bf_insns;
};
struct bpf_insn {
	USHORT	code;
	UCHAR 	jt;
	UCHAR 	jf;
	int k;
};
struct bpf_stat {
	UINT bs_recv;		/* number of packets received */
	UINT bs_drop;		/* number of packets dropped */
};

struct bpf_hdr {
	struct timeval	bh_tstamp;	/* time stamp */
	UINT	bh_caplen;	/* length of captured portion */
	UINT	bh_datalen;	/* original length of packet */
	USHORT		bh_hdrlen;	/* length of bpf header (this struct
					   plus alignment padding) */
};
#endif


#ifdef __cplusplus
extern "C" {
#endif

BOOLEAN PacketSetBpf(LPADAPTER AdapterObject,struct bpf_program *fp);
BOOLEAN PacketGetStats(LPADAPTER AdapterObject,struct bpf_stat *s);
BOOLEAN PacketSetBuff(LPADAPTER AdapterObject,int dim);
BOOLEAN PacketGetNetType (LPADAPTER AdapterObject,NetType *type);
LPADAPTER PacketOpenAdapter(LPTSTR AdapterName);
BOOLEAN PacketSendPacket(LPADAPTER AdapterObject,LPPACKET pPacket,BOOLEAN Sync);
LPPACKET PacketAllocatePacket(void);
LPPACKET PacketAllocateNPacket(UINT n);
VOID PacketInitPacket(LPPACKET lpPacket,PVOID  Buffer,UINT  Length);
VOID PacketFreePacket(LPPACKET lpPacket);
BOOLEAN PacketResetAdapter(LPADAPTER AdapterObject);
BOOLEAN PacketWaitPacket(LPADAPTER AdapterObject,LPPACKET lpPacket);
BOOLEAN PacketReceiveNPacket(LPADAPTER AdapterObject,LPPACKET headLPacket,UINT n,UINT length,BYTE* buffer,BOOLEAN Sync);
BOOLEAN PacketReceivePacket(LPADAPTER AdapterObject,LPPACKET lpPacket,BOOLEAN Sync);
VOID PacketCloseAdapter(LPADAPTER lpAdapter);
BOOLEAN PacketSetHwFilter(LPADAPTER AdapterObject,ULONG Filter);
ULONG PacketGetAdapterNames(PTSTR pStr,PULONG  BufferSize);
BOOLEAN PacketRequest(LPADAPTER  AdapterObject,BOOLEAN Set,PPACKET_OID_DATA  OidData);
VOID PacketSetNextPacket(LPPACKET lpPacket, LPPACKET next);
VOID PacketSetLengthBuffer(LPPACKET lpPacket, UINT dim);
VOID PacketSetLengthPacket(LPPACKET lpPacket, UINT numBytes);
LPPACKET PacketGetNextPacket(LPPACKET lpPacket);
LPADAPTER PacketOpenAdapter(LPTSTR AdapterName);

#ifdef __cplusplus
}
#endif

#endif
