; lowpass filter left audio channel (cutoff 900Hz)

	nolist
	include 'leonid'
	list


M	equ	160
buflen	equ	3*M


	system	'dsp4'

	org	p:user_code

	move		    #buffer+2,r7
	move		    #buflen*4-1,m7

	move		    #buffer,r2
	move		    #4-1,n2
	move		    #buflen*4-1,m2

	ctrlcd	1,r2,buflen,LINEI,0.0,0.0,LINEO|HEADP,0.0,0.0
	opencd	8

; wait for one complete block
loop	waitblk r2,buflen,M

; then filter the left channel
	move		    #buflen*4-1,m0
	move		    #-4,n0
	move		    #lotaps,r4
	move		    #<lolen-1,m4

	move		    r2,r0
	do	#M,_endlpf
	clr	a
	move		    x:(r0)+n0,x0  y:(r4)+,y0
	rep	#lolen-1
	mac	x0,y0,a     x:(r0)+n0,x0  y:(r4)+,y0
	macr	x0,y0,a     (r2)+
	move		    a,y:(r2)+n2
	move		    r2,r0
_endlpf

	jmp	<loop


	org	x:user_data

buffer	dsm	buflen*4


	org	y:user_data

	dsm	buflen*4

; 900 Hz lowpass filter generated using Parks-McClellan algorithm
;   sampling rate   8000 Hz
;   passband edge    840 Hz
;   stop band edge   960 Hz
;   filter lenght     79 taps
	dsm	256
lolen	equ	79
lotaps	dc	 1.619394e-02,5.805688e-03,3.155693e-03,-1.500173e-03,-6.545769e-03
	dc	-9.963868e-03,-1.022255e-02,-7.061145e-03,-1.754771e-03,3.332559e-03
	dc	 5.765334e-03,4.199639e-03,-8.617942e-04,-7.138900e-03,-1.151400e-02
	dc	-1.147496e-02,-6.426490e-03,1.780802e-03,9.467491e-03,1.274443e-02
	dc	 9.432186e-03,3.507424e-04,-1.070496e-02,-1.840716e-02,-1.827196e-02
	dc	-9.051937e-03,6.112294e-03,2.066623e-02,2.704929e-02,2.031219e-02
	dc	 9.089151e-04,-2.437167e-02,-4.415325e-02,-4.639930e-02,-2.320264e-02
	dc	 2.545267e-02,9.059131e-02,1.564397e-01,2.052803e-01,2.232958e-01	; center tap
	dc	 2.052803e-01,1.564397e-01,9.059131e-02,2.545267e-02,-2.320264e-02
	dc	-4.639930e-02,-4.415325e-02,-2.437167e-02,9.089151e-04,2.031219e-02
	dc	 2.704929e-02,2.066623e-02,6.112294e-03,-9.051937e-03,-1.827196e-02
	dc	-1.840716e-02,-1.070496e-02,3.507424e-04,9.432186e-03,1.274443e-02
	dc	 9.467491e-03,1.780802e-03,-6.426490e-03,-1.147496e-02,-1.151400e-02
	dc	-7.138900e-03,-8.617942e-04,4.199639e-03,5.765334e-03,3.332559e-03
	dc	-1.754771e-03,-7.061145e-03,-1.022255e-02,-9.963868e-03,-6.545769e-03
	dc	-1.500173e-03,3.155693e-03,5.805688e-03,1.619394e-02


	end
