/* Hauptverarbeitungsbildtypen *
 *******************************
 
 * RASTERGRAFIKEN *
 
 * Da sich Plane-orinetierte Bitmap-Grafiken ganz schlecht
 * und nur langsam weiterverabeiten lassen wurde ein eigenes
 * Format fr die Verarbeitungen gewhlt. Aber keine Angst,
 * entsprechende Konvertierungsfunktionen sind integriert.
 * Dieses Format hat auch den groen Vorteil das es oft
 * schon dem gerteabhngigem Format von Grafikkarten ent-
 * spricht. 
 * Man hat hchste Geschwindigkeit, da man sich eine Umwandlung
 * via VDI-Transform ersparen kann !
 * Die Umsetzung dieses Formates in das gerteabhngige Format
 * wird durch eigene, hochoptimierte Algorithmen bernommen und
 * eine entsprechende Funktion zur Verfgung gestellt.
 */

#include <portab.h>

#ifndef _GEN_IBMR_
#define _GEN_IBMR_

#ifndef BOOLEAN
 typedef enum
 {
	FAIL=-1,
	FALSE,
	TRUE
 } boolean;
#define BOOLEAN	boolean
#endif

typedef struct
{
   WORD  red;        /* Rot-Intensitt in Promille (0-1000) */
   WORD  green;      /* Grn-Intensitt in Promille (0-1000) */
   WORD  blue;       /* Blau-Intensitt in Promille (0-1000) */
} RGB1000;			 /* Farben VDI kompatibel */

#define RGB255	BYTE /* Genau: Eine Folge von 3 Bytes:
   						BYTE  red;	  Rotintensitt von 0-255
   						BYTE  green;  Grnintensitt von 0-255
   						BYTE  blue;	  Blauintensitt von 0-255
						
						Leider ist das Beschreiben einer Struktur
						hier nicht mglich, da PureC automatisch
						diese auf 16 Bit 'alignen' wrde, welches
						zu Verarbeitungsmngeln im 68000 Code fhrt.. 
   					 */

typedef struct {
						/* Viele (ableitbare) Informationen... */
						/* spart aber Zeit und wir wollen doch */
						/* Speeeeeed...... */
	WORD	xsize;		/* Bildbreite */
	WORD	ysize;		/* Bildhhe   */
	WORD	wdwidth;	/* Breite/16 (aligned) */
	BYTE	bpp;		/* Bytes pro Pixel (monochrome = -8) */
	WORD	bpl;		/* Bytes pro Zeile */
	WORD	dumb;		/* Anzahl der fr align. unbenutzten Bytes */
	LONG	bpb;		/* Speicherbedarf der Bilddaten in Bytes */
	BYTE	cdepth;		/* Farbtiefe (2^n Farben). */
	WORD	colors;		/* Wenn Farbtiefe <= 8: genaue Farbanzahl */
						/* sonst -1 fr keine Palette. */
	RGB255	*cmap;		/* Zeiger auf eine Farbtabelle */
	BYTE	*bitmap;	/* Die Bilddaten.
	                     * Folgender Aufbau:
	                     *
	                     * Wenn cdepth=1 ist (monochrome),
	                     * sind 16 pixel wordquivalent (und aligned).
	                     * Das hchste Bit steht an linker Position.
	                     * Die Farbzuordnung ist: Bit leer = Index 0
	                     * Bit gesetzt = Farbindex 1 der akt. cmap.
                         * Bilddaten sind WORD aligned.
	                     *
	                     * Wenn cdepth=2-8 ist, sind die
	                     * Bilddaten pixelgepakt farb-indiziert
	                     * bezgl. der Farbtabelle.
	                     * 1 Pixel = 1 Byte. 
	                     * 
	                     * Wenn cdepth=16 ist, liegt 16 Bit High-
	                     * Color vor. 2 Byte pro Pixel Motorola-Format:
	                     *   even  |  odd
	                     * rrrrrggg gggbbbbb
	                     *
	                     * Wenn cdepth=24 ist, liegt 24 Bit True-
	                     * Color vor. 3 Byte pro Pixel, Intel-Format:
	                     *  first  | second | third
	                     * bbbbbbbb gggggggg rrrrrrrr
	                     *
	                     * Die 'eigentuemiliche' Zahlenformat-
	                     * kombination ist ein Zugestndnis an
	                     * die Hardware des Falcon030 !
	                     * Da es aber von ATARI keine 24bit Grafik
	                     * gibt und Grafikkarten 'normalerweise' ;-)
	                     * das Intelzahlenformat benutzen, wurde
	                     * dieses aus Geschwindigkeitsgrnden bei
	                     * True-Color gewhlt.
	                     *
	                     * WICHTIG !!!
	                     * Alle Zeilen sind 16 Pixel-Aligned! Auch
	                     * wenn dieses ab 8 Bildebenen unsinnig
	                     * klingen mag, es ist von Vorteil, da so
	                     * oft 'automatisch' das gerteabhngige
	                     * Format von  Grafikkarten vorliegt.
	                     * Das spart bei der Konvertierung viel
	                     * Zeit. (Auch wenn es etwas zu Lasten
	                     * des Verarbeitungskomforts und Speicher-
	                     * bedarfs geht..)
	                     */
} IBMR;					/* Internal BitMap Representation */



/* VEKTORGRAFIK *
 *
 * GEM-Metafiles haben drei Nachteile bei der Ausgabe via VDI die
 * mit dem 'Compact-VDI'-Format beseitigt werden:
 * - alle Werte liegen im Intel-Zahlenformat vor
 * - Funktionsnummer treten auf, die nicht vom Bildschirmtreiber
 *   verstanden werden (Sub-Objekte etc.)
 * - Punkte mssen ziemlich umstndlich durch Befehlsinterpretation
 *   auf ihre Zieldimension umgerechnet werden.
 *
 * Das CVDI-Dateiformat hat folgenden Aufbau (alle Zahlen im
 * Motorola-Format!!!):
 */
 
typedef struct _cvdi_
{
  LONG	identifier;			/* 'CVDI' */
  WORD	headlen;			/* Headerlnge / Versionserkennung (1.0 = 60 Bytes) */
  BYTE	name[14];			/* Name der Grafik (nullterminierter String) */
  struct _cvdi_	*next;		/* Nchste Grafik oder NULL */
  WORD	xsize;				/* Breite der Grafik */
  WORD	ysize;				/* Hhe der Grafik */
  LONG	spcoffset;			/* Byte-Offset zu den Weiten/Hheninformationen... */
  LONG	spccount;			/* Anzahl der Special-!WORDS! */
  LONG	ptscount;			/* Anzahl der Punkte (x,y = 2!!) */
  WORD	*userlistcolor;		/* Programmspezifische Zeiger zu spez. Infos... */
  WORD	*userlistpattern;
  WORD	*userlistfonttype;
  WORD	*userlistfontsize;
  WORD	*userlistfree;
/*WORD  graphic[...]           Vektorgrafikdaten */
} CVDI;					    /* Compact-Vector-DescriptIon (oder Chriskers-VDI ;-) ) */

#endif
