/*
 *	Vdi contrl functions library interface (part 2)
 *
 *	v_clrwk		 clear workstation
 *	v_updwk		 update workstation
 *	vst_load_fonts   load fonts
 *	vst_unload_fonts unload fonts
 *	vs_clip		 set clipping rect
 *
 *		++jrb	bammi@cadence.com
 *		modified: mj -- ntomczak@vm.ucs.ualberta.ca
 */
#include "common.h"

#ifdef __DEF_ALL__

#define L_v_clrwk
#define L_v_updwk
#define L_vst_load
#define L_vst_unlo
#define L_vs_clip

#endif /* __DEF_ALL__ */


#ifdef L_v_clrwk

/* clear workstation
 *	returns void
 */
void v_clrwk(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(3, 0, 0, 0), handle);
}
#endif /* L_v_clrwk */

#ifdef L_v_updwk

/* update workstation
 *	returns void
 */
void v_updwk(int handle)
{
    __vdi__(VDI_CONTRL_ENCODE(4, 0, 0, 0), handle);
}
#endif /* L_v_updwk */

#ifdef L_vst_load

/* load fonts as per assign.sys	(atari -- when will you fix this brain death??)
 *	returns # of additional font id's
 */
int vst_load_fonts(int handle, int select)
{
    _intin[0] = select;
    __vdi__(VDI_CONTRL_ENCODE(119, 0, 1, 0), handle);
    
    return (int)_intout[0];
}
#endif /* L_vst_load */

#ifdef L_vst_unlo

/* unload fonts	(what a joke -- atari please fix)
 *	returns void
 */
void vst_unload_fonts(int handle, int select)
{
    _intin[0] = select;
    __vdi__(VDI_CONTRL_ENCODE(120, 0, 1, 0), handle);
}
#endif /* L_vst_unlo */

#ifdef L_vs_clip

/* set clip rect
 * 	returns void
 */
void vs_clip(int handle, int clip_flag, int pxyarray[])
{
#ifdef __MSHORT__       /* we have 16 bit ints, just change vdi params */
    _vdiparams[2] = (void *) &pxyarray[0];
#else                   /* 32 bit ints - let's copy */
    register int i;
    
    for(i = 0; i < 4; i++)
	_ptsin[i] = pxyarray[i];
#endif

    _intin[0] = clip_flag;

    __vdi__(VDI_CONTRL_ENCODE(129, 2, 1, 0), handle);

#ifdef __MSHORT__
    _vdiparams[2] = (void *)&_ptsin[0]; /* restore vdi parameters */
#endif
}
#endif /* L_vs_clip */

/* -eof- */
