/* void * operator new [] (size_t), described in 17.3.3.6.  This function
   is used by C++ programs to allocate a block of memory for an array.  */

#include <types.h>

extern void * __builtin_new (size_t);

void *
__builtin_vec_new (size_t sz)
{
  return __builtin_new (sz);
}

/* operator delete [] (void *), described in 17.3.3.4.  This function is
   used by C++ programs to return to the free store a block of memory
   allocated as an array. */

extern void __builtin_delete (void *);

void
__builtin_vec_delete (void *ptr)
{
  __builtin_delete (ptr);
}

#define MESSAGE "pure virtual method called\n"
void
__pure_virtual ()
{
  write (2, MESSAGE, sizeof (MESSAGE) - 1);
  _exit (-1);
}
