DEFINITION MODULE SysVars;

(* Autor: Dirk Steins.                             Stand: 5.12.90  *)

(* Liste der Systemvariablen                                       *)
(* Bezeichnungen nach                                              *)
(*      Atari ST Profi Buch                                        *)
(*      Jankowski, Rabich, Reschke                                 *)
(*      Sybex-Verlag                                               *)

(* Mehr Informationen zu den Variablen gibt es ebenfalls im oben   *)
(* genanntem Werk.                                                 *)

(* Der Zugriff auf diese Variablen ist Supervisor-Modus, z.B.      *)
(* mittels der Super..-Funktionen aus dem Modul SysUtil1 mglich.  *)



CONST

    etv_timer   =   $400     ; (* Interrupt-Vektor des System-Timers *)
    etv_critic  =   $404     ; (* Vektor fr den Critical-Error-Handler *)
    etv_term    =   $408     ; (* Interrupt-Vektor fr Prozebeendigungen *)
    etv_xtra    =   $40c     ; (* 5 reservierte Vektoren *)
    memvalid    =   $420     ; (* = $752019f3 heit, Speicherkonfiguration *)
                               (* ist gltig (nach RESET)                  *)
                               (* siehe auch memval2, memval3 und memcntrl *)
    memcntrl    =   $424     ; (* Unteres Nibble des Schattenregisters des *)
                               (* Speicherkontroll-Registers ($ff8001)     *)
    resvalid    =   $426     ; (* = $31415926 => bei RESET ber resvector  *)
                               (*                springen                  *)
    resvector   =   $42a     ; (* siehe resvalid                           *)
    phystop     =   $42e     ; (* Zeigt auf 1. Byte ber phys. Ende des RAM *)
    _membot     =   $432     ; (* Anfang des unter GEMDOS freien Speichers  *)
    _memtop     =   $436     ; (* Ende   des unter GEMDOS freien Speichers  *)
    memval2     =   $43a     ; (* = $237698aa , gilt in Verbindung mit memval *)
    flock       =   $43e     ; (* fr Sperren des DMA-Zugriffs             *)
    seekrate    =   $440     ; (* Default-Werte fr die Floppy-Steprate    *)
    _timer_ms   =   $442     ; (* Zeit in ms, die zwischen zwei System-Timer *)
                               (* Interrupts liegt, normalerweise 20 ms    *)
    _fverify    =   $444     ; (* <> 0 : Verify nach Floppy-Schreiben *)
    _bootdev    =   $446     ; (* legt das Boot-Laufwerk nach dem nchstem *)
                               (* RESET fest                               *)
    palmode     =   $448     ; (* fr Fernsehnorm: 0=60Hz, 1=50Hz (PAL)    *)
    defshiftmd  =   $44a     ; (* Default Farb-Auflsung: 0=320*200,1=640*200*)
    sshiftmd    =   $44c     ; (* Shadow des Shifter-Modus-Registers       *)
    _v_bas_ad   =   $44e     ; (* Zeiger auf den Anfang des Bildspeichers  *)
    vblsem      =   $452     ; (* 1= VBL-Handler aktiviert                 *)
    nvbls       =   $454     ; (* Anzahl der Eintrge in _vblqueue         *)
    _vblqueue   =   $456     ; (* Zeiger auf Tabelle mit Adressen der VBL- *)
                               (* Routinen. 1. Vektor immer Mausbewegung!! *)
    colorptr    =   $45a     ; (* Zeiger auf Farbpalette nach nchstem VBL *)
                               (* (kann auch 0 sein, dann passiert nichts) *)
    screenpt    =   $45e     ; (* Zeiger auf Start des Bildschirms nach    *)
                               (* nchstem VBlank. (kann auch 0 sein)      *)
    _vbclock    =   $462     ; (* Anzahl der bereits erfolgten VBlanks     *)
    _frclock    =   $466     ; (* wie _vbclock, wird nur nicht durch vblsem *)
                               (* gestoppt                                 *)
    hdv_init    =   $46a     ; (* Vektor fr Init der logischen Drives     *)
    swv_vec     =   $46e     ; (* Vektor auf Routine bei Wechsel           *)
                               (* Mono <-> Color, normalerweise auf RESET  *)
    hdv_bpb     =   $472     ; (* Vektor fr GetBPB auf logischen Drives   *)
    hdv_rw      =   $476     ; (* Vektor fr Lesen/Schreiben auf log. Drives *)
    hdv_boot    =   $47a     ; (* Vek. fr Lesen des Bootsectors auf log. "  *)
    hdv_mediach =   $47e     ; (* Vek. fr Wechselstatus auf log. Drive    *)
    _cmdload    =   $482     ; (* <>0 : Lade COMMAND.COM statt GEM nach Boot *)
    conterm     =   $484     ; (* Attributbits fr CON:                    *)
    trp14ret    =   $486     ; (* Interne Rcksprungadresse bei TRAP #14   *)
    criticret   =   $48a     ; (* Interne Rcksprungadresse                *)
    themd       =   $48e     ; (* MD-Struktur des GEMDOS. Nicht ndern!!!  *)
    _____md     =   $49e     ; (* Platz fr weiteren MD                    *)
    savptr      =   $4a2     ; (* Zeiger auf BIOS Register-Zwischenspeicher *)
    _nflops     =   $4a6     ; (* Anzahl der angemeldeten Disk-Drives      *)
    con_state   =   $4a8     ; (* Interner zeiger fr Bildschirmausgaben   *)
    sav_row     =   $4ac     ; (* Speicher fr Cursor-Position         *)
    sav_context =   $4ae     ; (* Zeiger  auf Speicherbereich fr Register *)
                               (* und Stackteile bei Exceptions (norm. $380) *)
    _bufl       =   $4b2     ; (* Zwei Zeiger auf Buffer-Control-Blocks(BCB) *)
    _hz_200     =   $4ba     ; (* Bisherige Anzahl der 200Hz-Interrupts    *)
    the_env     =   $4be     ; (* Standard Environment Zeiger (unbenutzt)  *)
    _drvbits    =   $4c2     ; (* Bit-Vektor der angemeldeten Drives *)
    _dskbufp    =   $4c6     ; (* Zeiger auf 1k Buffer fr Disk-I/O  *)
    _autopath   =   $4ca     ; (* Zeiger auf Zugriffspfad fr AUTO-Ordner   *)
    _vbl_list   =   $4ce     ; (* Ursprngliche Liste der VBL-Routinen      *)
    _dumpflg    =   $4ee     ; (* Zhler fr ALT-HELP-Tastendrcke   *)
    _prtabt     =   $4f0     ; (* Flag fr Abbruch des Druckvorgangs *)
    _sysbase    =   $4f2     ; (* Zeiger auf Anfangsadresse des TOS-Headers *)
    _shell_p    =   $4f6     ; (* Zeiger auf Kommandoeingabe-Routine einer  *)
                               (* Command-Shell. Im ROM nicht benutzt       *)
    end_os      =   $4fa     ; (* Zeiger auf 1. nicht vom TOS benutztes Byte*)
    exec_os     =   $4fe     ; (* Zeiger auf Shell-Programm nach Init von   *)
                               (* GEMDOS. Normalerweise AES und Desktop     *)
    scr_dump    =   $502     ; (* Zeiger auf Hardcopy-Routine               *)
    
    (* Die folgenden Variablen sind erst ab TOS 1.2 (Blitter-TOS) vorhanden *)
    
    prv_lsto    =   $506     ; (* Zeiger auf Routine fr Status der Drucker-*)
                               (* Schnittstelle. Ebenfalls fr Hardcopy     *)
    prv_lst     =   $50a     ; (* Zeiger auf Routine fr Ausgabe auf Drucker-*)
                               (* Schnittstelle. Ebenfalls fr Hardcopy     *)
    prv_auxo    =   $50e     ; (* Zeiger auf Routine fr Status der RS232-  *)
                               (* Schnittstelle. Ebenfalls fr Hardcopy     *)
    prv_aux     =   $512     ; (* Zeiger auf Routine fr Ausgabe auf RS232- *)
                               (* Schnittstelle. Ebenfalls fr Hardcopy     *)
    pun_ptr     =   $516     ; (* Zeiger auf HDINFO-Struktur                *)
    memval3     =   $51A     ; (* Siehe memval und memval2. Magic=$5555aaaa *)
    _longframe  =   $59E     ; (* Stackoffset bei Exceptions                *)
    
    (* Die folgenden Variablen sind erst ab TOS 1.6 (STE, TT) vorhanden *)

    _p_cookies  =   $5A0     ; (* Zeiger auf CookieJar - ggf. Null          *)
    bell_hook   =   $5AC     ; (* Adresse fr 'Glocken'-Ton. Zeigt auf nor- *)
                               (* male Prozedur, die mit RTS enden mu.     *)
                               (* Kann Original-Routine aufrufen            *)
    kcl_hook    =   $5B0     ; (* Adresse fr 'Key-Click'-Ton.              *)

    fmemtop     =   $5A4     ; (* Memtop fr Fast-RAM (TT-only!)            *)
    fmemvalid   =   $5A8     ; (* Memvalid fr Fast-RAM. Magic nicht bekannt*)

END SysVars.
