 
 IMPLEMENTATION MODULE MathLib0;                         (*$ l-, r-, x+ *)
 (*$M- mu wg. TABLEs bleiben! *)
 
 (*----------------------------------------------------------------------------
!* Mathematik-Standardbibliothek fuer Atari-Realformat mit 48 bit Mantisse
!*----------------------------------------------------------------------------
!* Text - Version     : V#75378
!*----------------------------------------------------------------------------
!* jm                 : Juergen Mueller
!* TT                 : Thomas Tempelmann
!*----------------------------------------------------------------------------
!* Datum     Version  Autor  Bemerkung (Arbeitsbericht)
!*----------------------------------------------------------------------------
!* 05.12.84  1.0      --     Grundversion
!* 16.05.85  1.1      jm     Korrektur fuer sin (0.), cos (pi/2.), tan (0.)
!* 16.10.85  1.2      TT     bei Runtimefehlern wird nun Adr. der aufrufenden
!*                           Procedure an TRAP-Routine uebergeben; nur nicht,
!*                           wenn Fehler in Proc. von Runtime auftritt.
!* 15.04.86  2.0      jm     erweiterte Definition implementiert;
!*                           sqrt-Funktion nach ?? uebernommen.
!* 27.07.86  2.1      jm     atanh in artanh umbenannt;
!*                           bessere Implementation von sinh, cosh.
!* 22.11.86  3.0      jm     neues Realformat (mit Signed Exponent)
!*                           Tabellen noch nicht umgestellt!
!* 16.03.87  3.1      jm     sqrt (0.0) korrigiert;
!*                           Umstellung des Realformats weiter
!* 14.06.87  3.2      jm     Realformat fertig umgestellt, noch keine Tests.
!*                           cpxn-Routine korrigiert
!* 16.06.87  3.3      jm     AdreReg-Belegung jetzt Atari-Konvention
!* 19.06.87  3.4      jm     Korrekturen in fraction, sin, PwrOfTwo
!* 08.07.87  3.4      TT     Fehlermeldungen korrigiert; Register gerettet
!* 29.08.87  3.4      TT     fraction: kein Absturz, wenn Expon.=0
!* 10.09.87  3.4      TT     pi, e als Funktionen
!* 26.10.87  3.5      jm     CallExc bergibt gltige String-Adr;
!*                           Continue nach Fehlern jetzt berall mglich
!* 27.10.87  3.5      jm     real und entier zur Wandlung REAL <> LONGINT.
!*                           CallExc meldet Fehler 'callercaused';
!*                           CallExc-Aufrufer mit Dummy A5-Link
!* 30.10.87  3.5      TT     pi, e als Variable
!* 24.05.88  3.6      TT     Fraction korrekt bei x.0 - Werten
!* 27.06.88  3.7      TT     expadd/expadd2-Variablen vertauscht -> alle Ex-
!*                           ponentialfunktionen.
!* 13.08.88  3.8      TT     $M- Option, da sonst zw. Tables ProcSym stehen,
!*                           was zu Fehlern bei log-Funktionen (u.a.?) fhrte.
!* 19.01.89  3.9      TT     68881 Support (von MR, 26.8.88).
!* 20.02.89  3.10     TT     Alle REAL-Konstante in Modulbody verlegt.
!* 15.06.89           TT     Include-File f. Prozessoren
!* 16.06.89  3.11     TT     Alle REAL-Konsts, die f. beide Formate verw.
!*                           werden, werden im Body korrekt zugewiesen;
!*                           Error-Behandlung berarbeitet f. FPU
!* 07.05.90  3.12     TT     Comp V4-Anpassung, ErrBase wird nicht mehr impor-
!*                           tiert (CallExc durch TRAP ersetzt)
!* 28.05.90  3.13     TT     Oops - $M- fehlte wieder, wie kam denn das?!
!* 01.06.90           TT     entier f. FPU korrigiert (kein allg. Error mehr)
!* 18.12.90  3.14     TT     int,expM1,lnP1,sincos implementiert
!* 20.02.91  3.15     TT     fpstat-Abfragen fr Sync. mit schneller CPU
!* 27.03.91  3.16     TT     'entier' f. TT-FPU korrigiert (verga UNLK, wenn
!*                           berlauf); ST-FPU-Routinen korrigiert.
!* 18.04.91  3.17     TT     'power' & 'logar' fr M68881 in Assembler.
!*                           exp/pwrOfTwo/pwrOfTen melden keinen Overflow mehr
!*                           bei bestimmten negativen Argumenten, sondern immer
!*                           Null.
!* 27.03.92  3.18     TT     ld,ln,log erzeugten bei vollst. Optimierung falsche
!*                           Ergebnisse, weil die Tables teilweise wegoptimiert
!*                           wurden -> Dummy-Access auf alle bentigten Tables
!*                           hinzugefgt.
!* 08.02.94  3.19     TT     Kein Byte-Zugriff mehr auf fpstat+1 wg. STE.
!*----------------------------------------------------------------------------
!*)
 
 FROM MOSGlobals IMPORT Overflow, OutOfRange;
 FROM SFP004 IMPORT FPUError;
 FROM SYSTEM IMPORT ASSEMBLER;
 
 (*$I FPU.CNF *)
 
 CONST IEEE   = M68881 OR A68881;
&Soft   = NOT IEEE;
 
 (* --------  Zwischenspeicher, Tabellen  --------- *)
 
 VAR     pi2: LONGREAL;
(piDiv180: LONGREAL;
(invPiDiv180: LONGREAL;
(half: LONGREAL;
 
 (*$? A68881:
 CONST
(fpstat  =  $fffa40;       (* Response word of MC68881 read *)
(fpcmd   =  $fffa4a;       (* Command  word of MC68881 write *)
(fpop    =  $fffa50;       (* Operand  long of MC68881 read/write *)
 
(A2stat  =  0;             (* Response word of MC68881 read *)
(A2cmd   =  10;            (* Command  word of MC68881 write *)
(A2op    =  16;            (* Operand  long of MC68881 read/write *)
 *)
 
 (*$? Soft:
 VAR      fpu: RECORD a,b:LONGCARD END;
)fpt: RECORD a,b:LONGCARD END;
 
 
 TABLE.L fptwo: $00128000;
 
 TABLE.L sqr2: $000AB504,$F333F9DE;
(logk: $000B8000,$00000000;
'fpone: $000A8000,$00000000,
.$FFF2FA61,$18DC43A5,
.$FFFA85C8,$07A095A8,
.$FFFAA428,$9100003A,
.$FFFAD30B,$A7EE2159,
.$000293BB,$628EF5FA,
.$0002F638,$4EE1CAE4,
.$0012B8AA,$3B295C18;
 
 TABLE.L tank: $FFFAA2F9,$836E4E44;
'tank1: $FEFAD967,$E1E426B5,
.$FF1A9C3D,$CBC63642,
.$FF3AA369,$61F9A940,
.$FF5AA2F5,$68557947,
.$FF7AA2FA,$50DA798D,
.$FF9AA2FF,$FC90F626,
.$FFBAA335,$E33C201E,
.$FFDAA55D,$E7312DAE,
.$FFFAC90F,$DAA22169;
 
 TABLE.L atnk: $FFEBB5AB,$6364E40E,
.$FFEAE381,$AEE4C3E4,
.$FFF39249,$1C8532D1,
.$FFF2CCCC,$CCC81F2E,
.$FFFBAAAA,$AAAAAA2B,
.$000A8000,$00000000;
(
(x1:   $FFEAC9B5,$DC62D96D,
.$001AA0DF,$F712123C,
.$002AD231,$718DED74,
.$FFF2C90F,$DAA22169,
.$FFFA9B50,$41AAE31F,
.$00129A82,$7999FCEF,
.$001ADA82,$7999FCEF,
.$FFFAC90F,$DAA22169,
.$000288D5,$B8C841A7,
.$000ABF90,$C712D3A3,
.$0012CF59,$5AEEA7CA,
.$000296CB,$E3F9990F,
.$0002D218,$01572142,
.$000A8000,$00000000,
.$00128000,$00000000,
.$0002C90F,$DAA22169;
(cosk: $000AC90F,$DAA22169;
 
 TABLE.L sink: $FFF2A2F9,$836E4E44,
.$FF13B131,$3233A218,
.$FF42F44E,$7501852C,
.$FF73F183,$11E19C26,
.$FFA2A83C,$1924E79B,
.$FFCB9969,$6670BE99,
.$FFEAA335,$E33BA883,
.$0003A55D,$E7312DEB,
.$000AC90F,$DAA22169;
 
 TABLE.L expk: $000A85AA,$C367CC48,
.$000A8B95,$C1E3EA8C,
.$000A91C3,$D373AB12,
.$000A9837,$F0518DB9,
.$000A9EF5,$326091A1,
.$000AA5FE,$D6A9B151,
.$000AAD58,$3EEA42A1,
.$000AB504,$F333F9DE,
.$000ABD08,$A39F580C,
.$000AC567,$2A115507,
.$000ACE24,$8C151F85,
.$000AD744,$FCCAD69D,
.$000AE0CC,$DEEC2A95,
.$000AEAC0,$C6E7DD24,
.$000AF525,$7D152487;
.
'expk2: $FFAA8B70,$00000000,
.$FFBAABBF,$80000000,
.$FFD29D9C,$CC200000,
.$FFE2E358,$36210000,
.$FFF2F5FD,$F00C0800,
.$0002B172,$17F7CD00,
.$000A8000,$00000000;
 
 VAR     logx: CARDINAL;
&SinSgn: CARDINAL;
&sercnt: CARDINAL;
&expadd: CARDINAL; expadd2: CARDINAL; (* werden auch als Long verwendet! *)
 
 
 (* --------  interne Funktionen  --------- *)
 
 PROCEDURE @RMUL;
"BEGIN
$ASSEMBLER
(MOVE.L  A0,-(A7)
(SUBQ.L  #8,A3
(MOVE.L  A3,A0
(LEA     -8(A3),A1
(JSR     @LMUL
(MOVE.L  (A7)+,A0
$END
"END @RMUL;
 
 PROCEDURE @RADD;
"BEGIN
$ASSEMBLER
(MOVE.L  A0,-(A7)
(SUBQ.L  #8,A3
(MOVE.L  A3,A0
(LEA     -8(A3),A1
(JSR     @LADD
(MOVE.L  (A7)+,A0
$END
"END @RADD;
 
 PROCEDURE rzer;
"BEGIN
$ASSEMBLER
&CLR.L -8(A3)
&CLR.L -4(A3)
$END
"END rzer;
 
 PROCEDURE fpsub;
"BEGIN
$ASSEMBLER
&TST.W -16(A3)
&BEQ   z
&BCHG  #0,-15(A3)
"z   JMP   @RADD
$END
"END fpsub;
"
 PROCEDURE fpdiv;  (* -(A3) / -(A3) -> (A3)+ *)
"BEGIN
$ASSEMBLER
(MOVE.L  A0,-(A7)
(SUBQ.L  #8,A3
(MOVE.L  A3,A1
(SUBQ.L  #8,A3
(MOVE.L  A3,A0
(JSR     @LDIV        (*  "a / b"   (A1),(A0) -> (A1) *)
(LEA     8(A3),A1
(MOVE.L  (A1)+,(A3)+
(MOVE.L  (A1)+,(A3)+
(MOVE.L  (A7)+,A0
$END
"END fpdiv;
$
 PROCEDURE pullfpu;
"BEGIN
$ASSEMBLER
&LEA     fpt,A1
&MOVE.L  -(A3),-(A1)
&MOVE.L  -(A3),-(A1)
$END
"END pullfpu;
 
 PROCEDURE getfpu;
"BEGIN
$ASSEMBLER
&LEA     fpu,A1
&MOVE.L  -8(A3),(A1)+
&MOVE.L  -4(A3),(A1)+
$END
"END getfpu;
"
 PROCEDURE cmpm1;
"(* Mantisse der Zahl auf (A3) mit (A0)+ vergleichen *)
"BEGIN
$ASSEMBLER
&MOVE.L  -6(A3),D0
&CMP.L   (A0)+,D0
&BNE     NOTEQL
&MOVE.W  -2(A3),D0
&CMP.W   (A0),D0
%NOTEQL
$END
"END cmpm1;
&
 PROCEDURE cpxn; (* ? *)  (* wird nur v. arctan verw. *)
"BEGIN
$ASSEMBLER
&ADD.L   D6,D7
&MOVE.L  D7,A0
&
&; so ist der Vergleich hoffentlich richtig:
&
&MOVE.W  -8(A3),D0
&CMP.W   (A0)+,D0
&BNE     NOTEQL
&MOVE.L  -6(A3),D0
&CMP.L   (A0)+,D0
&BNE     NOTEQL
&MOVE.W  -2(A3),D0
&CMP.W   (A0)+,D0
&
&; und so ist er bestimmt falsch:
&
&(*
&MOVE.W  -8(A3),D0
&CMP.W   (A0)+,D0
&BNE     NOTEQL
&MOVE.W  (A0)+,D0
&CMP.W   -8(A3),D0
&BNE     NOTEQL
&MOVE.L  (A0)+,D0
&CMP.L   -6(A3),D0
&BNE     NOTEQL
&MOVE.W  (A0),D0
&CMP.W   -2(A3),D0
&*)
&
%NOTEQL
$END
"END cpxn;
"
 PROCEDURE series;
"(* Polynomentwicklung nach dem Hornerschema;
%(A0) zeigt auf Koeffizienten-Tabelle,
%fpt enthaelt Variable,
%sercnt enthaelt Grad des Polynoms.       *)
"BEGIN
$ASSEMBLER
+MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     @RMUL
+BRA     SER2
#SER1    LEA     fpt,A1
+MOVE.L  (A1)+,(A3)+
+MOVE.L  (A1)+,(A3)+
+JSR     @RMUL
#SER2    MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     @RADD
+SUBQ.B  #1,sercnt
+BNE     SER1
$END
"END series;
 
 
 PROCEDURE fpz;  (* kopiert TOS nach fpt *)
"BEGIN
$ASSEMBLER
&LEA     fpt,A1
&MOVE.L  -8(A3),(A1)+
&MOVE.L  -4(A3),(A1)+
$END
"END fpz;
+
 PROCEDURE fpsqu;
"(* kopiert TOS nach fpu, quadriert TOS, bringt Ergebnis nach fpt *)
"BEGIN
$ASSEMBLER
&LEA     fpu,A1
&MOVE.L  -8(A3),(A1)+
&MOVE.L  -4(A3),(A1)+
&MOVE.L  -8(A3),(A3)+
&MOVE.L  -8(A3),(A3)+
&JSR     @RMUL
&JMP     fpz
$END
"END fpsqu;
#
 
 PROCEDURE sersqu;        (* berechnet TOS * Polynom in TOS^2 *)
"BEGIN
$ASSEMBLER
+JSR     fpsqu
+JSR     series
+LEA     fpu,A1
+MOVE.L  (A1)+,(A3)+
+MOVE.L  (A1)+,(A3)+
+JMP     @RMUL
$END
"END sersqu;
 
"(* Ende des Conditionals f. Softreals *)
 *)
 
 (*$? A68881:
 PROCEDURE DoDouble;
 (* Auf dem Stack befindet sich ein LONGREAL und mu auch wieder als Ergebnis drauf*)
 BEGIN
"ASSEMBLER
(MOVEA.W #$FA40,A2
"DoDl1 MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(SUBQ.B  #2,D0
(BNE     DoDErr
(MOVE.W  D1,A2cmd(A2)
(TST.W   (A2)
(MOVE.L  -8(A3),A2op(A2)
(TST.W   (A2)
(MOVE.L  -(A3),A2op(A2)
(SUBQ.L  #4,A3
(TST.W   (A2)
(MOVE.W  #$7400,A2cmd(A2)
"DoDl2 MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl2
(CMPI.B  #8,D0
(BNE     DoDErr
(; Ergebnis abholen
(MOVE.L  A2op(A2),(A3)+
(TST.W   (A2)
(MOVE.L  A2op(A2),(A3)+
(CMPI.W  #$0802,(A2)
(BNE     DoDErr2
(RTS
!DoDErr2
(SUBQ.L  #8,A3
!DoDErr LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   (A3)+
(CLR.L   (A3)+
"END;
 END DoDouble;
 *)
 
 
 
 (* --------  exportierte Funktionen, Assembler  --------- *)
 
 PROCEDURE ld (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
+LINK    A5,#0
+MOVE.W  -8(A3),D0
+BEQ.L   rErr         ;Argument Null
+BTST    #0,D0
+BNE.L   rErr         ;Argument negativ
+ASR.W   #3,D0
+MOVE.W  D0,logx      ;logx enthaelt Argument-Exponent als Integer
+MOVE.W  #2,-8(A3)    ;spaeterer Exponent
+LEA     sqr2,A0
+ADDQ.L  #2,A0
+JSR     cmpm1
+BEQ     LOG2A
+BPL     LOG2A
+ADDQ.W  #8,-8(A3)    ;spaeterer Exponent
+SUBQ.W  #1,logx      ;dec (logx)
#LOG2A   JSR     fpz          ;Argument -> fpt
+MOVE    fpone,D0     ;Dummy-Zugriff, um Optimierung zu verhindern
+LEA     logk,A0
+MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     @RADD
+JSR     pullfpu
+LEA     fpt,A1
+MOVE.L  (A1)+,(A3)+
+MOVE.L  (A1)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     @RADD
+LEA     fpu,A1
+MOVE.L  (A1)+,(A3)+
+MOVE.L  (A1)+,(A3)+
+JSR     fpdiv
+MOVE.B  #6,sercnt
+JSR     sersqu
+MOVE.W  logx,D1
+BEQ     LGEXIT
+BMI     LGNEG
+MOVE.W  #$0082,D0    ;Exponent 16
+
+;Argument-Exp grer Null: Ergebnis-Exp berechnen
+; Argument-Exponent wird zur Mantisse gemacht
+
#LOG2B   SUBQ.W  #8,D0        ;mit entspr. Exponenten-Korrektur..
+ASL.W   #1,D1        ;  .. linksbuendig machen
+BPL     LOG2B
+MOVE.W  D0,(A3)+
+MOVE.W  D1,(A3)+
+CLR.L   (A3)+
+JSR     @RADD
+BRA     LGEXIT
#LGNEG   MOVE.W  #$0083,D0    ;Exponent 16, negativ
+NEG.W   D1
+BRA     LOG2B
#rErr    SUBQ.L  #8,A3
+TRAP    #6
+DC.W    OutOfRange-$4000
+CLR.L   (A3)+
+CLR.L   (A3)+
#LGEXIT  UNLK    A5
#*)
#(*$? A68881:
+MOVE.W  #$5416,D1
+JMP     DoDouble
#*)
$(*$? M68881:
(FLOG2.D -(A3),FP0
(FMOVE.D FP0,(A3)+
$*)
$END
"END ld;
 
 PROCEDURE ln (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
(JSR    ld
(MOVE.L #$0002B172,(A3)+
(MOVE.L #$17F7D1CF,(A3)+
(JMP    @RMUL
$*)
$(*$? A68881:
(MOVE.W  #$5414,D1
(JMP     DoDouble
$*)
$(*$? M68881:
(FLOGN.D -(A3),FP0
(FMOVE.D FP0,(A3)+
$*)
$END
"END ln;
"
 PROCEDURE log (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
(JSR    ld
(MOVE.L #$FFFA9A20,(A3)+
(MOVE.L #$9A84FBD0,(A3)+
(JMP    @RMUL
$*)
$(*$? A68881:
(MOVE.W  #$5415,D1
(JMP     DoDouble
$*)
$(*$? M68881:
(FLOG10.D -(A3),FP0
(FMOVE.D FP0,(A3)+
$*)
$END
"END log;
"
 PROCEDURE fraction (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
+MOVEM.L D4-D5,-(A7)
+MOVE.W  -8(A3),D2
+BEQ.L   RZERO
+BMI.L   FracX        ;Exponent < Null: nur Nachkommastellen
+MOVE.W  D2,D1
+ANDI.W  #$FFF8,D2
+BEQ.L   FracX        ;Exponent = Null: nur Nachkommastellen
+CMPI.W  #$0138,D2    ;Exponent > 39 ?   nur Vorkommastellen
+BHI.L   RZERO
+CMPI.W  #$80,D2      ;Exponent <= 16 ?
+BLS     UND16
+CMPI.W  #$100,D2     ;Exponent <= 32 ?
+BLS     UND32
+SUBI.W  #$100,D2
+CLR.W   D5
+MOVE.W  -2(A3),D4
+LSL.W   D2,D4
+SWAP    D4
+CLR.W   D4
+BRA     FRO
#UND32   SUBI.W  #$80,D2
+CLR.W   D5
+MOVE.L  -4(A3),D4
+LSL.L   D2,D4
+BRA     FRO
#UND16   MOVE.L  -6(A3),D4
+MOVE.W  -2(A3),D5
#UND16A  LSL.W   #1,D5
+ROXL.L  #1,D4
+SUBQ.W  #8,D2
+BNE     UND16A
#FRO     SUBQ.L  #8,A3
+AND.W   #3,D1        ;Vorzeichen und #0-Bit
+MOVE.W  D1,(A3)
+TST.L   D4
+BMI.L   SUBEX        ;Mantisse ist schon linksbuendig
+
+; Mantisse wieder linksbuendig machen
+
+CLR.W   D1
+SUBQ.W  #8,(A3)      ;erst mal 'ne 1 Bit-Verschiebung (reicht oft)
+LSL.W   #1,D5
+ROXL.L  #1,D4
+BMI.L   SUBEX
+BNE     NORM1
+
+MOVEQ   #32,D1       ;mu mindestens 32 Bit verchieben
+MOVE.W  D5,D4
+BEQ.L   PZERO
+BMI     SHW1
#SHW     ADDQ.W  #1,D1
+LSL.W   #1,D4
+BPL     SHW
#SHW1    SWAP    D4
+CLR.L   D5
+BRA     SLT16X
"
#NORM1   CMPI.L  #$10000,D4
+BCC     SLT16A
+MOVEQ   #16,D1       ;mu mindestens 16 Bit verchieben
+SWAP    D4
+MOVE.W  D5,D4
+MOVE.L  D4,D0
+BMI     SHL1
#SHL     ADDQ.W  #1,D1
+LSL.L   #1,D4
+BPL     SHL
#SHL1    CLR.W   D5
+BRA     SLT16X
"
#SLT16A  ADDQ.W  #1,D1        ;mu < 16 bit verschieben
+LSL.W   #1,D5
+ROXL.L  #1,D4
+BPL     SLT16A
#SLT16X  LSL.W   #3,D1
+SUB.W   D1,(A3)
"
#SUBEX   ADDQ.L  #2,A3
+MOVE.L  D4,(A3)+
+MOVE.W  D5,(A3)+
#FracX   MOVEM.L (A7)+,D4-D5
+RTS
#PZERO   ADDQ.L  #8,A3  (* push zero *)
#RZERO   MOVEM.L (A7)+,D4-D5
+JMP     rzer
#*)
#(*$? M68881:
+FMOVE.D         -(A3),FP0   ; kein Runtime-Fehler mglich
+FINTRZ.D        (A3),FP1
+FSUB.X          FP1,FP0
+FMOVE.D         FP0,(A3)+
#*)
#(*$? A68881:
+; FMOVE.D         -(A3),FP0
%DoDl1 MOVE.W  fpstat,D0
+TST.B   D0
+BEQ     DoDl1
+MOVE.W  #$5400,fpcmd
+MOVE.W  fpstat,D0
+SUBQ.B  #8,D0
+BEQ     noError
+LINK    A5,#0
+JSR     FPUError
+UNLK    A5
+CLR.L   -4(A3)
+CLR.L   -8(A3)
+RTS
(noError
+MOVE.L  -8(A3),fpop
+TST.W   fpstat
+MOVE.L  -(A3),fpop
+TST.W   fpstat
+; FINTRZ.D        (A3),FP1
+MOVE.W  #$5483,fpcmd
#!entl2  MOVE.W  fpstat,D0
+TST.B   D0
+BEQ     entl2
+MOVE.L  -(A3),fpop
+TST.W   fpstat
+MOVE.L  4(A3),fpop
+TST.W   fpstat
+; FSUB.X          FP1,FP0
+MOVE.W  #$0428,fpcmd
#!entl3  MOVE.W  fpstat,D0
+TST.B   D0
+BEQ     entl3
+; FMOVE.D         FP0,(A3)+
+MOVE.W  #$7400,fpcmd
#!entl4  MOVE.W  fpstat,D0
+TST.B   D0
+BEQ     entl4
+MOVE.L  fpop,(A3)+
+TST.W   fpstat
+MOVE.L  fpop,(A3)+
+TST.W   fpstat
#*)
$END
"END fraction;
"
 PROCEDURE sin (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
+MOVE.B  -7(A3),SinSgn        ;Vorzeichen retten
+BCLR    #0,-7(A3)            ; und im Exponenten loeschen
+LEA     sink,A0
+MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     @RMUL
+JSR     fraction
+TST.W   -8(A3)          ;NULL?
+BEQ     SINX            ;DAS WAR'S DANN WOHL
+ADDI.W  #16,-8(A3)      ;addiere 2 zum Exponenten
+CMPI.W  #16,-8(A3)
+BLT     UNDTWO
+BCHG    #0,SinSgn
+MOVE.L  #$00138000,(A3)+ ;- 0.5 * 2 ^ 2
+CLR.L   (A3)+
+JSR     @RADD
#UNDTWO  CMPI.W  #$0008,-8(A3)
+BLT     UND1
+MOVE.L  fptwo,(A3)+
+CLR.L   (A3)+
+JSR     fpsub
#UND1    MOVE.B  #7,sercnt
+JSR     sersqu
+BTST    #0,SinSgn
+BEQ     SINX
+BSET    #0,-7(A3)
#SINX
#*)
#(*$? M68881:
(FSIN.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
#*)
#(*$? A68881:
(MOVE.W  #$540e,D1
(JMP     DoDouble
#*)
$END
"END sin;
"
 PROCEDURE sqrt (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
)LINK     A5,#0
)MOVEM.L  D3-D7,-(A7)
)MOVE.L   -(A3),D4
)MOVE.L   -(A3),D0
)
'EXPONENT
)SWAP     D0
)MOVE.W   D0,D2                ; EXPONENT ZWISCHENSPEICHERN
G; FUER TEST, OB GERADE
)BEQ.L    zero                 ; Zahl ist Null
)SUBQ.W   #8,D0
)ASR.W    #1,D0                ; Exponenten halbieren
)BCS.L    ERROR                ; Zahl ist negativ
)ADDQ.W   #8,D0
)AND.W    #$FFF8,D0
)BSET     #1,D0
)
)MOVE.W   D0,D7                ; neuen Exp in D7
)SWAP     D4
)MOVE.W   D4,D0
)CLR.W    D4
)BTST     #3,D2                ; EXPONENT GERADE ?
)BEQ      INITIALISIEREN       ;   NEIN : KEIN SHIFT, WEITER
)LSR.L    #1,D0                ;   JA   : A(1)..A(48) EINE STEL-
)ROXR.L   #1,D4                ;          LE RECHTS SCHIEBEN
)
'INITIALISIEREN
)MOVEQ.L  #0,D2
)MOVEQ.L  #0,D3
)MOVEQ.L  #0,D6
)MOVEQ.L  #1,D1                ; D[0] = 01
)MOVEQ    #22,D5
)
'VORBER
)LSL.L    #1,D4                ;
)ROXL.L   #1,D0                ;
)ROXL.W   #1,D2                ;
)LSL.L    #1,D4                ; R[1] = A(1)A(2) - D[0]
)ROXL.L   #1,D0                ;
)ROXL.W   #1,D2                ;
)SUB.L    D1,D2                ;
)
'THENTEIL
)LSL.L    #1,D3                ; ERGEBNIS FUER NAECHSTE STELLE FREI
)ADDQ.W   #1,D3                ; + NEUE ZIFFER = 1
)
)LSL.L    #1,D4                ;
)ROXL.L   #1,D0                ;
)ROXL.L   #1,D2                ; I - TEN REST
)LSL.L    #1,D4                ; BERECHNEN
)ROXL.L   #1,D0                ;
)ROXL.L   #1,D2                ;
)
)MOVE.L   D3,D1                ;   D[i]
)LSL.L    #2,D1                ;   BERECH -
)ADDQ.W   #1,D1                ;   NEN
)
)DBF      D5,WEITER1
)BRA      FERTIG
'WEITER1
)SUB.L    D1,D2
)BPL      THENTEIL
)
'ELSETEIL
)LSL.L    #1,D3                ; ERGEBNIS FUER NAECHSTE STELLE FREI
G; + NEUE ZIFFER = 0
G
)LSL.L    #1,D4                ;
)ROXL.L   #1,D0                ;
)ROXL.L   #1,D2                ; I - TEN REST
)LSL.L    #1,D4                ; BERECHNEN
)ROXL.L   #1,D0                ;
)ROXL.L   #1,D2                ;
)
)MOVE.L   D3,D1                ;   D[i]
)LSL.L    #2,D1                ;   BERECH -
)ADDQ.W   #3,D1                ;   NEN
)
)DBF      D5,WEITER2
)BRA      FERTIG
'WEITER2
)ADD.L    D1,D2
)BPL      THENTEIL
)BRA      ELSETEIL
)
'FERTIG
)BTST     #1,D1
)BNE      D2Korrigieren
)SUB.L    D1,D2
)BRA      Restliche24Ziffern
)
'D2Korrigieren
)ADD.L    D1,D2
)
'Restliche24Ziffern
)MOVEQ    #23,D5
)TST.L    D2
)BMI      ZiffernAddieren
)LSL.L    #1,D3
)ADDQ.W   #1,D3
)SUB.L    D3,D2
)BRA      Sprungverteiler
)
'ZiffernAddieren
)LSL.L    #1,D3
)ADD.L    D3,D2
)
'Sprungverteiler
)TST.L    D2
)BMI      RestKleinerNull
)
'DIVISION
)LSL.L    #1,D6
)ADDQ.W   #1,D6
)ASL.L    #1,D2
)DBF      D5,WEITER3
)BRA      ErgebnisSpeichern
'WEITER3
)SUB.L    D3,D2
)BPL      DIVISION
)
'RestKleinerNull
)LSL.L    #1,D6
)ADD.L    D3,D2
)ASL.L    #1,D2
)DBF      D5,WEITER4
)BRA      ErgebnisSpeichern
'WEITER4
)SUB.L    D3,D2
)BPL      DIVISION
)BRA      RestKleinerNull
)
'ErgebnisSpeichern
)MOVEQ    #0,D1
)MOVEQ.L  #9,D2
)ADD.B    D3,D1
)ROXR.L   D2,D1
)ADD.L    D6,D1
)LSR.L    #8,D3
)MOVE.W   D3,D0
)BCLR     #31,D0
)
'Ergebnisuebergabe
)MOVE.W   D7,(A3)+
)MOVE.W   D0,(A3)+
)MOVE.L   D1,(A3)+
)MOVEM.L  (A7)+,D3-D7
)BRA      sqExit
&
'zero
)CLR.L    (A3)+
)CLR.L    (A3)+
)MOVEM.L  (A7)+,D3-D7
)BRA      sqExit
)
&ERROR
)MOVEM.L  (A7)+,D3-D7
)TRAP    #6
)DC.W    OutOfRange-$4000
)CLR.L    (A3)+
)CLR.L    (A3)+
&
&sqExit
)UNLK     A5
$*)
$(*$? M68881:
(FSQRT.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
#*)
$(*$? A68881:
(MOVE.W  #$5404,D1
(JMP     DoDouble
$*)
$END
"END sqrt;
 
 (* alte Version der Sqrt: NICHT UMGESTELLT AUF ATARI-REALS !
 
 PROCEDURE sqrt (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
+MOVE.W  -8(A3),D2
+BMI.L   RERR
+ANDI.W  #$1FFF,D2
+BEQ.L   RZERO
+MOVE.L  -6(A3),D7
+MOVE.W  #$1000,-8(A3)
+MOVE.W  D2,D3
+LSR.W   #1,D3
+BCC     EVNEXP
+SUBQ.W  #1,-8(A3)
+LSR.L   #1,D7
#EVNEXP  MOVE.W  #$0800,D3
+LSR.W   #1,D2
+ADDX.W  D3,D2
+MOVE.W  D2,logx
+MOVE.W  #$FFFF,D7
+MOVEQ   #3,D0
+MOVE.W  D7,D5
#SQL1    MOVE.L  D7,D6
+DIVU    D5,D6
+ADD.W   D6,D5
+ROXR.W  #1,D5
+DBF     D0,SQL1
+JSR     getfpu
+SUBQ.L  #8,A3
+MOVE.W  #$1000,(A3)+
+MOVE.W  D5,(A3)+
+CLR.L   (A3)+
+BSR     SQITER
+BSR     SQITER
+MOVE.W  logx,-8(A3)
+RTS
#SQITER  LEA     fpt,A1
+MOVE.L  -8(A3),(A1)+
+MOVE.L  -4(A3),(A1)+
+LEA     fpu,A1
+MOVE.L  (A1)+,(A3)+
+MOVE.L  (A1)+,(A3)+
+JSR     fpdiv
+LEA     fpt,A0
+MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     @RADD
+SUBQ.W  #1,-8(A3)
+RTS
#RERR    TRAP    #6
+DC.W    OutOfRange-$4000
+RTS
#RZERO   JMP     rzer
$END
"END sqrt;
 *)
 
 PROCEDURE tan (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
+LEA     tank,A0
+MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     @RMUL
+JSR     fraction
+MOVE.W  #0,A0
+MOVE.W  -8(A3),D1
+BEQ.L   NOTNEG           ;null: NIX ZU TUN
+MOVE.B  D1,SinSgn        ;Vorzeichen retten
+BCLR    #0,-7(A3)        ;  und im Exponenten loeschen
+TST.W   D1
+BMI     TUH              ;Argument < 0.5
+BCHG    #0,SinSgn
+MOVE.L  fpone,(A3)+
+CLR.L   (A3)+
+JSR     fpsub
+
+; 0 <= Argument <= 0.5
+
#TUH     CMPI.W  #$FFF8,-8(A3)   ;Exponent < -1 ?
+BLT     TUQ
+ADDQ.W  #2,A0
+MOVE.L  #$00028000,(A3)+
+CLR.L   (A3)+
+JSR     fpsub
"
+; 0 <= Argument <= 0.25
+
#TUQ     CMPI.W  #$FFF0,-8(A3)
+BLT     TUE
+ADDQ.W  #1,A0
+SUBQ.W  #8,-8(A3)
#TUE     ADDI.W  #24,-8(A3)   ;Exponenten um 3 erhhen
+MOVE.W  A0,expadd    ;Exponentenkorrektur (nicht 8fach!)
+LEA     tank1,A0
+MOVE.B  #8,sercnt
+JSR     sersqu
+LSR     expadd
+BCC     NOTRNG
+JSR     fpsqu
+MOVE.L  fpone,(A3)+
+CLR.L   (A3)+
+JSR     fpsub
+LEA     fpu,A0
+MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     fpdiv
+ADDQ.W  #8,-8(A3)
#NOTRNG  LSR     expadd
+BCC     NOTINV
+MOVE.L  fpone,(A3)+
+CLR.L   (A3)+
+JSR     fpdiv
#NOTINV  BTST    #0,SinSgn
+BEQ     NOTNEG
+BSET    #0,-7(A3)
#NOTNEG
#*)
#(*$? M68881:
(FTAN.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
#*)
#(*$? A68881:
(MOVE.W  #$540f,D1
(JMP     DoDouble
#*)
)END
"END tan;
"
 PROCEDURE pwrOfTwo (x: LONGREAL): LONGREAL; (* / ausfhrlichst testen! *)
"BEGIN
$ASSEMBLER
$(*$? Soft:
+LINK    A5,#0
+MOVE.B  -7(A3),SinSgn
+BCLR    #0,-7(A3)
+CLR.L   expadd
+MOVE.W  -8(A3),D0
+BEQ.L   XRONE
+ASR.W   #3,D0
+CMPI.W  #$FFFD,D0    ;Exp < -3 ?
+BLT     EXP2A
+MOVE.W  #12,D1
+SUB.W   D0,D1        ;EXP >= 12 ?
+BLE.L   EXOVFL
+MOVE.L  -6(A3),D2
+ADD.W   #16,D1       ;D1 >= 16
+LSR.L   D1,D2
+MOVE.L  D2,expadd    ;Highword mu Null sein
+ADDI.W  #32,-8(A3)   ;inc (Exponent, 4)
+JSR     fraction
+SUBI.W  #32,-8(A3)   ;dec (Exponent, 4)
#EXP2A   LEA     expk2,A0
+MOVE.B  #6,sercnt
+JSR     fpz
+JSR     series
+MOVE.L  expadd,D0
+LSR.L   #1,D0
+AND.W   #$FFF8,D0
+ADD.W   D0,-8(A3)
+MOVE.W  expadd2,D0
+ANDI.W  #$000F,D0
+BEQ     NOexpk
+SUBQ.W  #1,D0
+LSL.W   #3,D0
+LEA     expk,A0
+ADDA.W  D0,A0
+MOVE.L  (A0)+,(A3)+
+MOVE.L  (A0)+,(A3)+
+JSR     @RMUL
#NOexpk  BTST    #0,SinSgn
+BEQ     EXP2X
+MOVE.L  fpone,(A3)+
+CLR.L   (A3)+
+JSR     fpdiv
+BRA     EXP2X
#
#XRONE   SUBQ.L  #8,A3
+MOVE.L  fpone,(A3)+
+CLR.L   (A3)+
+BRA     EXP2X
#
#EXOVFL  BTST    #0,SinSgn
+BNE     RZERO
+SUBQ.L  #8,A3
+TRAP    #6
+DC.W    Overflow-$4000
+CLR.L   (A3)+
+CLR.L   (A3)+
+BRA     EXP2X
#
#RZERO   UNLK    A5
+JMP     rzer
#
#EXP2X   UNLK    A5
#*)
#(*$? M68881:
(FTWOTOX.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
#*)
#(*$? A68881:
(MOVE.W  #$5411,D1
(JMP     DoDouble
#*)
#END
"END pwrOfTwo;
 
 PROCEDURE pwrOfTen (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
$MOVE.L  #$0012D49A,(A3)+
$MOVE.L  #$784BCD1C,(A3)+
$JSR     @RMUL
$JMP     pwrOfTwo
$*)
$(*$? M68881:
(FTENTOX.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
#*)
$(*$? A68881:
(MOVE.W  #$5412,D1
(JMP     DoDouble
$*)
$END
"END pwrOfTen;
"
 PROCEDURE exp (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
$MOVE.L  #$000AB8AA,(A3)+
$MOVE.L  #$3B295C18,(A3)+
$JSR     @RMUL
$JMP     pwrOfTwo
$*)
$(*$? M68881:
(FETOX.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
#*)
$(*$? A68881:
(MOVE.W  #$5410,D1
(JMP     DoDouble
$*)
$END
"END exp;
+
 PROCEDURE arctan (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
$(*$? Soft:
,MOVEM.L D6-D7,-(A7)
,CLR.L   expadd
,MOVE.W  -8(A3),D0
,BEQ.L   RZERO
,MOVE.W  D0,SinSgn           ;! kompletter Exponent im SinSgn!
,BCLR    #0,-7(A3)
,CMPI.W  #$8,D0
,BLT     UNDONE
,MOVE.L  fpone,(A3)+         ;Argument > 1: Kehrwert nehmen
,CLR.L   (A3)+
,JSR     fpdiv
#UNDONE   MOVEQ   #32,D6
,LEA     x1,A0
,MOVE.L  A0,D7
,SUB.L   D6,D7
,JSR     cpxn
,BMI     X0
,JSR     cpxn
,BMI     XN
,JSR     cpxn
,BMI     XN
,JSR     cpxn
,BMI     XN
,ADD.L   D6,D7
#XN       SUBQ.L  #8,D7
,MOVE.L  D7,expadd
,MOVE.L  D7,A0
,SUBA.W  #16,A0
,MOVE.L  (A0)+,(A3)+
,MOVE.L  (A0)+,(A3)+
,JSR     @RADD
,MOVE.L  (A0)+,(A3)+
,MOVE.L  (A0)+,(A3)+
,JSR     fpdiv
,SUBA.W  #16,A0
,MOVE.L  (A0)+,(A3)+
,MOVE.L  (A0)+,(A3)+
,JSR     fpsub
#X0       MOVE.B  #5,sercnt
,LEA     atnk,A0
,JSR     sersqu
,MOVE.L  expadd,D7
,BEQ     NOPTR
,MOVE.L  D7,A0
,MOVE.L  (A0)+,(A3)+
,MOVE.L  (A0)+,(A3)+
,JSR     @RADD
#NOPTR    MOVE.W  SinSgn,D0
,CMPI.W  #$8,D0
,BLT     NOINV
,LEA     cosk,A0
,MOVE.L  (A0)+,(A3)+
,MOVE.L  (A0)+,(A3)+
,JSR     fpsub
#NOINV    MOVE.W  SinSgn,D0
,BTST    #0,D0
,BEQ     ATNX
,BCHG    #0,-7(A3)
,MOVEM.L (A7)+,D6-D7
,RTS
#RZERO    MOVEM.L (A7)+,D6-D7
,JMP     rzer
#ATNX     MOVEM.L (A7)+,D6-D7
#*)
#(*$? M68881:
(FATAN.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
#*)
#(*$? A68881:
(MOVE.W  #$540A,D1
(JMP     DoDouble
#*)
$END
"END arctan;
 
 (*$? A68881:
 
 PROCEDURE cos (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(MOVE.W  #$541D,D1
(JMP     DoDouble
$END;
"END cos;
 
 PROCEDURE arcsin (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(MOVE.W  #$540C,D1
(JMP     DoDouble
$END;
"END arcsin;
 
 PROCEDURE arccos (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(MOVE.W  #$541C,D1
(JMP     DoDouble
$END;
"END arccos;
"
 PROCEDURE sinh (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(MOVE.W  #$5402,D1
(JMP     DoDouble
$END;
"END sinh;
"
 PROCEDURE cosh (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(MOVE.W  #$5419,D1
(JMP     DoDouble
$END;
"END cosh;
 
 PROCEDURE tanh (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(MOVE.W  #$5409,D1
(JMP     DoDouble
$END;
"END tanh;
 
 PROCEDURE artanh (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(MOVE.W  #$540D,D1
(JMP     DoDouble
$END
"END artanh;
 
 PROCEDURE real     (x: LONGINT): LONGREAL;    (* Umwandlung LONGINT <> LONGREAL *)
"BEGIN
$ASSEMBLER
(MOVE.W  #$4000,fpcmd
(MOVE.W  fpstat,D0
(SUBQ.B  #4,D0
(BEQ     noError
(LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   -4(A3)
(CLR.L   (A3)+
(RTS
%noError
(MOVE.L  -(A3),fpop
(TST.W   fpstat
(MOVE.W  #$7400,fpcmd
 !rel2   MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     rel2
(MOVE.L  fpop,(A3)+
(TST.W   fpstat
(MOVE.L  fpop,(A3)+
(TST.W   fpstat
$END
"END real;
 
 PROCEDURE entier   (x: LONGREAL): LONGINT;
"BEGIN
$ASSEMBLER
(; !!! entier (-3.3) liefert -3. Sollte nicht -4 rauskommen?
(; FMOVE.D         -(A3),FP0
(MOVE.W  #$5400,fpcmd
(MOVE.W  fpstat,D0
(SUBQ.B  #8,D0
(BEQ     noError
(LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(SUBQ.L  #8,A3
(CLR.L   (A3)+
(RTS
%noError
(MOVE.L  -8(A3),fpop
(TST.W   fpstat
(MOVE.L  -(A3),fpop
(TST.W   fpstat
(; FMOVE.L         FP0,(A3)+
(MOVE.W  #$6000,fpcmd
 !entl2  MOVE.W  fpstat,D0
(TST.B   D0
(BEQ     entl2
(SUBQ.B  #4,D0
(BNE     err
(MOVE.L  fpop,-4(A3)
(TST.W   fpstat
(RTS
 err     LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   -4(A3)
$END
"END entier;
 
 PROCEDURE int      (x: LONGREAL): LONGREAL;    (* Vorkomma-Anteil von x   *)
"BEGIN
$ASSEMBLER
(;FINTRZ.D
(MOVE.W  #$5403,D1
(JMP     DoDouble
$END
"END int;
 
 PROCEDURE lnP1     (x: LONGREAL): LONGREAL;    (* log_e  (x+1) *)
"BEGIN
$ASSEMBLER
(;FLOGNP1.D
(MOVE.W  #$5406,D1
(JMP     DoDouble
$END
"END lnP1;
 
 PROCEDURE expM1    (x: LONGREAL): LONGREAL;    (*  e ^ (x-1) *)
"BEGIN
$ASSEMBLER
(;FETOXM1.D
(MOVE.W  #$5408,D1
(JMP     DoDouble
$END
"END expM1;
 
 PROCEDURE sincos   (x: LONGREAL; VAR sin, cos: LONGREAL); (* beide zugleich *)
"BEGIN
$ASSEMBLER
(MOVE.L      -(A3),A1
(MOVE.L      -(A3),A0
(; FSINCOS.D   -(A3),FP1:FP0
(MOVEA.W #$FA40,A2
(MOVE.W  #$5431,A2cmd(A2)
"DoDl1 MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl1
(MOVE.L  -8(A3),A2op(A2)
(TST.W   (A2)
(MOVE.L  -(A3),A2op(A2)
(SUBQ.L  #4,A3
(TST.W   (A2)
(MOVE.W  #$7400,A2cmd(A2)        ;FMOVE.D FP0,(A0)
"DoDl2 MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl2
(CMPI.B  #8,D0
(BNE     DoDErr
(; Ergebnis abholen
(MOVE.L  A2op(A2),(A0)+
(TST.W   (A2)
(MOVE.L  A2op(A2),(A0)
(CMPI.W  #$0802,(A2)
(BNE     DoDErr2
(MOVE.W  #$7480,A2cmd(A2)        ;FMOVE.D FP1,(A1)
"DoDl3 MOVE.W  (A2),D0
(TST.B   D0
(BEQ     DoDl3
(CMPI.B  #8,D0
(BNE     DoDErr
(; Ergebnis abholen
(MOVE.L  A2op(A2),(A1)+
(TST.W   (A2)
(MOVE.L  A2op(A2),(A1)
(CMPI.W  #$0802,(A2)
(BNE     DoDErr2
(RTS
!DoDErr2
(SUBQ.L  #8,A3
!DoDErr LINK    A5,#0
(JSR     FPUError
(UNLK    A5
(CLR.L   (A3)+
(CLR.L   (A3)+
$END
"END sincos;
 
"(* Ende des A68881-Conditionals *)
 *)
 
 (*$? M68881:
 PROCEDURE cos (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(FCOS.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
$END;
"END cos;
 
 PROCEDURE arcsin (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(FASIN.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
$END;
"END arcsin;
 
 PROCEDURE arccos (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(FACOS.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
$END;
"END arccos;
"
 PROCEDURE sinh (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(FSINH.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
$END;
"END sinh;
"
 PROCEDURE cosh (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(FCOSH.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
$END;
"END cosh;
 
 PROCEDURE tanh (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(FTANH.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
$END;
"END tanh;
 
 PROCEDURE artanh (x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(FATANH.D  -(A3),FP0
(FMOVE.D FP0,(A3)+
$END
"END artanh;
 
 PROCEDURE real     (x: LONGINT): LONGREAL;    (* Umwandlung LONGINT <> LONGREAL *)
"BEGIN
$ASSEMBLER
(FMOVE.L     -(A3),FP0   ; kein Runtime-Fehler mglich
(FMOVE.D     FP0,(A3)+
$END
"END real;
 
 PROCEDURE entier   (x: LONGREAL): LONGINT;
"BEGIN
$ASSEMBLER
(; !!! entier (-3.3) liefert -3. Sollte nicht -4 rauskommen?
(LINK            A5,#0
(FMOVE.D         -(A3),FP0
(FMOVE.L         FP0,(A3)+
((*
(FMOVE.L         FPSR,D0
(AND.B           #$40,D0
(BEQ             ok
(; JSR             checkFPStatus
(*)
 !ok     UNLK            A5
$END
"END entier;
 
 PROCEDURE int      (x: LONGREAL): LONGREAL;    (* Vorkomma-Anteil von x   *)
"BEGIN
$ASSEMBLER
(FINTRZ.D    -(A3),FP0   ; kein Runtime-Fehler mglich
(FMOVE.D     FP0,(A3)+
$END
"END int;
 
 PROCEDURE lnP1     (x: LONGREAL): LONGREAL;    (* log_e  (x+1) *)
"BEGIN
$ASSEMBLER
(FLOGNP1.D   -(A3),FP0
(FMOVE.D     FP0,(A3)+
$END
"END lnP1;
 
 PROCEDURE expM1    (x: LONGREAL): LONGREAL;    (*  e ^ (x-1) *)
"BEGIN
$ASSEMBLER
(FETOXM1.D   -(A3),FP0
(FMOVE.D     FP0,(A3)+
$END
"END expM1;
 
 PROCEDURE sincos   (x: LONGREAL; VAR sin, cos: LONGREAL); (* beide zugleich *)
"BEGIN
$ASSEMBLER
(MOVE.L      -(A3),A1
(MOVE.L      -(A3),A0
(FSINCOS.D   -(A3),FP1:FP0
(FMOVE.D     FP0,(A0)
(FMOVE.D     FP1,(A1)
$END
"END sincos;
 
 PROCEDURE logar(b, x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(FLOGN.D -(A3),FP0
(FLOGN.D -(A3),FP1
(FDIV.X  FP1,FP0
(FMOVE.D FP0,(A3)+
(UNLK    A5
$END
"END logar;
 
 PROCEDURE power(b, x: LONGREAL): LONGREAL;
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(FLOGN.D -16(A3),FP0
(FMUL.D  -(A3),FP0
(SUBQ.L  #8,A3
(FETOX.X FP0
(FMOVE.D FP0,(A3)+
(UNLK    A5
$END
"END power;
 
"(* Ende des M68881-Conditionals *)
 *)
 
 
 
 (*$ L+ --------  exportierte Funktionen, Modula  --------- *)
 
 
 (*$? NOT M68881:
 
 PROCEDURE logar (b, x: LONGREAL): LONGREAL;
"BEGIN
$IF (x > 0.0) & (b > 0.0) THEN
&RETURN ld (x) / ld (b)
$ELSE
&ASSEMBLER
(; RaiseError (OutOfRange,'',callerCaused,mayContinue);
(TRAP    #6
(DC.W    OutOfRange-$4000
&END;
&RETURN 0.
$END
"END logar;
 
 PROCEDURE power (b, x: LONGREAL): LONGREAL;
"BEGIN
$IF b = 0.0 THEN
&IF x > 0.0 THEN
(RETURN 0.0
&ELSE
(ASSEMBLER
*; RaiseError (OutOfRange,'',callerCaused,mayContinue);
*TRAP    #6
*DC.W    OutOfRange-$4000
(END;
(RETURN 0.
&END
$ELSIF b > 0.0 THEN
&RETURN exp (ln (b) * x)
$ELSIF fraction (x) = 0.0 THEN
&IF fraction (half * x) = 0.0 THEN
(RETURN exp (ln (-b) * x)
&ELSE
(RETURN -exp (ln (-b) * x)
&END
$ELSE
&ASSEMBLER
(; RaiseError (OutOfRange,'',callerCaused,mayContinue);
(TRAP    #6
(DC.W    OutOfRange-$4000
&END;
&RETURN 0.
$END
"END power;
 
 *)
 
 PROCEDURE rad (x:  LONGREAL): LONGREAL;
"BEGIN
$RETURN x * piDiv180;
"END rad;
 
 PROCEDURE deg (x: LONGREAL): LONGREAL;
"BEGIN
$RETURN x * invPiDiv180;
"END deg;
 
 
 (*$? Soft:
 
 PROCEDURE cos (x: LONGREAL): LONGREAL;
"BEGIN
$RETURN sin (pi2-ABS(x))
"END cos;
 
 PROCEDURE int      (x: LONGREAL): LONGREAL;    (* Vorkomma-Anteil von x   *)
"BEGIN
$RETURN x - fraction (x)
"END int;
 
 PROCEDURE lnP1     (x: LONGREAL): LONGREAL;    (* log_e  (x+1) *)
"BEGIN
$RETURN ln (x+1.)
"END lnP1;
 
 PROCEDURE expM1    (x: LONGREAL): LONGREAL;    (*  e ^ (x-1) *)
"BEGIN
$RETURN exp (x-1.)
"END expM1;
 
 PROCEDURE sincos   (x: LONGREAL; VAR s, c: LONGREAL); (* beide zugleich *)
"BEGIN
$s:= sin (x);
$c:= cos (x)
"END sincos;
 
 
 PROCEDURE arcsin (x: LONGREAL): LONGREAL;
"VAR  x1: LONGREAL;
"BEGIN
$x1 := x*x;
$IF x1 = 1.0 THEN
&IF x < 0.0 THEN RETURN -pi2 ELSE RETURN pi2 END
$ELSIF ABS (x) > 1.0 THEN
&ASSEMBLER
(; RaiseError (OutOfRange,'',callerCaused,mayContinue);
(TRAP    #6
(DC.W    OutOfRange-$4000
&END;
&RETURN 1.
$ELSE
&RETURN arctan (x/sqrt (1.0-x1))
$END;
"END arcsin;
 
 
 PROCEDURE arccos (x: LONGREAL): LONGREAL;
"BEGIN
$IF x = 0.0 THEN
&RETURN pi2
$ELSIF ABS (x) > 1.0 THEN
&ASSEMBLER
(; RaiseError (OutOfRange,'',callerCaused,mayContinue);
(TRAP    #6
(DC.W    OutOfRange-$4000
&END;
&RETURN 1.
$ELSIF x < 0.0 THEN
&RETURN pi - arctan (- sqrt (1.0-x*x)/x)
$ELSE
&RETURN arctan (sqrt (1.0-x*x)/x)
$END;
"END arccos;
"
 PROCEDURE sinh (x: LONGREAL): LONGREAL;
"VAR z: LONGREAL;
"BEGIN
$z := exp (x);
$RETURN 0.5 * (z - 1.0 / z);
"END sinh;
"
"
 PROCEDURE cosh (x: LONGREAL): LONGREAL;
"VAR z: LONGREAL;
"BEGIN
$z := exp (x);
$RETURN 0.5 * (z + 1.0 / z);
"END cosh;
 
 
 PROCEDURE tanh (x: LONGREAL): LONGREAL;
"VAR ex2: LONGREAL;
"BEGIN
$ex2 := exp (2.0 * x);
$RETURN (ex2 - 1.0) / (ex2 + 1.0)
"END tanh;
 
 
 PROCEDURE artanh (x: LONGREAL): LONGREAL;
"BEGIN
$IF ABS (x) < 1.0 THEN
&RETURN 0.5 * ln ((1.0 + x) / (1.0 - x))
$ELSE
&ASSEMBLER
(; RaiseError (OutOfRange,'',callerCaused,mayContinue);
(TRAP    #6
(DC.W    OutOfRange-$4000
&END;
&RETURN 1.
$END
"END artanh;
 
 PROCEDURE real     (x: LONGINT): LONGREAL;    (* Umwandlung LONGINT <> LONGREAL *)
"BEGIN
$IF x >= 0L THEN
&RETURN FLOAT (ABS (x))
$ELSE
&RETURN - FLOAT (ABS (x))
$END
"END real;
 
 PROCEDURE entier   (x: LONGREAL): LONGINT;
"VAR  l: LONGINT;
"BEGIN
$l := TRUNC (ABS (x));
$IF l > MaxLInt THEN
&ASSEMBLER
(; RaiseError (OutOfRange,'',callerCaused,mayContinue);
(TRAP    #6
(DC.W    OutOfRange-$4000
&END;
&RETURN MaxLInt
$ELSIF x >= 0.0 THEN
&RETURN l
$ELSE
&RETURN -l
$END
"END entier;
 
 (* END Soft *) *)
 
 BEGIN
 (*$? NOT IEEE:
"pi2:=         000AC90FDAA22163R;
"piDiv180:=   0FFDA8EFA351294E6R;
"invPiDiv180:= 0032E52EE0D31E16R;
"half:=        0002800000000000R;
 *)
 (*$? IEEE:
"pi2:=         3FF921FB54442D18R;
"piDiv180:=    3F91DF46A2529D39R;
"invPiDiv180:= 404CA5DC1A63C1F8R;
"half:=        3FE0000000000000R;
 *)
 END MathLib0.
 
(* $FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$00007979$FFF43908$00009425$FFF43908$00008A0D$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$FFF43908$00001146T.......T.......T.......T...T...T.......T.......T.......T.......T.......T.......$000040CA$00004110$00004136$00007050$000070C5$000070EB$00007271$00007297$000072E5$0000734A$00001176$0000112D$00001146$0000734A$00001168$0000405C*)
