 IMPLEMENTATION MODULE Directory; (* V#144 *)
 (*$Y+,L-,H+*)
 
 (*
"13.1.88: TT  DrivesOnline & FreeSpace korrigiert.
"14.1.88: TT  SplitName korrekt, wenn sfx >3 Zeichen
"14.4.88: TT  DirQuery vollendet immer Suche mit Snext, damit der interne
1Directory-Puffer vom GEMDOS wieder freigegeben wird.
"26.8.88: TT  GetDirEntry neu - mu noch exportiert werden
"9.12.88: TT  GetCurrentDir schliet path immer mit '\' ab.
"1.07.89: TT  SplitPath: LINK-Instr. entfernt, da mit $L+ compiliert
"7.08.89: TT  GetDirEntry kann nun auch Ordner ermitteln
"15.8.89: TT  Delete liefert endlich 'fNotDeleted', wenn File nicht exist.
#5.9.89: TT  GetDirEntry mit INTEGER- statt BOOLEAN-Ergebnis
#2.2.90: TT  StrToDrive liefert 'defaultDrv', wenn ungltiger LW-Buchstabe;
/ForceMediaChange implementiert
#6.5.90: TT  Auch die Split/Concat-Funktionen haben nun REF-Parameter und
/legen ggf. vom Parameter eine Kopie an, wenn er identisch
/mit einem Ausgabe-Parm ist.
"27.5.90: TT  ConcatName/Path kommen nun auch mit gleichen Argumenten bei
/den REF-Parms klar.
"04.7.90: TT  Aufspaltung nach 'FileNames'-Modul
"20.7.90: TT  DrivesOnline: SETs verkehrt
"20.9.90: TT  SearchFirst liefert -49 statt -33, wenn keine Files.
"24.10.90: TT $H+ bei DirQuery
"31.01.91: TT SetCurrentDir: Keine Aktion, wenn 'path' leer ist; MakeFullPath
/verwendet "fileUpper" statt Strings.Upper
 *)
 
 FROM SYSTEM IMPORT ASSEMBLER, ADDRESS, ADR, TSIZE, BYTE, WORD, LONGWORD;
 IMPORT Strings, StrConv;
 FROM Clock IMPORT Time, Date, UnpackTime, UnpackDate;
 FROM MOSConfig IMPORT FileErrMsg;
 FROM FileNames IMPORT SplitPath, DriveToStr, StrToDrive;
 FROM MOSGlobals IMPORT FileStr, PathStr, DriveStr, NameStr, SfxStr, PfxStr,
(OutOfStack, StringOverflow, fNotDeleted, fPathNotFound, fFileNotFound,
(fNoMoreFiles, fNoMatchingFiles, Drive, DriveSet;
 
 (*
 TYPE    FileAttr     = (readOnlyAttr, hiddenAttr, systemAttr, volLabelAttr,
8subdirAttr, archiveAttr);
 
(FileAttrSet  = SET OF FileAttr;
 
(DirEntry     = RECORD
9name: ARRAY [0..11] OF CHAR;
9attr: FileAttrSet;
9time: Time;
9date: Date;
9size: LONGCARD
7END;
 
(DirQueryProc = PROCEDURE ( DirEntry ): BOOLEAN; (* TRUE: weiter *)
 
(Drive = ( defaultDrv, drvA, drvB, drvC, drvD, drvE, drvF, drvG,
2drvH, drvI, drvJ, drvK, drvL, drvM, drvN, drvO, drvP);
 *)
 
 VAR null: CARDINAL;
$strok: BOOLEAN;
 
 
 (*$C-*)
 VAR mydev: CARDINAL;
$regsav, oldgetbpb: ARRAY [0..3] OF LONGWORD;
$oldmediach, etv_merk: LONGWORD;
$fspec: ARRAY [0..5] OF CHAR;
 (*$C+*)
 PROCEDURE fmed_asm (driveNo: CARDINAL): LONGINT;
 (*$C-*)
"CONST hdv_bpb      = $0472L;
(hdv_rw       = $0476L;
(hdv_mediach  = $047EL;
(etv_critic   = $0404L; (* Hier der etv_critic-Handler fr MB *)
"BEGIN
$ASSEMBLER
0move.w  -(A3),D0        ; driveNo
0movem.l D7/A2-A3,-(A7)
0move.w  D0,D7
 
0clr.l   -(SP)           ;Super
0move.w  #$20,-(SP)
0trap    #$01
0move.l  D0,2(SP)        ;fr nchsten Super-Call
 
0move.l  etv_critic,etv_merk
0lea     etv_ersetzt(PC),A0
0move.l  A0,etv_critic
 
0move.w  D7,mydev
0add.b   #'A',D7
0move.b  D7,fspec
 
0movem.l hdv_bpb,A0-A3 ;4 Longs verschieben
0movem.l A0-A3,oldgetbpb
 
 ; Eines von den vier Longs ist berflssig, das macht aber nichts, die
 ; Routine ist immer noch schneller als die von Atari!
 ; Jetzt mten eigentlich XBRA-Verfahren benutzt werden, aber da die
 ; Verschiebung sowieso nur temporr ist, sparen wir an Zeit und Platz!
 
0lea     newgetbpb(PC),A0
0move.l  A0,hdv_bpb
0lea     newrwabs(PC),A0
0move.l  A0,hdv_rw
0lea     newmediach(PC),A0
0move.l  A0,hdv_mediach
 
0clr.w   -(SP)
0pea     fspec
0move.w  #$3D,-(SP)
0trap    #$01
0addq.l  #$08,SP
 
0tst.l   D0
0bmi.s   noclose
0move.w  D0,-(SP)
0move.w  #$3E,-(SP)
0trap    #$01
0addq.l  #$04,SP
 
 noclose         move.l  D0,D7
 
0lea     newgetbpb(PC),A0
0cmpa.l  hdv_bpb,A0
0bne.s   done
0movem.l oldgetbpb,A0-A3
0movem.l A0-A3,hdv_bpb
 
 done:           move.l  etv_merk,etv_critic ;Freigabe
0trap    #$01
0addq.l  #$06,SP
0move.l  D7,D0
0movem.l (A7)+,D7/A2-A3
0move.l  D0,(A3)+
0rts
 
 newgetbpb:      move.w  mydev,D0
0cmp.w   $04(SP),D0
0bne.s   dooldg
 
0movem.l oldgetbpb,A0-A3
0movem.l A0-A3,hdv_bpb
 
 dooldg:         movea.l oldgetbpb,A0
0jmp     (A0)
 
 newmediach:     move.w  mydev,D0
0cmp.w   $04(SP),D0
0bne.s   dooldm
0moveq   #$02,D0
0rts
 dooldm:         movea.l oldmediach,A0
0jmp     (A0)
 
 newrwabs:       move.w  mydev,D0
0cmp.w   $0E(SP),D0
0bne.s   dooldr
0moveq   #-$0E,D0
0rts
 
 dooldr:         movea.l oldmediach,A0
0jmp     (A0)
 
 etv_ersetzt:    move.w  $06(SP),D0      ;Hier der neue etv_critic-Treiber
0cmp.w   mydev,D0        ;Ist der Fehler auf unserem Laufwerk?
0beq.s   disk_flipped    ;Ja, dann abbrechen!
0movea.l etv_merk,A0     ;Normale Fehlerabfertigung
0jmp     (A0)
 
 disk_flipped:   move.w  $04(SP),D0      ;Fehler zurckmelden, Box abfangen!
$END
"END fmed_asm;
 (*$C+*)
 
 (*$L+*)
 PROCEDURE ForceMediaChange (driveNo: Drive);
"VAR err: LONGINT;
"BEGIN
$IF driveNo = defaultDrv THEN
&driveNo:= DefaultDrive ()
$END;
$err:= fmed_asm (ORD (driveNo) - 1);
 (*
$IF err = 0L THEN
&errCode:= -1
$ELSIF err = -33L THEN
&IF driveNo IN DrivesOnline () THEN
(errCode:= 0
&ELSE
(errCode:= fInvalidDrive
&END
$ELSE
&errCode:= SHORT (err)
$END
 *)
"END ForceMediaChange;
 (*$L-*)
 
 
 PROCEDURE fileUpper (VAR s: ARRAY OF CHAR);
"(* "Upper" fr Dateinamen: bercksichtigt nur die unteren 128 Zeichen *)
"VAR n: CARDINAL;
"BEGIN
$(*
$FOR n:= 0 TO HIGH (s) DO
&IF s[n]='' THEN RETURN END;
&IF s[n]<CHR(128) THEN s[n]:=CAP(s[n]) END
$END
$*)
$ASSEMBLER
(MOVE.W  -(A3),D1
(MOVE.L  -(A3),A1
(CLR.W   D0
&luup:
(MOVE.B  (A1)+,D0
(BEQ     ende
(BMI     next
(JSR     @CAP    ;/A2
(MOVE.B  D0,-1(A1)
&next:
(DBRA    D1,luup
&ende:
$END
"END fileUpper;
 
 
 PROCEDURE str0;
"BEGIN
$ASSEMBLER
(; D0: HIGH (s)
(; A0: ADR (s)
(; D2 erhalten !
(MOVE.L  (A7)+,A1
(
(MOVE    D0,D1
(ADDQ    #3,D1
(BCLR    #0,D1
(
(; LINK:
(PEA     (A5)
(MOVE.L  A7,A5
(SUBA.W  D1,A7
(
(CMPA.L  A3,A7
(BLS     E
(MOVE.L  A7,A2
(
%L: MOVE.B  (A0)+,(A2)+
(DBRA    D0,L
(CLR.B   (A2)+
(
(MOVE.L  A7,D0
(JMP     (A1)
%
%E: TRAP    #6      ; OUT OF STACK
(DC.W    -10
$END
"END str0;
 
 PROCEDURE str0b;
"BEGIN
$ASSEMBLER
(; D0: HIGH (s)
(; A0: ADR (s)
(; D2 erhalten !
(MOVE.L  (A7)+,A1
(
(MOVE    D0,D1
(ADDQ    #3,D1
(BCLR    #0,D1
(
(SUBA.W  D1,A7
(
(CMPA.L  A3,A7
(BLS     E
(MOVE.L  A7,A2
(
%L: MOVE.B  (A0)+,(A2)+
(DBRA    D0,L
(CLR.B   (A2)+
(
(MOVE.L  A7,D0
(JMP     (A1)
%
%E: TRAP    #6      ; OUT OF STACK
(DC.W    -10
$END
"END str0b;
 
 PROCEDURE setDta;
"BEGIN
$ASSEMBLER
(; get old DTA
(MOVE    #$2F,-(A7)
(TRAP    #1
(MOVE.L  D0,D3           ; alten DTA merken in D3
(; set new DTA
(MOVE.L  D4,-(A7)
(MOVE    #$1A,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
$END
"END setDta;
 
 PROCEDURE getDta;
"BEGIN
$ASSEMBLER
(MOVE    #$2F,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
$END
"END getDta;
 
 PROCEDURE rstDta;
"BEGIN
$ASSEMBLER
(; reset old DTA, erhalte D0 !
(MOVE.L  D0,-(A7)
(MOVE.L  D3,-(A7)
(MOVE    #$1A,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.L  (A7)+,D0
$END
"END rstDta;
 
 PROCEDURE copyDirEntry;
"BEGIN
$ASSEMBLER
(; Kopiert von DTA nach entry (A1)
 
(; name
(MOVEQ   #5,D0
(LEA     $1E(A0),A2
$L0: MOVE.W  (A2)+,(A1)+
(DBRA    D0,L0
(; attr
(MOVE.B  21(A0),(A1)+
(CLR.B   (A1)+
(; time
(MOVE    22(A0),(A3)+
(MOVEM.L A0/A1,-(A7)
(JSR     UnpackTime
(MOVEM.L (A7)+,A0/A1
(MOVE.L  -6(A3),(A1)+
(MOVE.W  -(A3),(A1)+
(SUBQ.L  #4,A3
(; date
(MOVE    24(A0),(A3)+
(MOVEM.L A0/A1,-(A7)
(JSR     UnpackDate
(MOVEM.L (A7)+,A0/A1
(MOVE.L  -6(A3),(A1)+
(MOVE.W  -(A3),(A1)+
(SUBQ.L  #4,A3
(; size
(MOVE.L  26(A0),(A1)+
$END
"END copyDirEntry;
 
 PROCEDURE GetDTAEntry ( dta: DTA; VAR entry: DirEntry );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),A1
(MOVE.L  -(A3),A0
(JMP     copyDirEntry
$END
"END GetDTAEntry;
 
 PROCEDURE MakeFullPath ( VAR filename: ARRAY OF CHAR;
9VAR result: INTEGER );
"(*$L+*)
"VAR oldpath, path: PathStr; dummy: INTEGER; name: NameStr;
"BEGIN
$fileUpper (filename);
$SplitPath (filename, path, name);
$GetDefaultPath (oldpath);
$SetDefaultPath (path, result);
$GetDefaultPath (path);
$SetDefaultPath (oldpath, dummy);
$IF result >= 0 THEN
&Strings.Concat (path, name, filename, strok);
$END
"END MakeFullPath;
"(*$L=*)
 
 PROCEDURE GetFileAttr (REF name: ARRAY OF CHAR; VAR attr: FileAttrSet; VAR result: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -14(A3),A0
(MOVE.W  -10(A3),D0
(JSR     str0
(CLR.L   -(A7)
(MOVE.L  D0,-(A7)
(MOVE    #$43,-(A7)
(TRAP    #1
(MOVE.L  -(A3),A1
(MOVE.L  -(A3),A0
(TST.L   D0
(BMI     E
(CLR.W   (A1)
(MOVE.B  D0,(A0)
%C: SUBQ.L  #6,A3
(; UNLK:
(UNLK    A5
(RTS
%E: MOVE    D0,(A1)
(BRA     C
$END
"END GetFileAttr;
 
 PROCEDURE SetFileAttr (REF name: ARRAY OF CHAR; attr: FileAttrSet; VAR result: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -12(A3),A0
(MOVE.W  -08(A3),D0
(JSR     str0
(MOVEQ   #0,D1
(MOVE.B  -06(A3),D1
(MOVE    D1,-(A7)
(MOVE    #1,-(A7)
(MOVE.L  D0,-(A7)
(MOVE    #$43,-(A7)
(TRAP    #1
(MOVE.L  -(A3),A1
(TST.L   D0
(BMI     E
(CLR.W   (A1)
%C: SUBQ.L  #8,A3
(; UNLK:
(UNLK    A5
(RTS
%E: MOVE    D0,(A1)
(BRA     C
$END
"END SetFileAttr;
 
 PROCEDURE Rename (REF oldName, newName: ARRAY OF CHAR; VAR result: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -10(A3),A0
(MOVE.W  -06(A3),D0      ; newName
(JSR     str0
(MOVE.L  D0,D2
(MOVE.L  -16(A3),A0
(MOVE.W  -12(A3),D0      ; oldName
(JSR     str0b           ; kein erneutes LINK
(MOVE.L  D2,-(A7)        ; newName
(MOVE.L  D0,-(A7)        ; oldName
(CLR     -(A7)
(MOVE    #$56,-(A7)
(TRAP    #1
(MOVE.L  -(A3),A1
(TST.L   D0
(BMI     E
(CLR.W   (A1)
%C: SUBA.W  #12,A3
(; UNLK:
(UNLK    A5
(RTS
%E: MOVE    D0,(A1)
(BRA     C
$END
"END Rename;
 
 PROCEDURE Delete (REF name: ARRAY OF CHAR; VAR result: INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -10(A3),A0
(MOVE.W  -06(A3),D0
(JSR     str0
(MOVE.L  D0,-(A7)
(MOVE    #$41,-(A7)
(TRAP    #1
(MOVE.L  -(A3),A1
(TST.L   D0
(BMI     E
(CLR.W   (A1)
%C: SUBQ.L  #6,A3
(; UNLK:
(UNLK    A5
(RTS
%E: CMPI    #fFileNotFound,D0
(BEQ     F
(CMPI    #fPathNotFound,D0
(BEQ     F
(MOVE    D0,(A1)
(BRA     C
%F: MOVE    #fNotDeleted,(A1)
(BRA     C
$END
"END Delete;
 
 PROCEDURE DirQuery (REF wildName: ARRAY OF CHAR;
8select  : FileAttrSet;
8dirProc : DirQueryProc;
4VAR result  : INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -20(A3),A0      ;wildName
(MOVE.W  -16(A3),D0
(JSR     str0
(
(MOVEM.L D3/D4,-(A7)
(
(; DTA anlegen
(SUBA.W  #44,A7
(MOVE.L  A7,D4
(
(MOVEQ   #0,D1
(MOVE.B  -14(A3),D1      ; select
(MOVE.W  D1,-(A7)
(MOVE.L  D0,-(A7)        ; zuerst D0 sichern
(JSR     setDta          ; dann DTA sichern/umsetzen
(MOVE    #$4E,-(A7)
(TRAP    #1              ; FSFIRST
(ADDQ.L  #8,A7
(JSR     rstDta          ; alten DTA wiederherstellen
 
(TST.L   D0
(BPL     again
 
(; wenn leeres Dir, dann 'fNoMatchingFiles' liefern.
(CMPI    #-33,D0         ; file not found ?
(BNE     ok3
(MOVEQ   #fNoMatchingFiles,D0
&ok3
(BRA.W   ok2
(
$again:
(MOVE.L  -12(A3),D3      ; 'dirProc'-Adr
(BEQ.L   errP
(MOVE.L  -08(A3),D4      ; 'dirProc'-Static Link
(; Pfadnamen (ohne Dateinamen) auf Eval-Stack
(;   Achtung: Da der Name nicht kopiert wird, darf 'dirProc' den
(;   Path-String nicht verndern !
(MOVE.L  -20(A3),(A3)+
(MOVE.W  -20(A3),(A3)+
(JSR     Strings.Length
(MOVE    -(A3),D0
(MOVE.L  -20(A3),A0
(BEQ     agend2
&aglupo:
(MOVE.B  -1(A0,D0.W),D1
(CMPI.B  #':',D1
(BEQ     agende
(CMPI.B  #'\',D1
(BEQ     agende
(SUBQ    #1,D0
(BNE     aglupo
(LEA     null,A0
(BRA     agend2
&agende:
(SUBQ    #1,D0
&agend2:
(MOVE.L  A0,(A3)+        ; ADR (path)
(MOVE.W  D0,(A3)+        ; HIGH (path)
 
(; DirEntry auf Eval-Stack laden, DTA ist direkt auf dem Systemstack
(; name
(MOVEQ   #5,D0
(LEA     $1E(A7),A0
$L0: MOVE.W  (A0)+,(A3)+
(DBRA    D0,L0
(; attr
(MOVE.B  21(A7),(A3)+
(CLR.B   (A3)+
(; time
(MOVE    22(A7),(A3)+
(JSR     UnpackTime
(MOVE    24(A7),(A3)+
(; date
(JSR     UnpackDate
(; size
(MOVE.L  26(A7),(A3)+
 
(; call 'dirProc'
(MOVE.L  D3,A0
(MOVE.L  D4,D2
(JSR     (A0)
(TST     -(A3)
(BEQ     abort           ; Abbruch
(
(MOVE.L  A7,D4
(JSR     setDta          ; DTA sichern/umsetzen
(MOVE    #$4F,-(A7)
(TRAP    #1              ; Fsnext
(ADDQ.L  #2,A7
(JSR     rstDta          ; alten DTA wiederherstellen
 
(TST.L   D0
(BPL     again
(
(CMPI    #-49,D0         ; ENMFIL ?
(BEQ     ok
(BRA     ok2
(
&errP:
(TRAP    #6
(DC.W    -17
(MOVEQ   #-1,D0
(BRA     ok2
(
&abort:
(MOVE.L  A7,D4
(JSR     setDta
(MOVE    #$4F,-(A7)
&ablp:
(TRAP    #1              ; Fsnext
(TST.L   D0
(BPL     ablp            ; so lange wiederholen, bis Ende o. Fehler
(ADDQ.L  #2,A7
(JSR     rstDta
(
&ok:
(MOVEQ   #0,D0
&ok2:
(MOVE.L  -(A3),A0
(MOVE    D0,(A0)
(
(SUBA.W  #16,A3
(ADDA.W  #44,A7
(MOVEM.L (A7)+,D3/D4
(
(; UNLK:
(UNLK    A5
$END
"END DirQuery;
 
 PROCEDURE SetDefaultDrive ( driveNo: Drive );
"BEGIN
$ASSEMBLER
(MOVE    -(A3),D0
(SUBQ    #1,D0
(BCS     e
(MOVE    D0,-(A7)
(MOVE    #$E,-(A7)
(TRAP    #1
(ADDQ.L  #4,A7
&e:
$END
"END SetDefaultDrive;
 
 PROCEDURE DefaultDrive (): Drive;
"BEGIN
$ASSEMBLER
(MOVE    #$19,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(ADDQ    #1,D0
(MOVE    D0,(A3)+
$END
"END DefaultDrive;
 
 PROCEDURE GetCurrentDir ( driveNo: Drive; VAR path: ARRAY OF CHAR );
"BEGIN
$ASSEMBLER
(SUBA.W  #128,A7
(MOVE.L  A7,D0
(MOVE.L  -(A3),-(A7)
(MOVE.L  -(A3),-(A7)
(MOVE.L  D0,-(A7)
(MOVE    #$47,-(A7)
(CMPA.L  A3,A7
(BLS     serr
(TRAP    #1
(ADDQ.L  #6,A7
(MOVE.W  (A7)+,D1        ; driveNo
(MOVE.L  (A7)+,A2        ; ADR (path)
(MOVE.W  (A7)+,D2        ; HIGH(path)
(TST.L   D0
(BPL     ok
'err:
(CLR.B   (A2)
(BRA     ende
'serr:
(TRAP    #6
(DC.W    OutOfStack-$2000
'ok:
(MOVE.L  A7,A0
'l:
(MOVE.B  (A0)+,(A2)+
(DBEQ    D2,l
(BNE     so
(MOVE.B  #'\',-1(A2)
(TST     D2
(BMI     ende
(CLR.B   (A2)
(BRA     ende
'so:
(TRAP    #6
(DC.W    StringOverflow
'ende:
(ADDA.W  #128,A7
$END
"END GetCurrentDir;
 
 PROCEDURE SetCurrentDir ( driveNo: Drive; REF path: ARRAY OF CHAR; VAR result: INTEGER );
"BEGIN
$ASSEMBLER
(MOVE.L  -10(A3),A0      ; ADR (path)
(MOVE.W  -6(A3),D0
(
(TST.B   (A0)            ; path = '' ?
(BNE     doSet
 
(MOVE.L  -(A3),A0
(CLR.W   (A0)            ; result:= 0
(SUBQ.L  #8,A3
(RTS
 
 doSet   MOVE    D0,D1
(ADDQ    #5,D1
(BCLR    #0,D1
(
(; LINK:
(PEA     (A5)
(MOVE.L  A7,A5
(SUBA.W  D1,A7
(
(CMPA.L  A3,A7
(BLS     E
(MOVE.L  A7,A2
(
(MOVEM.L D0/A0/A2,-(A7)
(
(MOVE.W  -12(A3),(A3)+   ; driveNo laden
(BNE     D               ; ist nicht default drive
(
(SUBQ.L  #2,A3
(MOVE.L  A0,(A3)+
(MOVE    D0,(A3)+
(JSR     StrToDrive      ; driveNo auf A3-Stack
(
%D: JSR     DefaultDrive
(MOVE    -(A3),-(A7)     ; akt. Drive retten
(JSR     SetDefaultDrive ; gewnschtes Drive setzen
(MOVE    (A7)+,(A3)+     ; akt. Drive auf A3-Stack
(
(MOVEM.L (A7)+,D0/A0/A2
(
%L: MOVE.B  (A0)+,(A2)+
(DBRA    D0,L
(CLR.B   (A2)+
(
(MOVE.L  A7,-(A7)
(MOVE    #$3B,-(A7)      ; SetDir
(TRAP    #1
(ADDQ.L  #6,A7
(
(MOVE.L  D0,-(A7)
(JSR     SetDefaultDrive
(MOVE.L  (A7)+,D0
(
(MOVE.L  -(A3),A1
(TST.L   D0
(BMI     F
(CLR.W   (A1)
%C: SUBQ.L  #8,A3
(; UNLK:
(UNLK    A5
(RTS
%F: MOVE    D0,(A1)
(BRA     C
(
%E: TRAP    #6      ; OUT OF STACK
(DC.W    -10
$END
"END SetCurrentDir;
 
 PROCEDURE FreeSpace ( driveNo: Drive ): LONGCARD; (* Angabe in Bytes *)
"BEGIN
$ASSEMBLER
(SUBA.W  #16,A7
(MOVE    -(A3),-(A7)
(PEA     2(A7)
(MOVE    #$36,-(A7)
(TRAP    #1
(ADDQ.L  #8,A7
(MOVEQ   #0,D1
(TST.L   D0
(BMI     ende
(MOVE.L  8(A7),D1        ; bytes per sector
(MULU.W  14(A7),D1       ; sectors per cluster
(MOVE.L  D1,(A3)+
(MOVE.L  (A7),(A3)+      ; free clusters
(JSR     @CMUL
(MOVE.L  -(A3),D1
&ende:
(ADDA.W  #16,A7
(MOVE.L  D1,(A3)+
$END
"END FreeSpace;
 
 PROCEDURE CreateDir ( REF path: ARRAY OF CHAR; VAR result: INTEGER );
 BEGIN
$ASSEMBLER
(MOVE.L  -10(A3),A0
(MOVE.W  -06(A3),D0
(JSR     str0
(MOVE.L  D0,-(A7)
(MOVE    #$39,-(A7)
(TRAP    #1
(MOVE.L  -(A3),A1
(TST.L   D0
(BMI     E
(CLR.W   (A1)
%C: SUBQ.L  #6,A3
(; UNLK:
(UNLK    A5
(RTS
%E: MOVE    D0,(A1)
(BRA     C
$END
"END CreateDir;
 
 PROCEDURE DeleteDir ( REF path: ARRAY OF CHAR; VAR result: INTEGER );
 BEGIN
$ASSEMBLER
(MOVE.L  -10(A3),A0
(MOVE.W  -06(A3),D0
(JSR     str0
(MOVE.L  D0,-(A7)
(MOVE    #$3A,-(A7)
(TRAP    #1
(MOVE.L  -(A3),A1
(TST.L   D0
(BMI     E
(CLR.W   (A1)
%C: SUBQ.L  #6,A3
(; UNLK:
(UNLK    A5
(RTS
%E: MOVE    D0,(A1)
(BRA     C
$END
"END DeleteDir;
 
 
 PROCEDURE DrivesOnline (): DriveSet;
"BEGIN
$ASSEMBLER
(MOVE    #10,-(A7)
(TRAP    #13
(ADDQ.L  #2,A7
(SWAP    D0
(CLR     D0
(SWAP    D0
(LSL.L   #1,D0
(MOVE.L  D0,(A3)+
$END
"END DrivesOnline;
 
 
 PROCEDURE GetDirEntry ( REF fileName: ARRAY OF CHAR;
8VAR entry: DirEntry; VAR res: INTEGER );
"BEGIN
$ASSEMBLER
(MOVE.L  -14(A3),A0
(MOVE.W  -10(A3),D0
(JSR     str0
 
(MOVE.W  #$0010,-(A7)    ; Attribut: alle Dateien/Ordner
(MOVE.L  D0,-(A7)        ; zuerst D0 (^name) sichern
(MOVE    #$4E,-(A7)
(TRAP    #1              ; FSFIRST
(ADDQ.L  #8,A7
 
(MOVE.L  -8(A3),A1       ; ADR (entry)
 
(; Name in Dir vorhanden ?
(TST.L   D0
(BMI     fals
 
(; DirEntry kopieren
(MOVE.L  A1,-(A7)
(JSR     getDta
(MOVE.L  D0,A0
(MOVE.L  (A7)+,A1
(JSR     copyDirEntry
(MOVEQ   #0,D0
(BRA     ende
 
&fals
(; entry lschen
(MOVEQ   #14,D1
$l1: CLR.W   (A1)+
(DBRA    D1,l1
 
&ende
(MOVE.L  -(A3),A0        ; ok
(MOVE    D0,(A0)
 
(SUBA.W  #10,A3          ; name + entry
(UNLK    A5
$END
"END GetDirEntry;
 
 
 PROCEDURE FileExists ( REF fileName: ARRAY OF CHAR ): BOOLEAN;
"BEGIN
$ASSEMBLER
(MOVE.L  -6(A3),A0
(MOVE.W  -2(A3),D0
(JSR     str0
(SUBQ.L  #6,A3
 
(MOVE.L  D0,A0
(TST.B   (A0)
(BNE     ok
 
(CLR     D0
(BRA     ende
 
$ok: CLR     -(A7)           ; Attribut: nur Dateien
(MOVE.L  D0,-(A7)        ; zuerst D0 (^name) sichern
(MOVE    #$4E,-(A7)
(TRAP    #1              ; FSFIRST
(ADDQ.L  #8,A7
 
(; Name in Dir vorhanden ?
(TST.L   D0
(SPL     D0
(ANDI    #1,D0
&ende:
(MOVE    D0,(A3)+
 
(UNLK    A5
$END
"END FileExists;
 
 
 PROCEDURE PathExists ( REF path: ARRAY OF CHAR ): BOOLEAN;
!(*
"* Hier kann nicht mit Fsfirst gearbeitet werden, weil bestimmte Pfadnamen
"* nicht als Root-Dir erkennbar wren (z.B. "..\") und dort Fsfirst nicht
"* funktioniert.
"*)
"BEGIN
$ASSEMBLER
(LINK    A5,#0
(SUBA.W  #66,A7
(MOVE.L  A7,(A3)+
(MOVE    #65,(A3)+
(JSR     GetDefaultPath
(SUBA.W  #66,A7
(MOVE.L  A7,(A3)+
(MOVE    #65,(A3)+
(SUBA.W  #12,A7
(MOVE.L  A7,(A3)+
(MOVE    #11,(A3)+
(JSR     SplitPath
(ADDA.W  #12,A7
(MOVE.L  A7,(A3)+
(MOVE    #65,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     SetDefaultPath
(TST     (A7)+
(SPL     D0
(ANDI    #1,D0
(MOVE    D0,(A3)+
(ADDA.W  #66,A7
(MOVE.L  A7,(A3)+
(MOVE    #65,(A3)+
(SUBQ.L  #2,A7
(MOVE.L  A7,(A3)+
(JSR     SetDefaultPath
(UNLK    A5
$END
"END PathExists;
 
 
 PROCEDURE SetDefaultPath ( REF path: ARRAY OF CHAR; VAR result: INTEGER );
"(*$L+*)
"BEGIN
$SetDefaultDrive ( StrToDrive (path) );
$SetCurrentDir ( StrToDrive (path), path, result )
"END SetDefaultPath;
"(*$L=*)
 
 PROCEDURE DefaultPath (): PathStr;
"(*$L+*)
"VAR path: PathStr;
"BEGIN
$GetDefaultPath (path);
$RETURN path
"END DefaultPath;
"(*$L=*)
 
 PROCEDURE GetDefaultPath ( VAR path: ARRAY OF CHAR );
"(*$L+*)
"BEGIN
$GetCurrentDir (defaultDrv, path);
$Strings.Insert (DriveToStr (DefaultDrive ()), 0, path, strok);
"END GetDefaultPath;
"(*$L=*)
 
 PROCEDURE GetDTA ( VAR dta: DTA );
"BEGIN
$ASSEMBLER
(MOVE    #$2F,-(A7)
(TRAP    #1
(ADDQ.L  #2,A7
(MOVE.L  -(A3),A0
(MOVE.L  D0,(A0)
$END
"END GetDTA;
 
 PROCEDURE SetDTA ( dta: DTA );
"BEGIN
$ASSEMBLER
(MOVE.L  -(A3),-(A7)
(MOVE    #$1A,-(A7)
(TRAP    #1
(ADDQ.L  #6,A7
$END
"END SetDTA;
 
 
 PROCEDURE SearchFirst (     REF wildcard: ARRAY OF CHAR;
<select  : FileAttrSet;
8VAR result  : INTEGER);
"BEGIN
$ASSEMBLER
(MOVE.L  -12(A3),A0
(MOVE.W  -08(A3),D0
(JSR     str0
 
(MOVEQ   #0,D1
(MOVE.B  -06(A3),D1
(MOVE.W  D1,-(A7)
(MOVE.L  D0,-(A7)        ; zuerst D0 (^name) sichern
(MOVE    #$4E,-(A7)
(TRAP    #1              ; FSFIRST
(ADDQ.L  #8,A7
 
(; wenn leeres Dir, dann 'fNoMoreFiles' liefern.
(CMPI    #-33,D0         ; file not found ?
(BNE     ok3
(MOVEQ   #fNoMoreFiles,D0
&ok3
 
(MOVE.L  -(A3),A0        ; ok
(MOVE    D0,(A0)
 
(SUBA.W  #6,A3          ; name + attrib
(UNLK    A5
$END
"END SearchFirst;
 
 PROCEDURE SearchNext  ( VAR result: INTEGER);
"BEGIN
$ASSEMBLER
(LINK    A5,#0
 
(MOVE    #$4F,-(A7)
(TRAP    #1              ; FSFIRST
(ADDQ.L  #2,A7
 
(MOVE.L  -(A3),A0        ; ok
(MOVE    D0,(A0)
 
(UNLK    A5
$END
"END SearchNext;
 
 
 PROCEDURE getSt2 (ad:ADDRESS; n:INTEGER; VAR msg:ARRAY OF CHAR): BOOLEAN;
"VAR s: POINTER TO ARRAY [0..31] OF CHAR;
"(*$L+*)
"BEGIN
$ASSEMBLER
(MOVE.L  ad(A6),A0
(MOVE.W  n(A6),D0
(
%l: CMP.W   (A0)+,D0
(BNE     c
(
(; gefunden
(MOVE.L  A0,s(A6)
(BRA     e
(
%c: TST.B   (A0)    ; Listenende ?
(BEQ     f       ; Ja, -> nicht gefunden
(
%m: ADDA.W  #32,A0
(BRA     l
(
%f: CLR.L   s(A6)
%e:
$END;
$IF s#NIL THEN
&Strings.Assign (s^,msg, strok);
&RETURN TRUE
$ELSE
&RETURN FALSE
$END
"END getSt2;
"(*$L=*)
 
 PROCEDURE GetErrMsg ( n: INTEGER; VAR msg: ARRAY OF CHAR );
"VAR p:INTEGER;
"(*$L+*)
"BEGIN
$msg[0]:=0C;
$IF FileErrMsg=NIL THEN
&Strings.Assign ('Unknown error #@',msg,strok)
$ELSE
&IF ~getSt2 (FileErrMsg,n,msg) THEN
(IF n<0 THEN
*IF getSt2 (FileErrMsg,-32768,msg) THEN END
(ELSE
*IF getSt2 (FileErrMsg,32767,msg) THEN END
(END
&END;
$END;
$p:=Strings.Pos ('@',msg,0);
$IF p>=0 THEN
&Strings.Delete (msg,p,1,strok);
&Strings.Insert (StrConv.IntToStr(n,0),p,msg,strok)
$END
"END GetErrMsg;
"(*$L=*)
 
 BEGIN
"null:= 0;
"(*$C-*) fspec:= ' :\\X'; (*$C+*)
 END Directory.
 
(* $000030D0$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$00005120$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFF21D8C$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFED45E4$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$FFFBFACF$00001639T.......T.......T.......T.......T.......T.......T.......T.......T.......T.......$000016FD$00002074$00004C41$000038DB$0000201C$FFEE7904$00000568$0000054D$FFEE4CC0$FFEE4CC0$00001709$00001655$FFF13E0C$0000165F$0000164C$00001639*)
