#ifndef _INET_UDP
#define _INET_UDP

#ifndef _INET_IP
#include "ip.h"
#endif

#ifndef _INET_ICUST
#include "inetcust.h"
#endif



typedef struct _udp
{
	unsigned src_port;			/* source port */
	unsigned dst_port;			/* dest port */
	unsigned length;			/* length of UDP packet incl. header */
	unsigned chksum;			/* UDP checksum */
} UDP;


#ifndef __TCP_PSEUDO
#define __TCP_PSEUDO

typedef struct 				/* tcp pseudoheader */
{
	INADDR	src;			/* source internet addr */
	INADDR	dst;			/* destination internet addr */
	u_short	protocol;		/* used protocol (hibyte must be zero!!) */
	u_short	length;			/* length of tcp header + tcp data */
} TCP_PSEUDO;

#endif

typedef int (*UDP_UPCALL)(int, char *, int);

/* The UDP Connection structure */
typedef struct udp_ctl
{
	struct udp_ctl *next;		/* link to next udp port */
	u_short		handle;			/* handle of this port */
	u_short		lcl_port;		/* local port */
	u_short		fgn_port;		/* foreign port */
	INADDR		fhost;			/* foreign host */
	UDP_UPCALL	upcall;			/* incoming packet handler */
	u_short		udp_err;		/* send error */
	u_short		data_len;		/* length of data */
	char 	   *data;			/* data */
	PACKET	   *pkt;
	TIMER		udp_tm;			/* timer how long to keep packet */
} UDP_CTL;

#define UDP_KEEPPKT		400			/* 2 sec */
#define UDP_MAXPORTS	4

#define UDP_OK		0		/* no error */
#define UDP_OVR		1		/* overrun */
#define UDP_MISS	2		/* packet timer expired */
#define UDP_NORECV	3		/* destination unreachable */
#define UDP_CLOSED	4		/* closed port */

#define udp_head(p_ip)	((UDP *)(((char *)p_ip) + ip_hdrlen(p_ip)))
#define udp_data(p_udp)	((char *)(p_udp) + sizeof(UDP))

int udp_init(void);
int udp_exit(void);

int udp_open(u_short,UDP_UPCALL);
int udp_close(u_short);
int udp_write(u_short,char *,u_short,INADDR, u_short);
int udp_free(u_short);
UDP_CTL *udp_getctl(u_short);
#endif
