#include <stdio.h>
#include <string.h>

#define FALSE 0
#define TRUE !FALSE

extern char curpath[];


int lookup_alias(char *user,char *shortname,char *longname,size_t len)
{
  char line[128];
  FILE *af;
  char *p=NULL;
  size_t llen,lnlen;

  strcpy(longname,shortname);
  sprintf(line,"%s\\mailrc.%.3s",curpath,user);
  af = fopen(line,"r");
  if(!af)
  {
    sprintf(line,"c:\\mailrc.%.3s",user);
    af = fopen(line,"r");
    if(!af)	return(FALSE);
  }
  while(fgets(line,128,af))
  { 
    p = strchr(line,'\n');
    if(p) *p = 0;
    p=strtok(line," \t");
    if(p && !stricmp(p,"alias"))
    {
      p= strtok(NULL," \t");
      if(!strcmp(p,shortname))
      {
        p=strtok(NULL,"\n");
        if(p) strcpy(longname,p);
        lnlen = strlen(longname);
        if(longname[lnlen-1] == '\\')
        {
          longname[--lnlen] = 0;  /* cut off '\\' */
          while(lnlen < len && fgets(line,128,af))
          {
            llen = strlen(line);
            if(lnlen+2+llen > len) 
            {
              fclose(af);
              return(-1);  /* buffer overflow */
            }
            if(line[0] == ' ' || line[0] == '\t' )
            {
              strcat(longname,"\r\n");
              strcat(longname,line);
              lnlen += 2 + llen;
            }
            if(longname[lnlen-1] == '\n') lnlen--;
            if(longname[lnlen-1] == '\\')
            {
              longname[--lnlen] = 0;
            }
            else
              break;
          }
          longname[lnlen] = 0;  /* cut off '\\' */
        }
        fclose(af);
        return(TRUE);
      }
    }
  }
  fclose(af);
  return(FALSE);
}


int range_next(char *r,int max)
{
  static char *sr = { ""  };
  static int nr = 0;
  char *p;
  int  ar;

  if(r)
  {
    sr = r;
    nr = 0;
  }
  while(*sr && (*sr==',' || *sr==' ' || *sr=='\t')) sr++;
  if(!*sr) return(0);  /* at end of string */
  if(*sr=='-') 
  {
    ar = (int)strtol(sr+1,&p,10);
    if(!ar) ar = max;
    if(nr == ar-1) sr = p;
    if(nr > ar-1) return(0);
    return(++nr);
  }
  ar = (int)strtol(sr,&sr,10);
  if(nr > ar) return(0);
  nr = ar;
  return(nr);
}




long gethostbyname(char *hostname)
{
  register FILE *fp;
  register long inet = 0L;
  register char *p; 
  char buf[128];
  int n1,n2,n3,n4;

  if(strchr(hostname,'.'))
  {
    if(sscanf(hostname,"%d.%d.%d.%d",&n1,&n2,&n3,&n4) == 4)
      inet = ((long)n1<<24) + ((long)n2<<16) + ((long)n3<<8) +(long)n4;
  }
  if(inet==0)
  {
    sprintf(buf,"%s\\hosts",curpath);
    if((fp=fopen(buf,"r")) == NULL && (fp=fopen("c:\\hosts","r")) == NULL)
    {
      inet=0L;
    }
    else
    {
      while (!feof(fp))
      {
        fgets(buf,(int)sizeof(buf),fp);
        p=strtok(buf," \t");
        if(!p || *p=='#' || *p=='\n') continue;
        if((sscanf(p,"%d.%d.%d.%d",&n1,&n2,&n3,&n4) == 4))
          do
          {
            p=strtok(NULL," \t\n");
            if(p && !strcmp(p,hostname))
            {
              inet = ((long)n1<<24) + ((long)n2<<16) + ((long)n3<<8) +(long)n4;
              fclose(fp);
              return(inet);
            }
          } 
        while(p);
        else inet=0L;
      }
      fclose(fp);         
    }
  }
  return(inet);
}
