#include "cookie.h"
#include "pktdrv.h"

#define NULL (void *)0L


int net_info(int len, char *buf)
{
static int (*n_info)(int,char *) = NULL;
COOKIE *cookie;
	if(!n_info)
	{
		cookie = get_cookie(PKTCOOKIE);
		if(!cookie || !cookie->val) return(-1);
		(long)n_info = ((long *)(cookie->val))[NETINFO];
		if(!n_info) return(-1);
	}
	return(n_info(len,buf));
}


int net_open(int type, pkt_hndl handler)
{
static int (*n_open)(int,pkt_hndl) = NULL;
COOKIE *cookie;
	if(!n_open)
	{
		cookie = get_cookie(PKTCOOKIE);
		if(!cookie || !cookie->val) return(-1);
		(long)n_open = ((long *)(cookie->val))[NETOPEN];
		if(!n_open) return(-1);
	}
	return(n_open(type,handler));
}


int net_release(int handle)
{
static int (*n_release)(int) = NULL;
COOKIE *cookie;
	if(!n_release)
	{
		cookie = get_cookie(PKTCOOKIE);
		if(!cookie || !cookie->val) return(-1);
		(long)n_release = ((long *)(cookie->val))[NETRELEASE];
		if(!n_release) return(-1);
	}
	return(n_release(handle));
}


int net_send(int len, char *buf)
{
static int (*n_send)(int,char *) = NULL;
COOKIE *cookie;
	if(!n_send)
	{
		cookie = get_cookie(PKTCOOKIE);
		if(!cookie || !cookie->val) return(-1);
		(long)n_send = ((long *)(cookie->val))[NETSEND];
		if(!n_send) return(-1);
	}
	return(n_send(len,buf));
}

int	net_getadr(int len,char *buf)
{
static int (*n_getadr)(int,char *) = NULL;
COOKIE *cookie;
	if(!n_getadr)
	{
		cookie = get_cookie(PKTCOOKIE);
		if(!cookie || !cookie->val) return(-1);
		(long)n_getadr = ((long *)(cookie->val))[NETGETADR];
		if(!n_getadr) return(-1);
	}
	return(n_getadr(len,buf));
}


int net_reset(void)
{
static int (*n_reset)(void) = NULL;
COOKIE *cookie;
	if(!n_reset)
	{
		cookie = get_cookie(PKTCOOKIE);
		if(!cookie || !cookie->val) return(-1);
		(long)n_reset = ((long *)(cookie->val))[NETRESET];
		if(!n_reset) return(-1);
	}
	return(n_reset());
}
