        .EXPORT _BasPag
        .EXPORT _app
        .EXPORT errno
        .EXPORT _AtExitVec, _FilSysVec
        .EXPORT _RedirTab
        .EXPORT _StkLim
        .EXPORT _PgmSize

        .EXPORT __text, __data, __bss
        .EXPORT inetcust,cookiejar,Start

*>>>>>> Import references <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

        .IMPORT main
        .IMPORT _StkSize

*>>>>>> Data structures <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

MAXUSERNAME	=	16
MAXNAME		=	64
MAXHOSTNAME	=	16

        .OFFSET 0

TpaStart:
        .DS.L   1
TpaEnd:
        .DS.L   1
TextSegStart:
        .DS.L   1
TextSegSize:
        .DS.L   1
DataSegStart:
        .DS.L   1
DataSegSize:
        .DS.L   1
BssSegStart:
        .DS.L   1
BssSegSize:
        .DS.L   1
DtaPtr:
        .DS.L   1
PntPrcPtr:
        .DS.L   1
Reserved0:
        .DS.L   1
EnvStrPtr:
        .DS.L   1
Reserved1:
        .DS.B   7
CurDrv:
        .DS.B   1
Reserved2:
        .DS.L   18
CmdLine:
        .DS.B   128
BasePageSize:
        .DS     0

		data
__data:
* Global error variable

errno:
        .DC.W   0


* Vector for atexit

_AtExitVec:
        .DC.L   0


* Vector for file system deinitialization

_FilSysVec:
        .DC.L   0


		bss
__bss:
* Pointer to base page

_BasPag:
        .DS.L   1


* Applikation flag

_app:
        .DS.W   1


* Stack limit

_StkLim:
        .DS.L   1

* Program size

_PgmSize:
        .DS.L   1

* Redirection address table

_RedirTab:
        .DS.L   6



*>>>>>>> Code segment <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

        text
__text:


******** TcStart ********************************************************

Start:
        BRA.B   Start_0



******* Configuration data

* Redirection array pointer

        .DC.L   _RedirTab


* Stack size entry

        .DC.L   _StkSize
Start_0:
		JMP		Start0

inetcust:
magic:		.DC.L	cookiejar-inetcust
haddr:		.DS.B	6			* my hardware adress
inaddr:		.DS.L	1			* my internet adress
subnetbits:	.DS.W	1			* number of subnet bits	 */
tcpwnd:		.DS.W	1			* default tcp window size   */
tcplowater:	.DS.W	1
netmem:		.DS.L	1
username:	.DS.B	MAXUSERNAME
hosts:		.DS.B	64			* path to hosttable		 */
passwd:		.DS.B	64			* path to passwordfile	 */
gmtoffs:	.DS.W	1			* time zone offset 		 */
tzname:		.DS.B	6			* timezone name			 */
timeserver:	.DS.L	2			* ip adr of 2 timeservers   */ 
nameserver:	.DS.L	3			* ip adr of 3 nameservers   */
gateway:	.DS.L	1			* ip adr of gateway		 */
hostname:	.DS.B	MAXHOSTNAME	* name of this host */
domainname:	.DS.B	MAXNAME		* domainname of this host */
mailhost:	.DS.B	MAXNAME		* mailhost name */
loginhost:	.DS.B	MAXNAME		* default host to login */
printhost:	.DS.B	MAXNAME		* printserver */
printdev:	.DS.B	MAXHOSTNAME	* printer device */


cookiejar:	.DC.L	0			* 11 cookies room for jar
			.DC.L	0
			.DS.L	20


        .EVEN

Start0:

        MOVE.L  A0, A3
        MOVE.L  A3, D0
        MOVE.L  4(A7), A3   ; BasePagePointer from Stack


        MOVE.L  TextSegSize(A3),A0
        ADD.L   DataSegSize(A3),A0
        ADD.L   BssSegSize(A3),A0
        ADD.W   #BasePageSize,A0

        MOVE.L  A3,D0
        ADD.L	A0,D0
        AND.B   #$FC,D0
        MOVE.L  D0,A7

        MOVE.L  A0,-(A7)
        MOVE.L  A3,-(A7)
        MOVE.W  #0,-(A7)
        MOVE.W  #74,-(A7)
        TRAP    #1
        LEA.L   12(A7),A7

*   <D0.W> = Command line argument count (argc)
*   <A0.L> = Pointer to command line argument pointer array (argv)
*   <A1.L> = Pointer to tos environment string (env)

        MOVEQ	#1, D0
        JSR     main

******** exit ***********************************************************
*
* Terminate program
*
* Entry parameters:
*   <D0.W> = Termination status : Integer
* Return parameters:
*   Never returns

* Program termination with return code

		MOVE.W	#0,-(A7)
		MOVE.L	D0,-(A7)
        MOVE.W  #49,-(A7)
        TRAP    #1

******* Module end *****************************************************

        .END
