;# NAME
;#    timespec.pl - convert a pre-defined time specifyer to seconds
;#
;# AUTHOR
;#    Michael S. Muegel (mmuegel@mot.com)
;#
;# RCS INFORMATION
;#    mmuegel
;#    /usr/local/ustart/src/mail-tools/dist/foo/libs/timespec.pl,v 1.1 1993/07/28 08:07:19 mmuegel Exp

package timespec;

%TIME_SPEC_TO_SECONDS 	= ("s", 1,
		    	   "m", 60,
		    	   "h", 60 * 60,
		    	   "d", 60 * 60 * 24
		    	   );

$VALID_TIME_SPEC_EXPR 	= "[" . join ("", keys (%TIME_SPEC_TO_SECONDS)) . "]";

;###############################################################################
;# Time_Spec_To_Seconds
;#
;# Converts a string of the form:
;#
;#    (<number>(s|m|h|d))+
;#
;# to seconds. The second part of the time spec specifies seconds, minutes, 
;# hours, or days, respectfully. The first part is the number of those untis. 
;# There can be any number of such specifiers. As an example, 1h30m means 1 
;# hour and 30 minutes.
;#
;# If the parsing went OK then $Status is 1, $Msg is undefined, and $Seconds
;# is $Time_Spec converted to seconds. If something went wrong then $Status
;# is 0 and $Msg explains what went wrong.
;#
;# Arguments:
;#    $Time_Spec
;#
;# Returns:
;#    $Status, $Msg, $Seconds
;###############################################################################
sub main'Time_Spec_To_Seconds
{
   $Time_Spec = $_[0];

   $Seconds = 0;
   while ($Time_Spec =~ /^(\d+)($VALID_TIME_SPEC_EXPR)/)
   {
      $Seconds += $1 * $TIME_SPEC_TO_SECONDS {$2};
      $Time_Spec = $';
   };

   return (0, "error parsing time spec: $Time_Spec") if ($Time_Spec ne "");
   return (1, "", $Seconds);

};


1;
