; long integer multiplication routine
;
; written by Kai-Uwe Bloem (I5110401@dbstu1.bitnet).
;
;
; Revision 1.1, kub 03-90
; first version, replaces the appropriate routine from fixnum.s.
; This one is longer, but normally faster because __umulsi3 is no longer
; called for multiplication. Rather, the code is inlined here. See the
; comments in _umulsi3.s

	text
	even
	xdef	__CXM22

__CXM22:
	movem.l	d2-d3,-(sp)
	move.l	d1,d2
	move.l	d1,d3
	swap	d2
	move.l	d0,d1
	swap	d0
	
	move.w	d0,-(sp)	; sign flag
	bpl.s	1$		; is u negative ?
	neg.w	d1		; yes, force it positive
	negx.w	d0
1$:	tst.w	d2		; is v negative ?
	bpl.s	2$
	neg.w	d3		; yes, force it positive ...
	negx.w	d2
	not.w	(sp)		;  ... and modify flag word
2$:
	ext.l	d0		; u.h <> 0 ?
	beq.s	3$
	mulu.w	d3,d0		; r  = v.l * u.h
3$:	tst.w	d2		; v.h <> 0 ?
	beq.s	4$
	mulu.w	d1,d2		; r += v.h * u.l
	add.w	d2,d0
4$:	swap	d0
	clr.w	d0
	mulu.w	d3,d1		; r += v.l * u.l
	add.l	d1,d0
	tst.w	(sp)+		; should the result be negated ?
	bpl.s	5$		; no, just return
	neg.l	d0		; else r = -r
5$	movem.l	(sp)+,d2-d3
	rts
	end
