/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

/*
	Display a boxchar (respecting 3d flags)
*/
void d_g_boxchar(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	short parent_x=odc_p->parent_x, parent_y=odc_p->parent_y;
	OBJC_COLORWORD *colourword;
	unsigned short zap;
	short border_thick=0,coords[4],tx,ty,temp;
	char temp_text[2];

	colourword=(OBJC_COLORWORD*)&zap;
	
	temp_text[0]=(char)((((unsigned long)ob->ob_spec)&0xff000000L)>>24);
	temp_text[1]='\0';
	zap=(unsigned short)ob->ob_spec&0xffff;
	border_thick=(short)((((unsigned long)ob->ob_spec)&0xff0000L)>>16);
	if (border_thick&128)
		border_thick=-(1+(border_thick^0xff));

	shadow_object(ob, parent_x, parent_y, colourword, border_thick);

	set_colours(ob, colourword);
	
	tx=parent_x + ob->ob_x + ((ob->ob_width-display.c_max_w)/2);	/* Centre the text in the box */
	ty=parent_y + ob->ob_y + ((ob->ob_height-display.c_max_h)/2);

	if (ob->ob_flags&FLD3DANY)
	{
		XA_3D_pushbutton(parent_x+ob->ob_x-1, parent_y+ob->ob_y-1, ob->ob_width+1, ob->ob_height+1, ob->ob_state&SELECTED);
		if (ob->ob_state&SELECTED)
		{
			tx+=PUSH3D_DISTANCE; ty+=PUSH3D_DISTANCE;
		}
	}else{
/*				if (colourword->opaque)*/
		{
			coords[0]=parent_x+ob->ob_x;
			coords[1]=parent_y+ob->ob_y;
			coords[2]=coords[0]+ob->ob_width-1;
			coords[3]=coords[1]+ob->ob_height-1;
			v_bar(V_handle, coords);
		}
		if (border_thick)			/* Display a border? */
		{
			draw_2d_box(parent_x+ob->ob_x, parent_y+ob->ob_y, 
						ob->ob_width, ob->ob_height,
						border_thick, colourword->borderc);
		}
	}

	vst_font(V_handle,display.standard_font_id);
	vst_point(V_handle,display.standard_font_point,&temp,&temp,&temp,&temp);
	vst_alignment(V_handle,0,5,&temp,&temp);
	vst_color(V_handle, colourword->textc);

	vswr_mode(V_handle, colourword->opaque ? MD_REPLACE:MD_TRANS);
	v_gtext(V_handle,tx,ty,temp_text);
}

