#declare Stones_Inc_Temp = version
#version 2.0
/*

                   Persistence of Vision Raytracer Version 2.0

                       Stone textures by Mike Miller  1992

    Contains declared texture statements defining a variety of
    stone granite & marble textures. Most use the granite texture.
    Turbulence has no effect on granite, but turbulence is stated
    before the color map for convenience of switching to marble, which
    does need a turbulence to swirl the color. I tried to avoid using
    a random dither, but I find it helps create a subtle grain & can
    spark lost colors in the map. On multi-layered texture, try a float
    of about 0.05 on the first texture.

    Final Note: I would not "INCLUDE" this whole data file into a scene
                file if only one or two of these textures were being
                used...There are too many declares being used.

    -----------------------------------------------------------------------
    The textures Grnt0-Grnt29, Grnt0A-Grnt24A and Crack1-Crack4 are
    "building blocks" that are used to create the final "usable" textures,
    Stone1 - Stone24 (and other textures that *you* design, of course!)

    INDEX:

            Grnt0  - Grnt29   color maps (generally) contain no filter values
            ------------------------------
                Grnt0  - Gray/Tan with Rose.
                Grnt1  - Creamy Whites with Yellow & Light Gray.
                Grnt2  - Deep Cream with Light Rose, Yellow, Orchid, & Tan.
                Grnt3  - Warm tans olive & light rose with cream.
                Grnt4  - Orchid, Sand & Mauve.
                Grnt5  - Medium Mauve Med.Rose & Deep Cream.
                Grnt6  - Med. Orchid, Olive & Dark Tan "mud pie".
                Grnt7  - Dark Orchid, Olive & Dark Putty.
                Grnt8  - Rose & Light Cream Yellows
                Grnt9  - Light Steely Grays
                Grnt10 - Gray Creams & Lavender Tans
                Grnt11 - Creams & Grays  Kahki
                Grnt12 - Tan Cream & Red Rose
                Grnt13 - Cream Rose Orange
                Grnt14 - Cream Rose & Light Moss w/Light Violet
                Grnt15 - Black with subtle chroma
                Grnt16 - White Cream & Peach
                Grnt17 - Bug Juice & Green
                Grnt18 - Rose & Creamy Yellow
                Grnt19 - Gray Marble with White feather Viens
                Grnt20 - White Marble with Gray feather Viens
                Grnt21 - Green Jade
                Grnt22 - Clear with White feather Viens (has some transparency)
                Grnt23 - Light Tan to Mauve
                Grnt24 - Light Grays
                Grnt25 - Moss Greens & Tan
                Grnt26 - Salmon with thin Green Viens
                Grnt27 - Dark Green & Browns
                Grnt28 - Red Swirl
                Grnt29 - White, Tan, w/ thin Red Viens

            Grnt0A - Grnt24A  color maps containing filter
            ------------------------------
                Grnt0a  - Translucent Grnt0
                Grnt1a  - Translucent Grnt1
                Grnt2a  - Translucent Grnt2
                Grnt3a  - Translucent Grnt3
                Grnt4a  - Translucent Grnt4
                Grnt5a  - Translucent Grnt5
                Grnt6a  - Translucent Grnt6
                Grnt7a  - Translucent Grnt7
                Grnt8a  - Aqua Tints
                Grnt9a  - Filter Creams With Cracks
                Grnt10a - Filter Cream Rose & light yellow
                Grnt11a - Filter Light Grays
                Grnt12a - Filter Creams & Tans
                Grnt13a - Filter Creams & Grays
                Grnt14a - Cream Rose & light moss
                Grnt15a - Filter Sand & light Orange
                Grnt16a - Cream Rose & light moss (again?)
                Grnt17a - ???
                Grnt18a - ???
                Grnt19a - Gray Marble with White feather Viens with Filter
                Grnt20a - White Feather Viens
                Grnt21a - Thin White Feather Viens
                Grnt22a - ???
                Grnt23a - Transparent Green Moss
                Grnt24a - ???

            Crack1 - Crack4   clear with an thin opaque band for Cracks
            ------------------------------
                Crack1 - Crack & Red Overtint
                Crack2 - Translucent Dark Cracks
                Crack3 - Overtint Green w/ Black Cracks
                Crack4 - Overtint w/ White Crack

            OTHERS

            Stone1 - Stone24  complete texture statements - edit to your
                              scene & lighting situations.
            ------------------------------
                Stone1 - Deep Rose & Green Marble with large White Swirls
                Stone2 - Light Greenish Tan Marble with Agate style veining
                Stone3 - Rose & Yellow Marble with fog white veining
                Stone4 - Tan Marble with Rose patches
                Stone5 - White Cream Marble with Pink veining
                Stone6 - Rose & Yellow Cream Marble
                Stone7 - Light Coffee Marble with darker patches
                Stone8 - Gray Granite with white patches
                Stone9 - White & Light Blue Marble with light violets
                Stone10- Dark Brown & Tan swirl Granite with gray undertones
                Stone11- Rose & White Marble with dark tan swirl
                Stone12- White & Pinkish Tan Marble
                Stone13- Medium Gray Blue Marble
                Stone14- Tan & Olive Marble with gray white veins
                Stone15- Deep Gray Marble with white veining
                Stone16- Peach & Yellow Marble with white veining
                Stone17- White Marble with gray veining
                Stone18- Green Jade with white veining
                Stone19- Peach Granite with white patches & green trim
                Stone20- Brown & Olive Marble with white veining
                Stone21- Red Marble with gray & white veining
                Stone22- Dark Tan Marble with gray & white veining
                Stone23- Peach & Cream Marble with orange veining
                Stone24- Green & Tan Moss Marble

    -----------------------------------------------------------------------
*/



//--------- Gray  Tan with Rose
#declare Grnt0 =
texture {
pigment
 {granite
  turbulence 0.4
  color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.000>
                    color rgbf <0.769, 0.686, 0.592, 0.000>]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.000>
                    color rgbf <0.843, 0.753, 0.718, 0.000>]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.000>
                    color rgbf <0.780, 0.667, 0.561, 0.000>]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.000>
                    color rgbf <0.741, 0.659, 0.576, 0.000>]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.000>
                    color rgbf <0.729, 0.502, 0.451, 0.000>]
   }
 }
 }

//----- Creamy Whites with yellow & light gray
#declare Grnt1 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.212   color rgbf <0.898, 0.898, 0.851, 0.000>
                    color rgbf <0.969, 0.980, 0.875, 0.000>]
    [0.212, 0.424   color rgbf <0.969, 0.980, 0.875, 0.000>
                    color rgbf <0.859, 0.859, 0.859, 0.000>]
    [0.424, 0.627   color rgbf <0.859, 0.859, 0.859, 0.000>
                    color rgbf <0.992, 0.922, 0.659, 0.000>]
    [0.627, 0.881   color rgbf <0.992, 0.922, 0.659, 0.000>
                    color rgbf <0.937, 0.965, 0.902, 0.000>]
    [0.881, 1.001   color rgbf <0.937, 0.965, 0.902, 0.000>
                    color rgbf <0.898, 0.898, 0.851, 0.000>]
   }
 }
 }

//------- Deep Cream with light rose, yellow orchid & tan
#declare Grnt2 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.863, 0.757, 0.596, 0.000>
                    color rgbf <0.925, 0.792, 0.714, 0.000>]
    [0.178, 0.356   color rgbf <0.925, 0.792, 0.714, 0.000>
                    color rgbf <0.871, 0.702, 0.659, 0.000>]
    [0.356, 0.525   color rgbf <0.871, 0.702, 0.659, 0.000>
                    color rgbf <0.992, 0.922, 0.659, 0.000>]
    [0.525, 0.729   color rgbf <0.992, 0.922, 0.659, 0.000>
                    color rgbf <0.902, 0.812, 0.714, 0.000>]
    [0.729, 1.001   color rgbf <0.902, 0.812, 0.714, 0.000>
                    color rgbf <0.863, 0.757, 0.596, 0.000>]
   }
 }
 }

//------- Warm tans olive & light rose with cream
#declare Grnt3 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.831, 0.631, 0.569, 0.000>
                    color rgbf <0.925, 0.831, 0.714, 0.000>]
    [0.178, 0.356   color rgbf <0.925, 0.831, 0.714, 0.000>
                    color rgbf <0.871, 0.702, 0.659, 0.000>]
    [0.356, 0.525   color rgbf <0.871, 0.702, 0.659, 0.000>
                    color rgbf <0.831, 0.631, 0.569, 0.000>]
    [0.525, 0.729   color rgbf <0.831, 0.631, 0.569, 0.000>
                    color rgbf <0.937, 0.882, 0.820, 0.000>]
    [0.729, 1.001   color rgbf <0.937, 0.882, 0.820, 0.000>
                    color rgbf <0.831, 0.631, 0.569, 0.000>]
   }
 }
 }

//-------- Orchid sand & mouve
#declare Grnt4 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.804, 0.569, 0.494, 0.000>
                    color rgbf <0.816, 0.725, 0.537, 0.000>]
    [0.178, 0.356   color rgbf <0.816, 0.725, 0.537, 0.000>
                    color rgbf <0.820, 0.580, 0.522, 0.000>]
    [0.356, 0.525   color rgbf <0.820, 0.580, 0.522, 0.000>
                    color rgbf <0.882, 0.725, 0.537, 0.000>]
    [0.525, 0.729   color rgbf <0.882, 0.725, 0.537, 0.000>
                    color rgbf <0.855, 0.729, 0.584, 0.000>]
    [0.729, 1.001   color rgbf <0.855, 0.729, 0.584, 0.000>
                    color rgbf <0.804, 0.569, 0.494, 0.000>]
   }
 }
 }

//------- Medium Mauve Med.Rose & deep cream
#declare Grnt5 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.804, 0.569, 0.494, 0.000>
                    color rgbf <0.855, 0.729, 0.584, 0.000>]
    [0.178, 0.356   color rgbf <0.855, 0.729, 0.584, 0.000>
                    color rgbf <0.667, 0.502, 0.478, 0.000>]
    [0.356, 0.525   color rgbf <0.667, 0.502, 0.478, 0.000>
                    color rgbf <0.859, 0.624, 0.545, 0.000>]
    [0.525, 0.729   color rgbf <0.859, 0.624, 0.545, 0.000>
                    color rgbf <0.855, 0.729, 0.584, 0.000>]
    [0.729, 1.001   color rgbf <0.855, 0.729, 0.584, 0.000>
                    color rgbf <0.804, 0.569, 0.494, 0.000>]
   }
 }
 }

//--------- Med. Orchid Olive & Dark Tan "mud pie"
#declare Grnt6 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.153   color rgbf <0.545, 0.380, 0.345, 0.000>
                    color rgbf <0.588, 0.475, 0.333, 0.000>]
    [0.153, 0.398   color rgbf <0.588, 0.475, 0.333, 0.000>
                    color rgbf <0.675, 0.478, 0.404, 0.000>]
    [0.398, 0.559   color rgbf <0.675, 0.478, 0.404, 0.000>
                    color rgbf <0.757, 0.635, 0.522, 0.000>]
    [0.559, 0.729   color rgbf <0.757, 0.635, 0.522, 0.000>
                    color rgbf <0.659, 0.549, 0.443, 0.000>]
    [0.729, 1.001   color rgbf <0.659, 0.549, 0.443, 0.000>
                    color rgbf <0.545, 0.380, 0.345, 0.000>]
   }
 }
 }

//------- Dark Orchid Olive & Dark Putty
#declare Grnt7 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.153   color rgbf <0.439, 0.310, 0.282, 0.000>
                    color rgbf <0.463, 0.369, 0.259, 0.000>]
    [0.153, 0.398   color rgbf <0.463, 0.369, 0.259, 0.000>
                    color rgbf <0.541, 0.369, 0.298, 0.000>]
    [0.398, 0.559   color rgbf <0.541, 0.369, 0.298, 0.000>
                    color rgbf <0.573, 0.424, 0.286, 0.000>]
    [0.559, 0.729   color rgbf <0.573, 0.424, 0.286, 0.000>
                    color rgbf <0.494, 0.396, 0.306, 0.000>]
    [0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.000>
                    color rgbf <0.439, 0.310, 0.282, 0.000>]
   }
 }
 }

//--------- Rose & Light cream Yellows
#declare Grnt8 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.179   color rgbf <0.843, 0.655, 0.655, 0.000>
                    color rgbf <0.886, 0.769, 0.627, 0.000>]
    [0.179, 0.368   color rgbf <0.886, 0.769, 0.627, 0.000>
                    color rgbf <0.906, 0.820, 0.714, 0.000>]
    [0.368, 0.538   color rgbf <0.906, 0.820, 0.714, 0.000>
                    color rgbf <0.851, 0.671, 0.671, 0.000>]
    [0.538, 0.846   color rgbf <0.851, 0.671, 0.671, 0.000>
                    color rgbf <0.890, 0.792, 0.675, 0.000>]
    [0.846, 0.983   color rgbf <0.890, 0.792, 0.675, 0.000>
                    color rgbf <0.827, 0.612, 0.612, 0.000>]
    [0.983, 1.001   color rgbf <0.827, 0.612, 0.612, 0.000>
                    color rgbf <0.843, 0.655, 0.655, 0.000>]
   }
 }
 }

//--------- Light Steely Grays
#declare Grnt9 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.000>
                    color rgbf <0.745, 0.745, 0.753, 0.000>]
    [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.000>
                    color rgbf <0.902, 0.902, 0.859, 0.000>]
    [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.000>
                    color rgbf <0.729, 0.706, 0.694, 0.000>]
    [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.000>
                    color rgbf <0.588, 0.592, 0.635, 0.000>]
    [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.000>
                    color rgbf <0.608, 0.616, 0.659, 0.000>]
    [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.000>
                    color rgbf <0.894, 0.886, 0.886, 0.000>]
   }
 }
 }

//--------- Gray Creams & lavender tans
#declare Grnt10 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.890, 0.690, 0.690, 0.000>
                    color rgbf <0.996, 0.835, 0.737, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.000>
                    color rgbf <0.745, 0.635, 0.651, 0.004>]
    [0.308, 0.444   color rgbf <0.745, 0.635, 0.651, 0.004>
                    color rgbf <0.733, 0.596, 0.557, 0.004>]
    [0.444, 0.615   color rgbf <0.733, 0.596, 0.557, 0.004>
                    color rgbf <0.996, 0.835, 0.737, 0.000>]
    [0.615, 0.803   color rgbf <0.996, 0.835, 0.737, 0.000>
                    color rgbf <0.765, 0.616, 0.659, 0.000>]
    [0.803, 1.001   color rgbf <0.765, 0.616, 0.659, 0.000>
                    color rgbf <0.890, 0.690, 0.690, 0.000>]
   }
 }
 }

//--------- Creams & Grays Kakhi
#declare Grnt11 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.800, 0.651, 0.557, 0.000>
                    color rgbf <0.996, 0.835, 0.737, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.000>
                    color rgbf <0.800, 0.651, 0.557, 0.000>]
    [0.308, 0.444   color rgbf <0.800, 0.651, 0.557, 0.000>
                    color rgbf <0.694, 0.624, 0.604, 0.004>]
    [0.444, 0.615   color rgbf <0.694, 0.624, 0.604, 0.004>
                    color rgbf <0.800, 0.651, 0.557, 0.000>]
    [0.615, 0.812   color rgbf <0.800, 0.651, 0.557, 0.000>
                    color rgbf <0.725, 0.655, 0.651, 0.000>]
    [0.812, 1.001   color rgbf <0.725, 0.655, 0.651, 0.000>
                    color rgbf <0.800, 0.651, 0.557, 0.000>]
   }
 }
 }

//--------- Tan Cream & Red Rose
#declare Grnt12 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.969, 0.800, 0.000>
                    color rgbf <0.996, 0.682, 0.604, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.682, 0.604, 0.000>
                    color rgbf <0.906, 0.820, 0.714, 0.000>]
    [0.308, 0.444   color rgbf <0.906, 0.820, 0.714, 0.000>
                    color rgbf <0.816, 0.631, 0.537, 0.000>]
    [0.444, 0.615   color rgbf <0.816, 0.631, 0.537, 0.000>
                    color rgbf <0.890, 0.792, 0.675, 0.000>]
    [0.615, 0.812   color rgbf <0.890, 0.792, 0.675, 0.000>
                    color rgbf <0.973, 0.627, 0.627, 0.000>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.000>
                    color rgbf <0.996, 0.969, 0.800, 0.000>]
   }
 }
 }

//--------- Cream Rose orange
#declare Grnt13 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.824, 0.780, 0.000>
                    color rgbf <0.996, 0.698, 0.624, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.698, 0.624, 0.000>
                    color rgbf <0.906, 0.675, 0.553, 0.000>]
    [0.308, 0.444   color rgbf <0.906, 0.675, 0.553, 0.000>
                    color rgbf <0.996, 0.682, 0.604, 0.000>]
    [0.444, 0.615   color rgbf <0.996, 0.682, 0.604, 0.000>
                    color rgbf <0.996, 0.824, 0.780, 0.000>]
    [0.615, 0.812   color rgbf <0.996, 0.824, 0.780, 0.000>
                    color rgbf <0.973, 0.627, 0.627, 0.000>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.000>
                    color rgbf <0.996, 0.824, 0.780, 0.000>]
   }
 }
 }

//--------- Cream Rose & light moss & light Violet
#declare Grnt14 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.690, 0.612, 0.569, 0.000>
                    color rgbf <0.737, 0.596, 0.522, 0.000>]
    [0.154, 0.368   color rgbf <0.737, 0.596, 0.522, 0.000>
                    color rgbf <0.776, 0.702, 0.624, 0.000>]
    [0.368, 0.538   color rgbf <0.776, 0.702, 0.624, 0.000>
                    color rgbf <0.796, 0.678, 0.643, 0.000>]
    [0.538, 0.846   color rgbf <0.796, 0.678, 0.643, 0.000>
                    color rgbf <0.690, 0.612, 0.569, 0.000>]
    [0.846, 0.932   color rgbf <0.690, 0.612, 0.569, 0.000>
                    color rgbf <0.773, 0.612, 0.569, 0.000>]
    [0.932, 1.001   color rgbf <0.773, 0.612, 0.569, 0.000>
                    color rgbf <0.690, 0.612, 0.569, 0.000>]
   }
 }
 }

//--------- Black with subtle chroma
#declare Grnt15 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.104   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.110, 0.082, 0.071, 0.000>]
    [0.104, 0.252   color rgbf <0.110, 0.082, 0.071, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
    [0.252, 0.383   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.000, 0.000, 0.000, 0.000>]
    [0.383, 0.643   color rgbf <0.000, 0.000, 0.000, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
    [0.643, 0.783   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.220, 0.149, 0.137, 0.000>]
    [0.783, 0.922   color rgbf <0.220, 0.149, 0.137, 0.000>
                    color rgbf <0.000, 0.000, 0.000, 0.000>]
    [0.922, 0.983   color rgbf <0.000, 0.000, 0.000, 0.000>
                    color rgbf <0.220, 0.149, 0.137, 0.000>]
    [0.983, 1.001   color rgbf <0.220, 0.149, 0.137, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
   }
 }
 }

//----- White Cream & Peach
#declare Grnt16 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.316   color rgbf <0.910, 0.788, 0.788, 0.000>
                    color rgbf <0.922, 0.914, 0.871, 0.000>]
    [0.316, 0.453   color rgbf <0.922, 0.914, 0.871, 0.000>
                    color rgbf <0.894, 0.867, 0.780, 0.000>]
    [0.453, 0.624   color rgbf <0.894, 0.867, 0.780, 0.000>
                    color rgbf <0.784, 0.788, 0.788, 0.000>]
    [0.624, 0.726   color rgbf <0.784, 0.788, 0.788, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.000>]
    [0.726, 0.863   color rgbf <0.851, 0.812, 0.741, 0.000>
                    color rgbf <0.647, 0.655, 0.655, 0.000>]
    [0.863, 1.001   color rgbf <0.647, 0.655, 0.655, 0.000>
                    color rgbf <0.910, 0.788, 0.788, 0.000>]
   }
 }
 }

//----- Bug Juice & Green
#declare Grnt17 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.303   color rgbf <0.000, 0.239, 0.000, 0.000>
                    color rgbf <0.333, 0.294, 0.000, 0.000>]
    [0.303, 0.588   color rgbf <0.333, 0.294, 0.000, 0.000>
                    color rgbf <0.000, 0.239, 0.341, 0.000>]
    [0.588, 0.790   color rgbf <0.000, 0.239, 0.341, 0.000>
                    color rgbf <0.000, 0.020, 0.000, 0.000>]
    [0.790, 1.001   color rgbf <0.000, 0.020, 0.000, 0.000>
                    color rgbf <0.000, 0.239, 0.000, 0.000>]
   }
 }
 }

//------------ Rose & cream yellow
#declare Grnt18 =
texture {
pigment
 {granite
  turbulence 0.4
  color_map
   {[0.000, 0.202   color rgbf <1.000, 0.718, 0.541, 0.000>
                    color rgbf <0.890, 0.651, 0.612, 0.000>]
    [0.202, 0.298   color rgbf <0.890, 0.651, 0.612, 0.000>
                    color rgbf <1.000, 0.820, 0.675, 0.000>]
    [0.298, 0.377   color rgbf <1.000, 0.820, 0.675, 0.000>
                    color rgbf <0.890, 0.643, 0.612, 0.000>]
    [0.377, 0.465   color rgbf <0.890, 0.643, 0.612, 0.000>
                    color rgbf <0.937, 0.729, 0.561, 0.000>]
    [0.465, 0.544   color rgbf <0.937, 0.729, 0.561, 0.000>
                    color rgbf <0.878, 0.604, 0.565, 0.000>]
    [0.544, 0.640   color rgbf <0.878, 0.604, 0.565, 0.000>
                    color rgbf <0.984, 0.780, 0.655, 0.000>]
    [0.640, 0.860   color rgbf <0.984, 0.780, 0.655, 0.000>
                    color rgbf <1.000, 0.863, 0.635, 0.000>]
    [0.860, 0.982   color rgbf <1.000, 0.863, 0.635, 0.000>
                    color rgbf <1.000, 0.765, 0.620, 0.000>]
    [0.982, 1.001   color rgbf <1.000, 0.765, 0.620, 0.000>
                    color rgbf <1.000, 0.718, 0.541, 0.000>]
   }
 }
 }

//--------- Gray Marble with White feather Viens
#declare Grnt19 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color White color DimGray]
    [0.3, 0.4 color DimGray color DimGray]
    [0.4, 0.6 color DimGray color DimGray]
    [0.6, 1.0 color DimGray color DimGray]
   }
 }
 finish {
  crand 0.02
 }
 }

//--------- White Marble with Gray feather Viens
#declare Grnt20 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color Mica color White]
    [0.3, 0.4 color White color White]
    [0.4, 0.6 color White color White]
    [0.6, 1.0 color White color White]
   }
 }
 finish {
  crand 0.02
 }
 }

//-------- Declare Green Colors
#declare g1 = color red 0.26 green 0.41 blue 0.31 //---Light Gray Green
#declare g2 = color red 0.27 green 0.34 blue 0.26 //---Med Gray Green
#declare g3 = color red 0.13 green 0.29 blue 0.28 //---Med Gray Aqua
#declare g4 = color red 0.03 green 0.18 blue 0.08 //---Dark Green

//--------- Green Jade
#declare Grnt21 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.1 color White    filter 0.3 color SeaGreen  filter 0.4]
    [0.1, 0.3 color SeaGreen filter 0.4 color g2        filter 0.7]
    [0.3, 0.5 color g2       filter 0.7 color DarkGreen filter 0.7]
    [0.5, 0.7 color DarkGreen  filter 0.7 color g4 filter 0.7]
    [0.7, 0.8 color g4         filter 0.7 color DarkGreen filter 0.7]
    [0.8, 1.0 color DarkGreen  filter 0.7 color DarkGreen filter 0.7]
   }
 }
 finish {
  crand 0.02
 }
 }

//--------- Clear with White feather Viens ----- This one does contain Filter
#declare Grnt22 =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.07 color White color White]
    [0.07, 0.2 color White color DimGray]
    [0.2, 0.3 color DimGray color Clear]
    [0.3, 0.7 color Clear color Clear]
    [0.7, 1.0 color Clear color DimGray]
   }
 }
 finish {
  crand 0.02
 }
 }

//---------- Light Tan to Mouve
#declare Grnt23 =
texture {
pigment
 {marble
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.831, 0.631, 0.569, 0.000>
                    color rgbf <0.925, 0.831, 0.714, 0.000>]
    [0.178, 0.356   color rgbf <0.925, 0.831, 0.714, 0.000>
                    color rgbf <0.871, 0.702, 0.659, 0.000>]
    [0.356, 0.525   color rgbf <0.871, 0.702, 0.659, 0.000>
                    color rgbf <0.831, 0.631, 0.569, 0.000>]
    [0.525, 0.729   color rgbf <0.831, 0.631, 0.569, 0.000>
                    color rgbf <0.937, 0.882, 0.820, 0.000>]
    [0.729, 1.001   color rgbf <0.937, 0.882, 0.820, 0.000>
                    color rgbf <0.831, 0.631, 0.569, 0.000>]
   }
 }
 }

//--------- Light Grays
#declare Grnt24 =
texture {
pigment
 {marble
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.000>
                    color rgbf <0.745, 0.745, 0.753, 0.000>]
    [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.000>
                    color rgbf <0.902, 0.902, 0.859, 0.000>]
    [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.000>
                    color rgbf <0.729, 0.706, 0.694, 0.000>]
    [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.000>
                    color rgbf <0.588, 0.592, 0.635, 0.000>]
    [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.000>
                    color rgbf <0.608, 0.616, 0.659, 0.000>]
    [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.000>
                    color rgbf <0.894, 0.886, 0.886, 0.000>]
   }
 }
 }

//------------ Moss Greens & Tan
#declare Grnt25 =
texture {
pigment
 {marble
  turbulence 0.7
  color_map
   {[0.000, 0.168   color rgbf <0.824, 0.725, 0.584, 0.000>
                    color rgbf <0.514, 0.584, 0.533, 0.000>]
    [0.168, 0.301   color rgbf <0.514, 0.584, 0.533, 0.000>
                    color rgbf <0.298, 0.376, 0.318, 0.000>]
    [0.301, 0.398   color rgbf <0.298, 0.376, 0.318, 0.000>
                    color rgbf <0.263, 0.337, 0.282, 0.000>]
    [0.398, 0.558   color rgbf <0.263, 0.337, 0.282, 0.000>
                    color rgbf <0.431, 0.506, 0.451, 0.000>]
    [0.558, 0.655   color rgbf <0.431, 0.506, 0.451, 0.000>
                    color rgbf <0.529, 0.631, 0.471, 0.000>]
    [0.655, 0.735   color rgbf <0.529, 0.631, 0.471, 0.000>
                    color rgbf <0.333, 0.376, 0.318, 0.000>]
    [0.735, 0.823   color rgbf <0.333, 0.376, 0.318, 0.000>
                    color rgbf <0.298, 0.376, 0.318, 0.000>]
    [0.823, 0.876   color rgbf <0.298, 0.376, 0.318, 0.000>
                    color rgbf <0.416, 0.376, 0.318, 0.000>]
    [0.876, 0.929   color rgbf <0.416, 0.376, 0.318, 0.000>
                    color rgbf <0.416, 0.376, 0.318, 0.000>]
    [0.929, 1.001   color rgbf <0.416, 0.376, 0.318, 0.000>
                    color rgbf <0.824, 0.725, 0.584, 0.000>]
   }
 }
 }

//---------- Salmon with thin Green Viens
#declare Grnt26 =
texture {
pigment
 {granite
  color_map
   {[0.000, 0.241   color rgbf <0.973, 0.973, 0.976, 0.000>
                    color rgbf <0.973, 0.973, 0.976, 0.000>]
    [0.241, 0.284   color rgbf <0.973, 0.973, 0.976, 0.000>
                    color rgbf <0.600, 0.741, 0.608, 0.000>]
    [0.284, 0.336   color rgbf <0.600, 0.741, 0.608, 0.000>
                    color rgbf <0.820, 0.643, 0.537, 0.000>]
    [0.336, 0.474   color rgbf <0.820, 0.643, 0.537, 0.000>
                    color rgbf <0.886, 0.780, 0.714, 0.000>]
    [0.474, 0.810   color rgbf <0.886, 0.780, 0.714, 0.000>
                    color rgbf <0.996, 0.643, 0.537, 0.000>]
    [0.810, 0.836   color rgbf <0.996, 0.643, 0.537, 0.000>
                    color rgbf <0.973, 0.973, 0.976, 0.000>]
    [0.836, 1.001   color rgbf <0.973, 0.973, 0.976, 0.000>
                    color rgbf <0.973, 0.973, 0.976, 0.000>]
   }
 }
 finish {
  crand 0.02
 }
 }

//------ Dark Green & Browns
#declare Grnt27 =
texture {
pigment
 {granite
  color_map
   {[0.000, 0.043   color rgbf <0.773, 0.647, 0.569, 0.000>
                    color rgbf <0.431, 0.322, 0.227, 0.000>]
    [0.043, 0.113   color rgbf <0.431, 0.322, 0.227, 0.000>
                    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.113, 0.304   color rgbf <0.278, 0.282, 0.216, 0.000>
                    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.304, 0.426   color rgbf <0.278, 0.282, 0.216, 0.000>
                    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.426, 0.843   color rgbf <0.459, 0.341, 0.243, 0.000>
                    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.843, 0.878   color rgbf <0.459, 0.341, 0.243, 0.000>
                    color rgbf <0.459, 0.341, 0.243, 0.000>]
    [0.878, 0.983   color rgbf <0.459, 0.341, 0.243, 0.000>
                    color rgbf <0.278, 0.282, 0.216, 0.000>]
    [0.983, 1.001   color rgbf <0.278, 0.282, 0.216, 0.000>
                    color rgbf <0.773, 0.647, 0.569, 0.000>]
   }
 }
 }

//------- Red Swirl
#declare Grnt28 =
texture {
pigment
 {marble
  turbulence 0.7
  color_map
   {[0.000, 0.155   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
    [0.155, 0.328   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.494, 0.243, 0.294, 0.000>]
    [0.328, 0.474   color rgbf <0.494, 0.243, 0.294, 0.000>
                    color rgbf <0.769, 0.329, 0.373, 0.000>]
    [0.474, 0.647   color rgbf <0.769, 0.329, 0.373, 0.000>
                    color rgbf <0.769, 0.329, 0.373, 0.000>]
    [0.647, 0.810   color rgbf <0.769, 0.329, 0.373, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
    [0.810, 0.922   color rgbf <0.686, 0.235, 0.282, 0.000>
                    color rgbf <0.792, 0.388, 0.427, 0.000>]
    [0.922, 1.001   color rgbf <0.792, 0.388, 0.427, 0.000>
                    color rgbf <0.686, 0.235, 0.282, 0.000>]
   }
 }
 finish {
  crand 0.03
 }
 }

//-------- White Tan & thin Reds
#declare Grnt29 =
texture {
pigment
 {marble
  turbulence 0.5
  color_map
   {[0.000, 0.053   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.784, 0.627, 0.624, 0.000>]
    [0.053, 0.263   color rgbf <0.784, 0.627, 0.624, 0.000>
                    color rgbf <0.824, 0.557, 0.376, 0.000>]
    [0.263, 0.281   color rgbf <0.824, 0.557, 0.376, 0.000>
                    color rgbf <0.643, 0.380, 0.376, 0.000>]
    [0.281, 0.325   color rgbf <0.643, 0.380, 0.376, 0.000>
                    color rgbf <0.839, 0.722, 0.722, 0.000>]
    [0.325, 0.711   color rgbf <0.839, 0.722, 0.722, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
    [0.711, 0.798   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.769, 0.380, 0.376, 0.000>]
    [0.798, 0.895   color rgbf <0.769, 0.380, 0.376, 0.000>
                    color rgbf <0.824, 0.557, 0.376, 0.000>]
    [0.895, 0.982   color rgbf <0.824, 0.557, 0.376, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
    [0.982, 1.001   color rgbf <0.784, 0.627, 0.522, 0.000>
                    color rgbf <0.784, 0.627, 0.522, 0.000>]
   }
 }
 }

//***************************************************************
//------------ start of textures with filter

//----- Translucent Grnt0
#declare Grnt0a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.729, 0.502, 0.451, 0.306>
                    color rgbf <0.769, 0.686, 0.592, 0.792>]
    [0.153, 0.398   color rgbf <0.769, 0.686, 0.592, 0.792>
                    color rgbf <0.843, 0.753, 0.718, 0.396>]
    [0.398, 0.559   color rgbf <0.843, 0.753, 0.718, 0.396>
                    color rgbf <0.780, 0.667, 0.561, 0.976>]
    [0.559, 0.729   color rgbf <0.780, 0.667, 0.561, 0.976>
                    color rgbf <0.741, 0.659, 0.576, 0.820>]
    [0.729, 1.001   color rgbf <0.741, 0.659, 0.576, 0.820>
                    color rgbf <0.729, 0.502, 0.451, 0.306>]
   }
 }
 }

//----- Translucent Grnt1
#declare Grnt1a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.212   color rgbf <0.898, 0.898, 0.851, 0.306>
                    color rgbf <0.969, 0.980, 0.875, 0.792>]
    [0.212, 0.424   color rgbf <0.969, 0.980, 0.875, 0.792>
                    color rgbf <0.859, 0.859, 0.859, 0.396>]
    [0.424, 0.627   color rgbf <0.859, 0.859, 0.859, 0.396>
                    color rgbf <0.992, 0.922, 0.659, 0.976>]
    [0.627, 0.881   color rgbf <0.992, 0.922, 0.659, 0.976>
                    color rgbf <0.937, 0.965, 0.902, 0.820>]
    [0.881, 1.001   color rgbf <0.937, 0.965, 0.902, 0.820>
                    color rgbf <0.898, 0.898, 0.851, 0.306>]
   }
 }
 }

//-----Translucent Grnt2
#declare Grnt2a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.144   color rgbf <0.863, 0.757, 0.596, 0.596>
                    color rgbf <0.925, 0.792, 0.714, 0.349>]
    [0.144, 0.288   color rgbf <0.925, 0.792, 0.714, 0.349>
                    color rgbf <0.871, 0.702, 0.659, 0.784>]
    [0.288, 0.644   color rgbf <0.871, 0.702, 0.659, 0.784>
                    color rgbf <0.992, 0.922, 0.659, 0.498>]
    [0.644, 0.983   color rgbf <0.992, 0.922, 0.659, 0.498>
                    color rgbf <0.902, 0.812, 0.714, 0.722>]
    [0.983, 1.001   color rgbf <0.902, 0.812, 0.714, 0.722>
                    color rgbf <0.863, 0.757, 0.596, 0.596>]
   }
 }
 }

//-----Translucent Grnt3
#declare Grnt3a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.153   color rgbf <0.831, 0.631, 0.569, 0.447>
                    color rgbf <0.925, 0.831, 0.714, 0.678>]
    [0.153, 0.297   color rgbf <0.925, 0.831, 0.714, 0.678>
                    color rgbf <0.871, 0.702, 0.659, 0.475>]
    [0.297, 0.441   color rgbf <0.871, 0.702, 0.659, 0.475>
                    color rgbf <0.831, 0.631, 0.569, 0.918>]
    [0.441, 0.763   color rgbf <0.831, 0.631, 0.569, 0.918>
                    color rgbf <0.937, 0.882, 0.820, 0.655>]
    [0.763, 1.001   color rgbf <0.937, 0.882, 0.820, 0.655>
                    color rgbf <0.831, 0.631, 0.569, 0.447>]
   }
 }
 }

//-----Translucent Grnt4
#declare Grnt4a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.144   color rgbf <0.804, 0.569, 0.494, 0.569>
                    color rgbf <0.816, 0.725, 0.537, 0.467>]
    [0.144, 0.449   color rgbf <0.816, 0.725, 0.537, 0.467>
                    color rgbf <0.820, 0.580, 0.522, 0.584>]
    [0.449, 0.568   color rgbf <0.820, 0.580, 0.522, 0.584>
                    color rgbf <0.882, 0.725, 0.537, 0.871>]
    [0.568, 0.754   color rgbf <0.882, 0.725, 0.537, 0.871>
                    color rgbf <0.855, 0.729, 0.584, 0.816>]
    [0.754, 1.001   color rgbf <0.855, 0.729, 0.584, 0.816>
                    color rgbf <0.804, 0.569, 0.494, 0.569>]
   }
 }
 }

//-----Translucent Grnt5
#declare Grnt5a =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.178   color rgbf <0.804, 0.569, 0.494, 0.569>
                    color rgbf <0.855, 0.729, 0.584, 0.467>]
    [0.178, 0.356   color rgbf <0.855, 0.729, 0.584, 0.467>
                    color rgbf <0.667, 0.502, 0.478, 0.584>]
    [0.356, 0.525   color rgbf <0.667, 0.502, 0.478, 0.584>
                    color rgbf <0.859, 0.624, 0.545, 0.871>]
    [0.525, 0.729   color rgbf <0.859, 0.624, 0.545, 0.871>
                    color rgbf <0.855, 0.729, 0.584, 0.816>]
    [0.729, 1.001   color rgbf <0.855, 0.729, 0.584, 0.816>
                    color rgbf <0.804, 0.569, 0.494, 0.569>]
   }
 }
 }

//-----Translucent Grnt6
#declare Grnt6a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.263   color rgbf <0.545, 0.380, 0.345, 0.733>
                    color rgbf <0.588, 0.475, 0.333, 0.741>]
    [0.263, 0.432   color rgbf <0.588, 0.475, 0.333, 0.741>
                    color rgbf <0.675, 0.478, 0.404, 0.545>]
    [0.432, 0.551   color rgbf <0.675, 0.478, 0.404, 0.545>
                    color rgbf <0.757, 0.635, 0.522, 0.384>]
    [0.551, 0.720   color rgbf <0.757, 0.635, 0.522, 0.384>
                    color rgbf <0.659, 0.549, 0.443, 0.675>]
    [0.720, 1.001   color rgbf <0.659, 0.549, 0.443, 0.675>
                    color rgbf <0.545, 0.380, 0.345, 0.733>]
   }
 }
 }

//-----Translucent Grnt7
#declare Grnt7a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.439, 0.310, 0.282, 0.631>
                    color rgbf <0.463, 0.369, 0.259, 0.847>]
    [0.119, 0.322   color rgbf <0.463, 0.369, 0.259, 0.847>
                    color rgbf <0.541, 0.369, 0.298, 0.549>]
    [0.322, 0.449   color rgbf <0.541, 0.369, 0.298, 0.549>
                    color rgbf <0.573, 0.424, 0.286, 0.965>]
    [0.449, 0.729   color rgbf <0.573, 0.424, 0.286, 0.965>
                    color rgbf <0.494, 0.396, 0.306, 0.741>]
    [0.729, 1.001   color rgbf <0.494, 0.396, 0.306, 0.741>
                    color rgbf <0.439, 0.310, 0.282, 0.631>]
   }
 }
 }

//-----Aqua Tints
#declare Grnt8a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.119   color rgbf <0.310, 0.384, 0.420, 0.631>
                    color rgbf <0.322, 0.369, 0.416, 0.847>]
    [0.119, 0.322   color rgbf <0.322, 0.369, 0.416, 0.847>
                    color rgbf <0.424, 0.369, 0.420, 0.549>]
    [0.322, 0.449   color rgbf <0.424, 0.369, 0.420, 0.549>
                    color rgbf <0.373, 0.424, 0.518, 0.965>]
    [0.449, 0.729   color rgbf <0.373, 0.424, 0.518, 0.965>
                    color rgbf <0.482, 0.573, 0.533, 0.741>]
    [0.729, 1.001   color rgbf <0.482, 0.573, 0.533, 0.741>
                    color rgbf <0.310, 0.384, 0.420, 0.631>]
   }
 }
 }

//-----Filter Creams With Cracks
#declare Grnt9a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.216   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.745, 0.843, 0.835, 0.847>]
    [0.216, 0.241   color rgbf <0.745, 0.843, 0.835, 0.847>
                    color rgbf <0.404, 0.337, 0.337, 0.463>]
    [0.241, 0.267   color rgbf <0.404, 0.337, 0.337, 0.463>
                    color rgbf <0.773, 0.729, 0.745, 0.622>]
    [0.267, 0.759   color rgbf <0.773, 0.729, 0.745, 0.622>
                    color rgbf <0.914, 0.843, 0.725, 0.651>]
    [0.759, 0.784   color rgbf <0.914, 0.843, 0.725, 0.651>
                    color rgbf <0.153, 0.133, 0.208, 0.437>]
    [0.784, 0.810   color rgbf <0.153, 0.133, 0.208, 0.437>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
    [0.810, 1.001   color rgbf <0.812, 0.812, 0.812, 0.835>
                    color rgbf <0.812, 0.812, 0.812, 0.835>]
   }
 }
 }

//--------- Filter Cream Rose & light yellow
#declare Grnt10a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.179   color rgbf <0.843, 0.655, 0.655, 0.455>
                    color rgbf <0.886, 0.769, 0.627, 0.608>]
    [0.179, 0.368   color rgbf <0.886, 0.769, 0.627, 0.608>
                    color rgbf <0.906, 0.820, 0.714, 0.392>]
    [0.368, 0.538   color rgbf <0.906, 0.820, 0.714, 0.392>
                    color rgbf <0.851, 0.671, 0.671, 0.659>]
    [0.538, 0.744   color rgbf <0.851, 0.671, 0.671, 0.659>
                    color rgbf <0.890, 0.792, 0.675, 0.392>]
    [0.744, 0.983   color rgbf <0.890, 0.792, 0.675, 0.392>
                    color rgbf <0.827, 0.612, 0.612, 0.706>]
    [0.983, 1.001   color rgbf <0.827, 0.612, 0.612, 0.706>
                    color rgbf <0.843, 0.655, 0.655, 0.455>]
   }
 }
 }

//--------- Filter Light Grays
#declare Grnt11a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.894, 0.886, 0.886, 0.659>
                    color rgbf <0.745, 0.745, 0.753, 0.584>]
    [0.154, 0.308   color rgbf <0.745, 0.745, 0.753, 0.584>
                    color rgbf <0.902, 0.902, 0.859, 0.780>]
    [0.308, 0.444   color rgbf <0.902, 0.902, 0.859, 0.780>
                    color rgbf <0.729, 0.706, 0.694, 0.686>]
    [0.444, 0.615   color rgbf <0.729, 0.706, 0.694, 0.686>
                    color rgbf <0.588, 0.592, 0.635, 0.424>]
    [0.615, 0.803   color rgbf <0.588, 0.592, 0.635, 0.424>
                    color rgbf <0.608, 0.616, 0.659, 0.761>]
    [0.803, 1.001   color rgbf <0.608, 0.616, 0.659, 0.761>
                    color rgbf <0.894, 0.886, 0.886, 0.659>]
   }
 }
 }

//--------- Filter Creams & Tans
#declare Grnt12a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.890, 0.690, 0.690, 0.659>
                    color rgbf <0.996, 0.835, 0.737, 0.659>]
    [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.659>
                    color rgbf <0.745, 0.635, 0.651, 0.780>]
    [0.308, 0.444   color rgbf <0.745, 0.635, 0.651, 0.780>
                    color rgbf <0.733, 0.596, 0.557, 0.686>]
    [0.444, 0.615   color rgbf <0.733, 0.596, 0.557, 0.686>
                    color rgbf <0.996, 0.835, 0.737, 0.659>]
    [0.615, 0.803   color rgbf <0.996, 0.835, 0.737, 0.659>
                    color rgbf <0.765, 0.616, 0.659, 0.761>]
    [0.803, 1.001   color rgbf <0.765, 0.616, 0.659, 0.761>
                    color rgbf <0.890, 0.690, 0.690, 0.659>]
   }
 }
 }

//--------- Filter Creams & Grays
#declare Grnt13a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.800, 0.651, 0.557, 0.000>
                    color rgbf <0.996, 0.835, 0.737, 0.608>]
    [0.154, 0.308   color rgbf <0.996, 0.835, 0.737, 0.608>
                    color rgbf <0.800, 0.651, 0.557, 0.635>]
    [0.308, 0.444   color rgbf <0.800, 0.651, 0.557, 0.635>
                    color rgbf <0.694, 0.624, 0.604, 0.294>]
    [0.444, 0.615   color rgbf <0.694, 0.624, 0.604, 0.294>
                    color rgbf <0.800, 0.651, 0.557, 0.816>]
    [0.615, 0.812   color rgbf <0.800, 0.651, 0.557, 0.816>
                    color rgbf <0.725, 0.655, 0.651, 0.957>]
    [0.812, 1.001   color rgbf <0.725, 0.655, 0.651, 0.957>
                    color rgbf <0.800, 0.651, 0.557, 0.000>]
   }
 }
 }

//--------- Cream Rose & light moss
#declare Grnt14a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.969, 0.800, 0.373>
                    color rgbf <0.996, 0.682, 0.604, 0.412>]
    [0.154, 0.308   color rgbf <0.996, 0.682, 0.604, 0.412>
                    color rgbf <0.906, 0.820, 0.714, 0.616>]
    [0.308, 0.444   color rgbf <0.906, 0.820, 0.714, 0.616>
                    color rgbf <0.816, 0.631, 0.537, 0.443>]
    [0.444, 0.615   color rgbf <0.816, 0.631, 0.537, 0.443>
                    color rgbf <0.890, 0.792, 0.675, 0.745>]
    [0.615, 0.812   color rgbf <0.890, 0.792, 0.675, 0.745>
                    color rgbf <0.973, 0.627, 0.627, 0.600>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.600>
                    color rgbf <0.996, 0.969, 0.800, 0.373>]
   }
 }
 }

//--------- Filter Sand & light Orange
#declare Grnt15a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.824, 0.780, 0.412>
                    color rgbf <0.996, 0.698, 0.624, 0.412>]
    [0.154, 0.308   color rgbf <0.996, 0.698, 0.624, 0.412>
                    color rgbf <0.906, 0.675, 0.553, 0.616>]
    [0.308, 0.444   color rgbf <0.906, 0.675, 0.553, 0.616>
                    color rgbf <0.996, 0.682, 0.604, 0.412>]
    [0.444, 0.615   color rgbf <0.996, 0.682, 0.604, 0.412>
                    color rgbf <0.996, 0.824, 0.780, 0.412>]
    [0.615, 0.812   color rgbf <0.996, 0.824, 0.780, 0.412>
                    color rgbf <0.973, 0.627, 0.627, 0.600>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.600>
                    color rgbf <0.996, 0.824, 0.780, 0.412>]
   }
 }
 }

//--------- Cream Rose & light moss
#declare Grnt16a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.078   color rgbf <0.769, 0.722, 0.690, 0.180>
                    color rgbf <0.745, 0.690, 0.655, 1.000>]
    [0.078, 0.96    color rgbf <0.745, 0.690, 0.655, 1.000>
                    color rgbf <0.839, 0.804, 0.780, 1.000>]
    [0.96, 1.001    color rgbf <0.839, 0.804, 0.780, 0.278>
                    color rgbf <0.769, 0.722, 0.690, 0.180>]
   }
 }
 }

#declare Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbf <0.027, 0.012, 0.012, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.034, 0.342   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.839>]
    [0.342, 0.462   color rgbf <0.792, 0.694, 0.690, 0.839>
                    color rgbf <0.631, 0.506, 0.471, 0.608>]
    [0.462, 0.632   color rgbf <0.631, 0.506, 0.471, 0.608>
                    color rgbf <0.851, 0.812, 0.741, 0.922>]
    [0.632, 0.983   color rgbf <0.851, 0.812, 0.741, 0.922>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.027, 0.012, 0.012, 0.000>]
   }
 }
 }

#declare Grnt18a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.128   color rgbf <0.820, 0.580, 0.580, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.128, 0.282   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.282>]
    [0.282, 0.393   color rgbf <0.792, 0.694, 0.690, 0.282>
                    color rgbf <0.647, 0.655, 0.655, 0.133>]
    [0.393, 0.590   color rgbf <0.647, 0.655, 0.655, 0.133>
                    color rgbf <0.851, 0.812, 0.741, 0.333>]
    [0.590, 0.983   color rgbf <0.851, 0.812, 0.741, 0.333>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.820, 0.580, 0.580, 0.000>]
   }
 }
 }

//--------- Gray Marble with White feather Viens with Filter
#declare Grnt19a =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.3 color White filter 0.0 color DimGray filter 0.5]
    [0.3, 0.4 color DimGray filter 0.5 color DimGray filter 0.8]
    [0.4, 1.0 color DimGray filter 0.8 color DimGray filter 0.9]
   }
 }
 finish {
  crand 0.02
 }
 }

//--------- White Feature Viens
#declare Grnt20a =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.2 color White filter 0.0 color White filter 0.7]
    [0.2, 0.3 color White filter 0.7 color Clear]
    [0.3, 1.0 color Clear color Clear]
   }
 }
 finish {
  crand 0.02
 }
 }

//--------- Thinner White Feature Viens
#declare Grnt21a =
texture {
pigment
 {granite
  turbulence 0.0
  color_map
   {[0.0, 0.2 color White filter 0.4 color White filter 0.8]
    [0.2, 0.3 color White filter 0.8 color Clear]
    [0.3, 1.0 color Clear color Clear]
   }
 }
 finish {
  crand 0.02
 }
 }

#declare Grnt22a =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.175   color rgbf <1.000, 0.718, 0.541, 0.890>
                    color rgbf <0.843, 0.678, 0.655, 0.753>]
    [0.175, 0.228   color rgbf <0.843, 0.678, 0.655, 0.753>
                    color rgbf <0.906, 0.831, 0.773, 0.98>]
    [0.228, 0.386   color rgbf <0.906, 0.831, 0.773, 0.698>
                    color rgbf <0.992, 0.718, 0.545, 0.794>]
    [0.386, 0.412   color rgbf <0.992, 0.718, 0.545, 0.794>
                    color rgbf <0.333, 0.188, 0.067, 0.784>]
    [0.412, 0.439   color rgbf <0.333, 0.188, 0.067, 0.784>
                    color rgbf <0.925, 0.557, 0.514, 0.778>]
    [0.439, 0.684   color rgbf <0.925, 0.557, 0.514, 0.678>
                    color rgbf <0.984, 0.780, 0.655, 0.696>]
    [0.684, 0.781   color rgbf <0.984, 0.780, 0.655, 0.696>
                    color rgbf <0.965, 0.847, 0.675, 0.880>]
    [0.781, 0.982   color rgbf <0.965, 0.847, 0.675, 0.880>
                    color rgbf <1.000, 0.718, 0.541, 0.990>]
    [0.982, 1.001   color rgbf <1.000, 0.718, 0.541, 0.890>
                    color rgbf <1.000, 0.718, 0.541, 0.890>]
   }
 }
 }

//---------- Transparent Green Moss Colors
#declare Grnt23a =
texture {
pigment
 {granite
  color_map
   {[0.000, 0.168   color rgbf <0.824, 0.725, 0.584, 0.600>
                    color rgbf <0.514, 0.584, 0.533, 0.600>]
    [0.168, 0.301   color rgbf <0.514, 0.584, 0.533, 0.600>
                    color rgbf <0.298, 0.376, 0.318, 0.600>]
    [0.301, 0.398   color rgbf <0.298, 0.376, 0.318, 0.600>
                    color rgbf <0.263, 0.337, 0.282, 0.700>]
    [0.398, 0.558   color rgbf <0.263, 0.337, 0.282, 0.700>
                    color rgbf <0.431, 0.506, 0.451, 0.600>]
    [0.558, 0.655   color rgbf <0.431, 0.506, 0.451, 0.600>
                    color rgbf <0.529, 0.631, 0.471, 0.500>]
    [0.655, 0.735   color rgbf <0.529, 0.631, 0.471, 0.500>
                    color rgbf <0.333, 0.376, 0.318, 0.700>]
    [0.735, 0.823   color rgbf <0.333, 0.376, 0.318, 0.700>
                    color rgbf <0.298, 0.376, 0.318, 0.600>]
    [0.823, 0.876   color rgbf <0.298, 0.376, 0.318, 0.600>
                    color rgbf <0.416, 0.376, 0.318, 0.500>]
    [0.876, 0.929   color rgbf <0.416, 0.376, 0.318, 0.500>
                    color rgbf <0.416, 0.376, 0.318, 0.600>]
    [0.929, 1.001   color rgbf <0.416, 0.376, 0.318, 0.600>
                    color rgbf <0.824, 0.725, 0.584, 0.700>]
   }
 }
 }

#declare Grnt24a =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.053   color rgbf <0.784, 0.627, 0.522, 0.500>
                    color rgbf <0.784, 0.627, 0.624, 0.500>]
    [0.053, 0.263   color rgbf <0.784, 0.627, 0.624, 0.500>
                    color rgbf <0.824, 0.557, 0.376, 0.500>]
    [0.263, 0.281   color rgbf <0.824, 0.557, 0.376, 0.500>
                    color rgbf <0.643, 0.380, 0.376, 0.500>]
    [0.281, 0.325   color rgbf <0.643, 0.380, 0.376, 0.500>
                    color rgbf <0.839, 0.722, 0.722, 0.500>]
    [0.325, 0.711   color rgbf <0.839, 0.722, 0.722, 0.500>
                    color rgbf <0.784, 0.627, 0.522, 0.500>]
    [0.711, 0.798   color rgbf <0.784, 0.627, 0.522, 0.500>
                    color rgbf <0.769, 0.380, 0.376, 0.500>]
    [0.798, 0.895   color rgbf <0.769, 0.380, 0.376, 0.500>
                    color rgbf <0.824, 0.557, 0.376, 0.500>]
    [0.895, 0.982   color rgbf <0.824, 0.557, 0.376, 0.500>
                    color rgbf <0.784, 0.627, 0.522, 0.500>]
    [0.982, 1.001   color rgbf <0.784, 0.627, 0.522, 0.500>
                    color rgbf <0.784, 0.627, 0.522, 0.500>]
   }
 }
 }

/*--------------------Crack & OverTint /Red---------------------*/
#declare Crack1 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color Scarlet filter 0.80 color DimGray filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
 }
 }

//-----Filter  Dark Cracks
#declare Crack2 =
texture {
pigment
 {granite
  turbulence 0.8
  color_map
   {[0.0, 0.5   color Clear color Clear]
    [0.5, 0.54   color Clear color Black]
    [0.54, 1.0 color Clear color Clear]
   }
 }
 }

//---------- Overtint Green with Black Cracks
#declare Crack3 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color DarkGreen filter 0.80 color DarkGreen filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
 }
 }

//--------- Overtint with White Crack
#declare Crack4 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.03 color White filter 0.3 color White filter 1.0]
    [0.03, 0.97 color Black filter 0.70 color DimGray filter 0.90]
    [0.97, 1.001 color White filter 0.9 color White filter 1.0]
   }
 }
 }

//-----------------  complete texture statements
//                   Scaled to cover nicely over a 2 unit Cube

//------------- Deep Rose & Green Marble with large White Swirls
#declare Stone1 =
texture{Grnt7  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt0a scale <2, 3, 2> rotate <0, 0,-30>
        finish{phong 1 phong_size 90}
       }

//------------- Light Greenish Tan Marble with Agate style veining
#declare Stone2 =
texture{Grnt0  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt7a scale <1.3, 2, 1.3> rotate <0, 0, -30> rotate <40, 0, 0>
        finish{phong 1.0 phong_size 90 ambient 0.2 }
}

//------------- Rose & Yellow Marble with fog white veining
#declare Stone3 =
texture{Grnt5  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt0a scale <2, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- Tan Marble with Rose patches
#declare Stone4 =
texture{Grnt6   scale <1.5, 3, 2> rotate <0, 0, 40>
        finish{diffuse 0.5}
}
texture{Grnt10a scale <1, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- White Cream Marble with Pink veining
#declare Stone5 =
texture{Grnt12  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt17a scale <2, 3, 2> rotate <0, 0, -30>}
texture{Crack1  scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}
}

//------------- Rose & Yellow Cream Marble
#declare Stone6 =
texture{Grnt18 scale <1.5, 3, 3> rotate <0, 0, 40>}
texture{Grnt19 scale <2, 4, 1.3> rotate <0, 0, 30>
        finish{phong 1.0 phong_size 90}
}
texture{Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}
}

//------------- Light Coffee Marble with darker patches
#declare Stone7 =
texture{pigment{color Salmon}}
texture{Grnt6a scale <1, 3, 2> rotate <0, 0, 40>}
texture{Grnt9a scale <3.5, 5, 4> rotate <0, 0, 60>
        finish{phong 1.0 phong_size 90}
}

//------------- Gray Granite with white patches
#declare Stone8 =
texture{pigment{color White}
        finish{ambient 0.4 crand 0.06 diffuse 0.7}
}
texture{Grnt0a scale <2, 3, 2> rotate <0, 0, -30>}
texture{Grnt9a scale <5, 3, 4> rotate <0, 0, 40>
        finish{phong 1.0 ambient 0.2 diffuse 0.5 phong_size 90}
}

//------------- White & Light Blue Marble with light violets
#declare Stone9 =
texture{Grnt9 scale <1.2, 2.4, 1.2> rotate <0, 0, -30> rotate <40, 0, 0>}
texture{Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}
}

//------------- Dark Brown & Tan swirl Granite with gray undertones
#declare Stone10 =
texture{pigment{color Black}}
texture{Grnt17a scale <3, 6, 2> rotate <0, 0, 50>}
texture{Grnt3a scale <1, 2, 1> rotate <0, 0, -50>
        finish{phong 1.0 phong_size 90}
}

//------------- Rose & White Marble with dark tan swirl
#declare Stone11 =
texture{pigment{color Black}}
texture{Grnt15a scale <1.2, 3, 1.5> rotate <70, 0, 30>
        finish{crand 0.03}
}
texture{Grnt2a scale <3, 3, 4> rotate <0, 0, 40>}
texture{Crack1 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- White & Pinkish Tan Marble
#declare Stone12 =
texture{Grnt23 scale <1, 5, 1> rotate <0, 0, 50>
        finish{ambient 0.2 crand 0.03}
}
texture{Grnt0a scale <1, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- Medium Gray Blue Marble
#declare Stone13 =
texture{Grnt24 scale <2, 5, 2> rotate <0, 0, 50>
        finish{ambient 0.2 crand 0.03}
}
texture{Grnt8a scale <1, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- Tan & Olive Marble with gray white veins
#declare Stone14 =
texture{Grnt6 scale <2, 3, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{Grnt19a scale <1, 3, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}

//------------- Deep Gray Marble with white veining
#declare Stone15 =
texture{Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{Grnt8a scale <1, 2, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}

//------------- Peach & Yellow Marble with white veining
#declare Stone16 =
texture{Grnt18 scale <1.3, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{Grnt19 scale <2, 4, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
texture{Grnt20a scale <1, 2, 1> rotate <0, 0, 40>
        finish{phong 1.0 phong_size 90}
}

//------------- White Marble with gray veining
#declare Stone17 =
texture{Grnt20 scale <1, 2, 2> rotate <0, 0, -30>
        finish{ambient 0.2 diffuse 0.9 crand 0.03}
}
//texture{Grnt8a scale <2.5, 4.5, 3.5> rotate <0, 0, 40>
//        finish{phong 1.0 phong_size 90}
//}
texture{Crack3 scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Green Jade with white veining
#declare Stone18 =
texture{pigment{color SeaGreen}
        finish{ambient 0.3 diffuse 0.6 crand 0.03}
}
texture{Grnt22 scale <1.5, 0.7, 0.5> rotate <0, 0, 40>}
texture{Grnt20a scale <2.5, 2, 0.5> rotate <0, 0, -50>}
texture{Crack4 scale <0.7, 1, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Peach Granite with white patches & green trim
#declare Stone19 =
texture{Grnt26 scale <1, 0.7, 0.5> rotate <0, 0, 40>}
texture{Grnt20a scale <2, 3, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Brown & Olive Marble with white veining
#declare Stone20 =
texture{Grnt27 scale <0.7, 0.99, 0.7> rotate <0, 0, 40>}
texture{Grnt12a scale <1, 1.3, 2> rotate <0, 0, 40>}
texture{Grnt20a scale <1.9, 3, 0.5> rotate <0, 0, -50>}
texture{Crack1 scale <1, 0.6, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Red Marble with gray & white veining
#declare Stone21 =
texture{Grnt28 scale <1.3, 2.5, 1.7> rotate <0, 0, 40>}
texture{Grnt22 scale <1, 2, 2> rotate <0, 0, 40>}
texture{Crack4 scale <1, 0.6, 1> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90}
}

//------------- Dark Tan Marble with gray & white veining
#declare Stone22 =
texture{pigment{color Feldspar}}
texture{Grnt8a scale <1, 2, 2> rotate <0, 0, 40>}
texture{Grnt22 scale <2, 4, 1.5> rotate <0, 0, -50>}
texture{Crack4 scale <1, 1, 1> rotate <10, 0, -40>
        finish{phong 1.0 phong_size 90}
}

//------------- Peach & Cream Marble with orange veining
#declare Stone23 =
texture{Grnt29 scale <1, 1, 2> rotate <40, 0, 0> rotate <0, 0, 30>}
texture{Grnt24a scale <2, 1, 2> rotate <40, 0, 0> rotate <0, 0, 30>}
texture{Crack1 scale <1, 2, 1.5> rotate <0, 0, 40>}
texture{pigment{color Yellow filter 0.9}
        finish{phong 1.0 phong_size 90}  // tint to liking
}

//------------- Green & Tan Moss Marble
#declare Stone24 =
texture{Grnt25 scale <1, 1, 2> rotate <0, 0, 50> rotate <20, 0, 30>}
texture{Grnt23a scale <2, 1, 2> rotate <40, 0, 0> rotate <0, 0, -30>}
texture{pigment{color Gray filter 0.8}
        finish{phong 1.0 phong_size 90} //   tint to liking
}
#version Stones_Inc_Temp 
