# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._source_control_configuration_client_enums import *


class ComplianceStatus(msrest.serialization.Model):
    """Compliance Status details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar compliance_state: The compliance state of the configuration. Possible values include:
     "Pending", "Compliant", "Noncompliant", "Installed", "Failed".
    :vartype compliance_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ComplianceStateType
    :ivar last_config_applied: Datetime the configuration was last applied.
    :vartype last_config_applied: ~datetime.datetime
    :ivar message: Message from when the configuration was applied.
    :vartype message: str
    :ivar message_level: Level of the message. Possible values include: "Error", "Warning",
     "Information".
    :vartype message_level: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.MessageLevelType
    """

    _validation = {
        'compliance_state': {'readonly': True},
    }

    _attribute_map = {
        'compliance_state': {'key': 'complianceState', 'type': 'str'},
        'last_config_applied': {'key': 'lastConfigApplied', 'type': 'iso-8601'},
        'message': {'key': 'message', 'type': 'str'},
        'message_level': {'key': 'messageLevel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        last_config_applied: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        message_level: Optional[Union[str, "MessageLevelType"]] = None,
        **kwargs
    ):
        """
        :keyword last_config_applied: Datetime the configuration was last applied.
        :paramtype last_config_applied: ~datetime.datetime
        :keyword message: Message from when the configuration was applied.
        :paramtype message: str
        :keyword message_level: Level of the message. Possible values include: "Error", "Warning",
         "Information".
        :paramtype message_level: str or
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.MessageLevelType
        """
        super(ComplianceStatus, self).__init__(**kwargs)
        self.compliance_state = None
        self.last_config_applied = last_config_applied
        self.message = message
        self.message_level = message_level


class ConfigurationIdentity(msrest.serialization.Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity which is used by the
     configuration.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is used by the
     configuration.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the configuration. Type 'SystemAssigned' will use an
     implicitly created identity. Type 'None' will not use Managed Identity for the configuration.
     Possible values include: "SystemAssigned", "None".
    :vartype type: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of identity used for the configuration. Type 'SystemAssigned' will use
         an implicitly created identity. Type 'None' will not use Managed Identity for the
         configuration. Possible values include: "SystemAssigned", "None".
        :paramtype type: str or
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ResourceIdentityType
        """
        super(ConfigurationIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ErrorDefinition(msrest.serialization.Model):
    """Error definition.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required. Service specific error code which serves as the substatus for the HTTP
     error code.
    :vartype code: str
    :ivar message: Required. Description of the error.
    :vartype message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        **kwargs
    ):
        """
        :keyword code: Required. Service specific error code which serves as the substatus for the HTTP
         error code.
        :paramtype code: str
        :keyword message: Required. Description of the error.
        :paramtype message: str
        """
        super(ErrorDefinition, self).__init__(**kwargs)
        self.code = code
        self.message = message


class ErrorResponse(msrest.serialization.Model):
    """Error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: Error definition.
    :vartype error: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ErrorDefinition
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDefinition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = None


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        system_data: Optional["SystemData"] = None,
        **kwargs
    ):
        """
        :keyword system_data: Top level metadata
         https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
        :paramtype system_data:
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SystemData
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = system_data


class ProxyResource(Resource):
    """ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        system_data: Optional["SystemData"] = None,
        **kwargs
    ):
        """
        :keyword system_data: Top level metadata
         https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
        :paramtype system_data:
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SystemData
        """
        super(ProxyResource, self).__init__(system_data=system_data, **kwargs)


class ExtensionInstance(ProxyResource):
    """The Extension Instance object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SystemData
    :ivar extension_type: Type of the Extension, of which this resource is an instance of.  It must
     be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
     Extension publisher.
    :vartype extension_type: str
    :ivar auto_upgrade_minor_version: Flag to note if this instance participates in auto upgrade of
     minor version, or not.
    :vartype auto_upgrade_minor_version: bool
    :ivar release_train: ReleaseTrain this extension instance participates in for auto-upgrade
     (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :vartype release_train: str
    :ivar version: Version of the extension for this extension instance, if it is 'pinned' to a
     specific version. autoUpgradeMinorVersion must be 'false'.
    :vartype version: str
    :ivar scope: Scope at which the extension instance is installed.
    :vartype scope: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.Scope
    :ivar configuration_settings: Configuration settings, as name-value pairs for configuring this
     instance of the extension.
    :vartype configuration_settings: dict[str, str]
    :ivar configuration_protected_settings: Configuration settings that are sensitive, as
     name-value pairs for configuring this instance of the extension.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar install_state: Status of installation of this instance of the extension. Possible values
     include: "Pending", "Installed", "Failed".
    :vartype install_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.InstallStateType
    :ivar statuses: Status from this instance of the extension.
    :vartype statuses:
     list[~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ExtensionStatus]
    :ivar creation_time: DateLiteral (per ISO8601) noting the time the resource was created by the
     client (user).
    :vartype creation_time: str
    :ivar last_modified_time: DateLiteral (per ISO8601) noting the time the resource was modified
     by the client (user).
    :vartype last_modified_time: str
    :ivar last_status_time: DateLiteral (per ISO8601) noting the time of last status from the
     agent.
    :vartype last_status_time: str
    :ivar error_info: Error information from the Agent - e.g. errors during installation.
    :vartype error_info:
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ErrorDefinition
    :ivar identity: The identity of the configuration.
    :vartype identity:
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ConfigurationIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'install_state': {'readonly': True},
        'creation_time': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'last_status_time': {'readonly': True},
        'error_info': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'extension_type': {'key': 'properties.extensionType', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'release_train': {'key': 'properties.releaseTrain', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'Scope'},
        'configuration_settings': {'key': 'properties.configurationSettings', 'type': '{str}'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
        'install_state': {'key': 'properties.installState', 'type': 'str'},
        'statuses': {'key': 'properties.statuses', 'type': '[ExtensionStatus]'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'str'},
        'last_status_time': {'key': 'properties.lastStatusTime', 'type': 'str'},
        'error_info': {'key': 'properties.errorInfo', 'type': 'ErrorDefinition'},
        'identity': {'key': 'properties.identity', 'type': 'ConfigurationIdentity'},
    }

    def __init__(
        self,
        *,
        system_data: Optional["SystemData"] = None,
        extension_type: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        release_train: Optional[str] = "Stable",
        version: Optional[str] = None,
        scope: Optional["Scope"] = None,
        configuration_settings: Optional[Dict[str, str]] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        statuses: Optional[List["ExtensionStatus"]] = None,
        identity: Optional["ConfigurationIdentity"] = None,
        **kwargs
    ):
        """
        :keyword system_data: Top level metadata
         https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
        :paramtype system_data:
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SystemData
        :keyword extension_type: Type of the Extension, of which this resource is an instance of.  It
         must be one of the Extension Types registered with Microsoft.KubernetesConfiguration by the
         Extension publisher.
        :paramtype extension_type: str
        :keyword auto_upgrade_minor_version: Flag to note if this instance participates in auto upgrade
         of minor version, or not.
        :paramtype auto_upgrade_minor_version: bool
        :keyword release_train: ReleaseTrain this extension instance participates in for auto-upgrade
         (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        :paramtype release_train: str
        :keyword version: Version of the extension for this extension instance, if it is 'pinned' to a
         specific version. autoUpgradeMinorVersion must be 'false'.
        :paramtype version: str
        :keyword scope: Scope at which the extension instance is installed.
        :paramtype scope: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.Scope
        :keyword configuration_settings: Configuration settings, as name-value pairs for configuring
         this instance of the extension.
        :paramtype configuration_settings: dict[str, str]
        :keyword configuration_protected_settings: Configuration settings that are sensitive, as
         name-value pairs for configuring this instance of the extension.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword statuses: Status from this instance of the extension.
        :paramtype statuses:
         list[~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ExtensionStatus]
        :keyword identity: The identity of the configuration.
        :paramtype identity:
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ConfigurationIdentity
        """
        super(ExtensionInstance, self).__init__(system_data=system_data, **kwargs)
        self.extension_type = extension_type
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version
        self.scope = scope
        self.configuration_settings = configuration_settings
        self.configuration_protected_settings = configuration_protected_settings
        self.install_state = None
        self.statuses = statuses
        self.creation_time = None
        self.last_modified_time = None
        self.last_status_time = None
        self.error_info = None
        self.identity = identity


class ExtensionInstancesList(msrest.serialization.Model):
    """Result of the request to list Extension Instances.  It contains a list of ExtensionInstance objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Extension Instances within a Kubernetes cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ExtensionInstance]
    :ivar next_link: URL to get the next set of extension instance objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ExtensionInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ExtensionInstancesList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ExtensionInstanceUpdate(msrest.serialization.Model):
    """Update Extension Instance request object.

    :ivar auto_upgrade_minor_version: Flag to note if this instance participates in Extension
     Lifecycle Management or not.
    :vartype auto_upgrade_minor_version: bool
    :ivar release_train: ReleaseTrain this extension instance participates in for auto-upgrade
     (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
    :vartype release_train: str
    :ivar version: Version number of extension, to 'pin' to a specific version.
     autoUpgradeMinorVersion must be 'false'.
    :vartype version: str
    """

    _attribute_map = {
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'release_train': {'key': 'properties.releaseTrain', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auto_upgrade_minor_version: Optional[bool] = None,
        release_train: Optional[str] = "Stable",
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword auto_upgrade_minor_version: Flag to note if this instance participates in Extension
         Lifecycle Management or not.
        :paramtype auto_upgrade_minor_version: bool
        :keyword release_train: ReleaseTrain this extension instance participates in for auto-upgrade
         (e.g. Stable, Preview, etc.) - only if autoUpgradeMinorVersion is 'true'.
        :paramtype release_train: str
        :keyword version: Version number of extension, to 'pin' to a specific version.
         autoUpgradeMinorVersion must be 'false'.
        :paramtype version: str
        """
        super(ExtensionInstanceUpdate, self).__init__(**kwargs)
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.release_train = release_train
        self.version = version


class ExtensionStatus(msrest.serialization.Model):
    """Status from this instance of the extension.

    :ivar code: Status code provided by the Extension.
    :vartype code: str
    :ivar display_status: Short description of status of this instance of the extension.
    :vartype display_status: str
    :ivar level: Level of the status. Possible values include: "Error", "Warning", "Information".
     Default value: "Information".
    :vartype level: str or ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.LevelType
    :ivar message: Detailed message of the status from the Extension instance.
    :vartype message: str
    :ivar time: DateLiteral (per ISO8601) noting the time of installation status.
    :vartype time: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        display_status: Optional[str] = None,
        level: Optional[Union[str, "LevelType"]] = "Information",
        message: Optional[str] = None,
        time: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Status code provided by the Extension.
        :paramtype code: str
        :keyword display_status: Short description of status of this instance of the extension.
        :paramtype display_status: str
        :keyword level: Level of the status. Possible values include: "Error", "Warning",
         "Information". Default value: "Information".
        :paramtype level: str or
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.LevelType
        :keyword message: Detailed message of the status from the Extension instance.
        :paramtype message: str
        :keyword time: DateLiteral (per ISO8601) noting the time of installation status.
        :paramtype time: str
        """
        super(ExtensionStatus, self).__init__(**kwargs)
        self.code = code
        self.display_status = display_status
        self.level = level
        self.message = message
        self.time = time


class HelmOperatorProperties(msrest.serialization.Model):
    """Properties for Helm operator.

    :ivar chart_version: Version of the operator Helm chart.
    :vartype chart_version: str
    :ivar chart_values: Values override for the operator Helm chart.
    :vartype chart_values: str
    """

    _attribute_map = {
        'chart_version': {'key': 'chartVersion', 'type': 'str'},
        'chart_values': {'key': 'chartValues', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        chart_version: Optional[str] = None,
        chart_values: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword chart_version: Version of the operator Helm chart.
        :paramtype chart_version: str
        :keyword chart_values: Values override for the operator Helm chart.
        :paramtype chart_values: str
        """
        super(HelmOperatorProperties, self).__init__(**kwargs)
        self.chart_version = chart_version
        self.chart_values = chart_values


class ResourceProviderOperation(msrest.serialization.Model):
    """Supported operation of this resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name, in format of {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: Display metadata associated with the operation.
    :vartype display:
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ResourceProviderOperationDisplay
    :ivar is_data_action: The flag that indicates whether the operation applies to data plane.
    :vartype is_data_action: bool
    """

    _validation = {
        'is_data_action': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'ResourceProviderOperationDisplay'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["ResourceProviderOperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword name: Operation name, in format of {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: Display metadata associated with the operation.
        :paramtype display:
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ResourceProviderOperationDisplay
        """
        super(ResourceProviderOperation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.is_data_action = None


class ResourceProviderOperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :ivar provider: Resource provider: Microsoft KubernetesConfiguration.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: Type of operation: get, read, delete, etc.
    :vartype operation: str
    :ivar description: Description of this operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: Resource provider: Microsoft KubernetesConfiguration.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: Type of operation: get, read, delete, etc.
        :paramtype operation: str
        :keyword description: Description of this operation.
        :paramtype description: str
        """
        super(ResourceProviderOperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourceProviderOperationList(msrest.serialization.Model):
    """Result of the request to list operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by this resource provider.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ResourceProviderOperation]
    :ivar next_link: URL to the next set of results, if any.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceProviderOperation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ResourceProviderOperation"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of operations supported by this resource provider.
        :paramtype value:
         list[~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ResourceProviderOperation]
        """
        super(ResourceProviderOperationList, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class Result(msrest.serialization.Model):
    """Sample result definition.

    :ivar sample_property: Sample property of type string.
    :vartype sample_property: str
    """

    _attribute_map = {
        'sample_property': {'key': 'sampleProperty', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sample_property: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword sample_property: Sample property of type string.
        :paramtype sample_property: str
        """
        super(Result, self).__init__(**kwargs)
        self.sample_property = sample_property


class Scope(msrest.serialization.Model):
    """Scope of the extensionInstance. It can be either Cluster or Namespace; but not both.

    :ivar cluster: Specifies that the scope of the extensionInstance is Cluster.
    :vartype cluster: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ScopeCluster
    :ivar namespace: Specifies that the scope of the extensionInstance is Namespace.
    :vartype namespace:
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ScopeNamespace
    """

    _attribute_map = {
        'cluster': {'key': 'cluster', 'type': 'ScopeCluster'},
        'namespace': {'key': 'namespace', 'type': 'ScopeNamespace'},
    }

    def __init__(
        self,
        *,
        cluster: Optional["ScopeCluster"] = None,
        namespace: Optional["ScopeNamespace"] = None,
        **kwargs
    ):
        """
        :keyword cluster: Specifies that the scope of the extensionInstance is Cluster.
        :paramtype cluster: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ScopeCluster
        :keyword namespace: Specifies that the scope of the extensionInstance is Namespace.
        :paramtype namespace:
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ScopeNamespace
        """
        super(Scope, self).__init__(**kwargs)
        self.cluster = cluster
        self.namespace = namespace


class ScopeCluster(msrest.serialization.Model):
    """Specifies that the scope of the extensionInstance is Cluster.

    :ivar release_namespace: Namespace where the extension Release must be placed, for a Cluster
     scoped extensionInstance.  If this namespace does not exist, it will be created.
    :vartype release_namespace: str
    """

    _attribute_map = {
        'release_namespace': {'key': 'releaseNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        release_namespace: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword release_namespace: Namespace where the extension Release must be placed, for a Cluster
         scoped extensionInstance.  If this namespace does not exist, it will be created.
        :paramtype release_namespace: str
        """
        super(ScopeCluster, self).__init__(**kwargs)
        self.release_namespace = release_namespace


class ScopeNamespace(msrest.serialization.Model):
    """Specifies that the scope of the extensionInstance is Namespace.

    :ivar target_namespace: Namespace where the extensionInstance will be created for an Namespace
     scoped extensionInstance.  If this namespace does not exist, it will be created.
    :vartype target_namespace: str
    """

    _attribute_map = {
        'target_namespace': {'key': 'targetNamespace', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        target_namespace: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword target_namespace: Namespace where the extensionInstance will be created for an
         Namespace scoped extensionInstance.  If this namespace does not exist, it will be created.
        :paramtype target_namespace: str
        """
        super(ScopeNamespace, self).__init__(**kwargs)
        self.target_namespace = target_namespace


class SourceControlConfiguration(ProxyResource):
    """The SourceControl Configuration object returned in Get & Put response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Top level metadata
     https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
    :vartype system_data: ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SystemData
    :ivar repository_url: Url of the SourceControl Repository.
    :vartype repository_url: str
    :ivar operator_namespace: The namespace to which this operator is installed to. Maximum of 253
     lower case alphanumeric characters, hyphen and period only.
    :vartype operator_namespace: str
    :ivar operator_instance_name: Instance name of the operator - identifying the specific
     configuration.
    :vartype operator_instance_name: str
    :ivar operator_type: Type of the operator. Possible values include: "Flux".
    :vartype operator_type: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.OperatorType
    :ivar operator_params: Any Parameters for the Operator instance in string format.
    :vartype operator_params: str
    :ivar configuration_protected_settings: Name-value pairs of protected configuration settings
     for the configuration.
    :vartype configuration_protected_settings: dict[str, str]
    :ivar operator_scope: Scope at which the operator will be installed. Possible values include:
     "cluster", "namespace". Default value: "cluster".
    :vartype operator_scope: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.OperatorScopeType
    :ivar repository_public_key: Public Key associated with this SourceControl configuration
     (either generated within the cluster or provided by the user).
    :vartype repository_public_key: str
    :ivar ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH keys
     required to access private Git instances.
    :vartype ssh_known_hosts_contents: str
    :ivar enable_helm_operator: Option to enable Helm Operator for this git configuration.
    :vartype enable_helm_operator: bool
    :ivar helm_operator_properties: Properties for Helm operator.
    :vartype helm_operator_properties:
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.HelmOperatorProperties
    :ivar provisioning_state: The provisioning state of the resource provider. Possible values
     include: "Accepted", "Deleting", "Running", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ProvisioningStateType
    :ivar compliance_status: Compliance Status of the Configuration.
    :vartype compliance_status:
     ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.ComplianceStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'repository_public_key': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'compliance_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'repository_url': {'key': 'properties.repositoryUrl', 'type': 'str'},
        'operator_namespace': {'key': 'properties.operatorNamespace', 'type': 'str'},
        'operator_instance_name': {'key': 'properties.operatorInstanceName', 'type': 'str'},
        'operator_type': {'key': 'properties.operatorType', 'type': 'str'},
        'operator_params': {'key': 'properties.operatorParams', 'type': 'str'},
        'configuration_protected_settings': {'key': 'properties.configurationProtectedSettings', 'type': '{str}'},
        'operator_scope': {'key': 'properties.operatorScope', 'type': 'str'},
        'repository_public_key': {'key': 'properties.repositoryPublicKey', 'type': 'str'},
        'ssh_known_hosts_contents': {'key': 'properties.sshKnownHostsContents', 'type': 'str'},
        'enable_helm_operator': {'key': 'properties.enableHelmOperator', 'type': 'bool'},
        'helm_operator_properties': {'key': 'properties.helmOperatorProperties', 'type': 'HelmOperatorProperties'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'compliance_status': {'key': 'properties.complianceStatus', 'type': 'ComplianceStatus'},
    }

    def __init__(
        self,
        *,
        system_data: Optional["SystemData"] = None,
        repository_url: Optional[str] = None,
        operator_namespace: Optional[str] = "default",
        operator_instance_name: Optional[str] = None,
        operator_type: Optional[Union[str, "OperatorType"]] = None,
        operator_params: Optional[str] = None,
        configuration_protected_settings: Optional[Dict[str, str]] = None,
        operator_scope: Optional[Union[str, "OperatorScopeType"]] = "cluster",
        ssh_known_hosts_contents: Optional[str] = None,
        enable_helm_operator: Optional[bool] = None,
        helm_operator_properties: Optional["HelmOperatorProperties"] = None,
        **kwargs
    ):
        """
        :keyword system_data: Top level metadata
         https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.
        :paramtype system_data:
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SystemData
        :keyword repository_url: Url of the SourceControl Repository.
        :paramtype repository_url: str
        :keyword operator_namespace: The namespace to which this operator is installed to. Maximum of
         253 lower case alphanumeric characters, hyphen and period only.
        :paramtype operator_namespace: str
        :keyword operator_instance_name: Instance name of the operator - identifying the specific
         configuration.
        :paramtype operator_instance_name: str
        :keyword operator_type: Type of the operator. Possible values include: "Flux".
        :paramtype operator_type: str or
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.OperatorType
        :keyword operator_params: Any Parameters for the Operator instance in string format.
        :paramtype operator_params: str
        :keyword configuration_protected_settings: Name-value pairs of protected configuration settings
         for the configuration.
        :paramtype configuration_protected_settings: dict[str, str]
        :keyword operator_scope: Scope at which the operator will be installed. Possible values
         include: "cluster", "namespace". Default value: "cluster".
        :paramtype operator_scope: str or
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.OperatorScopeType
        :keyword ssh_known_hosts_contents: Base64-encoded known_hosts contents containing public SSH
         keys required to access private Git instances.
        :paramtype ssh_known_hosts_contents: str
        :keyword enable_helm_operator: Option to enable Helm Operator for this git configuration.
        :paramtype enable_helm_operator: bool
        :keyword helm_operator_properties: Properties for Helm operator.
        :paramtype helm_operator_properties:
         ~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.HelmOperatorProperties
        """
        super(SourceControlConfiguration, self).__init__(system_data=system_data, **kwargs)
        self.repository_url = repository_url
        self.operator_namespace = operator_namespace
        self.operator_instance_name = operator_instance_name
        self.operator_type = operator_type
        self.operator_params = operator_params
        self.configuration_protected_settings = configuration_protected_settings
        self.operator_scope = operator_scope
        self.repository_public_key = None
        self.ssh_known_hosts_contents = ssh_known_hosts_contents
        self.enable_helm_operator = enable_helm_operator
        self.helm_operator_properties = helm_operator_properties
        self.provisioning_state = None
        self.compliance_status = None


class SourceControlConfigurationList(msrest.serialization.Model):
    """Result of the request to list Source Control Configurations.  It contains a list of SourceControlConfiguration objects and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Source Control Configurations within a Kubernetes cluster.
    :vartype value:
     list[~azure.mgmt.kubernetesconfiguration.v2020_07_01_preview.models.SourceControlConfiguration]
    :ivar next_link: URL to get the next set of configuration objects, if any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SourceControlConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SourceControlConfigurationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Top level metadata https://github.com/Azure/azure-resource-manager-rpc/blob/master/v1.0/common-api-contracts.md#system-metadata-for-all-azure-resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: A string identifier for the identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource: user, application,
     managedIdentity, key.
    :vartype created_by_type: str
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: A string identifier for the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource: user,
     application, managedIdentity, key.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        'created_by': {'readonly': True},
        'created_by_type': {'readonly': True},
        'created_at': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'last_modified_by_type': {'readonly': True},
        'last_modified_at': {'readonly': True},
    }

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = None
        self.created_by_type = None
        self.created_at = None
        self.last_modified_by = None
        self.last_modified_by_type = None
        self.last_modified_at = None
